/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// Quake is a trademark of Id Software, Inc., (c) 1996 Id Software, Inc. All
// rights reserved.

/*
==============================================================================================================
MH - this file is now nothing more than a Quake-compatible wrapper for my Direct X music playing routines 
(qmp3.cpp).

It should be easy to port it to any other engine as a "drop 'n' go" - you'll also need the WM_GRAPHNOTIFY
stuff in gl_vidnt.c and the appropriate headers and libs.
==============================================================================================================
*/


#include <windows.h>
#include "quakedef.h"


char InitMP3DShow (void);
void PlayMP3DShow (int mp3num);
void KillMP3DShow (void);
void StopMP3DShow (void);
void PawsMP3DShow (int Paused);
void VolmMP3DShow (int Level);
void MesgMP3DShow (int Looping);
void UserMP3DShow (char *mp3name, int yakyakfuckingyak);

static void CD_f (void);

// it's a dumb warning anyway...
#pragma warning(disable : 4761)


extern	cvar_t	bgmvolume;
extern int sound_started;


byte CurrentTrack;

qboolean Looping;
qboolean Paused;
qboolean Enabled;

static void CDAudio_Eject (void) {}
static void CDAudio_CloseDoor (void) {}
static int CDAudio_GetAudioDiskInfo (void) {return 0;}

void CDAudio_Stop (void)
{
	if (!sound_started) return;
	if (!Enabled) return;

	StopMP3DShow ();
}

void CDAudio_Pause (void)
{
	if (!sound_started) return;
	if (!Enabled) return;

	PawsMP3DShow (0);
}

void CDAudio_Resume (void)
{
	if (!sound_started) return;
	if (!Enabled) return;

	PawsMP3DShow (1);
}


void CDAudio_Update (void) {}


int CDAudio_Init (void)
{
	if (cls.state == ca_dedicated || COM_CheckParm("-nocdaudio"))
	{
		Enabled = false;
		return -1;
	}

	if (!InitMP3DShow ()) return -1;

	Looping = false;
	Paused = false;

	Enabled = true;

	Cmd_AddCommand ("cd", CD_f);
	Cmd_AddCommand ("mp3", CD_f);

	return 0;
}


void CDAudio_Shutdown (void)
{
	if (!Enabled) return;

	KillMP3DShow ();
}


void CDAudio_Play (byte track, qboolean looping)
{
	Looping = false;

	if (!sound_started) return;

	// worldspawn tracks are one ahead of the game
	CurrentTrack = track - 1;

	// exit conditions
	if (CurrentTrack > 99) return;
	if (CurrentTrack < 1) return;
	if (!Enabled) return;

	// stop any previous instances
	CDAudio_Stop ();

	PlayMP3DShow (CurrentTrack);

	Looping = looping;
}


void CDAudioSetVolume (void)
{
	if (!sound_started) return;

	// set the volume
	VolmMP3DShow ((int) (bgmvolume.value * 10));
}


LONG CDAudio_MessageHandler (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// pass to direct show stuff
	MesgMP3DShow ((int) Looping);

	return 0;
}


static void CD_f (void)
{
	char	*command;
	int		i;
	char	MP3FileName[MAX_OSPATH];
	char	*mp3nametemp;

	if (Cmd_Argc() < 2)
	{
		Con_Printf ("%s play|stop|pause|resume\n", Cmd_Argv (0));
		Con_Printf (" Put MP3s in gamedir/music!!!\n");
		Con_Printf (" spaces are allowed in file names\n");
		return;
	}

	command = Cmd_Argv (1);

	if (stricmp (command, "play") == 0)
	{
		// build the MP3 file name
		memset (MP3FileName, 0, sizeof (MP3FileName));

		for (i = 2; i < Cmd_Argc (); i++)
		{
			mp3nametemp = Cmd_Argv (i);
			sprintf (MP3FileName, "%s%s ", MP3FileName, mp3nametemp);
		}

		// get rid of the trailing space
		MP3FileName[strlen (MP3FileName) - 1] = 0;

		// stop anything that's currently playing
		if (Enabled && sound_started) StopMP3DShow ();

		UserMP3DShow (MP3FileName, 1);

		return;
	}

	if (stricmp (command, "stop") == 0)
	{
		CDAudio_Stop ();
		return;
	}

	if (stricmp (command, "pause") == 0)
	{
		CDAudio_Pause ();
		return;
	}

	if (stricmp (command, "resume") == 0)
	{
		CDAudio_Resume ();
		return;
	}
}


