/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#include "quakedef.h"
#include "glext.h"


qboolean automapOn = false;
float mScale = 1;

float vidAspect;
float mapAspect;
extern int lightmap_textures;

void LoadModelMinMaxXYZ (void)
{
	int s;
	int i;
	float *v;
	msurface_t *surf;

	cl.worldmodel->minmaxx[0] = cl.worldmodel->minmaxy[0] = cl.worldmodel->minmaxz[0] = 100000;
	cl.worldmodel->minmaxx[1] = cl.worldmodel->minmaxy[1] = cl.worldmodel->minmaxz[0] = -100000;

	// store these in the model...
	for (s = 0; s < cl.worldmodel->numsurfaces; s++)
	{
		surf = &cl.worldmodel->surfaces[s];

		if (surf->flags & SURF_DRAWSKY) continue;
		if (surf->flags & SURF_DRAWTURB) continue;

		for (i = 0, v = surf->polys->verts; i < surf->polys->numverts; i++, v += VERTEXSIZE)
		{
			if (v[0] < cl.worldmodel->minmaxx[0]) cl.worldmodel->minmaxx[0] = v[0];
			if (v[0] > cl.worldmodel->minmaxx[1]) cl.worldmodel->minmaxx[1] = v[0];

			if (v[1] < cl.worldmodel->minmaxy[0]) cl.worldmodel->minmaxy[0] = v[1];
			if (v[1] > cl.worldmodel->minmaxy[1]) cl.worldmodel->minmaxy[1] = v[1];

			if (v[2] < cl.worldmodel->minmaxz[0]) cl.worldmodel->minmaxz[0] = v[2];
			if (v[2] > cl.worldmodel->minmaxz[1]) cl.worldmodel->minmaxz[1] = v[2];
		}
	}

	cl.worldmodel->xSize = fabs (cl.worldmodel->minmaxx[1] - cl.worldmodel->minmaxx[0]);
	cl.worldmodel->ySize = fabs (cl.worldmodel->minmaxy[1] - cl.worldmodel->minmaxy[0]);

	// get the proper aspect ratio here
	vidAspect = (float) glwidth / (float) glheight;
	mapAspect = cl.worldmodel->xSize / cl.worldmodel->ySize;
}


void GL_DrawAutomap (void)
{
	int s;
	int i;
	float *v;
	glpoly_t *p;
	msurface_t *surf;
	float vpx;
	float vpy;
	float vpw;
	float vph;

	if (mapAspect < vidAspect)
	{
		vpw = (((float) glwidth - 30) * mapAspect) / vidAspect;
		vpx = (glwidth - vpw) / 2;

		vpy = gly + 15;
		vph = glheight - 30;
	}
	else
	{
		vpx = glx + 15;
		vpw = glwidth - 30;

		vph = (((float) glheight - 30) * vidAspect) / mapAspect;
		vpy = (glheight - vph) / 2;
	}

	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glViewport (vpx, vpy, vpw, vph);

	glMatrixMode(GL_PROJECTION);
    glLoadIdentity ();

	// draw from top to bottom
	glOrtho  (cl.worldmodel->minmaxx[0], 
			  cl.worldmodel->minmaxx[1], 
			  cl.worldmodel->minmaxy[1], 
			  cl.worldmodel->minmaxy[0], 
			  -8000, 8000);

	glMatrixMode(GL_MODELVIEW);
    glLoadIdentity ();

	glDisable (GL_DEPTH_TEST);
	glDisable (GL_CULL_FACE);
	glDisable (GL_BLEND);
	glEnable (GL_ALPHA_TEST);

	glColor4f (1, 1, 1, 1);

	glEnableClientState (GL_VERTEX_ARRAY);
	glVertexPointer (3, GL_FLOAT, (VERTEXSIZE * sizeof (GLfloat)), &surfarray[0]);

	glEnableClientState (GL_TEXTURE_COORD_ARRAY);
	glClientActiveTexture (GL_TEXTURE0);
	glTexCoordPointer (2, GL_FLOAT, (VERTEXSIZE * sizeof (GLfloat)), &surfarray[3]);

	glClientActiveTexture (GL_TEXTURE1);
	glTexCoordPointer (2, GL_FLOAT, (VERTEXSIZE * sizeof (GLfloat)), &surfarray[5]);

	glActiveTexture (GL_TEXTURE1);
	glEnable (GL_TEXTURE_2D);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	for (s = 0; s < cl.worldmodel->numsurfaces; s++)
	{
		surf = &cl.worldmodel->surfaces[s];

		if (surf->flags & SURF_DRAWSKY) continue;

		if (!surf->inClientPVS) continue;

		glActiveTexture (GL_TEXTURE0);
		glBindTexture (GL_TEXTURE_2D, surf->texinfo->texture->gl_texture->texnum);

		// draw the surface polygon
		// fixme - we need to check Z of each poly...
		if (surf->flags & SURF_DRAWTURB)
		{
			glMatrixMode (GL_TEXTURE);
			glLoadIdentity ();
			glScalef (1.0 / 64, 1.0 / 64, 1.0);
			glMatrixMode (GL_MODELVIEW);

			glActiveTexture (GL_TEXTURE1);
			glDisable (GL_TEXTURE_2D);

			for (p = surf->polys; p; p = p->next)
			{
				for (i = 0, v = p->verts; i < p->numverts; i++, v += VERTEXSIZE)
				{
					// invalidate the entire surf
					if (v[2] > mScale) goto wdone;

					// fix water warping - derive the texcoords from the verts!!!  mad, but it works!!!
					// warpindex is precalculated in gl_model.c - use the x2 sintable for 8 unit warps
					v[3] = v[surf->warpindex[0]] + sintable[(int) ((v[surf->warpindex[1]] * 0.025 + realtime) * STMult) & STBitMask];
					v[4] = v[surf->warpindex[1]] + sintable[(int) ((v[surf->warpindex[0]] * 0.025 + realtime) * STMult) & STBitMask];
				}

				glDrawArrays (GL_TRIANGLE_FAN, p->saindex, p->numverts);
			}

wdone:;
			glEnable (GL_TEXTURE_2D);

			glActiveTexture (GL_TEXTURE0);
			glMatrixMode (GL_TEXTURE);
			glLoadIdentity ();
			glMatrixMode (GL_MODELVIEW);
		}
		else
		{
			glActiveTexture (GL_TEXTURE1);
			glBindTexture (GL_TEXTURE_2D, lightmap_textures + surf->lightmaptexturenum);

			for (i = 0, v = surf->polys->verts; i < surf->polys->numverts; i++, v+= VERTEXSIZE)
			{
				// invalidate the entire surf
				if (v[2] > mScale) goto done;
			}

			glDrawArrays (GL_TRIANGLE_FAN, surf->polys->saindex, surf->polys->numverts);
		}

done:;
	}

	glDisableClientState (GL_VERTEX_ARRAY);
	glDisableClientState (GL_TEXTURE_COORD_ARRAY);

	glActiveTexture (GL_TEXTURE1);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDisable (GL_TEXTURE_2D);
	glActiveTexture (GL_TEXTURE0);

	// mark the players position on the map
	glTranslatef (r_refdef.vieworg[0], r_refdef.vieworg[1], -7999);

	// make it green
	glColor3f (0, 1, 0);

	glDepthMask (GL_FALSE);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE);
	glDisable (GL_ALPHA_TEST);

	glBindTexture (GL_TEXTURE_2D, crosshairfont);

	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glBegin (GL_QUADS);

	// the orthographic projection used for the automap is potentially 8000 in either dimension, so
	// i need to increase the size of the crosshair verts to make it appear reasonably sized on the
	// map image.  these verts are good for e1m1 - they may not work so well with other maps...
	glTexCoord2f (0, 0);
	glVertex2f (-60, 0);

	glTexCoord2f (0, 1);
	glVertex2f (0, -60);

	glTexCoord2f (1, 1);
	glVertex2f (60, 0);

	glTexCoord2f (1, 0);
	glVertex2f (0, 60);

	glEnd ();

	glColor3f (1, 1, 1);

	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable (GL_BLEND);
	glDepthMask (GL_TRUE);
	glEnable (GL_ALPHA_TEST);
}


void R_AutomapScaleUp_f (void)
{
	mScale += 50;

	if (mScale > cl.worldmodel->minmaxz[1])
		mScale = cl.worldmodel->minmaxz[1];
}


void R_AutomapScaleDown_f (void)
{
	mScale -= 50;

	if (mScale < cl.worldmodel->minmaxz[0])
		mScale = cl.worldmodel->minmaxz[0];
}


void R_Automap_f (void)
{
	if (automapOn)
	{
		automapOn = false;
		Con_DPrintf ("Automap off\n");
	}
	else
	{
		automapOn = true;
		mScale = r_refdef.vieworg[2] + 50;
		Con_DPrintf ("Automap on\n");
	}
}

