/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef GL_SHADERS_INCLUDE
#define GL_SHADERS_INCLUDE

#include "glext.h"

// meaningful array indexes for shader loading
#define QGL_VERTEX_SHADER		0
#define QGL_FRAGMENT_SHADER		1

// meaningful array indexes for uniforms
#define UNIFORM_TEXCOORD0		0
#define UNIFORM_TEXCOORD1		1
#define UNIFORM_FOGEND			2
#define UNIFORM_FOGSTART		3
#define UNIFORM_FBMASK			4

// shaders in use
#define NO_PROGRAM_OBJECT		0
#define SHADER_SURFACEREFRESH	0

// total number of shaders in the game
#define TOTAL_SHADERS 1

// shader structure
typedef struct shaders_s
{
	GLhandle Shader[2];
	int ResourceID[2];
	GLhandle programObject;
	qboolean ShaderOK;
	int shaderNum;
	char shaderName[64];
	int UniformLocations[16];
} shaders_t;


extern shaders_t GL_Shaders[];
extern qboolean GimmeShader;

void GL_MakeProgramObject (int shaderNum);
void GL_DeleteShaders (void);

#endif
