/*
==============================================================================================
OpenGL defines and prototypes up to version 1.4

Most of these were taken from the glext.h available from SGI/OpenGL.org, and hacked around
with to work properly with Quakes rather strange way of doing things...
==============================================================================================
*/

#include <stddef.h>

// OpenGL 1.2 Defines
#define GL_UNSIGNED_BYTE_3_3_2            0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4         0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1         0x8034
#define GL_UNSIGNED_INT_8_8_8_8           0x8035
#define GL_UNSIGNED_INT_10_10_10_2        0x8036
#define GL_RESCALE_NORMAL                 0x803A
#define GL_TEXTURE_BINDING_3D             0x806A
#define GL_PACK_SKIP_IMAGES               0x806B
#define GL_PACK_IMAGE_HEIGHT              0x806C
#define GL_UNPACK_SKIP_IMAGES             0x806D
#define GL_UNPACK_IMAGE_HEIGHT            0x806E
#define GL_TEXTURE_3D                     0x806F
#define GL_PROXY_TEXTURE_3D               0x8070
#define GL_TEXTURE_DEPTH                  0x8071
#define GL_TEXTURE_WRAP_R                 0x8072
#define GL_MAX_3D_TEXTURE_SIZE            0x8073
#define GL_UNSIGNED_BYTE_2_3_3_REV        0x8362
#define GL_UNSIGNED_SHORT_5_6_5           0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV       0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV     0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV     0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV       0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV    0x8368
#define GL_BGR                            0x80E0
#define GL_BGRA                           0x80E1
#define GL_MAX_ELEMENTS_VERTICES          0x80E8
#define GL_MAX_ELEMENTS_INDICES           0x80E9
#define GL_CLAMP_TO_EDGE                  0x812F
#define GL_TEXTURE_MIN_LOD                0x813A
#define GL_TEXTURE_MAX_LOD                0x813B
#define GL_TEXTURE_BASE_LEVEL             0x813C
#define GL_TEXTURE_MAX_LEVEL              0x813D
#define GL_LIGHT_MODEL_COLOR_CONTROL      0x81F8
#define GL_SINGLE_COLOR                   0x81F9
#define GL_SEPARATE_SPECULAR_COLOR        0x81FA
#define GL_SMOOTH_POINT_SIZE_RANGE        0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY  0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE        0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY  0x0B23
#define GL_ALIASED_POINT_SIZE_RANGE       0x846D
#define GL_ALIASED_LINE_WIDTH_RANGE       0x846E


// OpenGL ARB Imaging Subset defines
#define GL_CONSTANT_COLOR                 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR       0x8002
#define GL_CONSTANT_ALPHA                 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA       0x8004
#define GL_BLEND_COLOR                    0x8005
#define GL_FUNC_ADD                       0x8006
#define GL_MIN                            0x8007
#define GL_MAX                            0x8008
#define GL_BLEND_EQUATION                 0x8009
#define GL_FUNC_SUBTRACT                  0x800A
#define GL_FUNC_REVERSE_SUBTRACT          0x800B
#define GL_CONVOLUTION_1D                 0x8010
#define GL_CONVOLUTION_2D                 0x8011
#define GL_SEPARABLE_2D                   0x8012
#define GL_CONVOLUTION_BORDER_MODE        0x8013
#define GL_CONVOLUTION_FILTER_SCALE       0x8014
#define GL_CONVOLUTION_FILTER_BIAS        0x8015
#define GL_REDUCE                         0x8016
#define GL_CONVOLUTION_FORMAT             0x8017
#define GL_CONVOLUTION_WIDTH              0x8018
#define GL_CONVOLUTION_HEIGHT             0x8019
#define GL_MAX_CONVOLUTION_WIDTH          0x801A
#define GL_MAX_CONVOLUTION_HEIGHT         0x801B
#define GL_POST_CONVOLUTION_RED_SCALE     0x801C
#define GL_POST_CONVOLUTION_GREEN_SCALE   0x801D
#define GL_POST_CONVOLUTION_BLUE_SCALE    0x801E
#define GL_POST_CONVOLUTION_ALPHA_SCALE   0x801F
#define GL_POST_CONVOLUTION_RED_BIAS      0x8020
#define GL_POST_CONVOLUTION_GREEN_BIAS    0x8021
#define GL_POST_CONVOLUTION_BLUE_BIAS     0x8022
#define GL_POST_CONVOLUTION_ALPHA_BIAS    0x8023
#define GL_HISTOGRAM                      0x8024
#define GL_PROXY_HISTOGRAM                0x8025
#define GL_HISTOGRAM_WIDTH                0x8026
#define GL_HISTOGRAM_FORMAT               0x8027
#define GL_HISTOGRAM_RED_SIZE             0x8028
#define GL_HISTOGRAM_GREEN_SIZE           0x8029
#define GL_HISTOGRAM_BLUE_SIZE            0x802A
#define GL_HISTOGRAM_ALPHA_SIZE           0x802B
#define GL_HISTOGRAM_LUMINANCE_SIZE       0x802C
#define GL_HISTOGRAM_SINK                 0x802D
#define GL_MINMAX                         0x802E
#define GL_MINMAX_FORMAT                  0x802F
#define GL_MINMAX_SINK                    0x8030
#define GL_TABLE_TOO_LARGE                0x8031
#define GL_COLOR_MATRIX                   0x80B1
#define GL_COLOR_MATRIX_STACK_DEPTH       0x80B2
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH   0x80B3
#define GL_POST_COLOR_MATRIX_RED_SCALE    0x80B4
#define GL_POST_COLOR_MATRIX_GREEN_SCALE  0x80B5
#define GL_POST_COLOR_MATRIX_BLUE_SCALE   0x80B6
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE  0x80B7
#define GL_POST_COLOR_MATRIX_RED_BIAS     0x80B8
#define GL_POST_COLOR_MATRIX_GREEN_BIAS   0x80B9
#define GL_POST_COLOR_MATRIX_BLUE_BIAS    0x80BA
#define GL_POST_COLOR_MATRIX_ALPHA_BIAS   0x80BB
#define GL_COLOR_TABLE                    0x80D0
#define GL_POST_CONVOLUTION_COLOR_TABLE   0x80D1
#define GL_POST_COLOR_MATRIX_COLOR_TABLE  0x80D2
#define GL_PROXY_COLOR_TABLE              0x80D3
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE 0x80D4
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE 0x80D5
#define GL_COLOR_TABLE_SCALE              0x80D6
#define GL_COLOR_TABLE_BIAS               0x80D7
#define GL_COLOR_TABLE_FORMAT             0x80D8
#define GL_COLOR_TABLE_WIDTH              0x80D9
#define GL_COLOR_TABLE_RED_SIZE           0x80DA
#define GL_COLOR_TABLE_GREEN_SIZE         0x80DB
#define GL_COLOR_TABLE_BLUE_SIZE          0x80DC
#define GL_COLOR_TABLE_ALPHA_SIZE         0x80DD
#define GL_COLOR_TABLE_LUMINANCE_SIZE     0x80DE
#define GL_COLOR_TABLE_INTENSITY_SIZE     0x80DF
#define GL_CONSTANT_BORDER                0x8151
#define GL_REPLICATE_BORDER               0x8153
#define GL_CONVOLUTION_BORDER_COLOR       0x8154


// OpenGL 1.3 Defines
#define GL_TEXTURE0                       0x84C0
#define GL_TEXTURE1                       0x84C1
#define GL_TEXTURE2                       0x84C2
#define GL_TEXTURE3                       0x84C3
#define GL_TEXTURE4                       0x84C4
#define GL_TEXTURE5                       0x84C5
#define GL_TEXTURE6                       0x84C6
#define GL_TEXTURE7                       0x84C7
#define GL_TEXTURE8                       0x84C8
#define GL_TEXTURE9                       0x84C9
#define GL_TEXTURE10                      0x84CA
#define GL_TEXTURE11                      0x84CB
#define GL_TEXTURE12                      0x84CC
#define GL_TEXTURE13                      0x84CD
#define GL_TEXTURE14                      0x84CE
#define GL_TEXTURE15                      0x84CF
#define GL_TEXTURE16                      0x84D0
#define GL_TEXTURE17                      0x84D1
#define GL_TEXTURE18                      0x84D2
#define GL_TEXTURE19                      0x84D3
#define GL_TEXTURE20                      0x84D4
#define GL_TEXTURE21                      0x84D5
#define GL_TEXTURE22                      0x84D6
#define GL_TEXTURE23                      0x84D7
#define GL_TEXTURE24                      0x84D8
#define GL_TEXTURE25                      0x84D9
#define GL_TEXTURE26                      0x84DA
#define GL_TEXTURE27                      0x84DB
#define GL_TEXTURE28                      0x84DC
#define GL_TEXTURE29                      0x84DD
#define GL_TEXTURE30                      0x84DE
#define GL_TEXTURE31                      0x84DF
#define GL_ACTIVE_TEXTURE                 0x84E0
#define GL_CLIENT_ACTIVE_TEXTURE          0x84E1
#define GL_MAX_TEXTURE_UNITS              0x84E2
#define GL_TRANSPOSE_MODELVIEW_MATRIX     0x84E3
#define GL_TRANSPOSE_PROJECTION_MATRIX    0x84E4
#define GL_TRANSPOSE_TEXTURE_MATRIX       0x84E5
#define GL_TRANSPOSE_COLOR_MATRIX         0x84E6
#define GL_MULTISAMPLE                    0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE       0x809E
#define GL_SAMPLE_ALPHA_TO_ONE            0x809F
#define GL_SAMPLE_COVERAGE                0x80A0
#define GL_SAMPLE_BUFFERS                 0x80A8
#define GL_SAMPLES                        0x80A9
#define GL_SAMPLE_COVERAGE_VALUE          0x80AA
#define GL_SAMPLE_COVERAGE_INVERT         0x80AB
#define GL_MULTISAMPLE_BIT                0x20000000
#define GL_NORMAL_MAP                     0x8511
#define GL_REFLECTION_MAP                 0x8512
#define GL_TEXTURE_CUBE_MAP               0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP       0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X    0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X    0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y    0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y    0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z    0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z    0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP         0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE      0x851C
#define GL_COMPRESSED_ALPHA               0x84E9
#define GL_COMPRESSED_LUMINANCE           0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA     0x84EB
#define GL_COMPRESSED_INTENSITY           0x84EC
#define GL_COMPRESSED_RGB                 0x84ED
#define GL_COMPRESSED_RGBA                0x84EE
#define GL_TEXTURE_COMPRESSION_HINT       0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE  0x86A0
#define GL_TEXTURE_COMPRESSED             0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS     0x86A3
#define GL_CLAMP_TO_BORDER                0x812D
#define GL_COMBINE                        0x8570
#define GL_COMBINE_RGB                    0x8571
#define GL_COMBINE_ALPHA                  0x8572
#define GL_SOURCE0_RGB                    0x8580
#define GL_SOURCE1_RGB                    0x8581
#define GL_SOURCE2_RGB                    0x8582
#define GL_SOURCE0_ALPHA                  0x8588
#define GL_SOURCE1_ALPHA                  0x8589
#define GL_SOURCE2_ALPHA                  0x858A
#define GL_OPERAND0_RGB                   0x8590
#define GL_OPERAND1_RGB                   0x8591
#define GL_OPERAND2_RGB                   0x8592
#define GL_OPERAND0_ALPHA                 0x8598
#define GL_OPERAND1_ALPHA                 0x8599
#define GL_OPERAND2_ALPHA                 0x859A
#define GL_RGB_SCALE                      0x8573
#define GL_ADD_SIGNED                     0x8574
#define GL_INTERPOLATE                    0x8575
#define GL_SUBTRACT                       0x84E7
#define GL_CONSTANT                       0x8576
#define GL_PRIMARY_COLOR                  0x8577
#define GL_PREVIOUS                       0x8578
#define GL_DOT3_RGB                       0x86AE
#define GL_DOT3_RGBA                      0x86AF


// OpenGL 1.4 Defines
#define GL_BLEND_DST_RGB                  0x80C8
#define GL_BLEND_SRC_RGB                  0x80C9
#define GL_BLEND_DST_ALPHA                0x80CA
#define GL_BLEND_SRC_ALPHA                0x80CB
#define GL_POINT_SIZE_MIN                 0x8126
#define GL_POINT_SIZE_MAX                 0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE      0x8128
#define GL_POINT_DISTANCE_ATTENUATION     0x8129
#define GL_GENERATE_MIPMAP                0x8191
#define GL_GENERATE_MIPMAP_HINT           0x8192
#define GL_DEPTH_COMPONENT16              0x81A5
#define GL_DEPTH_COMPONENT24              0x81A6
#define GL_DEPTH_COMPONENT32              0x81A7
#define GL_MIRRORED_REPEAT                0x8370
#define GL_FOG_COORDINATE_SOURCE          0x8450
#define GL_FOG_COORDINATE                 0x8451
#define GL_FRAGMENT_DEPTH                 0x8452
#define GL_CURRENT_FOG_COORDINATE         0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE      0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE    0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER   0x8456
#define GL_FOG_COORDINATE_ARRAY           0x8457
#define GL_COLOR_SUM                      0x8458
#define GL_CURRENT_SECONDARY_COLOR        0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE     0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE     0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE   0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER  0x845D
#define GL_SECONDARY_COLOR_ARRAY          0x845E
#define GL_MAX_TEXTURE_LOD_BIAS           0x84FD
#define GL_TEXTURE_FILTER_CONTROL         0x8500
#define GL_TEXTURE_LOD_BIAS               0x8501
#define GL_INCR_WRAP                      0x8507
#define GL_DECR_WRAP                      0x8508
#define GL_TEXTURE_DEPTH_SIZE             0x884A
#define GL_DEPTH_TEXTURE_MODE             0x884B
#define GL_TEXTURE_COMPARE_MODE           0x884C
#define GL_TEXTURE_COMPARE_FUNC           0x884D
#define GL_COMPARE_R_TO_TEXTURE           0x884E


// OpenGL 1.5 Defines
#define GL_BUFFER_SIZE                    0x8764
#define GL_BUFFER_USAGE                   0x8765
#define GL_QUERY_COUNTER_BITS             0x8864
#define GL_CURRENT_QUERY                  0x8865
#define GL_QUERY_RESULT                   0x8866
#define GL_QUERY_RESULT_AVAILABLE         0x8867
#define GL_ARRAY_BUFFER                   0x8892
#define GL_ELEMENT_ARRAY_BUFFER           0x8893
#define GL_ARRAY_BUFFER_BINDING           0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING   0x8895
#define GL_VERTEX_ARRAY_BUFFER_BINDING    0x8896
#define GL_NORMAL_ARRAY_BUFFER_BINDING    0x8897
#define GL_COLOR_ARRAY_BUFFER_BINDING     0x8898
#define GL_INDEX_ARRAY_BUFFER_BINDING     0x8899
#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING 0x889A
#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING 0x889B
#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING 0x889C
#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING 0x889D
#define GL_WEIGHT_ARRAY_BUFFER_BINDING    0x889E
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_READ_ONLY                      0x88B8
#define GL_WRITE_ONLY                     0x88B9
#define GL_READ_WRITE                     0x88BA
#define GL_BUFFER_ACCESS                  0x88BB
#define GL_BUFFER_MAPPED                  0x88BC
#define GL_BUFFER_MAP_POINTER             0x88BD
#define GL_STREAM_DRAW                    0x88E0
#define GL_STREAM_READ                    0x88E1
#define GL_STREAM_COPY                    0x88E2
#define GL_STATIC_DRAW                    0x88E4
#define GL_STATIC_READ                    0x88E5
#define GL_STATIC_COPY                    0x88E6
#define GL_DYNAMIC_DRAW                   0x88E8
#define GL_DYNAMIC_READ                   0x88E9
#define GL_DYNAMIC_COPY                   0x88EA
#define GL_SAMPLES_PASSED                 0x8914
#define GL_FOG_COORD_SRC                  GL_FOG_COORDINATE_SOURCE
#define GL_FOG_COORD                      GL_FOG_COORDINATE
#define GL_CURRENT_FOG_COORD              GL_CURRENT_FOG_COORDINATE
#define GL_FOG_COORD_ARRAY_TYPE           GL_FOG_COORDINATE_ARRAY_TYPE
#define GL_FOG_COORD_ARRAY_STRIDE         GL_FOG_COORDINATE_ARRAY_STRIDE
#define GL_FOG_COORD_ARRAY_POINTER        GL_FOG_COORDINATE_ARRAY_POINTER
#define GL_FOG_COORD_ARRAY                GL_FOG_COORDINATE_ARRAY
#define GL_FOG_COORD_ARRAY_BUFFER_BINDING GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
#define GL_SRC0_RGB                       GL_SOURCE0_RGB
#define GL_SRC1_RGB                       GL_SOURCE1_RGB
#define GL_SRC2_RGB                       GL_SOURCE2_RGB
#define GL_SRC0_ALPHA                     GL_SOURCE0_ALPHA
#define GL_SRC1_ALPHA                     GL_SOURCE1_ALPHA
#define GL_SRC2_ALPHA                     GL_SOURCE2_ALPHA


// OpenGL 1.2 Prototypes
void (APIENTRY *glBlendColor) (GLclampf, GLclampf, GLclampf, GLclampf);
void (APIENTRY *glBlendEquation) (GLenum);
void (APIENTRY *glDrawRangeElements) (GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid *);
void (APIENTRY *glColorTable) (GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glColorTableParameterfv) (GLenum, GLenum, const GLfloat *);
void (APIENTRY *glColorTableParameteriv) (GLenum, GLenum, const GLint *);
void (APIENTRY *glCopyColorTable) (GLenum, GLenum, GLint, GLint, GLsizei);
void (APIENTRY *glGetColorTable) (GLenum, GLenum, GLenum, GLvoid *);
void (APIENTRY *glGetColorTableParameterfv) (GLenum, GLenum, GLfloat *);
void (APIENTRY *glGetColorTableParameteriv) (GLenum, GLenum, GLint *);
void (APIENTRY *glColorSubTable) (GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glCopyColorSubTable) (GLenum, GLsizei, GLint, GLint, GLsizei);
void (APIENTRY *glConvolutionFilter1D) (GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glConvolutionFilter2D) (GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glConvolutionParameterf) (GLenum, GLenum, GLfloat);
void (APIENTRY *glConvolutionParameterfv) (GLenum, GLenum, const GLfloat *);
void (APIENTRY *glConvolutionParameteri) (GLenum, GLenum, GLint);
void (APIENTRY *glConvolutionParameteriv) (GLenum, GLenum, const GLint *);
void (APIENTRY *glCopyConvolutionFilter1D) (GLenum, GLenum, GLint, GLint, GLsizei);
void (APIENTRY *glCopyConvolutionFilter2D) (GLenum, GLenum, GLint, GLint, GLsizei, GLsizei);
void (APIENTRY *glGetConvolutionFilter) (GLenum, GLenum, GLenum, GLvoid *);
void (APIENTRY *glGetConvolutionParameterfv) (GLenum, GLenum, GLfloat *);
void (APIENTRY *glGetConvolutionParameteriv) (GLenum, GLenum, GLint *);
void (APIENTRY *glGetSeparableFilter) (GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid *);
void (APIENTRY *glSeparableFilter2D) (GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid *);
void (APIENTRY *glGetHistogram) (GLenum, GLboolean, GLenum, GLenum, GLvoid *);
void (APIENTRY *glGetHistogramParameterfv) (GLenum, GLenum, GLfloat *);
void (APIENTRY *glGetHistogramParameteriv) (GLenum, GLenum, GLint *);
void (APIENTRY *glGetMinmax) (GLenum, GLboolean, GLenum, GLenum, GLvoid *);
void (APIENTRY *glGetMinmaxParameterfv) (GLenum, GLenum, GLfloat *);
void (APIENTRY *glGetMinmaxParameteriv) (GLenum, GLenum, GLint *);
void (APIENTRY *glHistogram) (GLenum, GLsizei, GLenum, GLboolean);
void (APIENTRY *glMinmax) (GLenum, GLenum, GLboolean);
void (APIENTRY *glResetHistogram) (GLenum);
void (APIENTRY *glResetMinmax) (GLenum);
void (APIENTRY *glTexImage3D) (GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glTexSubImage3D) (GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *);
void (APIENTRY *glCopyTexSubImage3D) (GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);


// OpenGL 1.3 Prototypes
void (APIENTRY *glActiveTexture) (GLenum);
void (APIENTRY *glClientActiveTexture) (GLenum);
void (APIENTRY *glMultiTexCoord1d) (GLenum, GLdouble);
void (APIENTRY *glMultiTexCoord1dv) (GLenum, const GLdouble *);
void (APIENTRY *glMultiTexCoord1f) (GLenum, GLfloat);
void (APIENTRY *glMultiTexCoord1fv) (GLenum, const GLfloat *);
void (APIENTRY *glMultiTexCoord1i) (GLenum, GLint);
void (APIENTRY *glMultiTexCoord1iv) (GLenum, const GLint *);
void (APIENTRY *glMultiTexCoord1s) (GLenum, GLshort);
void (APIENTRY *glMultiTexCoord1sv) (GLenum, const GLshort *);
void (APIENTRY *glMultiTexCoord2d) (GLenum, GLdouble, GLdouble);
void (APIENTRY *glMultiTexCoord2dv) (GLenum, const GLdouble *);
void (APIENTRY *glMultiTexCoord2f) (GLenum, GLfloat, GLfloat);
void (APIENTRY *glMultiTexCoord2fv) (GLenum, const GLfloat *);
void (APIENTRY *glMultiTexCoord2i) (GLenum, GLint, GLint);
void (APIENTRY *glMultiTexCoord2iv) (GLenum, const GLint *);
void (APIENTRY *glMultiTexCoord2s) (GLenum, GLshort, GLshort);
void (APIENTRY *glMultiTexCoord2sv) (GLenum, const GLshort *);
void (APIENTRY *glMultiTexCoord3d) (GLenum, GLdouble, GLdouble, GLdouble);
void (APIENTRY *glMultiTexCoord3dv) (GLenum, const GLdouble *);
void (APIENTRY *glMultiTexCoord3f) (GLenum, GLfloat, GLfloat, GLfloat);
void (APIENTRY *glMultiTexCoord3fv) (GLenum, const GLfloat *);
void (APIENTRY *glMultiTexCoord3i) (GLenum, GLint, GLint, GLint);
void (APIENTRY *glMultiTexCoord3iv) (GLenum, const GLint *);
void (APIENTRY *glMultiTexCoord3s) (GLenum, GLshort, GLshort, GLshort);
void (APIENTRY *glMultiTexCoord3sv) (GLenum, const GLshort *);
void (APIENTRY *glMultiTexCoord4d) (GLenum, GLdouble, GLdouble, GLdouble, GLdouble);
void (APIENTRY *glMultiTexCoord4dv) (GLenum, const GLdouble *);
void (APIENTRY *glMultiTexCoord4f) (GLenum, GLfloat, GLfloat, GLfloat, GLfloat);
void (APIENTRY *glMultiTexCoord4fv) (GLenum, const GLfloat *);
void (APIENTRY *glMultiTexCoord4i) (GLenum, GLint, GLint, GLint, GLint);
void (APIENTRY *glMultiTexCoord4iv) (GLenum, const GLint *);
void (APIENTRY *glMultiTexCoord4s) (GLenum, GLshort, GLshort, GLshort, GLshort);
void (APIENTRY *glMultiTexCoord4sv) (GLenum, const GLshort *);
void (APIENTRY *glLoadTransposeMatrixf) (const GLfloat *);
void (APIENTRY *glLoadTransposeMatrixd) (const GLdouble *);
void (APIENTRY *glMultTransposeMatrixf) (const GLfloat *);
void (APIENTRY *glMultTransposeMatrixd) (const GLdouble *);
void (APIENTRY *glSampleCoverage) (GLclampf, GLboolean);
void (APIENTRY *glCompressedTexImage3D) (GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid *);
void (APIENTRY *glCompressedTexImage2D) (GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid *);
void (APIENTRY *glCompressedTexImage1D) (GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid *);
void (APIENTRY *glCompressedTexSubImage3D) (GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid *);
void (APIENTRY *glCompressedTexSubImage2D) (GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid *);
void (APIENTRY *glCompressedTexSubImage1D) (GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid *);
void (APIENTRY *glGetCompressedTexImage) (GLenum, GLint, GLvoid *);


// OpenGL 1.4 Prototypes
void (APIENTRY *glBlendFuncSeparate) (GLenum, GLenum, GLenum, GLenum);
void (APIENTRY *glFogCoordf) (GLfloat);
void (APIENTRY *glFogCoordfv) (const GLfloat *);
void (APIENTRY *glFogCoordd) (GLdouble);
void (APIENTRY *glFogCoorddv) (const GLdouble *);
void (APIENTRY *glFogCoordPointer) (GLenum, GLsizei, const GLvoid *);
void (APIENTRY *glMultiDrawArrays) (GLenum, GLint *, GLsizei *, GLsizei);
void (APIENTRY *glMultiDrawElements) (GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei);
void (APIENTRY *glPointParameterf) (GLenum, GLfloat);
void (APIENTRY *glPointParameterfv) (GLenum, const GLfloat *);
void (APIENTRY *glPointParameteri) (GLenum, GLint);
void (APIENTRY *glPointParameteriv) (GLenum, const GLint *);
void (APIENTRY *glSecondaryColor3b) (GLbyte, GLbyte, GLbyte);
void (APIENTRY *glSecondaryColor3bv) (const GLbyte *);
void (APIENTRY *glSecondaryColor3d) (GLdouble, GLdouble, GLdouble);
void (APIENTRY *glSecondaryColor3dv) (const GLdouble *);
void (APIENTRY *glSecondaryColor3f) (GLfloat, GLfloat, GLfloat);
void (APIENTRY *glSecondaryColor3fv) (const GLfloat *);
void (APIENTRY *glSecondaryColor3i) (GLint, GLint, GLint);
void (APIENTRY *glSecondaryColor3iv) (const GLint *);
void (APIENTRY *glSecondaryColor3s) (GLshort, GLshort, GLshort);
void (APIENTRY *glSecondaryColor3sv) (const GLshort *);
void (APIENTRY *glSecondaryColor3ub) (GLubyte, GLubyte, GLubyte);
void (APIENTRY *glSecondaryColor3ubv) (const GLubyte *);
void (APIENTRY *glSecondaryColor3ui) (GLuint, GLuint, GLuint);
void (APIENTRY *glSecondaryColor3uiv) (const GLuint *);
void (APIENTRY *glSecondaryColor3us) (GLushort, GLushort, GLushort);
void (APIENTRY *glSecondaryColor3usv) (const GLushort *);
void (APIENTRY *glSecondaryColorPointer) (GLint, GLenum, GLsizei, const GLvoid *);
void (APIENTRY *glWindowPos2d) (GLdouble, GLdouble);
void (APIENTRY *glWindowPos2dv) (const GLdouble *);
void (APIENTRY *glWindowPos2f) (GLfloat, GLfloat);
void (APIENTRY *glWindowPos2fv) (const GLfloat *);
void (APIENTRY *glWindowPos2i) (GLint, GLint);
void (APIENTRY *glWindowPos2iv) (const GLint *);
void (APIENTRY *glWindowPos2s) (GLshort, GLshort);
void (APIENTRY *glWindowPos2sv) (const GLshort *);
void (APIENTRY *glWindowPos3d) (GLdouble, GLdouble, GLdouble);
void (APIENTRY *glWindowPos3dv) (const GLdouble *);
void (APIENTRY *glWindowPos3f) (GLfloat, GLfloat, GLfloat);
void (APIENTRY *glWindowPos3fv) (const GLfloat *);
void (APIENTRY *glWindowPos3i) (GLint, GLint, GLint);
void (APIENTRY *glWindowPos3iv) (const GLint *);
void (APIENTRY *glWindowPos3s) (GLshort, GLshort, GLshort);
void (APIENTRY *glWindowPos3sv) (const GLshort *);


// OpenGL 1.5 Typedefs
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;


// OpenGL 1.5 Prototypes
void (APIENTRY *glGenQueries) (GLsizei, GLuint *);
void (APIENTRY *glDeleteQueries) (GLsizei, const GLuint *);
GLboolean (APIENTRY *glIsQuery) (GLuint);
void (APIENTRY *glBeginQuery) (GLenum, GLuint);
void (APIENTRY *glEndQuery) (GLenum);
void (APIENTRY *glGetQueryiv) (GLenum, GLenum, GLint *);
void (APIENTRY *glGetQueryObjectiv) (GLuint, GLenum, GLint *);
void (APIENTRY *glGetQueryObjectuiv) (GLuint, GLenum, GLuint *);
void (APIENTRY *glBindBuffer) (GLenum, GLuint);
void (APIENTRY *glDeleteBuffers) (GLsizei, const GLuint *);
void (APIENTRY *glGenBuffers) (GLsizei, GLuint *);
GLboolean (APIENTRY *glIsBuffer) (GLuint);
void (APIENTRY *glBufferData) (GLenum, GLsizeiptr, const GLvoid *, GLenum);
void (APIENTRY *glBufferSubData) (GLenum, GLintptr, GLsizeiptr, const GLvoid *);
void (APIENTRY *glGetBufferSubData) (GLenum, GLintptr, GLsizeiptr, GLvoid *);
GLvoid* (APIENTRY *glMapBuffer) (GLenum, GLenum);
GLboolean (APIENTRY *glUnmapBuffer) (GLenum);
void (APIENTRY *glGetBufferParameteriv) (GLenum, GLenum, GLint *);
void (APIENTRY *glGetBufferPointerv) (GLenum, GLenum, GLvoid* *);



/*
================================================================================================

				SHADERS

	I've removed the "ARB" from the end of all these

================================================================================================
*/

typedef char GLchar;		/* native character */
typedef unsigned int GLhandle;	/* shader object handle */

#define GL_PROGRAM_OBJECT             0x8B40
#define GL_SHADER_OBJECT              0x8B48
#define GL_OBJECT_TYPE                0x8B4E
#define GL_OBJECT_SUBTYPE             0x8B4F
#define GL_FLOAT_VEC2                 0x8B50
#define GL_FLOAT_VEC3                 0x8B51
#define GL_FLOAT_VEC4                 0x8B52
#define GL_INT_VEC2                   0x8B53
#define GL_INT_VEC3                   0x8B54
#define GL_INT_VEC4                   0x8B55
#define GL_BOOL                       0x8B56
#define GL_BOOL_VEC2                  0x8B57
#define GL_BOOL_VEC3                  0x8B58
#define GL_BOOL_VEC4                  0x8B59
#define GL_FLOAT_MAT2                 0x8B5A
#define GL_FLOAT_MAT3                 0x8B5B
#define GL_FLOAT_MAT4                 0x8B5C
#define GL_OBJECT_DELETE_STATUS       0x8B80
#define GL_OBJECT_COMPILE_STATUS      0x8B81
#define GL_OBJECT_LINK_STATUS         0x8B82
#define GL_OBJECT_VALIDATE_STATUS     0x8B83
#define GL_OBJECT_INFO_LOG_LENGTH     0x8B84
#define GL_OBJECT_ATTACHED_OBJECTS    0x8B85
#define GL_OBJECT_ACTIVE_UNIFORMS     0x8B86
#define GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_OBJECT_SHADER_SOURCE_LENGTH 0x8B88

#define GL_VERTEX_SHADER              0x8B31
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS 0x8B4A
#define GL_MAX_VARYING_FLOATS         0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_OBJECT_ACTIVE_ATTRIBUTES   0x8B89
#define GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A

#define GL_FRAGMENT_SHADER            0x8B30
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49


void (APIENTRY *glDeleteObject) (GLhandle obj);
GLhandle (APIENTRY *glGetHandle) (GLenum pname);
void (APIENTRY *glDetachObject) (GLhandle containerObj, GLhandle attachedObj);
GLhandle (APIENTRY *glCreateShaderObject) (GLenum shaderType);
void (APIENTRY *glShaderSource) (GLhandle shaderObj, GLsizei count, const GLchar* *string, const GLint *length);
void (APIENTRY *glCompileShader) (GLhandle shaderObj);
GLhandle (APIENTRY *glCreateProgramObject) (void);
void (APIENTRY *glAttachObject) (GLhandle containerObj, GLhandle obj);
void (APIENTRY *glLinkProgram) (GLhandle programObj);
void (APIENTRY *glUseProgramObject) (GLhandle programObj);
void (APIENTRY *glValidateProgram) (GLhandle programObj);
void (APIENTRY *glUniform1f) (GLint location, GLfloat v0);
void (APIENTRY *glUniform2f) (GLint location, GLfloat v0, GLfloat v1);
void (APIENTRY *glUniform3f) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
void (APIENTRY *glUniform4f) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
void (APIENTRY *glUniform1i) (GLint location, GLint v0);
void (APIENTRY *glUniform2i) (GLint location, GLint v0, GLint v1);
void (APIENTRY *glUniform3i) (GLint location, GLint v0, GLint v1, GLint v2);
void (APIENTRY *glUniform4i) (GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
void (APIENTRY *glUniform1fv) (GLint location, GLsizei count, const GLfloat *value);
void (APIENTRY *glUniform2fv) (GLint location, GLsizei count, const GLfloat *value);
void (APIENTRY *glUniform3fv) (GLint location, GLsizei count, const GLfloat *value);
void (APIENTRY *glUniform4fv) (GLint location, GLsizei count, const GLfloat *value);
void (APIENTRY *glUniform1iv) (GLint location, GLsizei count, const GLint *value);
void (APIENTRY *glUniform2iv) (GLint location, GLsizei count, const GLint *value);
void (APIENTRY *glUniform3iv) (GLint location, GLsizei count, const GLint *value);
void (APIENTRY *glUniform4iv) (GLint location, GLsizei count, const GLint *value);
void (APIENTRY *glUniformMatrix2fv) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void (APIENTRY *glUniformMatrix3fv) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void (APIENTRY *glUniformMatrix4fv) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void (APIENTRY *glGetObjectParameterfv) (GLhandle obj, GLenum pname, GLfloat *params);
void (APIENTRY *glGetObjectParameteriv) (GLhandle obj, GLenum pname, GLint *params);
void (APIENTRY *glGetInfoLog) (GLhandle obj, GLsizei maxLength, GLsizei *length, GLchar *infoLog);
void (APIENTRY *glGetAttachedObjects) (GLhandle containerObj, GLsizei maxCount, GLsizei *count, GLhandle *obj);
GLint (APIENTRY *glGetUniformLocation) (GLhandle programObj, const GLchar *name);
void (APIENTRY *glGetActiveUniform) (GLhandle programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
void (APIENTRY *glGetUniformfv) (GLhandle programObj, GLint location, GLfloat *params);
void (APIENTRY *glGetUniformiv) (GLhandle programObj, GLint location, GLint *params);
void (APIENTRY *glGetShaderSource) (GLhandle obj, GLsizei maxLength, GLsizei *length, GLchar *source);


// anisotropic filtering
#define GL_TEXTURE_MAX_ANISOTROPY		0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY	0x84FF

// NVIDIA texture shader
#define GL_DSDT8_NV							0x8709
#define GL_DSDT_NV							0x86F5
#define GL_TEXTURE_SHADER_NV				0x86DE
#define GL_SHADER_OPERATION_NV				0x86DF
#define GL_OFFSET_TEXTURE_2D_NV				0x86E8
#define GL_PREVIOUS_TEXTURE_INPUT_NV		0x86E4
#define GL_OFFSET_TEXTURE_MATRIX_NV			0x86E1


// OpenGL 1.5 Vertex Buffers
