/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// disable data conversion warnings

#pragma warning(disable : 4244)     // MIPS
#pragma warning(disable : 4136)     // X86
#pragma warning(disable : 4051)     // ALPHA
  
#ifdef _WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

void GL_BeginRendering (int *x, int *y, int *width, int *height);
void GL_EndRendering (void);


extern	int texture_extension_number;

extern	float	gldepthmin, gldepthmax;

image_t *GL_LoadTexture (char *identifier, int width, int height, byte *data, qboolean mipmap, qboolean alpha);
int GL_FindTexture (char *identifier);


extern	int glx, gly, glwidth, glheight;

// r_local.h -- private refresh defs
#define ALIAS_BASE_SIZE_RATIO		(1.0 / 11.0)
					// normalizing factor so player model works out to about
					//  1 pixel per triangle
#define	MAX_LBM_HEIGHT		480

#define BACKFACE_EPSILON	0.01


void R_TimeRefresh_f (void);
void R_ReadPointFile_f (void);



//====================================================


extern	entity_t	r_worldentity;
extern	vec3_t		modelorg, r_entorigin;
extern	entity_t	*currententity;
extern	int			r_visframecount;	// ??? what difs?
extern	unsigned int			r_framecount;
extern	mplane_t	frustum[4];
extern	int		c_brush_polys, c_alias_polys;


//
// view origin
//
extern	vec3_t	vup;
extern	vec3_t	vpn;
extern	vec3_t	vright;
extern	vec3_t	r_origin;

//
// screen size info
//
extern	refdef_t	r_refdef;
extern	mleaf_t		*r_viewleaf, *r_oldviewleaf;

extern	int		d_lightstylevalue[256];	// 8.8 fraction of base light value

extern	qboolean	envmap;
extern	int	playertextures;

extern	cvar_t	r_norefresh;
extern	cvar_t	r_drawentities;
extern	cvar_t	r_drawworld;
extern	cvar_t	r_drawviewmodel;
extern	cvar_t	r_speeds;
extern	cvar_t	r_waterwarp;
extern	cvar_t	r_lightmap;
extern	cvar_t	r_shadows;
extern	cvar_t	r_wateralpha;
extern	cvar_t	r_dynamic;
extern	cvar_t	r_novis;

extern	cvar_t	gl_clear;
extern	cvar_t	gl_cull;
extern	cvar_t	gl_poly;
extern	cvar_t	gl_smoothmodels;
extern	cvar_t	gl_affinemodels;
extern	cvar_t	gl_polyblend;
extern	cvar_t	gl_keeptjunctions;
extern	cvar_t	gl_reporttjunctions;
extern	cvar_t	gl_nocolors;
extern	cvar_t	gl_doubleeyes;

extern	cvar_t	gl_playermip;

extern	const char *gl_vendor;
extern	const char *gl_renderer;
extern	const char *gl_version;
extern	const char *gl_extensions;

void R_TranslatePlayerSkin (int playernum);



#ifndef _WIN32
#define APIENTRY /* */
#endif


// fog support
extern cvar_t gl_fogenable;
extern cvar_t gl_fogstart;
extern cvar_t gl_fogend;
extern cvar_t gl_fogdensity;
extern cvar_t gl_fogr;
extern cvar_t gl_fogg;
extern cvar_t gl_fogb;
extern cvar_t gl_foguser;

extern float water_fog[4];
extern float world_fog[4];
extern float sky_fog[4];
extern float generic_fog[4];

#define FOG_NONE		0
#define FOG_WORLD		1
#define FOG_SKY			2
#define FOG_WATER		3
#define FOG_REVERT		4
#define FOG_WATERSURF	5


void R_SetFog (int fogType);

// fix a long standing MH Quake bug - this array had no bounds checking and some mods
// used alias models with higher numbers of verts.  this will make it safe
extern GLfloat VArray[];


// gl 2d picture
typedef struct glpic_s
{
	int		texnum;
	float	sl, tl, sh, th;
} glpic_t;


extern cvar_t gl_blend_src;
extern cvar_t gl_blend_dst;
extern cvar_t r_farclip;

void GL_BlendTest (void);

void GL_TileTexture (unsigned int *in, unsigned int *out, int inWidth, int inHeight, int tileX, int tileY);

extern int gl_textureunits;

qboolean FindFullbrightTexture (byte *pixels, int num_pix);
void ConvertPixels (byte *pixels, int num_pixels, int alphaColour);
void RemoveFullBrights (byte *pixels, int num_pixels, int alphaColour);
void AverageColour (byte *pixels, int num_pixels);
void GL_LoadMapTexture (texture_t *tx);


void R_ApplyStains (mnode_t *node);

extern float frametime;
extern texture_t *r_notexture_mip;

// increase for higher precision, decrease for lower precision
// gives same results as the old gl_warpsin.h when set to 256
// beyond a certain size rounding errors give extremely jerky results
// 1024 is a good balance
#define SINTABLE_SIZE 1024

extern float sintable[SINTABLE_SIZE];

extern int STBitMask;

extern float STMult;

extern int crosshairfont;
extern int particlefont;
extern int logoTex;

qboolean LoadBMPResource (GLenum BMPFormat, int BMPResourceID, int glTextureNum, qboolean mipmap, qboolean alpha);
void LoadResourceTextures (void);
char *Mod_FindWorldSpawnEntry (model_t *mod, char *KeyToFind);
msurface_t *SurfContainsPoint (vec3_t pt, float fudge);
void R_RunGunshotEffect (vec3_t org, int count, int colour);
void R_RunGunshotEffect2 (vec3_t org, vec3_t angles, int count, int colour);
extern cvar_t crosshaircolour;

extern float GL_MaxAnisotropy;
extern cvar_t	gl_anisotropicfilter;

extern cvar_t gl_vertexlight;

// vertex buffers
extern int r_worldvb;
extern qboolean OpenGL_1_5;

