/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// refresh.h -- public interface to refresh functions

#define	MAXCLIPPLANES	11

#define	TOP_RANGE		16			// soldier uniform colors
#define	BOTTOM_RANGE	96

//=============================================================================

typedef struct efrag_s
{
	struct mleaf_s		*leaf;
	struct efrag_s		*leafnext;
	struct entity_s		*entity;
	struct efrag_s		*entnext;
} efrag_t;


#define ENTCONTENTS_EMPTY	0
#define ENTCONTENTS_WATER	1
#define ENTCONTENTS_MIXED	2

typedef struct entity_s
{
	qboolean				forcelink;		// model changed

	int						update_type;

	entity_state_t			baseline;		// to fill in defaults in updates

	double					msgtime;		// time of last update
	vec3_t					msg_origins[2];	// last two updates (0 is newest)	
	vec3_t					origin;
	vec3_t					msg_angles[2];	// last two updates (0 is newest)
	vec3_t					angles;	
	struct model_s			*model;			// NULL = no model
	struct efrag_s			*efrag;			// linked list of efrags
	int						frame;
	float					syncbase;		// for client-side animations
	byte					*colormap;
	int						effects;		// light, particals, etc
	int						skinnum;		// for Alias models
	unsigned int						visframe;		// last frame this entity was
											//  found in an active leaf
											
	int						dlightframe;	// dynamic lighting
	int						dlightbits;
	
	// interpolation
	float					frameStartTime;
	float					frameInterval;
	int						pose1;
	int						pose2;

	float					translateStartTime;
	vec3_t					origin1;
	vec3_t					origin2;

	float					rotateStartTime;
	vec3_t					angles1;
	vec3_t					angles2;

	vec3_t					lastShadeLight;
	int						leafContents;	// 0 = empty, 1 = underwater, 2 = mixed

	qboolean				isstatic;

	// set to true to notify the client that the edict is dead
	qboolean				dead;

	// set to true when all dead stuff has been processed
	qboolean				alreadydead;

	// store the modelview matrix for entities rather than models cos multiple entities may share a single model!!!
	// this is only used for drawing shadows of alias models and for any time we wish to restore the world matrix.
	// using it as a full matrix caching system *does* *not* *work* as the player is also moving here, which is
	// not factored into the cached matrix.
	float					MViewMatrix[16];

	// how big does this need to be anyway?  MAX_ALIAS_VERTS is set just to be safe...
	// at 50 odd visible ents per frame (which seems a reasonable max) it's only about 1.5 MB of
	// a RAM overhead.  cl_visedicts is a big static array, alright, but it's also an array of
	// pointers, so unless an ent is visible it won't have memory allocated.
	float					shadowverts[8192];
	struct mplane_s			*lightplane;
	vec3_t					lightspot;

// FIXME: could turn these into a union
	int						trivial_accept;
	struct mnode_s			*topnode;		// for bmodels, first world node
											//  that splits bmodel, or NULL if
											//  not split
} entity_t;

// !!! if this is changed, it must be changed in asm_draw.h too !!!
typedef struct
{
	vrect_t		vrect;				// subwindow in video for refresh

	vec3_t		vieworg;
	vec3_t		viewangles;

	float		fov_x, fov_y;
} refdef_t;


// refresh
extern	refdef_t	r_refdef;
extern vec3_t	r_origin, vpn, vright, vup;




void R_Init (void);
void R_InitTextures (void);
void R_InitEfrags (void);
void R_RenderView (void);		// must set r_refdef first
void R_InitSky (struct texture_s *mt);	// called at level load

void R_AddEfrags (entity_t *ent);
void R_RemoveEfrags (entity_t *ent);

void R_NewMap (void);


void R_ParseParticleEffect (void);
void R_RunParticleEffect (vec3_t org, vec3_t dir, int color, int count);
void R_RocketTrail (vec3_t start, vec3_t end, int type);

void R_EntityParticles (entity_t *ent);
void R_BlobExplosion (vec3_t org);
void R_ParticleExplosion (vec3_t org);
void R_ParticleExplosion2 (vec3_t org, int colorStart, int colorLength);
void R_LavaSplash (vec3_t org);
void R_TeleportSplash (vec3_t org);

