/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// chase.c -- chase camera code

#include "quakedef.h"

cvar_t	chase_back = {"chase_back", "100", true}; // Manoel Kasimier - edited
cvar_t	chase_up = {"chase_up", "16", true}; // Manoel Kasimier - edited
cvar_t	chase_right = {"chase_right", "0"};
cvar_t	chase_active = {"chase_active", "0", true}; // Manoel Kasimier - edited

/*/// Manoel Kasimier
vec3_t	chase_pos;
vec3_t	chase_angles;

vec3_t	chase_dest;
vec3_t	chase_dest_angles;
//*/// Manoel Kasimier

void Chase_Init (void)
{
	Cvar_RegisterVariable (&chase_back);
	Cvar_RegisterVariable (&chase_up);
	Cvar_RegisterVariable (&chase_right);
	Cvar_RegisterVariable (&chase_active);
}

/*/// Manoel Kasimier
void Chase_Reset (void)
{
	// for respawning and teleporting
//	start position 12 units behind head
}

void TraceLine (vec3_t start, vec3_t end, vec3_t impact)
{
	trace_t	trace;

	memset (&trace, 0, sizeof(trace));
	SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, start, end, &trace);

	VectorCopy (trace.endpos, impact);
}
//*/// Manoel Kasimier

void Chase_Update (void)
{
	int		i;
//	float	dist; // Manoel Kasimier - removed
	vec3_t	forward, up, right;
//	vec3_t	dest, stop; // Manoel Kasimier - removed
	vec3_t	chase_dest; // Manoel Kasimier
	trace_t	trace; // Manoel Kasimier


	// if can't see player, reset
	AngleVectors (cl.viewangles, forward, right, up);

	// calc exact destination
	for (i=0 ; i<3 ; i++)
		chase_dest[i] = r_refdef.vieworg[i] 
		+ up[i]*chase_up.value // Manoel Kasimier
		- forward[i]*chase_back.value
		- right[i]*chase_right.value;
// Manoel Kasimier - begin
	if (sv.active)
	{
		// hack to prevent the camera from seeing through solid objects.
		// not all solid objects are detected, and it crashes on demo play (hence the "if (sv.active)").
		// start, mins, maxs, end, nomonsters, ignore_ent
		trace = SV_Move (r_refdef.vieworg, vec3_origin, vec3_origin, chase_dest, false, G_EDICT(cl.viewentity));
	}
	else //if (chase_active.value)
	{
		memset (&trace, 0, sizeof(trace));
		SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, r_refdef.vieworg, chase_dest, &trace);
	}

	if (Length(trace.endpos) == 0) // no bateu na parede
	{
		VectorCopy (chase_dest, r_refdef.vieworg);
	}
	else
	{
		VectorCopy (trace.endpos, r_refdef.vieworg);
	}
// Manoel Kasimier - end

/*/// Manoel Kasimier
//	TraceLine(r_refdef.vieworg, chase_dest, r_refdef.vieworg); // Manoel Kasimier
	chase_dest[2] = r_refdef.vieworg[2] + chase_up.value;

	// find the spot the player is looking at
	VectorMA (r_refdef.vieworg, 4096, forward, dest);
	TraceLine (r_refdef.vieworg, dest, stop);

	// calculate pitch to look at the same spot from camera
	VectorSubtract (stop, r_refdef.vieworg, stop);
	dist = DotProduct (stop, forward);
	if (dist < 1)
		dist = 1;
	r_refdef.viewangles[PITCH] = -atan(stop[2] / dist) / M_PI * 180;

	// move towards destination
	VectorCopy (chase_dest, r_refdef.vieworg);

//*/// Manoel Kasimier
}

