#include "quakedef.h"
int  num_texture_maps;

typedef struct texture_map_s 
{
    char name[64];
    int  index;
} texture_map_t;

texture_map_t* texture_maps;

typedef struct
{
	int  texnum;
	char identifier[64];
	int  width, height;
	qboolean mipmap;
	int		bytesperpixel;
	int		lhcsum;
} gltexture_t;

#define MAX_GLTEXTURES 1024
gltexture_t gltextures[MAX_GLTEXTURES];
extern int   numgltextures;

void GL_UploadTGA(unsigned *data, int width, int height, qboolean mipmap,	qboolean picmip, qboolean alpha, qboolean clampmap)
{
	int   samples;
    static unsigned scaled[1024*512]; // [512*256];
	int   scaled_width, scaled_height;

	// alpha = true;//TROND 5/6 tga conchars

	for (scaled_width = 1 ; scaled_width < width ; scaled_width<<=1);
	{
		for (scaled_height = 1 ; scaled_height < height ; scaled_height<<=1);
		{
			if (scaled_width > gl_max_size.value)
			{
				scaled_width = gl_max_size.value;
			}
			if (scaled_height > gl_max_size.value)
			{
				scaled_height = gl_max_size.value;
			}
			if (scaled_width * scaled_height > sizeof(scaled)/4)
			{
				Sys_Error ("GL_LoadTexture: too big");
			}
		}
	}
	samples = alpha ? gl_alpha_format : gl_solid_format;

	if (scaled_width == width && scaled_height == height)
	{
		if (!mipmap)
		{
			glTexImage2D (GL_TEXTURE_2D, 0, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
			goto done;
		}
		memcpy (scaled, data, width*height*4);
	}
	else
	{
		GL_ResampleTexture (data, width, height, scaled, scaled_width, scaled_height);
	}
	glTexImage2D (GL_TEXTURE_2D, 0, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, scaled);
	if (mipmap)
	{
		int  miplevel;

		miplevel = 0;
		while (scaled_width > 1 || scaled_height > 1)
		{
			GL_MipMap ((byte *)scaled, scaled_width, scaled_height);
			scaled_width >>= 1;
			scaled_height >>= 1;
			if (scaled_width < 1)
			{
				scaled_width = 1;
			}
			if (scaled_height < 1)
			{
				scaled_height = 1;
			}
			miplevel++;
			glTexImage2D (GL_TEXTURE_2D, miplevel, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, scaled);
		}
	}
	done:;

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);
}

int GL_LoadTextureTGA(char* identifier, int width, int height, int* data, qboolean mipmap, qboolean picmip, qboolean alpha, qboolean clampmap)
{
	qboolean noalpha;
	gltexture_t *glt;
	int		i, p, s;
	int		lhcsum;

	lhcsum = 0;
	// see if the texture is allready present
	if (identifier[0])
	{
		for (i=0, glt=gltextures ; i<numgltextures ; i++, glt++)
		{
			if (!strcmp (identifier, glt->identifier))
			{
				if (lhcsum != glt->lhcsum || width != glt->width || height != glt->height)
				{
					Con_DPrintf("GL_LoadTexture: cache mismatch, replacing old texture\n");
					goto GL_LoadTexture_setup; // drop out with glt pointing to the texture to replace
				}
				return glt->texnum;
			}
		}
	}
	else 
	{
		// whoever at id or threewave must've been half asleep...
		glt = &gltextures[numgltextures];
		numgltextures++;
	}
	strcpy (glt->identifier, identifier);
	glt->texnum = texture_extension_number;
	texture_extension_number++;

	GL_LoadTexture_setup:
	glt->lhcsum = lhcsum;
	glt->width = width;
	glt->height = height;
	glt->mipmap = mipmap;

	GL_Bind(texture_extension_number );

	GL_UploadTGA (data, width, height, mipmap, picmip, alpha, clampmap);

	texture_extension_number++;

	return texture_extension_number-1;
}

/*
=========================================================

TARGA LOADING

=========================================================
*/

typedef struct _TargaHeader {
unsigned char  id_length, colormap_type, image_type;
unsigned short colormap_index, colormap_length;
unsigned char colormap_size;
unsigned short x_origin, y_origin, width, height;
unsigned char pixel_size, attributes;
} TargaHeader;


TargaHeader  targa_header;
byte   *targa_rgba;

int TA_LoadTGA(const char* name)
{
	int   bilde;
	FILE*  fd;
	char  path[32];

	strcat((char *)name, ".tga");
	sprintf (path, "textures/%s", name);

	COM_FOpenFile (path, &fd);

	if (!fd) 
	{
		return 65536;//draws LMP when cannot find matching TGA
	}

	LoadTGA(fd);

	texture_maps = Hunk_AllocName(sizeof(texture_map_t) * 1024, "texture_maps");

	bilde = GL_LoadTextureTGA(path, targa_header.width, targa_header.height, (int*)targa_rgba, 1, 0, 0, 0);

	free (targa_rgba);

	return bilde;
}
// ENDS