/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// mathlib.h
// Tomaz - Whole File Redone
typedef float vec_t;
typedef vec_t vec3_t[3];
typedef vec_t vec5_t[5];

typedef	int	fixed4_t;
typedef	int	fixed8_t;
typedef	int	fixed16_t;

#ifndef M_PI
#define M_PI		3.141592653589793	// matches value in gcc v2 math.h
#endif

struct	mplane_s;

extern	vec3_t vec3_origin;
extern	int nanmask;

#define	IS_NAN(x) (((*(int *)&x)&nanmask)==nanmask)
#define DEG2RAD( a ) ( a * degRadScalar )

#define DotProduct(x,y) (x[0]*y[0]+x[1]*y[1]+x[2]*y[2])
#define Length(v) (sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]))
#define VectorCompare(v1, v2) ((v1[0] == v2[0]) & (v1[1] == v2[1]) & (v1[2] == v2[2]))

#define VectorSubtract(a,b,c)								\
{															\
	c[0]	= a[0] - b[0];									\
	c[1]	= a[1] - b[1];									\
	c[2]	= a[2] - b[2];									\
}

#define VectorAdd(a,b,c)									\
{															\
	c[0]	= a[0] + b[0];									\
	c[1]	= a[1] + b[1];									\
	c[2]	= a[2] + b[2];									\
}

#define VectorScale(a,b,c)									\
{															\
	c[0]	= a[0] * b;										\
	c[1]	= a[1] * b;										\
	c[2]	= a[2] * b;										\
}

#define VectorCopy(in,out)									\
{															\
	out[0]	= in[0];										\
	out[1]	= in[1];										\
	out[2]	= in[2];										\
}

#define VectorInverse(v)									\
{															\
	v[0]	= -v[0];										\
	v[1]	= -v[1];										\
	v[2]	= -v[2];										\
}

#define CrossProduct(v1,v2,cross)							\
{															\
	cross[0] = v1[1] * v2[2] - v1[2] * v2[1];				\
	cross[1] = v1[2] * v2[0] - v1[0] * v2[2];				\
	cross[2] = v1[0] * v2[1] - v1[1] * v2[0];				\
}

#define VectorMA(a,s,b,c)									\
{															\
	c[0]	= a[0] + (s * b[0]);							\
	c[1]	= a[1] + (s * b[1]);							\
	c[2]	= a[2] + (s * b[2]);							\
}

void	VectorScalarMult(vec3_t veca, vec3_t vecb, vec3_t out); 
float	VectorNormalize(vec3_t v);

int		Q_log2(int val);
void	R_ConcatRotations (float in1[3][3], float in2[3][3], float out[3][3]);
void	R_ConcatTransforms (float in1[3][4], float in2[3][4], float out[3][4]);

void	FloorDivMod (double numer, double denom, int *quotient,	int *rem);
fixed16_t Invert24To16(fixed16_t val);
int		GreatestCommonDivisor (int i1, int i2);

void	AngleVectors (vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
int		BoxOnPlaneSide (vec3_t emins, vec3_t emaxs, struct mplane_s *plane);
float	anglemod(float a);

#define BOX_ON_PLANE_SIDE(emins, emaxs, p)	\
	(((p)->type < 3)?						\
	(										\
		((p)->dist <= (emins)[(p)->type])?	\
			1								\
		:									\
		(									\
			((p)->dist >= (emaxs)[(p)->type])?\
				2							\
			:								\
				3							\
		)									\
	)										\
	:										\
		BoxOnPlaneSide( (emins), (emaxs), (p)))

extern	float			degRadScalar;
extern	double			angleModScalar1;
extern	double			angleModScalar2;

void	Math_Init();