/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2012 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// r_misc.c

#include "quakedef.h"

//johnfitz -- new cvars
extern cvar_t r_stereo;
extern cvar_t r_stereodepth;
extern cvar_t r_clearcolor;
extern cvar_t r_drawflat;
extern cvar_t r_flatlightstyles;
extern cvar_t gl_fullbrights;
extern cvar_t gl_farclip;
extern cvar_t gl_overbright;
extern cvar_t gl_overbright_models;
extern cvar_t r_waterquality;
extern cvar_t r_oldwater;
extern cvar_t r_waterwarp;
extern cvar_t r_oldskyleaf;
extern cvar_t r_drawworld;
extern cvar_t r_showtris;
extern cvar_t r_showbboxes;
extern cvar_t r_lerpmodels;
extern cvar_t r_lerpmove;
extern cvar_t r_nolerp_list;
//johnfitz
#ifdef SUPPORTS_NOSHADOW_FBRIGHTHACK_CVARS // Baker change
extern cvar_t r_noshadow_list;
extern cvar_t r_fbrighthack_list;
#endif // Baker change +


extern float load_subdivide_size; //johnfitz -- remember what subdivide_size value was when this map was loaded

extern cvar_t gl_subdivide_size; //johnfitz -- moved here from gl_model.c

#if !defined(SUPPORTS_COLORMAPPING_EVERYTHING) // Baker change
extern gltexture_t *playertextures[MAX_SCOREBOARD]; //johnfitz
#endif // Baker change -

#ifdef SUPPORTS_COMMA_DELIM_FIX // Baker change
void R_Modelflags_Refresh_f (void);
#else // Baker change +
void R_NoLerpList_f (void); //johnfitz
#endif // Baker change -
/*
====================
GL_Overbright_f -- johnfitz
====================
*/
void GL_Overbright_f (void)
{
	R_RebuildAllLightmaps ();
}

/*
====================
GL_Fullbrights_f -- johnfitz
====================
*/
void GL_Fullbrights_f (void)
{
	TexMgr_ReloadNobrightImages ();
}

/*
====================
R_SetClearColor_f -- johnfitz
====================
*/
void R_SetClearColor_f (void)
{
	byte	*rgb;
	int		s;

	s = (int)r_clearcolor.value & 0xFF;
	rgb = (byte*)(d_8to24table + s);
	glClearColor (rgb[0]/255.0,rgb[1]/255.0,rgb[2]/255.0,0);
}

/*
====================
R_Novis_f -- johnfitz
====================
*/
void R_Novis_f (void)
{
	extern int vis_changed;
	vis_changed = TRUE;
}

/*
====================
R_OldSkyLeaf_f -- johnfitz
====================
*/
void R_OldSkyLeaf_f (void)
{
	extern int vis_changed;
	vis_changed = TRUE;
}

/*
===============
R_Envmap_f

Grab six views for environment mapping tests
===============
*/
void R_Envmap_f (void)
{
	byte	buffer[256*256*4];
	char	name[1024];

#ifdef TOUCHUP_ENVMAP_MAKES_TGA_FILES // Baker change
	envmap = true;

	glx = gly = r_refdef.vrect.x = r_refdef.vrect.y = 0;
	glwidth = glheight = r_refdef.vrect.width = r_refdef.vrect.height = 256;

	r_refdef.viewangles[0] = 0;
	r_refdef.viewangles[1] = 0;
	r_refdef.viewangles[2] = 0;

	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env0.tga", buffer, 256, 256, 32, false);	
	
	r_refdef.viewangles[1] = 90;
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env1.tga", buffer, 256, 256, 32, false);	

	r_refdef.viewangles[1] = 180;
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env2.tga", buffer, 256, 256, 32, false);	

	r_refdef.viewangles[1] = 270;
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env3.tga", buffer, 256, 256, 32, false);

	r_refdef.viewangles[0] = -90;
	r_refdef.viewangles[1] = 0;
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env4.tga", buffer, 256, 256, 32, false);

	r_refdef.viewangles[0] = 90;
	r_refdef.viewangles[1] = 0;
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	glFinish ();
	Image_WriteTGA ("env5.tga", buffer, 256, 256, 32, false);	

	envmap = false;

#ifdef SUPPORTS_FOLDER_COMMAND_LASTFILE // Baker change
	sprintf (recent_file, "%s/%s", com_gamedir, "env0.tga");
#endif // Baker change +
	Con_Printf ("Envmaps env.tga files created\n");
	vid.recalc_refdef = true; // Recalc the refdef next frame

#else // Baker change +
	glDrawBuffer  (GL_FRONT);
	glReadBuffer  (GL_FRONT);
	envmap = true;

	r_refdef.vrect.x = 0;
	r_refdef.vrect.y = 0;
	r_refdef.vrect.width = 256;
	r_refdef.vrect.height = 256;

	r_refdef.viewangles[0] = 0;
	r_refdef.viewangles[1] = 0;
	r_refdef.viewangles[2] = 0;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env0.rgb", buffer, sizeof(buffer));

	r_refdef.viewangles[1] = 90;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env1.rgb", buffer, sizeof(buffer));

	r_refdef.viewangles[1] = 180;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env2.rgb", buffer, sizeof(buffer));

	r_refdef.viewangles[1] = 270;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env3.rgb", buffer, sizeof(buffer));

	r_refdef.viewangles[0] = -90;
	r_refdef.viewangles[1] = 0;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env4.rgb", buffer, sizeof(buffer));

	r_refdef.viewangles[0] = 90;
	r_refdef.viewangles[1] = 0;
	GL_BeginRendering (&glx, &gly, &glwidth, &glheight);
	R_RenderView ();
	glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
	COM_WriteFile ("env5.rgb", buffer, sizeof(buffer));

	envmap = false;
	glDrawBuffer  (GL_BACK);
	glReadBuffer  (GL_BACK);
	GL_EndRendering ();
#endif // Baker change -
}

/*
===============
R_Init
===============
*/

#ifdef SUPPORTS_TEXTURE_POINTER // Baker change
void TexturePointer_Reset (void);
cvar_t tool_texturepointer = {"tool_texturepointer", "0"};
#endif // Baker change +

#ifdef SUPPORTS_ENTITY_INSPECTOR // Baker change
void Inspector_Change_f (void);
cvar_t tool_inspector = {"tool_inspector", "0"};
#endif // Baker change +


void R_Init (void)
{
	extern byte *hunk_base;
	extern cvar_t gl_finish;

	Cmd_AddCommand ("timerefresh", R_TimeRefresh_f);
	Cmd_AddCommand ("envmap", R_Envmap_f);
	Cmd_AddCommand ("pointfile", R_ReadPointFile_f);

#ifdef SUPPORTS_TEXTURE_POINTER // Baker change
	Cvar_RegisterVariable (&tool_texturepointer, TexturePointer_Reset);
#endif // Baker change +

#ifdef SUPPORTS_ENTITY_INSPECTOR // Baker change
	Cvar_RegisterVariable (&tool_inspector, Inspector_Change_f);
#endif // Baker change +

	Cvar_RegisterVariable (&r_norefresh, NULL);
	Cvar_RegisterVariable (&r_lightmap, NULL);
	Cvar_RegisterVariable (&r_fullbright, NULL);
	Cvar_RegisterVariable (&r_drawentities, NULL);
	Cvar_RegisterVariable (&r_drawviewmodel, NULL);
	Cvar_RegisterVariable (&r_shadows, NULL);
#ifdef SUPPORTS_R_LIGHTPOINT_DEPTH_CVAR // Baker change
	Cvar_RegisterVariable (&r_lightpoint_depth, NULL);
#endif // Baker change +

	Cvar_RegisterVariable (&r_wateralpha, NULL);

#ifdef SUPPORTS_CUSTOM_LIQUIDS // Baker change
	Cvar_RegisterVariable (&r_waterripple, NULL);
	Cvar_RegisterVariable (&r_watercshift, V_WaterCshift_f);
	Cvar_RegisterVariable (&r_lavacshift, V_LavaCshift_f);
	Cvar_RegisterVariable (&r_slimecshift, V_SlimeCshift_f);
#endif // Baker change +

	Cvar_RegisterVariable (&r_dynamic, NULL);
	Cvar_RegisterVariable (&r_novis, R_Novis_f);
#ifdef SUPPORTS_LOCK_FRUSTUM_PVS // Baker change
	Cvar_RegisterVariable (&r_lockfrustum, NULL);
	Cvar_RegisterVariable (&r_lockpvs, NULL);
#endif // Baker change +
	Cvar_RegisterVariable (&r_speeds, NULL);

	Cvar_RegisterVariable (&gl_finish, NULL);
	Cvar_RegisterVariable (&gl_clear, NULL);
	Cvar_RegisterVariable (&gl_cull, NULL);
	Cvar_RegisterVariable (&gl_smoothmodels, NULL);
	Cvar_RegisterVariable (&gl_affinemodels, NULL);
	Cvar_RegisterVariable (&gl_polyblend, NULL);
	Cvar_RegisterVariable (&gl_flashblend, NULL);
	Cvar_RegisterVariable (&gl_playermip, NULL);
	Cvar_RegisterVariable (&gl_nocolors, NULL);

	//johnfitz -- new cvars
	Cvar_RegisterVariable (&r_stereo, NULL);
	Cvar_RegisterVariable (&r_stereodepth, NULL);
	Cvar_RegisterVariable (&r_clearcolor, R_SetClearColor_f);
	Cvar_RegisterVariable (&r_waterquality, NULL);
	Cvar_RegisterVariable (&r_oldwater, NULL);
	Cvar_RegisterVariable (&r_waterwarp, NULL);
	Cvar_RegisterVariable (&r_drawflat, NULL);
	Cvar_RegisterVariable (&r_flatlightstyles, NULL);
	Cvar_RegisterVariable (&r_oldskyleaf, R_OldSkyLeaf_f);
	Cvar_RegisterVariable (&r_drawworld, NULL);
	Cvar_RegisterVariable (&r_showtris, NULL);
	Cvar_RegisterVariable (&r_showbboxes, NULL);
	Cvar_RegisterVariable (&gl_farclip, NULL);
	Cvar_RegisterVariable (&gl_fullbrights, GL_Fullbrights_f);
	Cvar_RegisterVariable (&gl_overbright, GL_Overbright_f);
	Cvar_RegisterVariable (&gl_overbright_models, NULL);
	Cvar_RegisterVariable (&r_lerpmodels, NULL);
	Cvar_RegisterVariable (&r_lerpmove, NULL);
#ifdef SUPPORTS_COMMA_DELIM_FIX // Baker change
	Cvar_RegisterVariable (&r_nolerp_list, R_Modelflags_Refresh_f);
#else // Baker change +
	Cvar_RegisterVariable (&r_nolerp_list, R_NoLerpList_f);
#endif // Baker change -
	//johnfitz
#ifdef SUPPORTS_NOSHADOW_FBRIGHTHACK_CVARS // Baker change
	Cvar_RegisterVariable (&r_noshadow_list, R_Modelflags_Refresh_f);
	Cvar_RegisterVariable (&r_fbrighthack_list, R_Modelflags_Refresh_f);
#endif // Baker change +

#ifdef SUPPORTS_TEXTURE_CLASSIFICATIONS // Baker change
	Cvar_RegisterVariable (&r_texprefix_fence, NULL);
	Cvar_RegisterVariable (&r_texprefix_envmap, NULL);
	Cvar_RegisterVariable (&r_texprefix_mirror, NULL);
	Cvar_RegisterVariable (&r_texprefix_tele, NULL);
	Cvar_RegisterVariable (&r_texprefix_scrollx, NULL);
	Cvar_RegisterVariable (&r_texprefix_scrolly, NULL);
#endif // Baker change +

	Cvar_RegisterVariable (&gl_subdivide_size, NULL); //johnfitz -- moved here from gl_model.c

	R_InitParticles ();
	R_SetClearColor_f (); //johnfitz

#ifdef SPEEDUP_PRECALC_FLASHBLEND_BUBBLE // Baker change
	R_Init_FlashBlend_Bubble ();
#endif // Baker change +

	Sky_Init (); //johnfitz
	Fog_Init (); //johnfitz

#ifdef GLTEST
	Test_Init ();
#endif
}

#ifdef SUPPORTS_COMMA_DELIM_FIX // Baker change
/*
=======================
R_Modelflags_Refresh_f -- johnfitz -- called when r_nolerp_list or other list cvar changes
=======================
*/
void R_Modelflags_Refresh_f (void)
#else // Baker change +
/*
===============
R_NoLerpList_f -- johnfitz -- called when r_nolerp_list cvar changes
===============
*/
void R_NoLerpList_f (void)
#endif // Baker change-
{
	int i;

	for (i=0; i < MAX_MODELS; i++)
		Mod_SetExtraFlags (cl.model_precache[i]);
}



#ifdef SUPPORTS_COLORMAPPING_EVERYTHING // Baker change
/*
===============
R_TranslateNewModelSkinColormap

Looks through our table and returns an existing model/skin/pants/shirt combination already uploaded.
If does not exist.  Uploads it.

Since this re-uses colormapped skins (2 red players = same texture) this will upload fewer skins
than the GLQuake way, but will colormap everything.

r_nocolormap_list provides a means to exclude colormapping trivial things like gibs.  Although it
supports 1024 combinations, it will rarely use more than 10 to 30 in practice.  All skins are 
deleted on a new map.
===============
*/

#ifdef SUPPORTS_COLORMAPPING_EVERYTHING // Baker change
cvar_t	r_nocolormap_list = {"r_nocolormap_list", ""}; // Under consideration: progs/eyes.mdl,progs/h_player.mdl,progs/gib1.mdl,progs/gib2.mdl,progs/gib3.mdl
#endif // Baker change +

// This is for an entity WITH an existing skin texture
// So we know it is an alias model (or at least was until now!)
qboolean SkinTextureChanged (entity_t *cur_ent)
{
	gltexture_t *skintexture	= cur_ent->coloredskin;
	int entnum = cur_ent - cl_entities;
	
	if (skintexture->owner != cur_ent->model)
	{
//		Con_Printf ("ent %i Model changed\n", entnum);
		return true;	// Model changed
	}

	do
	{
		int playerslot				= cur_ent->colormap - 1;
		int shirt_color				= (cl.scores[playerslot].colors & 0xf0) >> 4;
		int pants_color				= cl.scores[playerslot].colors & 15;

		if (skintexture->pants != pants_color)
		{
//			Con_Printf ("ent %i: Pants changed\n", entnum);		// Pants changed
			return true;
		}

		if (skintexture->shirt != shirt_color)
		{
//			Con_Printf ("ent %i: Shirt changed\n", entnum);		// Shirt changed
			return true;
		}

		if (skintexture->skinnum != cur_ent->skinnum)
		{
//			Con_Printf ("ent %i: Player skin changed\n", entnum);		// Skin changed
			return true; // Skin changed
		}

		// NOTE: Baker --> invalid skin situation can persistently trigger "skin changed"
		return false;

	} while (0);

}


gltexture_t *R_TranslateNewModelSkinColormap (entity_t *cur_ent)
{
	int entity_number = cur_ent - cl_entities; // If player, this will be 1-16
	int shirt_color, pants_color, skinnum, matchingslot;
	aliashdr_t	*paliashdr;
	
	do	// REJECTIONS PHASE
	{
		// No model or it isn't an alias model
		if (!cur_ent->model || cur_ent->model->type != mod_alias)
			return NULL;

		// No color map or it is invalid
		if (cur_ent->colormap <= 0 || cur_ent->colormap > cl.maxclients)
			return NULL;

		// Certain models just aren't worth trying to colormap
		if (cur_ent->model->flags & MOD_NOCOLORMAP)
			return NULL;

		//TODO: move these tests to the place where skinnum gets received from the server
		paliashdr = (aliashdr_t *)Mod_Extradata (cur_ent->model);
		skinnum = cur_ent->skinnum;

		if (skinnum < 0 || skinnum >= paliashdr->numskins)
		{
			Con_DPrintf("(%d): Invalid player skin #%d\n", entity_number, skinnum);
			skinnum = 0;
		}

	} while (0);


	do // SEE IF WE HAVE SKIN + MODEL + COLOR ALREADY PHASE
	{	
		int playerslot = cur_ent->colormap - 1;

		shirt_color = (cl.scores[playerslot].colors & 0xf0) >> 4;
		pants_color = cl.scores[playerslot].colors & 15;
		
		for (matchingslot = 0; matchingslot < MAX_COLORMAP_SKINS; matchingslot ++)
		{
			gltexture_t *curtex = playertextures[matchingslot];

			if (playertextures[matchingslot] == NULL)
				break; // Not found, but use this slot

			if (curtex->shirt != shirt_color) continue;
			if (curtex->pants != pants_color) continue;
			if (curtex->skinnum != skinnum) continue;
			if (curtex->owner != cur_ent->model) continue;
			
			// Found an existing translation for this 
			return curtex;

		}

		if (matchingslot == MAX_COLORMAP_SKINS)
		{
			Host_Error ("Color Slots Full");
			return NULL;
		}

		// If we are here matchingslot is our new texture slot

	} while (0);

	do // UPLOAD THE NEW SKIN + MODEL PHASE (MAYBE COLOR)
	{
		aliashdr_t	*paliashdr = (aliashdr_t *)Mod_Extradata (cur_ent->model);
		byte		*pixels = (byte *)paliashdr + paliashdr->texels[skinnum]; // This is not a persistent place!
		char		name[64];

		sprintf(name, "player_%i", entity_number);

//		Con_Printf ("New upload\n");

		//upload new image
		playertextures[matchingslot] = TexMgr_LoadImage (cur_ent->model, name, paliashdr->skinwidth, paliashdr->skinheight,
		SRC_INDEXED, pixels, paliashdr->gltextures[skinnum][0]->source_file, paliashdr->gltextures[skinnum][0]->source_offset, TEXPREF_PAD | TEXPREF_OVERWRITE);
	
		if (playertextures[matchingslot])
		{
			playertextures[matchingslot]->skinnum = skinnum;
			TexMgr_ReloadImage (playertextures[matchingslot], shirt_color, pants_color);
		}

	} while (0);

	return playertextures[matchingslot];
}
#else // Baker change +
/*
===============
R_TranslatePlayerSkin -- johnfitz -- rewritten.  also, only handles new colors, not new skins
===============
*/
void R_TranslatePlayerSkin (int playernum)
{
	int			top, bottom;

	top = (cl.scores[playernum].colors & 0xf0)>>4;
	bottom = cl.scores[playernum].colors &15;

	//FIXME: if gl_nocolors is on, then turned off, the textures may be out of sync with the scoreboard colors.
	if (!gl_nocolors.value)
		if (playertextures[playernum])
			TexMgr_ReloadImage (playertextures[playernum], top, bottom);
}

/*
===============
R_TranslateNewPlayerSkin -- johnfitz -- split off of TranslatePlayerSkin -- this is called when
the skin or model actually changes, instead of just new colors
added bug fix from bengt jardup
===============
*/
void R_TranslateNewPlayerSkin (int playernum)
{
	char		name[64];
	byte		*pixels;
	aliashdr_t	*paliashdr;
	int		skinnum;

//get correct texture pixels
	currententity = &cl_entities[1+playernum];

	if (!currententity->model || currententity->model->type != mod_alias)
		return;

	paliashdr = (aliashdr_t *)Mod_Extradata (currententity->model);

	skinnum = currententity->skinnum;

	//TODO: move these tests to the place where skinnum gets received from the server
	if (skinnum < 0 || skinnum >= paliashdr->numskins)
	{
		Con_DPrintf("(%d): Invalid player skin #%d\n", playernum, skinnum);
		skinnum = 0;
	}

	pixels = (byte *)paliashdr + paliashdr->texels[skinnum]; // This is not a persistent place!

//upload new image
	sprintf(name, "player_%i", playernum);
	playertextures[playernum] = TexMgr_LoadImage (currententity->model, name, paliashdr->skinwidth, paliashdr->skinheight,
		SRC_INDEXED, pixels, paliashdr->gltextures[skinnum][0]->source_file, paliashdr->gltextures[skinnum][0]->source_offset, TEXPREF_PAD | TEXPREF_OVERWRITE);

//now recolor it
	R_TranslatePlayerSkin (playernum);
}
#endif // Baker change -

/*
===============
R_NewGame -- johnfitz -- handle a game switch
===============
*/
void R_NewGame (void)
{
	int i;

	//clear playertexture pointers (the textures themselves were freed by texmgr_newgame)
#ifdef SUPPORTS_COLORMAPPING_EVERYTHING // Baker change
	for (i = 0; i < MAX_COLORMAP_SKINS; i ++)
#else // Baker change +
	for (i=0; i<MAX_SCOREBOARD; i++)
#endif // Baker change -
		playertextures[i] = NULL;
}

/*
===============
R_NewMap
===============
*/
void R_NewMap (void)
{
	int		i;

	for (i=0 ; i<256 ; i++)
		d_lightstylevalue[i] = 264;		// normal light value

// clear out efrags in case the level hasn't been reloaded
// FIXME: is this one short?
	for (i=0 ; i<cl.worldmodel->numleafs ; i++)
		cl.worldmodel->leafs[i].efrags = NULL;

	r_viewleaf = NULL;
	R_ClearParticles ();

	GL_BuildLightmaps ();

	r_framecount = 0; //johnfitz -- paranoid?
	r_visframecount = 0; //johnfitz -- paranoid?

	Sky_NewMap (); //johnfitz -- skybox in worldspawn
	Fog_NewMap (); //johnfitz -- global fog in worldspawn
#ifdef SUPPORTS_TEXTURE_POINTER // Baker change
	TexturePointer_Reset ();
#endif // Baker change +

	load_subdivide_size = gl_subdivide_size.value; //johnfitz -- is this the right place to set this?
}

/*
====================
R_TimeRefresh_f

For program optimization
====================
*/
void R_TimeRefresh_f (void)
{
	int			i;
	float		start, stop, time;
	int			startangle;
	vrect_t		vr;

	glDrawBuffer  (GL_FRONT);
	glFinish ();

	start = Sys_FloatTime ();
	for (i=0 ; i<128 ; i++)
	{
		r_refdef.viewangles[1] = i/128.0*360.0;
		R_RenderView ();
	}

	glFinish ();
	stop = Sys_FloatTime ();
	time = stop-start;
	Con_Printf ("%f seconds (%f fps)\n", time, 128/time);

	glDrawBuffer (GL_BACK);
	GL_EndRendering ();
}

/* void D_FlushCaches (void)
{
} Baker:  WinQuake only */

#ifdef SUPPORTS_TEXTURE_POINTER // Baker change
void R_EmitCaption (vec3_t location, char *caption, qboolean backgrounded);

extern msurface_t *lightpoint_surface;
qboolean R_SurfacePoint (void);

void TexturePointer_Reset (void)
{
//	texturepointer_surface = NULL;
//	texturepointer_name = NULL;
}

void TexturePointer_Think (void)
{
	if (tool_texturepointer.value == 0)
		return;

	if (R_SurfacePoint () == true)
	{
		static const qboolean do_lines = false;
		float *verts = lightpoint_surface->polys->verts[0];

		vec3_t mins = { 99999,  99999,  99999};
		vec3_t maxs = {-99999, -99999, -99999};
		vec3_t center;
		int i;

		if (do_lines)		// Set to lines
			glPolygonMode	(GL_FRONT_AND_BACK, GL_LINE);

		glDisable (GL_TEXTURE_2D);
		glEnable (GL_POLYGON_OFFSET_FILL);
		glDisable (GL_CULL_FACE);
		glColor4f (1, 0, 0, sin(realtime * 3) * 0.05f + 0.20f);
		glDisable (GL_DEPTH_TEST);
		glEnable (GL_BLEND);

		glBegin (GL_POLYGON);
		for (i = 0 ; i < lightpoint_surface->polys->numverts ; i++, verts+= VERTEXSIZE)
		{
			VectorExtendLimits (verts, mins, maxs);
			glVertex3fv (verts);
		}
		glEnd ();

		glEnable (GL_TEXTURE_2D);
		glDisable (GL_POLYGON_OFFSET_FILL);
		glEnable (GL_CULL_FACE);
		glColor4f (1, 1, 1, 1);
		glEnable (GL_DEPTH_TEST);
		glDisable (GL_BLEND);

		if (do_lines) // Revert
			glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

		VectorAverage (mins, maxs, center);

		R_EmitCaption (center, va("\bTexture:\b %s", lightpoint_surface->texinfo->texture->name), false );
	}

}

#endif // Baker change+

#ifdef SUPPORTS_ENTITY_INSPECTOR // Baker change
void Inspector_Change_f (void)
{
	if (tool_inspector.value && !sv.active)
		Con_Printf ("Note: tool_inspector only works when serving a game (single player, host, etc.)\n");
}

void R_EmitBox (vec4_t boxcolor, vec3_t centerpoint, vec3_t mins, vec3_t maxs, qboolean topmost, qboolean do_lines, float padding);

/*

  Entity Inspector

// 0: Model + Frame		(No model then skip)
// 1: Classname			(Everything)
// 2: Server edict		(Everything)
// 4: Flags				(Everything)
// 8: Target -->		(Everything)
//16. --> Targetname	(Everything)
//32: Origin/Angles		(Everything)
//64: Nextthink time	(Everything)

 */

void Entity_Inspector_Draw (void)
{
	extern		edict_t *sv_player;
	edict_t		*ed;
	int			i;
	entity_t	*client_entity;

	// Cycle through the server entities  TODO: Sort by distance?

	for (i = 1, ed = NEXT_EDICT(sv.edicts) ; i < sv.num_edicts ; i ++, ed = NEXT_EDICT(ed))
	{
		char	*my_classname = pr_strings + ed->v.classname;
		vec4_t	boxcolor;

		if (ed->free)
			continue;	// Free edict, just skip

		client_entity = NULL;
		if (i < cl.num_entities)		// Baker: Not all server ents get communicated to client.
			client_entity = cl_entities + i;

		if (ed == sv_player && chase_active.value == 0)
			continue;	// If entity is the player and chase cam isn't on ... skip it.

		// Screen out stuff

		switch (cl.stats[STAT_ACTIVEWEAPON])
		{
		case 0:		if (!ed->v.model || strlen(pr_strings + ed->v.model) == 0)
					continue;	// Have no model.

//		case 16:	if (ed->v.health <= 0)
//					continue;	// Have no health

		case 32:	break; // For the moment
		default:	break;

		}


		// Obtain Quake specific super-special color
		do
		{
			int special_entity = 0;

			if      (Q_strncasecmp (my_classname, "info_player_start", 17) == 0) 	 special_entity = 1;
			else if (Q_strcasecmp (my_classname, "info_player_coop") == 0) 		 special_entity = 2;
			else if (Q_strcasecmp (my_classname, "info_player_deathmatch") == 0) special_entity = 3;
			else if (Q_strncasecmp (my_classname, "light", 5) == 0) special_entity = 4;

			switch (special_entity)
			{
			case 1:		VectorSetColor4f (boxcolor, 1.0f, 0.0f, 0.0f, 0.40f);	break;
			case 2:		VectorSetColor4f (boxcolor, 1.0f, 1.0f, 0.0f, 0.30f);	break;
			case 3:		VectorSetColor4f (boxcolor, 1.0f, 0.0f, 0.0f, 0.40f); break;
			case 4:		VectorSetColor4f (boxcolor, 1.0f, 1.0f, 0.0f, 0.70f); break;
			}

			// If we already determined a color, exit stage left ...
			if (special_entity)
				continue;

			// normal color selection
			switch ((int)ed->v.solid)
			{
			case SOLID_NOT:      VectorSetColor4f (boxcolor, 1.0f, 1.0f, 1.0f, 0.05f); break;
			case SOLID_TRIGGER:  VectorSetColor4f (boxcolor, 1.0f, 0.0f, 1.0f, 0.10f); break;
			case SOLID_BBOX:     VectorSetColor4f (boxcolor, 0.0f, 1.0f, 0.0f, 0.10f); break;
			case SOLID_SLIDEBOX: VectorSetColor4f (boxcolor, 1.0f, 0.0f, 0.0f, 0.10f); break;
			case SOLID_BSP:      VectorSetColor4f (boxcolor, 0.0f, 0.0f, 1.0f, 0.05f); break;
			default:             VectorSetColor4f (boxcolor, 0.0f, 0.0f, 0.0f, 0.50f); break;
			}

		} while (0);

		// Render box phase

		do
		{
			qboolean isPointEntity  = VectorCompare (ed->v.mins, ed->v.maxs); // point entities have 0 size

			if (isPointEntity)
			{
				qboolean bRenderTopMost = false;
				qboolean bRenderLines   = false;
				float size_adjust = 4.0f; // Give it a little bit of size

				R_EmitBox (boxcolor, ed->v.origin, NULL, NULL, bRenderTopMost, bRenderLines, size_adjust);
			}
			else
			{
				qboolean bRenderTopMost = false;
				qboolean bRenderLines   = false;
				float size_adjust	  = -0.10f; // Pull size in just a little

				R_EmitBox (boxcolor, ed->v.origin, ed->v.mins, ed->v.maxs, bRenderTopMost, bRenderLines, size_adjust);
			}
		} while (0);

		// Render Caption phase

		do
		{
			extern qboolean SV_InvisibleToClient (edict_t *viewer, edict_t *seen);

			extern vec3_t currentbox_mins, currentbox_maxs;	// Last box rendering result
			vec3_t caption_location;
			char buffer[1024];
			char *fieldstring;

			if (SV_InvisibleToClient (sv_player, ed))
				continue; //don't draw if entity cannot be seen

			// Averaging the vectors gives the center
			VectorAverage (currentbox_mins, currentbox_maxs, caption_location);

			// Except we want the caption to be at the top
			caption_location[2] = currentbox_maxs[2];

			// Add a couple of height units to make it overhead
			caption_location[2] = caption_location[2] + 20.0f;


/*

  Entity Inspector


// 0: Model + Frame		(No model then skip)
// 1: Classname			(Everything)
// 2: Server edict		(Everything)
// 4: Flags				(Everything)
// 8: Target -->		(Everything)
//16. --> Targetname	(Everything)
//32: Origin/Angles		(Everything)
//64: Nextthink time	(Everything)


 */

			switch (cl.stats[STAT_ACTIVEWEAPON])
/*weapon*/	{
/* 1 */		case 0:		sprintf (buffer, "\bframe\b %i \bindex:\b %i\n%s", (int)ed->v.frame, (int)ed->v.modelindex, pr_strings + ed->v.model);
						break;

/* 3 */		case 2:		if (tool_inspector.value <= 1 && ((int)cl.time % 10) < 3)
							sprintf  (buffer, "\btype\b edict %i\n\bin console\nfor more info\b", i); // So someone can learn the right words.
						else
							sprintf (buffer, "\bserver edict # \b%i", i);
						break;

/* 7 */		case 32:	sprintf (buffer, "\borigin:\b %i %i %i\n\bangles:\b %i %i %i", (int)ed->v.origin[0], (int)ed->v.origin[1], (int)ed->v.origin[2], (int)ed->v.angles[0], (int)ed->v.angles[1], (int)ed->v.angles[2] );
						break;

/* 8 */		case 64:	sprintf (buffer, "\bnextthink time:\b\n\babs:\b %4.2f \bnet:\b%s\n", ed->v.nextthink, ed->v.nextthink < 1 ? "never" : va("%4.2f", ed->v.nextthink - sv.time) );
						break;

/* 4 */		case 4:		sprintf (buffer, "\bflags:\b  %i", ed->v.flags);
						break;

/* 5 */		case 8:		if (strlen(pr_strings + ed->v.target) > 0)
							sprintf (buffer, "\btarget -->:\b %s", pr_strings + ed->v.target);
						else
							strcpy (buffer, "no entity targeted");
						break;


/* 6 */		case 16:	if (strlen(pr_strings + ed->v.targetname) > 0)
							sprintf (buffer, "--> \btargetname:\b %s", pr_strings + ed->v.targetname);
						else
							strcpy (buffer, "none");
						break;

/* 2 */		case 1:
			default:	if (tool_inspector.value <= 1 && ((int)cl.time % 20) == 0)
							strcpy  (buffer, "\bentity classname is ...\b"); // So someone can learn the right words.
						else
							sprintf  (buffer, "%s", my_classname);
						break;
			}

			R_EmitCaption  (caption_location, buffer, true);
		} while (0);

		// End of this entity
	}  // For Loop closing brace

}



void Entity_Inspector_Think (void)
{
	if (!sv.active)
		return; // Only works if client is the server too

	if (tool_inspector.value == 0)
		return;

	Entity_Inspector_Draw ();
}

#endif // Baker change +

#ifdef WANTED_AVI_CAPTURE // Baker change
#pragma message "Note: AVI Capture disabled; MinGW doesn't support msacm.h at this time :("
#endif

#ifdef SUPPORTS_AVI_CAPTURE // Baker change

void AVI_LoadLibrary (void);
void ACM_LoadLibrary (void);
#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
int Capture_Open (char *filename, char *usercodec, qboolean silentish);
#else // Baker change +
qboolean Capture_Open (char *filename);
#endif // Baker change -
void Capture_WriteVideo (byte *pixel_buffer);
void Capture_WriteAudio (int samples, byte *sample_buffer);
void Capture_Close (void);


extern qboolean	scr_drawloading;
extern	short	*snd_out;
extern	int	snd_linear_count, soundtime;

// Variables for buffering audio
short	capture_audio_samples[44100];	// big enough buffer for 1fps at 44100Hz
int	captured_audio_samples;

static	int	out_size, ssize, outbuf_size;
static	byte	*outbuf, *picture_buf;
static	FILE	*moviefile;

static	float	hack_ctr;

#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
cvar_t	capture_codec	= {"cl_capturevideo_codec", "auto"};
#else // Baker change +
cvar_t	capture_codec	= {"cl_capturevideo_codec", "0", true};
#endif // Baker change -
cvar_t	capture_fps	= {"cl_capturevideo_fps", "30.0"};
cvar_t	capture_console	= {"cl_capturevideo_console", "1"};
cvar_t	capture_hack	= {"cl_capturevideo_hack", "0"};
cvar_t	capture_mp3	= {"cl_capturevideo_mp3", "0"};
cvar_t	capture_mp3_kbps = {"cl_capturevideo_mp3_kbps", "128"};

static qboolean movie_is_capturing = false;
qboolean	avi_loaded, acm_loaded;

qboolean Movie_IsActive (void)
{
	// don't output whilst console is down or 'loading' is displayed
	if ((!capture_console.value && scr_con_current > 0) || scr_drawloading)
		return false;

#ifdef SUPPORTS_CAPTUREDEMO_NOT_CONSOLE // Baker change
	// Never capture the console if capturedemo is running
	if (cls.capturedemo && scr_con_current > 0)
		return false;
#endif // Baker change +

	// otherwise output if a file is open to write to
	return movie_is_capturing;
}


char	movie_capturing_name[MAX_QPATH];
char	movie_capturing_fullpath[MAX_OSPATH]; // fullpath
#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
char	movie_codec[12];
#endif // Baker change +

void Movie_Start_Capturing (char *moviename)
{

	hack_ctr = capture_hack.value;

	strcpy (movie_capturing_name, moviename);
	COM_DefaultExtension (movie_capturing_name, ".avi");
	sprintf (movie_capturing_fullpath, "%s/%s", com_gamedir, movie_capturing_name);

	if (!(moviefile = fopen(movie_capturing_fullpath, "wb")))
	{
		COM_CreatePath (movie_capturing_fullpath);
		if (!(moviefile = fopen(movie_capturing_fullpath, "wb")))
		{
			Con_Printf ("ERROR: Couldn't open %s\n", movie_capturing_name);
			return;
		}
	}

#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
	if (Q_strcasecmp("auto", capture_codec.string) == 0)
	{
		// Automatic
		char *codec_order[] = {"vp80", "xvid", "divx", "none"};
		int	count = sizeof(codec_order) / sizeof(codec_order[0]);
		int result, i;

		for (i = 0; i < count ; i ++)
		{
			result = Capture_Open (movie_capturing_fullpath, codec_order[i], true);
			if (result == true)
			{
				strcpy (movie_codec, codec_order[i]);
				break;
			}
		}
		if (result != true)
		{
			movie_is_capturing = false;
			Con_Printf ("ERROR: Couldn't create video stream\n");
		}
		else
			movie_is_capturing = true;
	}
	else
	{
		movie_is_capturing = (Capture_Open (movie_capturing_fullpath, capture_codec.string, false) > 0);	
		if (movie_is_capturing)
			strcpy (movie_codec, capture_codec.string);
	}
#else // Baker change +
	movie_is_capturing = Capture_Open (movie_capturing_fullpath);
#endif // Baker change -
}



void Movie_Stop (void)
{
	movie_is_capturing = false;
	Capture_Close ();
	fclose (moviefile);
#ifdef SUPPORTS_FOLDER_COMMAND_LASTFILE // Baker change
	strcpy (recent_file, movie_capturing_name);
#endif // Baker change +
	
#ifdef SUPPORTS_DEMO_PROGRESS_ESTIMATION // Baker change	
	if (cls.demo_hosttime_elapsed /*cls.capturedemo*/) // Because cls.capturedemo already was cleared :(
		Con_Printf ("Video completed: %s in %d:%02d (codec: %s)\n", movie_capturing_name, COM_Minutes((int)cls.demo_hosttime_elapsed), COM_Seconds((int)cls.demo_hosttime_elapsed), movie_codec);
	else
#endif // Baker change +

#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
	Con_Printf ("Video completed: %s (codec: %s)\n", movie_capturing_name, movie_codec);
#else // Baker change +
	Con_Printf ("Video completed: %s\n", movie_capturing_name);
#endif // Baker change -

}

void Movie_Stop_Capturing (void)
{
	if (movie_is_capturing == 0)
	{
		Con_Printf ("Not capturing\n");
		return;
	}

	if (cls.capturedemo)
		cls.capturedemo = false;

	Movie_Stop ();

}

void Movie_StopPlayback (void);

void Movie_CaptureDemo_f (void)
{
	if (Cmd_Argc() != 2)
	{
		Con_Printf ("Usage: capturedemo <demoname>\n\nNote: stopdemo will stop video capture\nUse cl_capturevideo_* cvars for codec, fps, etc.\n");
		return;
	}

	if (movie_is_capturing)
	{
		Con_Printf ("Can't capture demo, video is capturing\n");
		return;
	}

#ifdef SUPPORTS_TIMEDEMO_CLOSES_CONSOLE // Baker change
	// Baker: This is a performance benchmark.  No reason to have console up.
	if (key_dest != key_game)
		key_dest = key_game;
#endif // Baker change +

#ifdef SUPPORTS_CLEAR_DEMOQUEUE // Baker change
	CL_Clear_Demos_Queue (); // timedemo is a very intentional action
#endif // Baker change +
	
	CL_PlayDemo_f ();
	if (!cls.demoplayback)
		return;

	Movie_Start_Capturing (Cmd_Argv(1));
	cls.capturedemo = true;

	if (!movie_is_capturing)
	{
		Movie_StopPlayback ();
#ifdef GENERIC_TOUCH_UP // Baker change
		// Baker: If capturedemo fails, just stop the demo playback.
		// Don't confuse the user
		Host_Stopdemo_f ();
#endif // Baker change +

#ifdef SUPPORTS_CAPTUREDEMO_COMMANDLINE // Baker change
 		// If +capturedemo in command line, we exit after demo capture 
		// completed (even if failed .. and this is failure location here)
		if (cls.capturedemo_and_exit)
			Host_Quit ();
#endif // Baker change +
	}
	
}

void Movie_Capture_Toggle_f (void)
{
	if (Cmd_Argc() != 2 || Q_strcasecmp(Cmd_Argv(1), "toggle") != 0)
	{
		Con_Printf ("usage: %s <toggle>\n\nset cl_capturevideo_codec and fps first\n", Cmd_Argv (0));
		Con_Printf (movie_is_capturing ? "status: movie capturing\n" : "status: not capturing\n");
		return;
	}

	if (cls.capturedemo)
	{
		Con_Printf ("Can't capturevideo toggle, capturedemo running\n");
		return;
	}

	if (movie_is_capturing)
	{
		Movie_Stop_Capturing ();
	}
	else
	{
		byte	*buffer;
		char	aviname[MAX_QPATH];
		char	checkname[MAX_OSPATH];
		char	barename[MAX_QPATH] = "video";
		int		i;

		if (cl.worldmodel)
			COM_StripExtension (cl.worldmodel->name + 5, barename);

	// find a file name to save it to
		for (i=0; i<10000; i++)
		{
			sprintf (aviname, "%s%04i.avi", barename, i);
			sprintf (checkname, "%s/%s", com_gamedir, aviname);
			if (Sys_FileTime(checkname) == -1)
				break;	// file doesn't exist
		}
		if (i == 10000)
		{
			Con_Printf ("Movie_Capture_Toggle_f: Couldn't find an unused filename\n");
			return;
 		}

		Movie_Start_Capturing (aviname);
	}

}

#ifdef SUPPORTS_CAPTUREVIDEO_AUTOCODEC // Baker change
void CaptureCodec_Validate (void)
{
	if (!capture_codec.string[0]) // Empty string ... assume user means none
	{
		Cvar_Set (capture_codec.name, "none");
		Con_Printf ("%s set to \"%s\"\n", capture_codec.name, capture_codec.string);
	}

	if (capture_codec.string[0] == '0') // Begins with 0 ... set to auto
	{
		Cvar_Set (capture_codec.name, "auto");
		Con_Printf ("%s set to \"%s\"\n", capture_codec.name, capture_codec.string);
	}
}
#endif // Baker change +

void Movie_Init (void)
{
	AVI_LoadLibrary ();
	if (!avi_loaded)
		return;

	captured_audio_samples = 0;

	Cmd_AddCommand ("capturevideo", Movie_Capture_Toggle_f);
	Cmd_AddCommand ("capturedemostop", Movie_Stop_Capturing);
	Cmd_AddCommand ("capturedemo", Movie_CaptureDemo_f);

	Cvar_RegisterVariable (&capture_codec, CaptureCodec_Validate);
	Cvar_RegisterVariable (&capture_fps, NULL);

	Cvar_RegisterVariable (&capture_console, NULL);
	Cvar_RegisterVariable (&capture_hack, NULL);


	ACM_LoadLibrary ();
	if (!acm_loaded)
		return;

	Cvar_RegisterVariable (&capture_mp3, NULL);
	Cvar_RegisterVariable (&capture_mp3_kbps, NULL);
}

void Movie_StopPlayback (void)
{
	if (!cls.capturedemo)
		return;

	cls.capturedemo = false;
	Movie_Stop ();

#ifdef SUPPORTS_CAPTUREDEMO_COMMANDLINE // Baker change
	// If +capturedemo in command line, we exit after demo capture 
	// completed (even if failed .. and this is failure location here)

	if (cls.capturedemo_and_exit)
		Host_Quit ();
#endif // Baker change +

}

double Movie_FrameTime (void)
{
	double	time;

	if (capture_fps.value > 0)
		time = !capture_hack.value ? 1.0 / capture_fps.value : 1.0 / (capture_fps.value * (capture_hack.value + 1.0));
	else
		time = 1.0 / 30.0;
	return CLAMP (1.0 / 1000, time, 1.0);
}

void Movie_UpdateScreen (void)
{
	int	i, size = glwidth * glheight * 3;
	byte	*buffer, temp;

	if (!Movie_IsActive())
		return;

	if (capture_hack.value)
	{
		if (hack_ctr != capture_hack.value)
		{
			if (!hack_ctr)
				hack_ctr = capture_hack.value;
			else
				hack_ctr--;
			return;
		}
		hack_ctr--;
	}

	buffer = malloc (size);
	glReadPixels (glx, gly, glwidth, glheight, GL_RGB, GL_UNSIGNED_BYTE, buffer);
	//	ApplyGamma (buffer, size);  Baker: a thought

	for (i = 0 ; i < size ; i += 3)
	{
		temp = buffer[i];
		buffer[i] = buffer[i+2];
		buffer[i+2] = temp;
	}

	Capture_WriteVideo (buffer);

	free (buffer);
}

void Movie_TransferStereo16 (void)
{
	if (!Movie_IsActive())
		return;

	// Copy last audio chunk written into our temporary buffer
	memcpy (capture_audio_samples + (captured_audio_samples << 1), snd_out, snd_linear_count * shm->channels);
	captured_audio_samples += (snd_linear_count >> 1);

	if (captured_audio_samples >= Q_rint (host_frametime * shm->speed))
	{
		// We have enough audio samples to match one frame of video
		Capture_WriteAudio (captured_audio_samples, (byte *)capture_audio_samples);
		captured_audio_samples = 0;
	}
}

qboolean Movie_GetSoundtime (void)
{
	if (!Movie_IsActive())
		return false;

	soundtime += Q_rint (host_frametime * shm->speed * (Movie_FrameTime() / host_frametime));

	return true;
}

#endif // Baker change +

