/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2012 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// quakedef.h -- primary header for client

//#define	GLTEST			// experimental stuff

#define	QUAKE_GAME			// as opposed to utilities

#define	VERSION				1.09
#define	GLQUAKE_VERSION		1.00
#define	D3DQUAKE_VERSION	0.01
#define	WINQUAKE_VERSION	0.996
#define	LINUX_VERSION		1.30
#define	X11_VERSION			1.10

// Baker: Since I change project compiler optimizations, this must be used even for classic FitzQuake 0.85 or will crash
#define TOUCH_WGL_EXTENSIONS_CHECK_REMOVED		// WGL extension check code explodes with better compiler optimization settings (We search for GL_WIN_swap_hint and maybe WGL_EXT_swap_control instead)

#if 1 // Baker change
#define	FITZQUAKE_VERSION	0.88 //Baker: for clarity

#define GENERIC_TOUCH_UP						// Just small bug fixes, eliminate a compiler warning, a typo or what not
#define SUPPORTS_HIGHER_MEM_DEFAULT				// 64 MB.  Even ARWOP doesn't even use HALF of that.

// FITZQUAKE MARK V R7

// Note: Improved compiler optimizations

// Removed light bleed through fix.  It is inconsistent in context of the other
// limitations of dynamic lighting and the surfaces affected.

#define SUPPORTS_GL_GREYSCALE					// gl_greyscale 1 makes textures shades of grey
#define SUPPORTS_HALFLIFE_BSP30					// Support for Half-Life BSP 30 hulls, wad3 palette per texture, texture naming.
#define SUPPORTS_MP3_MUSIC						// Plays id1/music/track00.mp3 or rather <gamedir + search paths>/music/track<xx>.mp3 (Does not play in-pak mp3 files)

#ifdef __GNUC__ // Baker:  I have never been able to make this work under MinGW + CodeBlocks
#ifdef SUPPORTS_MP3_MUSIC
#undef SUPPORTS_MP3_MUSIC
#define WANTED_MP3_MUSIC // But ... can't have it.
#endif
#endif

// FITZQUAKE MARK V R6

// Removed shadow flicker fix.  On some graphics cards it reveals secret doors and brush entities. Unfortunately.

#define SUPPORTS_COLORMAPPING_EVERYTHING		// TODO: If we get an svc scoreboard change, stale the obsolete skins
#define SUPPORTS_DYNAMIC_LIGHTS_CORRECTIONS		// Dynamic light max 128, affect moved brush models correctly, streamlined
#define SUPPORTS_WIDESCREEN_CORRECTION			// Widescreen correction
//#define SUPPORTS_DLIGHT_BLEED_THROUGH_FIX		// Dynamic light bleed through fix (MH says this bad.  And it is because it is inconsistent).
#define TEMP_LIGHT_FIX							// Restored temporarily original light R_Lightpoint until I can find the little discrepancy
// NOTE: The dlight radius values are crazy big.

// Unreversible:  These are unreversible events because they are started by a one-time server message.  In rewind
//                we would only get these messages when they have ended.  In reverse, we cannot have them when they start.
// 1) Temporary entities and client side dynamic lighting.
// 2) Sbar face animations due to pain and such.
// 3) Particles, because they are spawned by temp entities.
// 4) Sbar flashes.
// 5) Fog transitions
// 6) A very few aspects of entity lerping (position, frame) that depend on server flags.

// Reversible.
// 1) R_TextureAnimation.
// 2) View bobs and such.
// 3) Sbar time displayed.
// 4) Sky scrolls, liquid scrolls and anything that is direct derivative of current time.
// 5) Sprite animations and skin group animations.

#define SUPPORTS_DEMO_REWIND					// Demo rewind and fast forward via PGUP and PGDN during non-start demo
#define SUPPORTS_DEMO_REWIND_DISPLAY_TIME		// Sbar or clock
#define SUPPORTS_DEMO_REWIND_VIEW_TIME			// View.c everything goes in reverse. (bobs, kicks, rolls)  Except face.
#define SUPPORTS_DEMO_REWIND_HARD_ANIMS_TIME	// Direct animations off current time in current frame (sky scroll, warp textures, texture animation, etc.)
// TO DO: Fast forwarding things some events should occur shorter?

#define TOUCHUP_VID_RESTART_REFINEMENT			// Kills sound during a video restart.
#define TOUCHUP_CLEAR_DEMOQUEUE_PLAYDEMO		// Playdemo clears demo queue too.

//#define SUPPORTS_NEW_INPUT_SCHEME				// Written input code and related refinements.  Future: Enable m_directinput

//#define SUPPORTS_WIDESCREEN_FOV					// fov_y calculated as if for fov_x 90 4:3.  Then we get fov_x from that.

//#define SUPPORTS_REALLY_FIXING_SHADOWS_ISSUE	// Kill
//#define TOUCHUP_STARTDEMOS_VS_PLAYDEMO			// Startdemo show the menu when most keys are pressed.  playdemo shouldn't.

// FITZQUAKE MARK V R5

#define SUPPORTS_SPECIAL_KEY_COMBINES			// Key combinations.  Specific ones:
#define SUPPORTS_ALT_ENTER_FULLSCREEN_TOGGLE	// Toggle between fullscreen and windowed mode.
#define SUPPORTS_CTRL_M_MUTE					// CTRL-M mutes or un-mutes

#define SUPPORTS_NICE_CVAR_FLOAT_STRING			// No more "skill is 1.00000000".  If float can be presented nicely, remove trailing zeros
#define SUPPORTS_GAME_HIPNOTIC_ROGUE_QUOTH		// Enhanced -game command like "game warpspasm -quoth"
#define SUPPORTS_FULLSCREEN_FRONTMOST_WIN7		// Final nail in the coffin of annoying Windows 7 issues as far as I can tell.
#define SUPPORTS_FOLDER_COMMAND_LASTFILE		// Folder command will now highlight last file written (demo, avi, writeconfig, condump, screenshot, envmap, imagedump)
#define SUPPORTS_WINDOW_SET_TITLE				// Function to support setting the window title.  Demo progress estimation uses this.

#define SUPPORTS_DEMO_END_AT_INTERMISSION		// Bug fix: A demo (like a typical SDA demo) that ends of intermission displays wrong after end of demo
#define SUPPORTS_DEMO_PROGRESS_ESTIMATION		// Estimates the progress of demo playback and displays it in caption for Window (if fullscreen, isn't seen)
#define SUPPORTS_TITLE_DEMOS					// Titledemos do not display HUD or status bar.  To make mod intro demos presentation nicer.
												// Title demos get no HUD, no crosshair, no con_notify, FOV 90, viewsize 120

#define SUPPORTS_R_LIGHTPOINT_DEPTH_CVAR		// r_lightpoint_depth can be set.
#define SUPPORTS_CAPTUREDEMO_COMMANDLINE		// If +capturedemo is in the commandline, we exit upon completion of demo capture
#define SUPPORTS_CAPTUREVIDEO_AUTOCODEC			// Searches through hardcoded list for one that works if cl_capturevideo_codec cvar is unset.

#define TOUCHUP_FAST_EXIT						// Split out real "quit" function so possible to call without confirmation dialog
#define TOUCHUP_R_LIGHTPOINT_FIX				// Baker: my lighting function was one line short of being equivalent; marking for future reference.
#define SUPPORTS_CAPTUREDEMO_NOT_CONSOLE		// Don't capture the console if capturedemo is running.  Ever.

// FITZQUAKE MARK V R4
// 
// SUPPORTS: Is a feature or something of some significance
// TOUCHUP:  Fixes something small.  Not really a "feature"
// SPEEDUP:  Mild incremental speed boost.  Speed gain amount in comments.


#define SUPPORTS_TIMEDEMO_CLOSES_CONSOLE		// Time demo is to test demo speed.  Close the console automatically.
#define SUPPORTS_LOADGAME_CORRECT_SETANGLE		// MH fix.  Loadgames didn't load player angle right. http://forums.inside3d.com/viewtopic.php?f=12&t=4898
#define SUPPORTS_CENTERING_IN_USEABLE_SPACE		// MH method supercedes my window centering method.
#define SUPPORTS_LOCALMODELS_6_NOT_5			// Szo fix
#define SUPPORTS_TEXMGR_FLOODFILL_SKINS			// Texture manager wasn't floodfilling skins
#define SUPPORTS_REUSE_DIBWINDOW				// Prevents VERY annoying things on Windows 7.

#define SPEEDUP_FAST_FIELD_LOOKUP				// Look up the QuakeC fields fast.  Rockets, alpha, etc. Not sure how to measure speed gain,
#define SPEEDUP_SAVEGAME_FAST_NO_FFLUSH			// Massively speeds up save game saves.
#define SPEEDUP_PRECALC_FLASHBLEND_BUBBLE		// +3 to 5 frames per second (208 --> 212 fps) in timedemo1.
#define SPEEDUP_PRECALC_LM_SMAX_TMAX 			// +3 to 5 frames per second (204 --> 208 fps) gl_flashblend 0
#define SPEEDUP_TEXMGR_DONT_LOAD_WHOLE_PAK		// Big time speedup.  TexMgr was loading an entire pak file into memory to get an image.

#define TOUCHUP_VIDEO_READ_CVARS_EARLY			// Tweaked to ignore cvars not starting a line.  Avoid reading vid_fullscreen from an alias.
#define TOUCHUP_RMQ_QUAKESPASM_MILD_TWEAKS		// Bug fixes that address something small that can happen
#define TOUCHUP_NOCLIP_ANGLEHACK_MOVED_TO_CL	// Relocated noclip angle hack to cl.  Trivial, yes.
#define TOUCHUP_DEMO_ANY_TIME_MISSED_SOME_STATS	// A demo with the level in progress missed some single player stats (I thought I checked that).
#define TOUCHUP_R_MARKLIGHTS_READABILITY		// Improved the readability of R_MarkLights plus made it skip SKY/WATER which cannot be lit by dynamics
#define TOUCHUP_ENVMAP_MAKES_TGA_FILES			// "envmap" may as well write TGA files instead of .rgb files.
#define TOUCHUP_RESTORE_VIS_CHANGED_FALSE		// Setting r_novis 1 would set vis_changed = true and engine would always recalc vis ever-after (or r_oldskyleaf)
#define TOUCHUP_DONT_SPAM_FINDFILE_DEDICATED	// -dedicated was spamming can't find extra content stuff .tga, .pcx, .lit, etc.
//#define TOUCHUP_SOUND_INIT_SAYS_STEREO_VS_MONO// Via RMQ engine.  (Unless inherited from Quakespasm?)

// TODO: Fix dedicated so it doesn't even look for the textures?

// either because this was commenting out unused variables or something with no actual effect.
// a. Removed all software variables by commenting them out.  Colormap eliminated gently. (RMQ engine)
// b. Make snd_win.c/snd_mix.c/snd_dma.c use the DirectSound actual function names like ...
//
//	  before: pDSPBuf->lpVtbl->Release(pDSPBuf);
//    after:  IDirectSound_Release (pDSPBuf);
//
//    I saw that in DarkPlaces and it makes the code more readable
//
// c. Removed the goto in R_Marklight by turning it into a while loop
// d. R_SetupView -> R_SetupView ... used contents from r_viewleaf instead of calling Mod_PointInLeaf again for no reason
// e. Made V_BoundOffsets in view.c clean looking (no actual code changes)
// f. Improved SUPPORTS_SMOOTH_FULLSCREEN_SHUTDOWN

// END FITZQUAKE MARK V R3



// NETWORKING
#define SUPPORTS_IP_PORT						// IP:PORT support.  Connect server:port
#define SUPPORTS_NETWORK_FIXES					// A couple of things that cause crashes or break
#define SUPPORTS_NETWORK_FEEDBACK_MESSAGE		// Messages that provide better feedback
#define SUPPORTS_RESTORED_NETWORK_TEST_TEST2	// metlslime's "test" still works in debug mode.  Quake's test and test2 are useful
#define SUPPORTS_EASY_NAT_FIX					// Fix to allow connecting through an NAT router.  Fixes most cases of "connection accepted" problem.

// SYSTEM
#define SUPPORTS_REALLY_CENTERING_WINDOW		// Many monitors the code to center the window mistakenly believes we have dual monitors
#define SUPPORTS_DONT_USE_GETSYSTEMMETRICS		// GetSystemMetrics gets entire desktop space in multi-monitor setup
#define SUPPORTS_CLOCK_FIX						// multi-core clock fix
#define SUPPORTS_GAMMA_RESET					// Reset gamma (setgamma.c LordHavoc) on startup to reset gamma if crash (as opposed to leaving screen really bright potentially)
#define SUPPORTS_SMOOTH_FULLSCREEN_SHUTDOWN		// Don't shutdown from fullscreen that paints the desktop window jerky
#define SUPPORTS_VIDEO_READ_CVARS_EARLY			// Read video cvars early.  Don't setup video twice.
#define SUPPORTS_SETFOREGROUNDWINDOW			// Move the window to the foreground upon creation.  Windows7 ignores

// DEVELOPER (Debugging or inspection)
#define SUPPORTS_LOCK_FRUSTUM_PVS				// Ability to lock PVS and frustum
#define SUPPORTS_FREEZEALL_COMMAND				// Stop the execution of all entities except for players. Freezes the world.
#define SUPPORTS_QCEXEC_COMMAND					// Ability to run a QuakeC function from the command line
#define SUPPORTS_ENTITY_INSPECTOR				// Entity inspector
#define SUPPORTS_TEXTURE_POINTER				// Texture pointer modification (ENV DONE)
#define SUPPORTS_SV_NOVIS						// Ability to send all entities to client regardless of vis.  For testing stuff.
#define SUPPORTS_SERVER_CULLENTITIES			// Anti-wallhack (The SV_InvisibleToClient function has additional great uses.)
#define SUPPORTS_CONSOLE_SIZING					// Use CTRL + UPARROW/DOWNARROW to resize console size while in-game

// CONTENT CREATION (Add options for a mapper)
#define SUPPORTS_COMMA_DELIM_FIX				// r_nolerp_list parsing
#define SUPPORTS_NOSHADOW_FBRIGHTHACK_CVARS		// r_noshadow_list/r_fbrighthack_list cvars.  Dependent on SUPPORTS_COMMA_DELIM_FIX.
#define SUPPORTS_CUSTOM_LIQUIDS					// Water ripple, custom cshifts
#define SUPPORTS_BOUNCE_FIX						// Option grenades and other stuff bounce down slopes fix (OFF by default)
#define SUPPORTS_CL_SIDEBOBBING					// Weapon side bobbing
#define SUPPORTS_ROTATION_PHYSICS				// Support for rotation physics
#define SUPPORTS_ANGLE16_PROTOCOL_668			// Baker: Ugh.  But smooth rotation needed.
#define SUPPORTS_EXTERNAL_MDL_TEXTURES			// Baker.  Centralized skin load to a function (RMQ), but this feature isn't like RMQ's implementation at all
#define SUPPORTS_ALPHA_TEXTURES					// Barely needs SUPPORTS_TEXTURE_CLASSIFICATIONS
#define SUPPORTS_SHADOWS_ON_SUBMODELS			// Shadows on world submodels (like lifts and stuff).  Shadows are still the same imperfect Quake shadows.
#define SUPPORTS_TEXTURE_CLASSIFICATIONS		// Custom texture rendering
#define SUPPORTS_CHASE_MODE						// Alternate change camera views. (Does NOT affect chase_active 1, only if chase_mode command is used).

// Presentation
//#define SUPPORTS_SHADOW_FLICKER_FIX			// Uses glpolygon offset params to eliminate shadow flicker
#define SUPPORTS_STENCIL_SHADOWS 				// MrG stencil shadows
#define SUPPORTS_VIEWMODEL_ORIGINAL_POS			// Some screen resolutions FitzQuake weapon goes partially off-screen
#define SUPPORTS_VIEWMODEL_FOV_NEUTRAL			// View model constant FOV
#define SUPPORTS_VIEW_ANGLES_INTERPOLATION		// Quake only interpolates angles during demo playback.  Affects camera entities.  Especially over network.
#define SUPPORTS_MH_DYNASPEED					// MH dynamic light speed up (Nvidia, Intel ... ATI seems unaffected).

//#define SUPPORTS_CHASE_FRUSTUM_CULL			// Define a frustum from chase camera to player.  A surface or entity in this frustum is culled so can't block chasecam
// I'd like to prove to myself that gamma reset conclusively works.  I'm not 100% on this.

// http://msdn.microsoft.com/en-us/library/windows/desktop/ms633539%28v=vs.85%29.aspx
// NOTE: Windows 7 does not allow a window to assert it to the top and have focus (SetForegroundWindow).
// Win7 security feature. I'm not 100% sure of side-effects this may cause Quake engines in general
// in uncommon situations.  The engine does expect to have the focus on startup (input, gamma etc.) and
// It might not necessarily so situations where the engine in the past could expect to have focus ... maybe not.

// USER CONVENIENCE
#define SUPPORTS_CHECK_RIGHT_DIR				// Fixes it when a user makes a shortcut in Windows and didn't set working directory (a very common user error)
#define SUPPORTS_SMART_EDICTS					// Automatic allocation of an estimated number of entities plus external ent
#define SUPPORTS_WRONG_CONTENT_PROTECTION		// (Quakespasm idea) Prevents Travail start.bsp from using id1/start.bsp, etc.
#define SUPPORTS_BESTWEAPON_COMMAND				// bind CTRL "bestweapon 8 5 4 3 2 1" will select LG (weapon 8), SSG (weapon 5), etc. based on if you have the weapon and ammo for it.  ProQuake, DarkPlaces, DirectQ, Qrack, etc. have this.

#define SUPPORTS_DISABLE_CHEATS					// Ability to disable cheats (intended for coop)
#define SUPPORTS_TALK_MACROS					// Embed %a (armor) %h (health) and %r (rockets) such in talk "say" messages
#define SUPPORTS_HISTORY_FILE					// Session-to-session console history
#define SUPPORTS_LEGIT_PING_SCOREBOARD 			// Baker change: Amalgam of DarkPlaces/ProQuake implementation of ping in scoreboard
#define SUPPORTS_VIDEO_CONTRAST					// Contrast support via "contrast" command.  Like gamma.
#define SUPPORTS_DOSQUAKE_SOUND_DISTANCE		// DOSQuake sound distance was 1500, not 1000.
#define SUPPORTS_FOLDER_COMMAND					// Opens gamedir folder in windowed mode
#define SUPPORTS_SOUND_HZ_COMMANDLINE_PARAM		// -sndspeed command line param

// DEMOS
#define SUPPORTS_MULTIMAP_DEMOS					// Plays back multi-map demos
#define SUPPORTS_DEMO_RECORD_ANY_TIME			// Record a demo at any time
#define SUPPORTS_PAUSE_DEMO						// Pause key pauses demos
#define SUPPORTS_CLEAR_DEMOQUEUE				// Clear the demo queue for disconnect command, playdemo and stopdemo
#define SUPPORTS_AVI_CAPTURE					// capturedemo command and friends
#define SUPPORTS_DEMO_ADVANCE_WHILE_IN_MENU		// Startdemos can advance to the next while in the menu.
#define SUPPORTS_PROPER_DEMO_KEY_BEHAVIOR		// Most keys *should* bring up the menu.  During the intro.  Not during a user played demo.

#ifdef __GNUC__
#undef SUPPORTS_AVI_CAPTURE // Must disable AVI capture :(
#define WANTED_AVI_CAPTURE // But ... can't have it.
#endif

// CLIPBOARD SUPPORT
// These three pretty much need each other.  All or none.
#define SUPPORTS_CLIPBOARD						// Clipboard capability
#define SUPPORTS_CONSOLE_COPY					// Type "copy" in the console and it copies the console text to clipboard
#define SUPPORTS_SCREEN_COPY					// Type "copy screen" in the console it copies the screen to clipboard
#define SUPPORTS_ENTITIES_COPY					// Type "copy ents" in the console and ents --> clipboard.  Requires smartedicts and other 3 clipboard enhancements

// SYSTEM INPUT
#define SUPPORTS_MOUSEWHEEL_SCROLL_CONSOLE		// Mousewheel (intentionally?) didn't scroll console; this makes it so
#define SUPPORTS_5_MOUSE_BUTTONS				// Fitz supported 3 buttons
#define SUPPORTS_MOUSEWHEEL_DINPUT				// Mouse wheel didn't work with dinput on in FitzQuake 0.85
#define SUPPORTS_AVOIDING_WINDOWS_ANNOYANCES	// Disable unused accessibility toggles/Windows key while active app
#define SUPPORTS_MWHEEL_CONSOLE_DINPUT_NOMAP	// DirectInput on the mousewheel doesn't get checked unless playing a game, means cannot mousewheel scroll console when no map playing
#define SUPPORTS_WINDOWED_MENU_MOUSE_BIND		// Bind mouse in customized controls even when -windowed.

//#define SUPPORTS_MULTIPLE_BSP_VERSIONS		// Half-Life map support.  BSP2 maybe in future.  Other tweaks?
//#define SUPPORTS_PROTOCOL_15_FIX				// Can't connect GLQuake to FitzQuake 0.85 running CL_ReadFromServer: lost server connection (I revert MAX_DATAGRAM to 1024 and it works?)

#else // Baker change +
#define	FITZQUAKE_VERSION	0.85 //johnfitz
#endif // Baker change -


//define	PARANOID			// speed sapping error checking

#define	GAMENAME	"id1"		// directory to look in by default

#include <math.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <assert.h> //johnfitz


/*
#if defined(_WIN32) && !defined(WINDED)

#if defined(_M_IX86)
#define __i386__	1
#endif

void	VID_LockBuffer (void);
void	VID_UnlockBuffer (void);

#else

#define	VID_LockBuffer()
#define	VID_UnlockBuffer()

#endif

#if defined __i386__ // && !defined __sun__
#define id386	1
#else
#define id386	0
#endif

#if id386
#define UNALIGNED_OK	1	// set to 0 if unaligned accesses are not supported
#else
#define UNALIGNED_OK	0
#endif

// !!! if this is changed, it must be changed in d_ifacea.h too !!!
#define CACHE_SIZE	32		// used to align key data structures

#define UNUSED(x)	(x = x)	// for pesky compiler / lint warnings
Baker: WinQuake only */

#define	MINIMUM_MEMORY			0x550000
#define	MINIMUM_MEMORY_LEVELPAK	(MINIMUM_MEMORY + 0x100000)

#define MAX_NUM_ARGVS	50

// up / down
#define	PITCH	0

// left / right
#define	YAW		1

// fall over
#define	ROLL	2


#define	MAX_QPATH		64			// max length of a quake game pathname
#define	MAX_OSPATH		128			// max length of a filesystem pathname

#define	ON_EPSILON		0.1			// point on plane side epsilon

#define	MAX_MSGLEN		32000		// max length of a reliable message //johnfitz -- was 8000
#define	MAX_DATAGRAM	32000		// max length of unreliable message //johnfitz -- was 1024

#define DATAGRAM_MTU	1400		// johnfitz -- actual limit for unreliable messages to nonlocal clients

//
// per-level limits
//

#define MIN_EDICTS		256			// johnfitz -- lowest allowed value for max_edicts cvar
#define MAX_EDICTS		32000		// johnfitz -- highest allowed value for max_edicts cvar
									// ents past 8192 can't play sounds in the standard protocol
#define	MAX_LIGHTSTYLES	64
#define	MAX_MODELS		2048		// johnfitz -- was 256
#define	MAX_SOUNDS		2048		// johnfitz -- was 256

#define	SAVEGAME_COMMENT_LENGTH	39

#define	MAX_STYLESTRING	64

//
// stats are integers communicated to the client by the server
//
#define	MAX_CL_STATS		32
#define	STAT_HEALTH			0
#define	STAT_FRAGS			1
#define	STAT_WEAPON			2
#define	STAT_AMMO			3
#define	STAT_ARMOR			4
#define	STAT_WEAPONFRAME	5
#define	STAT_SHELLS			6
#define	STAT_NAILS			7
#define	STAT_ROCKETS		8
#define	STAT_CELLS			9
#define	STAT_ACTIVEWEAPON	10
#define	STAT_TOTALSECRETS	11
#define	STAT_TOTALMONSTERS	12
#define	STAT_SECRETS		13		// bumped on client side by svc_foundsecret
#define	STAT_MONSTERS		14		// bumped by svc_killedmonster

// stock defines

#define	IT_SHOTGUN				1
#define	IT_SUPER_SHOTGUN		2
#define	IT_NAILGUN				4
#define	IT_SUPER_NAILGUN		8
#define	IT_GRENADE_LAUNCHER		16
#define	IT_ROCKET_LAUNCHER		32
#define	IT_LIGHTNING			64
#define IT_SUPER_LIGHTNING      128
#define IT_SHELLS               256
#define IT_NAILS                512
#define IT_ROCKETS              1024
#define IT_CELLS                2048
#define IT_AXE                  4096
#define IT_ARMOR1               8192
#define IT_ARMOR2               16384
#define IT_ARMOR3               32768
#define IT_SUPERHEALTH          65536
#define IT_KEY1                 131072
#define IT_KEY2                 262144
#define	IT_INVISIBILITY			524288
#define	IT_INVULNERABILITY		1048576
#define	IT_SUIT					2097152
#define	IT_QUAD					4194304
#define IT_SIGIL1               (1<<28)
#define IT_SIGIL2               (1<<29)
#define IT_SIGIL3               (1<<30)
#define IT_SIGIL4               (1<<31)

//===========================================
//rogue changed and added defines

#define RIT_SHELLS              128
#define RIT_NAILS               256
#define RIT_ROCKETS             512
#define RIT_CELLS               1024
#define RIT_AXE                 2048
#define RIT_LAVA_NAILGUN        4096
#define RIT_LAVA_SUPER_NAILGUN  8192
#define RIT_MULTI_GRENADE       16384
#define RIT_MULTI_ROCKET        32768
#define RIT_PLASMA_GUN          65536
#define RIT_ARMOR1              8388608
#define RIT_ARMOR2              16777216
#define RIT_ARMOR3              33554432
#define RIT_LAVA_NAILS          67108864
#define RIT_PLASMA_AMMO         134217728
#define RIT_MULTI_ROCKETS       268435456
#define RIT_SHIELD              536870912
#define RIT_ANTIGRAV            1073741824
#define RIT_SUPERHEALTH         2147483648

//MED 01/04/97 added hipnotic defines
//===========================================
//hipnotic added defines
#define HIT_PROXIMITY_GUN_BIT 16
#define HIT_MJOLNIR_BIT       7
#define HIT_LASER_CANNON_BIT  23
#define HIT_PROXIMITY_GUN   (1<<HIT_PROXIMITY_GUN_BIT)
#define HIT_MJOLNIR         (1<<HIT_MJOLNIR_BIT)
#define HIT_LASER_CANNON    (1<<HIT_LASER_CANNON_BIT)
#define HIT_WETSUIT         (1<<(23+2))
#define HIT_EMPATHY_SHIELDS (1<<(23+3))

//===========================================

#define	MAX_SCOREBOARD		16
#define	MAX_SCOREBOARDNAME	32

#define	SOUND_CHANNELS		8

#include "common.h"
#include "bspfile.h"
#include "vid.h"
#include "sys.h"
#include "zone.h"
#include "mathlib.h"

typedef struct
{
	vec3_t			origin;
	vec3_t			angles;
	unsigned short 	modelindex; //johnfitz -- was int
	unsigned short 	frame; //johnfitz -- was int
	unsigned char 	colormap; //johnfitz -- was int
	unsigned char 	skin; //johnfitz -- was int
	unsigned char	alpha; //johnfitz -- added
	int				effects;
} entity_state_t;


#include "wad.h"
#include "draw.h"
#include "cvar.h"
#include "screen.h"
#include "net.h"
#include "protocol.h"
#include "cmd.h"
#include "sbar.h"
#include "sound.h"
#include "render.h"
#include "client.h"
#include "progs.h"
#include "server.h"
#include "gl_model.h"

#include "image.h" //johnfitz
#include "gl_texmgr.h" //johnfitz

#include "input.h"
#include "world.h"
#include "keys.h"
#include "console.h"
#include "view.h"
#include "menu.h"
#include "crc.h"
#include "cdaudio.h"
#include "glquake.h"


//=============================================================================

// the host system specifies the base of the directory tree, the
// command line parms passed to the program, and the amount of memory
// available for the program to use

typedef struct
{
	char	*basedir;
	char	*cachedir;		// for development over ISDN lines
	int		argc;
	char	**argv;
	void	*membase;
	int		memsize;
} quakeparms_t;


//=============================================================================



extern qboolean noclip_anglehack;


//
// host
//
extern	quakeparms_t host_parms;

extern	cvar_t		sys_ticrate;
extern	cvar_t		sys_nostdout;
extern	cvar_t		developer;
extern	cvar_t		max_edicts; //johnfitz

extern	qboolean	host_initialized;		// true if into command execution
extern	double		host_frametime;
/*extern	byte	*host_colormap; Baker: WinQuake only */
extern	int			host_framecount;	// incremented every frame, never reset
extern	double		realtime;			// not bounded in any way, changed at
										// start of every frame, never reset

void Host_ClearMemory (void);
void Host_ServerFrame (void);
void Host_InitCommands (void);
void Host_Init (quakeparms_t *parms);
void Host_Shutdown(void);
void Host_Error (char *error, ...);
void Host_EndGame (char *message, ...);
void Host_Frame (float time);
void Host_Quit_f (void);
void Host_ClientCommands (char *fmt, ...);
void Host_ShutdownServer (qboolean crash);
/*
extern qboolean		msg_suppress_1;		// suppresses resolution and cache size console output
										//  an fullscreen DIB focus gain/loss
Baker: WinQuake only */


extern int			current_skill;		// skill level for currently loaded level (in case
										//  the user changes the cvar while the level is
										//  running, this reflects the level actually in use)

extern qboolean		isDedicated;

extern int			minimum_memory;

//
// chase
//
extern	cvar_t	chase_active;

void Chase_Init (void);
void Chase_UpdateForClient (void); //johnfitz
void Chase_UpdateForDrawing (void); //johnfitz
