/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2009 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// vid.h -- video driver defs

/*
#define VID_CBITS	6
#define VID_GRADES	(1 << VID_CBITS)

// a pixel can be one, two, or four bytes
typedef byte pixel_t;
Baker: WinQuake only */

typedef struct vrect_s
{
	int				x,y,width,height;
	struct vrect_s	*pnext;
} vrect_t;

typedef struct
{
	unsigned		width;
	unsigned		height;
	int				numpages;
	int				recalc_refdef;	// if true, recalc vid-based stuff
	unsigned		conwidth;
	unsigned		conheight;

#ifdef SUPPORTS_ALT_ENTER_FULLSCREEN_TOGGLE // Baker change
	int				desktop_width;
	int				desktop_height;
	int				desktop_bpp;
	int				desktop_dispfreq;

   	int				desktop_areawidth;
   	int				desktop_areaheight;
#endif // Baker change +

/* Baker: These are WinQuake only and we do not need them ...
	pixel_t			*buffer;		// invisible buffer
	pixel_t			*colormap;		// 256 * VID_GRADES size	
	unsigned short	*colormap16;	// 256 * VID_GRADES size
	int				fullbright;		// index of first fullbright color
	unsigned		rowbytes;	// may be > width if displayed in a window
	float			aspect;		// width / height -- < 0 is taller than wide
	pixel_t			*conbuffer;
	int				conrowbytes;
	int				maxwarpwidth;
	int				maxwarpheight;
	pixel_t			*direct;		// direct drawing to framebuffer, if not
									//  NULL
 Baker: WinQuake only */
} viddef_t;

extern	viddef_t	vid;				// global video state
//extern	unsigned short	d_8to16table[256]; //johnfitz -- never used
extern void (*vid_menudrawfn)(void);
extern void (*vid_menukeyfn)(int key);
extern void (*vid_menucmdfn)(void); //johnfitz

//johnfitz -- deleted VID_SetPalette and VID_ShiftPalette

void	VID_Init (void); //johnfitz -- removed palette from argument list

void	VID_Shutdown (void);
// Called at shutdown

void	VID_Update (vrect_t *rects);
// flushes the given rectangles from the view buffer to the screen

int VID_SetMode (int modenum); //johnfitz -- removed palette from argument list
// sets the mode; only used by the Quake engine for resetting to mode 0 (the
// base mode) on memory allocation failures

/*
void VID_HandlePause (qboolean pause);
// called only on Win32, when pause happens, so the mouse can be released
Baker: WinQuake only */