/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2012 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// client.h

typedef struct
{
	vec3_t	viewangles;

// intended velocities
	float	forwardmove;
	float	sidemove;
	float	upmove;
} usercmd_t;

typedef struct
{
	int		length;
	char	map[MAX_STYLESTRING];
	char	average; //johnfitz
	char	peak; //johnfitz
} lightstyle_t;

typedef struct
{
	char	name[MAX_SCOREBOARDNAME];
	float	entertime;
	int		frags;
	int		colors;			// two 4 bit fields
#ifdef SUPPORTS_LEGIT_PING_SCOREBOARD // Baker change
	int		ping;
#endif // Baker change +
/*	byte	translations[VID_GRADES*256]; Baker: WinQuake only */
} scoreboard_t;

typedef struct
{
	int		destcolor[3];
	int		percent;		// 0-256
} cshift_t;

#define	CSHIFT_CONTENTS	0
#define	CSHIFT_DAMAGE	1
#define	CSHIFT_BONUS	2
#define	CSHIFT_POWERUP	3
#define	NUM_CSHIFTS		4

#define	NAME_LENGTH	64


//
// client_state_t should hold all pieces of the client state
//

#define	SIGNONS		4			// signon messages to receive before connected

#ifdef SUPPORTS_DYNAMIC_LIGHTS_CORRECTIONS // Baker change
#define	MAX_DLIGHTS		128 //johnfitz -- was 32
#else // Baker change +
#define	MAX_DLIGHTS		64 //johnfitz -- was 32
#endif // Baker change -

typedef struct
{
	vec3_t	origin;
#ifdef SUPPORTS_DYNAMIC_LIGHTS_CORRECTIONS // Baker change
	vec3_t	transformed;
#endif // Baker change +
	float	radius;
	float	die;				// stop lighting after this time
	float	decay;				// drop this each second
	float	minlight;			// don't add when contributing less
	int		key;
	vec3_t	color;				//johnfitz -- lit support via lordhavoc
} dlight_t;


#define	MAX_BEAMS	32 //johnfitz -- was 24
typedef struct
{
	int		entity;
	struct model_s	*model;
	float	endtime;
	vec3_t	start, end;
} beam_t;

#define	MAX_EFRAGS		2048 //johnfitz -- was 640

#define	MAX_MAPSTRING	2048
#define	MAX_DEMOS		8
#define	MAX_DEMONAME	16

typedef enum {
ca_dedicated, 		// a dedicated server with no ability to start a client
ca_disconnected, 	// full screen console with no connection
ca_connected		// valid netcon, talking to a server
} cactive_t;

#ifdef SUPPORTS_GHOSTING_VIA_DEMOS // Baker change
typedef struct // Used to write ghost data
{
// WRITTEN PER MAP CHANGE
	char		player_map[31];
// WRITTEN WHEN PLAYER DATA CHANGES
	short		player_frame;
	int			player_time;
	int			player_origin[3];
	int			player_angles[3];
} ghostw_t;

typedef struct
{
	double		ghost_time;			// Named so we know this isn't a cl.time (have to convert to get "virtual cl.time"
	short		frame;
	vec3_t		origin;
	vec3_t		angles;
} mghost_t; // To some extent this must above.

typedef struct
{
// CALCULATED EVERY FRAME

//	qboolean	waiting_current;	// Are we in a waiting state this frame?
//	float		frac_time;			// Current REAL fraction between old time and new time
//	double		ghost_time;			// Derived ghost time of NOW.  The formula NEVER changes (but virtual_base_time advances if ghost is waiting so the conversion can change)

//	double		cl_time;
	double		ghost_time;			// Mostly to detect end of time.
	float		frac_final;			// fraction between last frame and future frame.  If EOF, frac is 1.
									// This must be kept so we can interpolate between frames
	short		framepast;
	short		framefuture;
	vec3_t		origin;
	vec3_t		angles;
	
// ^^ Keep that, it doesn't depend on any rendering information

// If frac ghost isn't visible ... this accumulates.  If ghost is 
	

} ghostfme_t;

typedef struct
{
	mghost_t	past;
	mghost_t	future;			
	ghostfme_t	current;			// The "present" we CAN render.
	ghostfme_t	current_failed;		// The "present" we CAN'T render.  Until this can be rendered, we accumulate waiting and do not move time forward

// RE-CALCULATED UNDER CERTAIN CIRCUMSTANCES: These 2 help us convert between ghost time and cl.time
	double		virtual_base_time;// Calculated ONCE per map.  Never changes.
	
// These can only be changed by a committed simulated present
	double		waiting_accumulator;	// If ghost is waiting, this accumulates "ghost paused" time which holds back the ghost clock from really advancing.
	qboolean	end_of_time;			// At end of file and past future time
	
	// No future until this is cleared.  If we can't be seen now, we can't progress to future.
	qboolean	out_of_sight;			// Retry previous "current" as-is.
	double		out_of_sight_cltime;	// Only way to store this, since we can't use ghost_times to accumulate wait inactivity		

	double		last_cl_time;
	//	qboolean	rvisible;				// Rendering: Is ghost visible.  Only matters for caption.
// ^^ Kill!  Even a dead ghost needs that.
} ghost_t;
#endif // Baker change + SUPPORTS_GHOSTING_VIA_DEMOS


//
// the client_static_t structure is persistant through an arbitrary number
// of server connections
//
typedef struct
{
	cactive_t	state;

// personalization data sent to server
	char		mapstring[MAX_QPATH];
	char		spawnparms[MAX_MAPSTRING];	// to restart a level

// demo loop control
	int			demonum;		// -1 = don't play demos
	char		demos[MAX_DEMOS][MAX_DEMONAME];		// when not playing

// demo recording info must be here, because record is started before
// entering a map (and clearing client_state_t)
	qboolean	demorecording;
	qboolean	demoplayback;
#ifdef SUPPORTS_DEMO_REWIND // Baker change
	qboolean	demorewind;
	float		demospeed;
#endif // Baker change +

#ifdef SUPPORTS_FOLDER_COMMAND_LASTFILE // Baker change
	char		demoname[MAX_OSPATH];	// So we can print demo whatever completed.
#endif // Baker change +

#ifdef SUPPORTS_DEMO_PROGRESS_ESTIMATION // Baker change
	int			demo_file_length;		// Length of file in bytes
	int			demo_offset_start;		// If in a pak, the offset into the file otherwise 0.
	int			demo_offset_current;	// Current offset into the file, updated as the demo is player
	
	float		demo_hosttime_start;	// For measuring capturedemo time completion estimates.
	float		demo_hosttime_elapsed;	// Does not advance if paused.
	float		demo_cltime_start;		// Above except cl.time
	float		demo_cltime_elapsed;	// Above except cl.time
#endif // Baker change +
	
#ifdef SUPPORTS_TITLE_DEMOS // Baker change
	qboolean	titledemo;				// Does not display HUD, notify, centerprint or crosshair when played as part of startdemos
#endif // Baker change +

	qboolean	capturedemo;			// Indicates if we are capturing demo playback
#ifdef SUPPORTS_CAPTUREDEMO_COMMANDLINE // Baker change
	qboolean	capturedemo_and_exit;	// Quit after capturedemo
#endif // Baker change +

	qboolean	timedemo;
#ifdef SUPPORTS_GHOSTING_VIA_DEMOS // Baker change
	
// THE FOLLOWING 3 VARIABLES ARE FOR WRITING ONLY	
	qboolean	ghostdemo;				// Records a ghost file, similar to timedemo but no rendering/loading/sound
	FILE		*ghostfile;
	ghostw_t	ghost_write;			// Variables used during writing.

// This is set by the "ghostdemo" command.  Resets on gamedir change or exit or subsequent "ghostdemo" command (delete the file too).
	char		ghostname[MAX_OSPATH];	// Keep track of the name.  Delete it on gamedir change and exit or re-use.
#ifdef SUPPORTS_GHOSTING_AUTOMAP // Baker change
	char		ghostfirstmap[MAX_QPATH];	// First map of current ghost file.  Erase it when we erase ghostname.
#endif // Baker change +

// Variables for using a ghost.  i.e. READ
	qboolean	using_ghost;			// Set at level load
	FILE		*ghostfileread;			// Read a ghost file
	int			ghost_record_count;
	int			ghost_record_map_begin;// First map record number
	int			ghost_record_map_end;	// Last map record number			
	int			ghost_record_map_current;	

	ghost_t		ghost_read;


/*  Make this static wherever it really goes ...
// Note: Don't advance the ghost position if he'd be out of sight
	char		ghost_player_map[31];	// Should be MAX_QPATH, but we are using 31 to round records to 32 length.
	int			ghost_player_frame_frac;
	int			ghost_player_x;
	int			ghost_player_y;
	int			ghost_player_z;
	int			ghost_player_pitch;
	int			ghost_player_yaw;
	int			ghost_player_roll;
*/

#endif // Baker change + SUPPORTS_GHOSTING_VIA_DEMOS

	int			forcetrack;			// -1 = use normal cd track
	FILE		*demofile;
	int			td_lastframe;		// to meter out one message a frame
	int			td_startframe;		// host_framecount at start
	float		td_starttime;		// realtime at second frame of timedemo


// connection information
	int			signon;			// 0 to SIGNONS
	struct qsocket_s	*netcon;
	sizebuf_t	message;		// writing buffer to send to server

} client_static_t;

extern client_static_t	cls;

//
// the client_state_t structure is wiped completely at every
// server signon
//
typedef struct
{
	int			movemessages;	// since connecting to this server
								// throw out the first couple, so the player
								// doesn't accidentally do something the
								// first frame
	usercmd_t	cmd;			// last command sent to the server

// information for local display
	int			stats[MAX_CL_STATS];	// health, etc
	int			items;			// inventory bit flags
	float	item_gettime[32];	// cl.time of aquiring item, for blinking
	float		faceanimtime;	// use anim frame if cl.time < this

	cshift_t	cshifts[NUM_CSHIFTS];	// color shifts for damage, powerups
	cshift_t	prev_cshifts[NUM_CSHIFTS];	// and content types

// the client maintains its own idea of view angles, which are
// sent to the server each frame.  The server sets punchangle when
// the view is temporarliy offset, and an angle reset commands at the start
// of each level and after teleporting.
	vec3_t		mviewangles[2];	// during demo playback viewangles is lerped
								// between these
	vec3_t		viewangles;

	vec3_t		mvelocity[2];	// update by server, used for lean+bob
								// (0 is newest)
	vec3_t		velocity;		// lerped between mvelocity[0] and [1]

	vec3_t		punchangle;		// temporary offset

// pitch drifting vars
	float		idealpitch;
	float		pitchvel;
	qboolean	nodrift;
	float		driftmove;
	double		laststop;

	float		viewheight;
	float		crouch;			// local amount for smoothing stepups

	qboolean	paused;			// send over by server
	qboolean	onground;
	qboolean	inwater;

	int			intermission;	// don't change view angle, full screen, etc
	int			completed_time;	// latched at intermission start

	double		mtime[2];		// the timestamp of last two messages
	double		time;			// clients view of time, should be between
								// servertime and oldservertime to generate
								// a lerp point for other data
#ifdef SUPPORTS_DEMO_REWIND // Baker change
	double		ctime;			// inclusive of demo speed (can go backwards)
#endif // Baker change +
	double		oldtime;		// previous cl.time, time-oldtime is used
								// to decay light values and smooth step ups


	float		last_received_message;	// (realtime) for net trouble icon

//
// information that is static for the entire time connected to a server
//
	struct model_s		*model_precache[MAX_MODELS];
	struct sfx_s		*sound_precache[MAX_SOUNDS];

	char		levelname[128];	// for display on solo scoreboard //johnfitz -- was 40.
	int			viewentity;		// cl_entitites[cl.viewentity] = player
	int			maxclients;
	int			gametype;

// refresh related state
	struct model_s	*worldmodel;	// cl_entitites[0].model
	struct efrag_s	*free_efrags;
	int			num_entities;	// held in cl_entities array
	int			num_statics;	// held in cl_staticentities array
	entity_t	viewent;			// the gun model

	int			cdtrack, looptrack;	// cd audio

// frag scoreboard
	scoreboard_t	*scores;		// [cl.maxclients]

#ifdef SUPPORTS_LEGIT_PING_SCOREBOARD // Baker change
	double			last_ping_time;
	qboolean		expecting_ping;
	qboolean		in_ping_parse;
	int				in_ping_parse_slot;
#endif // Baker change +

#ifdef SUPPORTS_TALK_MACROS // Baker change
	vec3_t			death_location;		// used for %d formatting
#endif // Baker change +

#ifdef SUPPORTS_VIEW_ANGLES_INTERPOLATION // Baker change
	double			last_angle_time;
	vec3_t			lerpangles;
#endif // Baker change +

#ifdef TOUCHUP_NOCLIP_ANGLEHACK_MOVED_TO_CL // Baker change
	qboolean		noclip_anglehack;
#endif // Baker change +
	unsigned		protocol; //johnfitz
} client_state_t;


//
// cvars
//
extern	cvar_t	cl_name;
extern	cvar_t	cl_color;

extern	cvar_t	cl_upspeed;
extern	cvar_t	cl_forwardspeed;
extern	cvar_t	cl_backspeed;
extern	cvar_t	cl_sidespeed;

extern	cvar_t	cl_movespeedkey;

extern	cvar_t	cl_yawspeed;
extern	cvar_t	cl_pitchspeed;

extern	cvar_t	cl_anglespeedkey;

extern	cvar_t	cl_autofire;

extern	cvar_t	cl_shownet;
extern	cvar_t	cl_nolerp;

extern	cvar_t	cl_pitchdriftspeed;
extern	cvar_t	lookspring;
extern	cvar_t	lookstrafe;
extern	cvar_t	sensitivity;

extern	cvar_t	m_pitch;
extern	cvar_t	m_yaw;
extern	cvar_t	m_forward;
extern	cvar_t	m_side;

#define	MAX_TEMP_ENTITIES	256		//johnfitz -- was 64
#define	MAX_STATIC_ENTITIES	512		//johnfitz -- was 128
#define	MAX_VISEDICTS		1024	//johnfitz -- was 256

extern	client_state_t	cl;

// FIXME, allocate dynamically
extern	efrag_t			cl_efrags[MAX_EFRAGS];
extern	entity_t		cl_static_entities[MAX_STATIC_ENTITIES];
extern	lightstyle_t	cl_lightstyle[MAX_LIGHTSTYLES];
extern	dlight_t		cl_dlights[MAX_DLIGHTS];
extern	entity_t		cl_temp_entities[MAX_TEMP_ENTITIES];
extern	beam_t			cl_beams[MAX_BEAMS];
extern	entity_t		*cl_visedicts[MAX_VISEDICTS];
extern	int				cl_numvisedicts;

extern	entity_t		*cl_entities; //johnfitz -- was a static array, now on hunk
extern	int				cl_max_edicts; //johnfitz -- only changes when new map loads

//=============================================================================

//
// cl_main
//
dlight_t *CL_AllocDlight (int key);
void	CL_DecayLights (void);

void CL_Init (void);

void CL_EstablishConnection (char *host);
void CL_Signon1 (void);
void CL_Signon2 (void);
void CL_Signon3 (void);
void CL_Signon4 (void);

void CL_Disconnect (void);
void CL_Disconnect_f (void);
void CL_NextDemo (void);

//
// cl_input
//
typedef struct
{
	int		down[2];		// key nums holding it down
	int		state;			// low bit is down state
} kbutton_t;

extern	kbutton_t	in_mlook, in_klook;
extern 	kbutton_t 	in_strafe;
extern 	kbutton_t 	in_speed;
extern	kbutton_t	in_attack;


void CL_InitInput (void);
void CL_SendCmd (void);
void CL_SendMove (usercmd_t *cmd);

void CL_ParseTEnt (void);
void CL_UpdateTEnts (void);

void CL_ClearState (void);


int  CL_ReadFromServer (void);
void CL_WriteToServer (usercmd_t *cmd);
void CL_BaseMove (usercmd_t *cmd);


float CL_KeyState (kbutton_t *key);
char *Key_KeynumToString (int keynum);

//
// cl_demo.c
//
void CL_StopPlayback (void);
int CL_GetMessage (void);

void CL_Stop_f (void);
void CL_Record_f (void);
void CL_PlayDemo_f (void);
#ifdef TOUCHUP_CLEAR_DEMOQUEUE_PLAYDEMO // Baker change
void CL_PlayDemo_NextStartDemo_f (void);
#endif // Baker change +
void CL_TimeDemo_f (void);

#ifdef SUPPORTS_GHOSTING_VIA_DEMOS // Baker change
void CL_GhostDemo_f (void);
#endif // Baker change + SUPPORTS_GHOSTING_VIA_DEMOS
//
// cl_parse.c
//
void CL_ParseServerMessage (void);
void CL_NewTranslation (int slot); // Baker: It's ok.  cl_parse.c uses it

//
// view
//
void V_StartPitchDrift (void);
void V_StopPitchDrift (void);

void V_RenderView (void);
//void V_UpdatePalette (void); //johnfitz
void V_Register (void);
void V_ParseDamage (void);
void V_SetContentsColor (int contents);


//
// cl_tent
//
void CL_InitTEnts (void);
void CL_SignonReply (void);
