/*
Copyright (C) 1996-2001 Id Software, Inc.
Copyright (C) 2002-2012 John Fitzgibbons and others

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// comndef.h  -- general definitions

#if !defined BYTE_DEFINED
typedef unsigned char 		byte;
#define BYTE_DEFINED 1
#endif

#undef true
#undef false

typedef enum {false, true}	qboolean;

//============================================================================

typedef struct sizebuf_s
{
	qboolean	allowoverflow;	// if false, do a Sys_Error
	qboolean	overflowed;		// set to true if the buffer size failed
	byte	*data;
	int		maxsize;
	int		cursize;
} sizebuf_t;

void SZ_Alloc (sizebuf_t *buf, int startsize);
void SZ_Free (sizebuf_t *buf);
void SZ_Clear (sizebuf_t *buf);
void *SZ_GetSpace (sizebuf_t *buf, int length);
void SZ_Write (sizebuf_t *buf, void *data, int length);
void SZ_Print (sizebuf_t *buf, char *data);	// strcats onto the sizebuf

//============================================================================

typedef struct link_s
{
	struct link_s	*prev, *next;
} link_t;


void ClearLink (link_t *l);
void RemoveLink (link_t *l);
void InsertLinkBefore (link_t *l, link_t *before);
void InsertLinkAfter (link_t *l, link_t *after);

// (type *)STRUCT_FROM_LINK(link_t *link, type, member)
// ent = STRUCT_FROM_LINK(link,entity_t,order)
// FIXME: remove this mess!
#define	STRUCT_FROM_LINK(l,t,m) ((t *)((byte *)l - (int)&(((t *)0)->m)))

//============================================================================

#ifndef NULL
#define NULL ((void *)0)
#endif

#define Q_MAXCHAR ((char)0x7f)
#define Q_MAXSHORT ((short)0x7fff)
#define Q_MAXINT	((int)0x7fffffff)
#define Q_MAXLONG ((int)0x7fffffff)
#define Q_MAXFLOAT ((int)0x7fffffff)

#define Q_MINCHAR ((char)0x80)
#define Q_MINSHORT ((short)0x8000)
#define Q_MININT 	((int)0x80000000)
#define Q_MINLONG ((int)0x80000000)
#define Q_MINFLOAT ((int)0x7fffffff)

//============================================================================

extern	qboolean		bigendien;

extern	short	(*BigShort) (short l);
extern	short	(*LittleShort) (short l);
extern	int	(*BigLong) (int l);
extern	int	(*LittleLong) (int l);
extern	float	(*BigFloat) (float l);
extern	float	(*LittleFloat) (float l);

//============================================================================

void MSG_WriteChar (sizebuf_t *sb, int c);
void MSG_WriteByte (sizebuf_t *sb, int c);
void MSG_WriteShort (sizebuf_t *sb, int c);
void MSG_WriteLong (sizebuf_t *sb, int c);
void MSG_WriteFloat (sizebuf_t *sb, float f);
void MSG_WriteString (sizebuf_t *sb, char *s);
void MSG_WriteCoord (sizebuf_t *sb, float f);
void MSG_WriteAngle (sizebuf_t *sb, float f);
void MSG_WriteAngle16 (sizebuf_t *sb, float f); //johnfitz

extern	int			msg_readcount;
extern	qboolean	msg_badread;		// set if a read goes beyond end of message

void MSG_BeginReading (void);
int MSG_ReadChar (void);
int MSG_ReadByte (void);
int MSG_ReadShort (void);
int MSG_ReadLong (void);
float MSG_ReadFloat (void);
char *MSG_ReadString (void);

float MSG_ReadCoord (void);
float MSG_ReadAngle (void);
float MSG_ReadAngle16 (void); //johnfitz

//============================================================================

void Q_memset (void *dest, int fill, int count);
void Q_memcpy (void *dest, void *src, int count);
int Q_memcmp (void *m1, void *m2, int count);
void Q_strcpy (char *dest, char *src);
void Q_strncpy (char *dest, char *src, int count);
int Q_strlen (char *str);
char *Q_strrchr (char *s, char c);
void Q_strcat (char *dest, char *src);
int Q_strcmp (char *s1, char *s2);
int Q_strncmp (char *s1, char *s2, int count);
int Q_strcasecmp (char *s1, char *s2);
int Q_strncasecmp (char *s1, char *s2, int n);
int	Q_atoi (char *str);
float Q_atof (char *str);

//============================================================================

extern	char		com_token[1024];
extern	qboolean	com_eof;

char *COM_Parse (char *data);


extern	int		com_argc;
extern	char	**com_argv;

int COM_CheckParm (char *parm);
void COM_Init (char *path);
void COM_InitArgv (int argc, char **argv);

char *COM_SkipPath (char *pathname);
void COM_StripExtension (char *in, char *out);
void COM_FileBase (char *in, char *out);
void COM_DefaultExtension (char *path, char *extension);

char	*va(char *format, ...);
#ifdef SUPPORTS_ENHANCED_C_FUNCS // Baker change
// veg copies a string to a static temp buffer which is returned.
// and then deallocates the one it was passed.
// received.  So I can write lines of code that consume and use an allocated
// string.
char *veg(const char* x);

// This makes it somewhat easy to make a constants/enumeration table
typedef struct
{
	const char* string;
	int value;
} keypair_t;

// String macros
#define StringStartsWith(bigstr, lilstr)		!strncmp(bigstr, lilstr, strlen(lilstr))

// Extra string functions
int String_Does_End_With_Caseless (const char *bigstring, const char *littlestring);
char* String_Edit_SlashesBack_Like_Windows (char *UnixStylePath);

// strlcat and strlcpy, from OpenBSD
// Most (all?) BSDs already have them
#if defined(__OpenBSD__) || defined(__NetBSD__) || defined(__FreeBSD__) || defined(MACOSX)
# define HAVE_STRLCAT 1
# define HAVE_STRLCPY 1
#endif

#ifndef HAVE_STRLCAT
/*!
 * Appends src to string dst of size siz (unlike strncat, siz is the
 * full size of dst, not space left).  At most siz-1 characters
 * will be copied.  Always NUL terminates (unless siz <= strlen(dst)).
 * Returns strlen(src) + MIN(siz, strlen(initial dst)).
 * If retval >= siz, truncation occurred.
 */
size_t strlcat(char *dst, const char *src, size_t siz);
#endif  // #ifndef HAVE_STRLCAT

#ifndef HAVE_STRLCPY
/*!
 * Copy src to string dst of size siz.  At most siz-1 characters
 * will be copied.  Always NUL terminates (unless siz == 0).
 * Returns strlen(src); if retval >= siz, truncation occurred.
 */
size_t strlcpy(char *dst, const char *src, size_t siz);

#endif  // #ifndef HAVE_STRLCPY

#endif // Baker change +

#ifdef SUPPORTS_ENHANCED_C_FUNCS // Baker change

	#if 1 // Bandages.  Not gonna rewrite all my external code
		#define Message_FatalError Sys_Error
		#define System_Clipboard_Set_Text Sys_CopyToClipboard
		#define NSLogc(x) 
		#define Memory_calloc(_count, _num, _why) calloc(_count, _num)
		#define Memory_malloc(_count, _why) malloc(_count)
		#define Memory_strdup strdup
		#define Memory_realloc(_p, _size, _why) realloc (_p, _size)	
//		#define fbool qboolean

		#ifdef _WIN32
			#define strcasecmp stricmp
			#define strncasecmp strnicmp
		#endif
	#endif

#endif // Baker change +

// does a varargs printf into a temp buffer

#ifdef SUPPORTS_COMMA_DELIM_FIX // Baker change
qboolean COM_ListMatch (char *liststr, const char *itemstr);
#endif // Baker change +

#ifdef SUPPORTS_SMART_EDICTS // Baker change
int	COM_StringCount (char *bigstring, char *findwhat);
#endif // Baker change +

#ifdef SUPPORTS_CHECK_RIGHT_DIR // Baker change
void COM_SlashesForward_Like_Unix (char *WindowsStylePath);
void COM_Reduce_To_Parent_Path (char* myPath);
#endif // Baker change +

// %g might be a better way to do this, but this works fine.  Not broke, don't fix.
#ifdef SUPPORTS_NICE_CVAR_FLOAT_STRING // Baker change
char *COM_NiceFloatString (float floatvalue);
#endif // Baker change +

//============================================================================

extern int com_filesize;
#ifdef SUPPORTS_WRONG_CONTENT_PROTECTION // Baker change
extern char	com_filepath[MAX_OSPATH];
extern char	com_basedir[MAX_OSPATH];
#endif // Baker change +

#ifdef SUPPORTS_FOLDER_COMMAND_LASTFILE // Baker change
extern char recent_file[MAX_OSPATH]; // Most recent file.  Used to folder command.
#endif // Baker change +

struct cache_user_s;

extern	char	com_gamedir[MAX_OSPATH];

void COM_WriteFile (char *filename, void *data, int len);
int COM_OpenFile (char *filename, int *hndl);
int COM_FOpenFile (char *filename, FILE **file);
void COM_CloseFile (int h);

#ifdef SUPPORTS_WRONG_CONTENT_PROTECTION // Baker change
int COM_FOpenFile_Limited (char *filename, FILE **file, char *media_owner_path);
byte *COM_LoadHunkFile_Limited (char *path, char *media_owner_path);
#endif // Baker change +

#ifdef SUPPORTS_MP3_MUSIC // Baker change
char *COM_FindFile_NoPak (const char *file_to_find);
#endif // Baker change +

byte *COM_LoadStackFile (char *path, void *buffer, int bufsize);
byte *COM_LoadTempFile (char *path);
byte *COM_LoadHunkFile (char *path);
void COM_LoadCacheFile (char *path, struct cache_user_s *cu);


extern	struct cvar_s	registered;

#ifdef SUPPORTS_GAME_HIPNOTIC_ROGUE_QUOTH // Baker change
extern qboolean		standard_quake, rogue, hipnotic, quoth;
#else // Baker change +
extern qboolean		standard_quake, rogue, hipnotic;
#endif // Baker change -




#ifdef SUPPORTS_ENHANCED_C_FUNCS // Baker change
// Easier dynamic strings.


typedef const char ezString;

#endif // Baker change +

#ifdef SUPPORTS_ENHANCED_C_FUNCS // Baker change
// Easier dynamic lists

typedef struct ezSortList_s
{	
	struct ezSortList_s	*next;
	struct ezSortList_s	*prev;
	
	ezString*			string;
	ezString*			itemdata;	// Default
	
	void				*data;
} ezSortList;

#define ForEachSortList(_j, _cursor, _list) for (_j = 0, _cursor = _list; _cursor; _j++, _cursor = _cursor->next)
// This will move forward X items or stop prematurely at last non-null item
#define SortListCursorForwardStopAtEnd(_j, _cursor, _start, _count) for ((_cursor) = (_start), (_j) = 0; (_j) < (_count) && (_cursor)->next; (_j)++, (_cursor) = (_cursor)->next)

ezSortList* ezSortList_Add (ezSortList** alphaboss, const char* string);
ezSortList* ezSortList_Add_With_ItemData (ezSortList** alphaboss, const char* string, const char* itemdata);

// This one we add "down"
ezSortList* ezLinkEnd_Add_With_ItemData (ezSortList** chaintop, ezSortList* tail, const char* string, const char* itemdata);

#endif // Baker change +

