/*

Copyright (C) 2001-2002       A Nourai

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the included (GNU.txt) GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <string.h>

#include "quakedef.h"
#include "utils.h"
#include "fchecks.h"
#include "modules.h"
#include "md5.h"

void  FMod_Response (void);

struct CheckedFile
{
	const char *name;
	unsigned char md5sum[16];
	int checked;
	int modified;
};

struct CheckedFile CheckedFiles[] =
{
	{ "progs/armor.mdl", { 0xca, 0x06, 0x01, 0x66, 0xd7, 0xe4, 0xe4, 0x68, 0x69, 0x95, 0xf0, 0x56, 0x45, 0xdd, 0xe5, 0x93 }, 0, 0 },
	{ "progs/backpack.mdl", { 0x31, 0x5b, 0x4e, 0xf4, 0x2f, 0xb0, 0x35, 0xaa, 0x33, 0x18, 0xe8, 0xd2, 0xd6, 0x19, 0x61, 0xce }, 0, 0 },
	{ "progs/bolt2.mdl", { 0xf5, 0x9c, 0xe0, 0x7c, 0xfb, 0xe0, 0x1f, 0xcf, 0xc5, 0x78, 0x25, 0x8c, 0x57, 0x3d, 0x2c, 0x31 }, 0, 0 },
	{ "progs/end1.mdl", { 0x67, 0xc0, 0xfc, 0xab, 0x33, 0xd3, 0x77, 0x2c, 0x00, 0xbb, 0x46, 0x2b, 0x0e, 0x74, 0x92, 0x75 }, 0, 0 },
	{ "progs/end2.mdl", { 0x3a, 0x0d, 0x6d, 0x55, 0xc9, 0x68, 0x07, 0x09, 0x55, 0x4c, 0x25, 0x5e, 0x4f, 0x33, 0x58, 0xb2 }, 0, 0 },
	{ "progs/end3.mdl", { 0x23, 0x66, 0x71, 0xa8, 0x8e, 0x06, 0x4a, 0x6e, 0xd6, 0xe9, 0x22, 0xa4, 0x0a, 0x6b, 0x4e, 0x30 }, 0, 0 },
	{ "progs/end4.mdl", { 0x81, 0x81, 0x49, 0x0e, 0xef, 0xaf, 0xc2, 0x7d, 0x43, 0xf7, 0xb7, 0x32, 0x86, 0xf2, 0x58, 0xa2 }, 0, 0 },
	{ "progs/eyes.mdl", { 0xed, 0x72, 0xf6, 0x4a, 0x17, 0xc6, 0x90, 0x9b, 0x2c, 0xb3, 0x03, 0x4a, 0x73, 0x4b, 0xca, 0x97 }, 0, 0 },
	{ "progs/g_light.mdl", { 0x61, 0xbb, 0xa0, 0x6e, 0xc3, 0x80, 0x4b, 0x7f, 0x35, 0x5a, 0x62, 0xfd, 0x45, 0x85, 0xad, 0x8f }, 0, 0 },
	{ "progs/g_nail.mdl", { 0xe2, 0x95, 0x9c, 0xa7, 0x41, 0xc7, 0x64, 0xdd, 0x42, 0x02, 0x5e, 0xf5, 0x31, 0xa1, 0xb5, 0x54 }, 0, 0 },
	{ "progs/g_nail2.mdl", { 0xed, 0x6d, 0x7b, 0xb5, 0xff, 0x05, 0x0a, 0xd5, 0xf2, 0xbf, 0x4b, 0xe7, 0x73, 0x9a, 0x16, 0xa5 }, 0, 0 },
	{ "progs/g_rock.mdl", { 0x61, 0x34, 0x6f, 0x84, 0x29, 0x44, 0x79, 0x5e, 0x08, 0x21, 0xe3, 0x1e, 0x3d, 0x61, 0xb4, 0x27 }, 0, 0 },
	{ "progs/g_rock2.mdl", { 0x68, 0xc0, 0x47, 0xc9, 0x7b, 0xab, 0x89, 0xaf, 0xe2, 0xcb, 0x69, 0xe6, 0x5b, 0x7c, 0x62, 0xe1 }, 0, 0 },
	{ "progs/g_shot.mdl", { 0x7f, 0xac, 0xfe, 0xc1, 0xa3, 0xcf, 0xb8, 0x92, 0xcc, 0xe8, 0x71, 0xf3, 0x98, 0xe9, 0xcb, 0x6b }, 0, 0 },
	{ "progs/gib1.mdl", { 0xf5, 0xc5, 0xb7, 0x99, 0xe8, 0x95, 0xdc, 0x03, 0x03, 0x65, 0x22, 0xa4, 0x87, 0xe9, 0x99, 0x13 }, 0, 0 },
	{ "progs/gib2.mdl", { 0xcf, 0xa9, 0xe9, 0x7a, 0x35, 0x42, 0x85, 0x24, 0x18, 0x12, 0x3e, 0x0b, 0xb1, 0x2e, 0x4f, 0x86 }, 0, 0 },
	{ "progs/gib3.mdl", { 0xd7, 0x3b, 0xe7, 0xb2, 0x88, 0x1e, 0x0a, 0x5a, 0xac, 0xf2, 0xb3, 0x32, 0xac, 0x29, 0x08, 0x6f }, 0, 0 },
	{ "progs/grenade.mdl", { 0xf4, 0x92, 0xd6, 0x25, 0x7c, 0x21, 0x63, 0x06, 0x98, 0x3a, 0x72, 0xf4, 0x1d, 0xb0, 0xd8, 0x91 }, 0, 0 },
	{ "progs/invisibl.mdl", { 0x1e, 0x87, 0xd8, 0x6a, 0xf0, 0x2e, 0x69, 0xdb, 0x9c, 0x9f, 0x27, 0xf5, 0xfd, 0xdc, 0x7a, 0x47 }, 0, 0 },
	{ "progs/invulner.mdl", { 0x8c, 0x8d, 0x83, 0xe4, 0xd5, 0x0c, 0x32, 0x82, 0xd0, 0x09, 0xb3, 0x33, 0xa1, 0x28, 0x04, 0x22 }, 0, 0 },
	{ "progs/missile.mdl", { 0x47, 0xf1, 0x9f, 0x9e, 0x34, 0x95, 0x4b, 0x93, 0x44, 0x3c, 0x97, 0x59, 0xdd, 0x2e, 0x7b, 0xa0 }, 0, 0 },
	{ "progs/quaddama.mdl", { 0x00, 0xb1, 0x77, 0xff, 0x27, 0x2a, 0x47, 0x79, 0x09, 0x7e, 0xa0, 0x83, 0x44, 0xda, 0x8a, 0xff }, 0, 0 },
	{ "progs/s_spike.mdl", { 0xeb, 0xb1, 0xd5, 0x82, 0x42, 0xb6, 0x4a, 0x70, 0x36, 0x23, 0xc8, 0xa3, 0x3f, 0xcb, 0xd9, 0xe6 }, 0, 0 },
	{ "progs/spike.mdl", { 0xbe, 0x4c, 0xb7, 0x31, 0x25, 0xf9, 0x39, 0x28, 0x43, 0x76, 0x08, 0x0a, 0xcc, 0x98, 0x87, 0xdd }, 0, 0 },
	{ "progs/suit.mdl", { 0x88, 0x2a, 0x61, 0xf5, 0xee, 0xa7, 0xf9, 0xcd, 0xbc, 0x04, 0x80, 0x0b, 0x96, 0x3c, 0xef, 0x85 }, 0, 0 },
	{ "progs/player.mdl", { 0x40, 0x5c, 0xef, 0x9a, 0x10, 0xd9, 0x6c, 0xda, 0xbf, 0xfb, 0x5e, 0x91, 0x31, 0x2f, 0x8e, 0x5c }, 0, 0 },
	{ "progs/s_bubble.spr", { 0x7c, 0x08, 0x87, 0x63, 0x0e, 0xd4, 0x68, 0x20, 0x52, 0x92, 0xd8, 0xcb, 0x7a, 0xbc, 0xae, 0x93 }, 0, 0 },
	{ "progs/s_explod.spr", { 0x76, 0x6c, 0x6a, 0x92, 0xc2, 0x6b, 0x54, 0xf6, 0x8f, 0x7f, 0xf8, 0x7c, 0x90, 0xd7, 0x1c, 0xf2 }, 0, 0 },
	{ "maps/b_bh100.bsp", { 0x62, 0xf7, 0x8b, 0xb5, 0x14, 0x32, 0x65, 0xf0, 0x37, 0xb7, 0x9d, 0xdd, 0x07, 0x7c, 0x50, 0xed }, 0, 0 },
	{ "sound/buttons/airbut1.wav", { 0x9d, 0x2e, 0x14, 0xe7, 0x17, 0x68, 0x42, 0xa0, 0xdc, 0xe9, 0x09, 0xa4, 0x3d, 0x38, 0x87, 0x3d }, 0, 0 },
	{ "sound/items/armor1.wav", { 0x18, 0x6d, 0x29, 0xf2, 0xba, 0xf3, 0x5b, 0x8c, 0x28, 0x0b, 0xc9, 0x77, 0x54, 0x60, 0x6f, 0xad }, 0, 0 },
	{ "sound/items/damage.wav", { 0x8c, 0xde, 0x8b, 0x92, 0x78, 0xca, 0x49, 0x22, 0xa4, 0xec, 0x7e, 0xad, 0x6e, 0x5e, 0xe0, 0x1b }, 0, 0 },
	{ "sound/items/damage2.wav", { 0x14, 0xe5, 0x3b, 0x76, 0x17, 0xff, 0xe3, 0x15, 0xa7, 0xc3, 0xf8, 0xd8, 0x96, 0x52, 0xe5, 0x1c }, 0, 0 },
	{ "sound/items/damage3.wav", { 0xba, 0xf7, 0x54, 0xae, 0xc7, 0xed, 0x4b, 0xab, 0xa1, 0x67, 0x60, 0xac, 0x85, 0x51, 0x31, 0x84 }, 0, 0 },
	{ "sound/items/health1.wav", { 0x52, 0xa2, 0xc4, 0xf8, 0x08, 0xdb, 0x4e, 0xdd, 0x83, 0x93, 0xde, 0x0d, 0xe6, 0x18, 0xc9, 0x1f }, 0, 0 },
	{ "sound/items/inv1.wav", { 0x58, 0x50, 0xca, 0xb5, 0x5d, 0x61, 0x97, 0xd0, 0xe7, 0x6d, 0x9f, 0x0a, 0x22, 0xba, 0x10, 0xbe }, 0, 0 },
	{ "sound/items/inv2.wav", { 0x4e, 0xdc, 0xd3, 0x8a, 0x2c, 0x6a, 0xdc, 0x53, 0x05, 0x63, 0x6d, 0xd7, 0xaf, 0xd5, 0xef, 0x60 }, 0, 0 },
	{ "sound/items/inv3.wav", { 0x32, 0x5c, 0x26, 0x8b, 0xe0, 0x5b, 0x42, 0xa0, 0x19, 0xcc, 0xb9, 0x2e, 0x69, 0x93, 0xab, 0x9e }, 0, 0 },
	{ "sound/items/itembk2.wav", { 0x27, 0x0c, 0x68, 0x8b, 0x3c, 0xb8, 0x84, 0xf5, 0xd4, 0xe5, 0xff, 0xd8, 0xcc, 0xc9, 0x34, 0xa1 }, 0, 0 },
	{ "sound/player/land.wav", { 0xe3, 0x43, 0x28, 0xa4, 0x03, 0x58, 0xd9, 0x8f, 0x0f, 0x95, 0x40, 0x3b, 0x9e, 0x27, 0xec, 0x1e }, 0, 0 },
	{ "sound/player/land2.wav", { 0x6b, 0xa5, 0x34, 0x25, 0x6a, 0x77, 0x9d, 0x66, 0xd9, 0xd9, 0xda, 0xbb, 0x90, 0xe6, 0x3c, 0x8b }, 0, 0 },
	{ "sound/misc/outwater.wav", { 0x35, 0x73, 0x24, 0x12, 0x41, 0x2d, 0xdb, 0x5e, 0xd4, 0x18, 0x63, 0x3b, 0xb0, 0x12, 0x3b, 0xbe }, 0, 0 },
	{ "sound/weapons/pkup.wav", { 0x0a, 0xa6, 0xf0, 0xa7, 0xd6, 0x09, 0xe1, 0xa5, 0x6f, 0xd5, 0x35, 0xa0, 0x6d, 0x1b, 0xb5, 0x6e }, 0, 0 },
	{ "sound/player/plyrjmp8.wav", { 0xd4, 0xa5, 0x52, 0xd8, 0xf6, 0x27, 0xc7, 0xf3, 0xb9, 0x33, 0x56, 0x8c, 0x4a, 0x74, 0xc9, 0x13 }, 0, 0 },
	{ "sound/items/protect.wav", { 0xd8, 0x39, 0xd5, 0xa8, 0x4f, 0x81, 0x1c, 0xe8, 0xa0, 0xe2, 0x86, 0x16, 0x89, 0x1b, 0xf1, 0xa7 }, 0, 0 },
	{ "sound/items/protect2.wav", { 0x25, 0x62, 0x7a, 0x4b, 0xd2, 0xb4, 0xc6, 0x05, 0x4c, 0xfd, 0x2f, 0xc4, 0xbf, 0x69, 0xdd, 0xc2 }, 0, 0 },
	{ "sound/items/protect3.wav", { 0x7b, 0x93, 0x74, 0xd6, 0x7f, 0x6d, 0x59, 0xe5, 0x24, 0xbb, 0xa2, 0xaf, 0x23, 0x6c, 0xa3, 0x0a }, 0, 0 },
	{ "sound/misc/water1.wav", { 0xd8, 0x29, 0x1c, 0x76, 0x2a, 0xcb, 0x1e, 0xdf, 0x24, 0x92, 0x7f, 0xdc, 0xc0, 0xf6, 0xa6, 0xcd }, 0, 0 },
	{ "sound/misc/water2.wav", { 0x04, 0x9e, 0x8e, 0x7e, 0x7b, 0x30, 0xd4, 0xd8, 0x03, 0x8a, 0xfb, 0x72, 0x48, 0xbd, 0xd9, 0x77 }, 0, 0 },
	{ "gfx/colormap.lmp", { 0x0d, 0x79, 0x3b, 0x70, 0xbf, 0xfa, 0xfb, 0xd6, 0x66, 0xfc, 0x5c, 0x88, 0xd6, 0xe1, 0x5e, 0x9d }, 0, 0 },
	{ "gfx/palette.lmp", { 0x79, 0xbc, 0x14, 0x9d, 0x4f, 0x2f, 0xb0, 0xbd, 0x68, 0xcd, 0x84, 0x00, 0xa3, 0xfd, 0x87, 0xd4 }, 0, 0 },
};

#define CHECKEDFILESCOUNT (sizeof(CheckedFiles)/sizeof(*CheckedFiles))

static float fmod_warn_time = 0;

void FMod_CheckModel(char *name, void *buf, int len)
{
	int i;
	qboolean modified;
	struct md5 md5;
	unsigned char out[16];

	for (i = 0; i < CHECKEDFILESCOUNT; i++)
	{
		if (Q_strcasecmp(name, CheckedFiles[i].name) == 0)
			break;
	}
	if (i == CHECKEDFILESCOUNT)
		return;

	md5_init(&md5);
	md5_process(&md5, buf, len);
	md5_done(&md5, out);

	modified = memcmp(out, CheckedFiles[i].md5sum, 16);

	if (CheckedFiles[i].checked && !CheckedFiles[i].modified && modified)
	{
		if (!fmod_warn_time || cls.realtime - fmod_warn_time >= 3)
		{
			Cbuf_AddText("say warning: models changed !!  Use f_modified again\n");
			fmod_warn_time = cls.realtime;
		}
	}
	CheckedFiles[i].modified = modified;
	CheckedFiles[i].checked = true;
}

void FMod_CvarInit(void)
{
	Cmd_AddCommand("f_modified", FMod_Response);
}

void FMod_Response (void)
{
	int i, count;
	char buf[512] = {'m', 'o', 'd', 'i', 'f', 'i', 'e', 'd', ':', '\0'};

	for (i = count = 0; i < CHECKEDFILESCOUNT; i++)
	{
		if (CheckedFiles[i].checked && CheckedFiles[i].modified)
		{
			if (strlen(buf) < 240)
			{
				strcat(buf, va(" %s", COM_SkipPath(CheckedFiles[i].name)));
				count++;
			}
			else
			{
				strcat(buf, " & more...");
				break;
			}
		}
	}

	if (!count)
		strcpy(buf, "all models ok");

	Cbuf_AddText(va("%s %s\n", cls.state == ca_disconnected ? "echo" : "say", buf));
}

