/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// r_main.c

#include "quakedef.h"

entity_t	r_worldentity;

qboolean	r_cache_thrash;		// compatability

vec3_t		modelorg, r_entorigin;
entity_t	*currententity;

int			r_visframecount;	// bumped when going to a new PVS
int			r_framecount;		// used for dlight push checking

mplane_t	frustum[4];

int			c_brush_polys, c_alias_polys;

qboolean	envmap;				// true during envmap command capture 


// Q2K4-0058 start
qboolean	dyntex;				// true during dynamic texture capture
qboolean	clearZBuffer;		// overrides gl_ztrick 
float		dyntex_lastupdate;	
// Q2K4-0058 end

// Q2K4-0083 start

vec3_t		dyntexOrigin;
vec3_t		dyntexAngles;

// int			dyntexViewEntity;
// Q2K4-0083 end

int			currenttexture = -1;		// to avoid unnecessary texture sets

int			cnttextures[2] = {-1, -1};     // cached

int			particletexture;	// little dot for particles
int			playertextures;		// up to 16 color translated skins


// Q2K4-0025 start
int			mirrortexturenum;	// quake texturenum, not gltexturenum

qboolean	mirror;
mplane_t	*mirror_plane;
// Q2K4-0025 end

// Q2K4-0058 start
int			dyntexture;			// dynamic texture
// Q2K4-0058 end
//
// view origin
//
vec3_t	vup;
vec3_t	vpn;
vec3_t	vright;
vec3_t	r_origin;

float	r_world_matrix[16];
float	r_base_world_matrix[16];

//
// screen size info
//
refdef_t	r_refdef;

mleaf_t		*r_viewleaf, *r_oldviewleaf;

texture_t	*r_notexture_mip;

int		d_lightstylevalue[256];	// 8.8 fraction of base light value


void R_MarkLeaves (void);

cvar_t	r_norefresh = {"r_norefresh","0"};
cvar_t	r_drawentities = {"r_drawentities","1"};
cvar_t	r_drawviewmodel = {"r_drawviewmodel","1"};
cvar_t	r_speeds = {"r_speeds","0"};
cvar_t	r_fullbright = {"r_fullbright","0"};
cvar_t	r_lightmap = {"r_lightmap","0"};
// Q2K4-0004 start
cvar_t	r_shadows = {"r_shadows","0", true};
// Q2K4-0004 end

// Q2K4-0004 start
cvar_t	r_wateralpha = {"r_wateralpha","0.35", true};
// Q2K4-0004 end
cvar_t	r_dynamic = {"r_dynamic","1"};
cvar_t	r_novis = {"r_novis","0"};

cvar_t	gl_finish = {"gl_finish","0"};
cvar_t	gl_clear = {"gl_clear","0"};
cvar_t	gl_cull = {"gl_cull","1"};
cvar_t	gl_texsort = {"gl_texsort","1"};
cvar_t	gl_smoothmodels = {"gl_smoothmodels","1"};
cvar_t	gl_affinemodels = {"gl_affinemodels","1"};
cvar_t	gl_polyblend = {"gl_polyblend","1"};
// Q2K4-0055 start
// cvar_t	gl_flashblend = {"gl_flashblend","1"};
cvar_t	gl_flashblend = {"gl_flashblend","0", true};
// Q2K4-0055 end
cvar_t	gl_playermip = {"gl_playermip","0"};
cvar_t	gl_nocolors = {"gl_nocolors","0"};
cvar_t	gl_keeptjunctions = {"gl_keeptjunctions","0"};
cvar_t	gl_reporttjunctions = {"gl_reporttjunctions","0"};
cvar_t	gl_doubleeyes = {"gl_doubleeys", "1"};

// Q2K4-0019 start
cvar_t	skybox = {"skybox", "0", true};
cvar_t	skyname = {"skyname", "sky", true};
// Q2K4-0019 end

// Q2K4-0002 start
// fenix@io.com: model interpolation
cvar_t  r_interpolate_model_animation = { "r_interpolate_model_animation", "1", true };
cvar_t  r_interpolate_model_transform = { "r_interpolate_model_transform", "1", true };
// Q2K4-0002 end

// Q2K4-0004 start
cvar_t	cl_itemfx = {"cl_itemfx", "0", true};
// Q2K4-0004 end

// Q2K4-0010 start
cvar_t r_waterwarp = {"r_waterwarp", "0", true};
// Q2K4-0010 end

// Q2K4-0027 start
cvar_t  r_waterripple = {"r_waterripple", "3", true};
// Q2K4-0027 end

// Q2K4-0011 start
// NATAS - BramBo - Fog Code
cvar_t gl_fogenable = {"gl_fogenable", "0", true}; 
cvar_t gl_fogstart = {"gl_fogstart", "50.0", true}; 
cvar_t gl_fogend = {"gl_fogend", "800.0", true}; 
cvar_t gl_fogdensity = {"gl_fogdensity", "0.8", true}; 
cvar_t gl_fogred = {"gl_fogred","0.6", true}; 
cvar_t gl_foggreen = {"gl_foggreen","0.5", true}; 
cvar_t gl_fogblue = {"gl_fogblue","0.4", true}; 
cvar_t gl_fogalpha = {"gl_fogalpha", "0.5", true};
// END
// Q2K4-0011 end
// Q2K4-0013 start
cvar_t gl_fullbright = {"gl_fullbright", "1", true};
// Q2K4-0013 end

// Q2K4-0016 start
cvar_t r_theme = {"r_theme", "main"};
// Q2K4-0016 end

// Q2K4-0021 start
cvar_t gl_intensity = {"gl_intensity", "1.0", true};
// Q2K4-0021 end

// Q2K4-0025 start
cvar_t r_mirroralpha = {"r_mirroralpha", "1.0", true};

// Q2K4-0058 start
cvar_t r_dyntexenable = {"r_dyntexenable", "0"};
cvar_t r_dyntexfps = {"r_dyntexfps", "15", true};
// Q2K4-0065 start
extern	cvar_t	gl_ztrick;
// Q2K4-0065 end
// Q2K4-0058 end

// Q2K4-0083 start
cvar_t r_dyntexsize = {"r_dyntexsize", "128"};
// Q2K4-0083 end

// Q2K4-0095 start
cvar_t r_dbltexsize = {"r_dbltexsize", "0", true};
// Q2K4-0095 end
/*
=================
R_CullBox

Returns true if the box is completely outside the frustom
=================
*/
qboolean R_CullBox (vec3_t mins, vec3_t maxs)
{
	int		i;

	for (i=0 ; i<4 ; i++)
		if (BoxOnPlaneSide (mins, maxs, &frustum[i]) == 2)
			return true;
	return false;
}


void R_RotateForEntity (entity_t *e)
{
    glTranslatef (e->origin[0],  e->origin[1],  e->origin[2]);

    glRotatef (e->angles[1],  0, 0, 1);
    glRotatef (-e->angles[0],  0, 1, 0);
    glRotatef (e->angles[2],  1, 0, 0);
}

// Q2K4-0002 start
// Q2K4-0005 start
void R_BlendedRotateForEntity (entity_t *e, int shadow)
 {
// Q2K4-0025 start
	 float timepassed;
// Q2K4-0025 end

     float blend;
     vec3_t d;
     int i;

     // positional interpolation

// Q2K4-0025 start
	 timepassed = realtime - e->translate_start_time; 
     if (e->translate_start_time == 0  || timepassed > 1)
// Q2K4-0025 end
     {
         e->translate_start_time = realtime;
         VectorCopy (e->origin, e->origin1);
         VectorCopy (e->origin, e->origin2);
     }

     if (!VectorCompare (e->origin, e->origin2))
     {
         e->translate_start_time = realtime;
         VectorCopy (e->origin2, e->origin1);
         VectorCopy (e->origin,  e->origin2);
         blend = 0;
     }
     else
     {
// Q2K4-0025 start
		 blend =  timepassed / 0.1;
// Q2K4-0025 end
         if (cl.paused || blend > 1) blend = 1;
     }

     VectorSubtract (e->origin2, e->origin1, d);

     glTranslatef (
         e->origin1[0] + (blend * d[0]),
         e->origin1[1] + (blend * d[1]),
         e->origin1[2] + (blend * d[2]));

     // orientation interpolation (Euler angles, yuck!)

// Q2K4-0025 start
	 timepassed = realtime - e->rotate_start_time; 
     if (e->rotate_start_time == 0 || timepassed > 1)
// Q2K4-0025 end
     {
         e->rotate_start_time = realtime;
         VectorCopy (e->angles, e->angles1);
         VectorCopy (e->angles, e->angles2);
     }

     if (!VectorCompare (e->angles, e->angles2))
     {
         e->rotate_start_time = realtime;
         VectorCopy (e->angles2, e->angles1);
         VectorCopy (e->angles,  e->angles2);
         blend = 0;
     }
     else
     {
// Q2K4-0025 start
		 blend = timepassed / 0.1;
// Q2K4-0025 end
         if (cl.paused || blend > 1) blend = 1;
     }

     VectorSubtract (e->angles2, e->angles1, d);

     // always interpolate along the shortest path
     for (i = 0; i < 3; i++) 
     {
         if (d[i] > 180)
         {
             d[i] -= 360;
         }
         else if (d[i] < -180)
         {
             d[i] += 360;
         }
     }

     glRotatef ( e->angles1[1] + ( blend * d[1]),  0, 0, 1);
// Q2K4-0005 start
	if (shadow==0)
	{
		glRotatef (-e->angles1[0] + (-blend * d[0]),  0, 1, 0); // this rotates tilt
		glRotatef ( e->angles1[2] + ( blend * d[2]),  1, 0, 0); // this is the one that causes the weird missile stuff
	}

// Q2K4-0005 end
}
// Q2K4-0002 end
/*
=============================================================

  SPRITE MODELS

=============================================================
*/

/*
================
R_GetSpriteFrame
================
*/
mspriteframe_t *R_GetSpriteFrame (entity_t *currententity)
{
	msprite_t		*psprite;
	mspritegroup_t	*pspritegroup;
	mspriteframe_t	*pspriteframe;
	int				i, numframes, frame;
	float			*pintervals, fullinterval, targettime, time;

	psprite = currententity->model->cache.data;
	frame = currententity->frame;

	if ((frame >= psprite->numframes) || (frame < 0))
	{
		Con_Printf ("R_DrawSprite: no such frame %d\n", frame);
		frame = 0;
	}

	if (psprite->frames[frame].type == SPR_SINGLE)
	{
		pspriteframe = psprite->frames[frame].frameptr;
	}
	else
	{
		pspritegroup = (mspritegroup_t *)psprite->frames[frame].frameptr;
		pintervals = pspritegroup->intervals;
		numframes = pspritegroup->numframes;
		fullinterval = pintervals[numframes-1];

		time = cl.time + currententity->syncbase;

	// when loading in Mod_LoadSpriteGroup, we guaranteed all interval values
	// are positive, so we don't have to worry about division by 0
		targettime = time - ((int)(time / fullinterval)) * fullinterval;

		for (i=0 ; i<(numframes-1) ; i++)
		{
			if (pintervals[i] > targettime)
				break;
		}

		pspriteframe = pspritegroup->frames[i];
	}

	return pspriteframe;
}


/*
=================
R_DrawSpriteModel

=================
*/
// Q2K4-0014 start
#define VectorScalarMult(a,b,c) {c[0]=a[0]*b;c[1]=a[1]*b;c[2]=a[2]*b;}
void R_DrawSpriteModel (entity_t *e)
{
	vec3_t	point;
	mspriteframe_t	*frame;
	float		*up, *right;
	vec3_t		v_forward, v_right, v_up;
	msprite_t		*psprite;
	vec3_t		fixed_origin;
	vec3_t		temp;

// Q2K4-0016 start
	glDisable(GL_ALPHA_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
// Q2K4-0016 end

	// don't even bother culling, because it's just a single
	// polygon without a surface cache
	frame = R_GetSpriteFrame (e);
	psprite = currententity->model->cache.data;
	VectorCopy(e->origin,fixed_origin);
	if (psprite->type == SPR_ORIENTED)
	{	// bullet marks on walls
		AngleVectors (currententity->angles, v_forward, v_right, v_up);
		VectorScalarMult(v_forward,-2,temp);
		VectorAdd(temp,fixed_origin,fixed_origin);
		up = v_up;
		right = v_right;
	}
	else
	{	// normal sprite
		up = vup;
		right = vright;
	}

	glColor3f (1,1,1);
	GL_DisableMultitexture();
    GL_Bind(frame->gl_texturenum);
	glEnable (GL_ALPHA_TEST);
	glBegin (GL_QUADS);
	glTexCoord2f (0, 1);
	VectorMA (fixed_origin, frame->down, up, point);
	VectorMA (point, frame->left, right, point);
	glVertex3fv (point);
	glTexCoord2f (0, 0);
	VectorMA (fixed_origin, frame->up, up, point);
	VectorMA (point, frame->left, right, point);
	glVertex3fv (point);
	glTexCoord2f (1, 0);
	VectorMA (fixed_origin, frame->up, up, point);
	VectorMA (point, frame->right, right, point);
	glVertex3fv (point);
	glTexCoord2f (1, 1);
	VectorMA (fixed_origin, frame->down, up, point);
	VectorMA (point, frame->right, right, point);
	glVertex3fv (point);
	glEnd ();
// Q2K4-0016 start
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDisable(GL_BLEND);
// Q2K4-0016 end
	glDisable (GL_ALPHA_TEST);
}

// Q2K4-0014 end
/*
=============================================================

  ALIAS MODELS

=============================================================
*/


#define NUMVERTEXNORMALS	162

float	r_avertexnormals[NUMVERTEXNORMALS][3] = {
#include "anorms.h"
};

vec3_t	shadevector;
// precalculated dot products for quantized angles
#define SHADEDOT_QUANT 16
float	r_avertexnormal_dots[SHADEDOT_QUANT][256] =
#include "anorm_dots.h"
;

float	*shadedots = r_avertexnormal_dots[0];

int	lastposenum;

// Q2K4-0002 start
int lastposenum0;
// Q2K4-0002 end
/*
=============
GL_DrawAliasFrame
=============
*/
extern vec3_t lightcolor; // LordHavoc: .lit support
void GL_DrawAliasFrame (aliashdr_t *paliashdr, int posenum)
{
	float	s, t;
	float 	l;
	int		i, j;
	int		index;
	trivertx_t	*v, *verts;
	int		list;
	int		*order;
	vec3_t	point;
	float	*normal;
	int		count;

lastposenum = posenum;

	verts = (trivertx_t *)((byte *)paliashdr + paliashdr->posedata);
	verts += posenum * paliashdr->poseverts;
	order = (int *)((byte *)paliashdr + paliashdr->commands);

	while (1)
	{
		// get the vertex count and primitive type
		count = *order++;
		if (!count)
			break;		// done
		if (count < 0)
		{
			count = -count;
			glBegin (GL_TRIANGLE_FAN);
		}
		else
			glBegin (GL_TRIANGLE_STRIP);

		do
		{
			// texture coordinates come from the draw list
			glTexCoord2f (((float *)order)[0], ((float *)order)[1]);
			order += 2;
			l = shadedots[verts->lightnormalindex];
			glColor3f (l * lightcolor[0], l * lightcolor[1], l * lightcolor[2]);
			glVertex3f (verts->v[0], verts->v[1], verts->v[2]);
			verts++;
		} while (--count);

		glEnd ();
	}
}

// Q2K4-0002 start
/*
=============
GL_DrawAliasBlendedFrame

fenix@io.com: model animation interpolation
=============
*/
void GL_DrawAliasBlendedFrame (aliashdr_t *paliashdr, int pose1, int pose2, float blend)
{
float       l;
trivertx_t* verts1;
trivertx_t* verts2;
int*        order;
int         count;
vec3_t      d;

lastposenum0 = pose1;
lastposenum  = pose2;

verts1  = (trivertx_t *)((byte *)paliashdr + paliashdr->posedata);
verts2  = verts1;

verts1 += pose1 * paliashdr->poseverts;
verts2 += pose2 * paliashdr->poseverts;

order = (int *)((byte *)paliashdr + paliashdr->commands);

for (;;)
   {
   // get the vertex count and primitive type
   count = *order++;

   if (!count) break;

   if (count < 0)
	  {
	  count = -count;
	  glBegin (GL_TRIANGLE_FAN);
	  }
   else
	  {
	  glBegin (GL_TRIANGLE_STRIP);
	  }

   do
	  {
	  // texture coordinates come from the draw list
	  glTexCoord2f (((float *)order)[0], ((float *)order)[1]);
	  order += 2;

	  // normals and vertexes come from the frame list
	  // blend the light intensity from the two frames together
	  d[0] = shadedots[verts2->lightnormalindex] -
			 shadedots[verts1->lightnormalindex];
// Q2K4-0001 start
		l = shadedots[verts1->lightnormalindex] + (blend * d[0]);
		glColor3f (l * lightcolor[0], l * lightcolor[1], l * lightcolor[2]);
// Q2K4-0001 end
	  VectorSubtract(verts2->v, verts1->v, d);

	  // blend the vertex positions from each frame together
	  glVertex3f (
				 verts1->v[0] + (blend * d[0]),
				 verts1->v[1] + (blend * d[1]),
				 verts1->v[2] + (blend * d[2]));

	  verts1++;
	  verts2++;
	  } while (--count);
	glEnd ();
	}
}
// Q2K4-0002 end

/*
=============
GL_DrawAliasShadow
=============
*/
extern	vec3_t			lightspot;

// Q2K4-0024 start
extern qboolean have_stencil; // Stencil shadows - MrG
// Q2K4-0024 end

// Q2K4-0005 start
void GL_DrawAliasShadow (aliashdr_t *paliashdr, int posenum)
{
	float	s, t, l;
	int		i, j;
	int		index;
	trivertx_t	*v, *verts;
	int		list;
	int		*order;
	vec3_t	point;
	float	*normal;
	float	height, lheight;
	int		count;

	// muff@yakko.globalnet.co.uk - 17 Mar 2000
	trace_t		steptrace, downtrace;
	vec3_t		dest,stop,downmove;
	float		s1,c1; //this will store the sin and cos values as they are used so heavily
	//end of muff

	lheight = currententity->origin[2] - lightspot[2];

	height = 0;
	verts = (trivertx_t *)((byte *)paliashdr + paliashdr->posedata);
	verts += posenum * paliashdr->poseverts;
	order = (int *)((byte *)paliashdr + paliashdr->commands);


// Q2K4-0024 start
	height = -lheight + 0.1;
	if (have_stencil) 
	{
		glEnable(GL_STENCIL_TEST);
		glStencilFunc(GL_EQUAL,1,2);
		glStencilOp(GL_KEEP,GL_KEEP,GL_INCR);
	}
// Q2K4-0024 end
	VectorCopy (currententity->origin, downmove);
	downmove[2] = downmove[2] - 4096;
	memset (&downtrace, 0, sizeof(downtrace));
	SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, currententity->origin, downmove, &downtrace);
	s1 = sin( currententity->angles[1]/180*M_PI);
	c1 = cos( currententity->angles[1]/180*M_PI);
	while (1)
	{
		// get the vertex count and primitive type
		count = *order++;
		if (!count)
			break;		// done
		if (count < 0)
		{
			count = -count;
			glBegin (GL_TRIANGLE_FAN);
		}
		else
			glBegin (GL_TRIANGLE_STRIP);

		do
		{
			// texture coordinates come from the draw list
			// (skipped for shadows) glTexCoord2fv ((float *)order);
			order += 2;

			// normals and vertexes come from the frame list
			point[0] = verts->v[0] * paliashdr->scale[0] + paliashdr->scale_origin[0];
			point[1] = verts->v[1] * paliashdr->scale[1] + paliashdr->scale_origin[1];
			point[2] = verts->v[2] * paliashdr->scale[2] + paliashdr->scale_origin[2];
			point[0] -= shadevector[0]*(point[0]); 
			point[1] -= shadevector[1]*(point[1]);
			point[2] -= shadevector[2]*(point[2]);

			//drop it down to floor
			point[2] = point[2] - (currententity->origin[2] - downtrace.endpos[2]) ;

			// now adjust the point with respect to all the normals of the tracepoint
			// I'm probably missing an easy piece of maths to do this
			// it reads messy, but works ;)
			point[2] +=	 (    	(point[1] * (s1 * downtrace.plane.normal[0])) -
					     	(point[0] * (c1 * downtrace.plane.normal[0])) -
						(point[0] * (s1 * downtrace.plane.normal[1])) - 
						(point[1] * (c1 * downtrace.plane.normal[1])) 
					 	 ) +  ((1.0 - downtrace.plane.normal[2])*20)
						 + 0.2 ;

		        //end of muff

			glVertex3fv (point);

			verts++;
		} while (--count);

		glEnd ();
	}	

// Q2K4-0024 start
	if (have_stencil) 
	{
		glDisable(GL_STENCIL_TEST); // Stencil shadows - MrG
	}
// Q2K4-0024 end
}

// Q2K4-0050 start
//math function
void vectoangles (vec3_t value1, vec3_t angles)
{
	float	forward;
	float	yaw, pitch;
	
	if ( value1[1] == 0 && value1[0] == 0 ) {
		yaw = 0;
		if ( value1[2] > 0 ) {
			pitch = 90;
		}
		else {
			pitch = 270;
		}
	}
	else {
		if ( value1[0] ) {
			yaw = ( atan2 ( value1[1], value1[0] ) * 180 / M_PI );
		}
		else if ( value1[1] > 0 ) {
			yaw = 90;
		}
		else {
			yaw = 270;
		}
		if ( yaw < 0 ) {
			yaw += 360;
		}

		forward = sqrt ( value1[0]*value1[0] + value1[1]*value1[1] );
		pitch = ( atan2(value1[2], forward) * 180 / M_PI );
		if ( pitch < 0 ) {
			pitch += 360;
		}
	}

	angles[PITCH] = -pitch;
	angles[YAW] = yaw;
	angles[ROLL] = 0;
}

//Convenience function to get the pose given the frame of the alias model.
int R_GetPose (int frame, aliashdr_t *paliashdr)
{
	int				pose, numposes;
	float			interval;

	if ((frame >= paliashdr->numframes) || (frame < 0))
	{
		Con_DPrintf ("R_AliasSetupFrame: no such frame %d\n", frame);
		frame = 0;
	}

	pose = paliashdr->frames[frame].firstpose;
	numposes = paliashdr->frames[frame].numposes;

	if (numposes > 1)
	{
		interval = paliashdr->frames[frame].interval;
		pose += (int)(cl.time / interval) % numposes;
	}

	return pose;
}

//Transforms a given vert point.
//I guess I'm doing this kind of oddly, just came up with
//the formula myself and I'm not too great with math.
void R_TransformPoint(vec3_t basePos, vec3_t scale, vec3_t eAngles, vec3_t in, vec3_t out)
{
	static vec3_t v, d, a;
	static vec3_t fwd, right, up;
	static vec3_t tAngles;
	static float f;

	v[0] = in[0];
	v[1] = in[1];
	v[2] = in[2];

	//scale it accordingly
	v[0] *= scale[0];
	v[1] *= scale[1];
	v[2] *= scale[2];

	//offset by scale origin
	VectorAdd(v, basePos, v);

	//get the angles from 0 for vert point
	//and the length
	VectorSubtract(v, vec3_origin, d);
	f = VectorNormalize(d);
	vectoangles(d, a);

	//add relative entity angles into offset angle
	tAngles[0] = -eAngles[0];
	tAngles[1] = eAngles[1];
	tAngles[2] = eAngles[2];

	VectorAdd(a, tAngles, a);

	//re-orient point in relation to center based on angular offsets
	AngleVectors(a, fwd, right, up);
	VectorMA(vec3_origin, f, fwd, out);
}

//Transform all the points for a given triangle
void R_TransformedTri(vec3_t basePos, vec3_t scale, vec3_t eAngles, trivertx_t *verts, mtriangle_t *tri, vec3_t x, vec3_t y, vec3_t z)
{
	static vec3_t vX, vY, vZ;

	vX[0] = verts[tri->vertindex[0]].v[0];
	vX[1] = verts[tri->vertindex[0]].v[1];
	vX[2] = verts[tri->vertindex[0]].v[2];
	R_TransformPoint(basePos, scale, eAngles, vX, x);

	vY[0] = verts[tri->vertindex[1]].v[0];
	vY[1] = verts[tri->vertindex[1]].v[1];
	vY[2] = verts[tri->vertindex[1]].v[2];
	R_TransformPoint(basePos, scale, eAngles, vY, y);

	vZ[0] = verts[tri->vertindex[2]].v[0];
	vZ[1] = verts[tri->vertindex[2]].v[1];
	vZ[2] = verts[tri->vertindex[2]].v[2];
	R_TransformPoint(basePos, scale, eAngles, vZ, z);
}

//Using same plane equation calculation routine as my stencil shadow
//tutorial.
void R_CalcPlaneEq(vec3_t x, vec3_t y, vec3_t z, float *planeEq)
{
	planeEq[0] = x[1]*(y[2]-z[2]) + y[1]*(z[2]-x[2]) + z[1]*(x[2]-y[2]);
	planeEq[1] = x[2]*(y[0]-z[0]) + y[2]*(z[0]-x[0]) + z[2]*(x[0]-y[0]);
	planeEq[2] = x[0]*(y[1]-z[1]) + y[0]*(z[1]-x[1]) + z[0]*(x[1]-y[1]);
	planeEq[3] = -( x[0]*( y[1]*z[2] - z[1]*y[2] ) + y[0]*(z[1]*x[2] - x[1]*z[2]) + z[0]*(x[1]*y[2] - y[1]*x[2]) );
}

//See which side of the tri plane a point is on (or if it's equal).
int R_PointRelativeToPlane(vec3_t pos, float *side, float *planeEq)
{
	*side = planeEq[0]*pos[0] + planeEq[1]*pos[1] + planeEq[2]*pos[2] + planeEq[3];

	if (*side > 0.0f)
	{
		return 1;
	}
	else if (*side < 0.0f)
	{
		return -1;
	}

	return 0;
}

//Go through all the tris and see if we can hit one.
int R_TraceModel(moveclip_t *clip, model_t *model)
{
	aliashdr_t *paliashdr;
	trivertx_t *verts;
	mtriangle_t *tris;
	vec3_t start, end, dir;
	vec3_t x, y, z;
	float side, side2;
	float planeEq[4];
	float bLen = -1;
	int i;
	int pose;
// Q2K4-0053 start		
	/*
	if (!model ||
		model->type != mod_alias)
	{ //we only want to do this for alias models
		return 1;
	}
	*/
	if (!model || model->type != mod_alias || model->aliastype != ALIASTYPE_MDL)
	{ //we only want to do this for .mdl models (.md2 not supported yet)
		return 1;
	}

// Q2K4-0053 end
	paliashdr = (aliashdr_t *)Mod_Extradata (model);

	if (!paliashdr)
	{
		return 1;
	}

	pose = R_GetPose(clip->trace.ent->v.frame, paliashdr);

	verts = (trivertx_t *)((byte *)paliashdr + paliashdr->baseposedata);
	tris = (mtriangle_t *)((byte *)paliashdr + paliashdr->triangles);
	verts += pose * paliashdr->numverts;

	//We're going to transform the triangles and make them relative to
	//the ent origin, so make start and end relative to the ent origin
	//as well (meaning, the ent origin is now considered 0 0 0)
	VectorSubtract(clip->start, clip->trace.ent->v.origin, start);
	VectorSubtract(clip->end, clip->trace.ent->v.origin, end);

	//Get the direction from the start pos to the end pos
	VectorSubtract(end, start, dir);

	for ( i = 0; i < paliashdr->numtris; i++ )
	{
		mtriangle_t *tri = &tris[i];

		//Transform the vert points for this tri taking angle,
		//scale, and base origin into account
		R_TransformedTri(paliashdr->scale_origin, paliashdr->scale, clip->trace.ent->v.angles, verts, tri, x, y, z);
		//now x, y, and z are all transformed to be relative to
		//the "start" and "end" positions.

		R_CalcPlaneEq(x, y, z, planeEq);
	
		if (R_PointRelativeToPlane(start, &side, planeEq) !=
			R_PointRelativeToPlane(end, &side2, planeEq))
		{ //the start and end points are intersecting with the tri plane somewhere
			vec3_t point;
			vec3_t tricenter;
			vec3_t extruded;
			vec3_t planeNormal;
			float dist;
			int facing;

			planeNormal[0] = planeEq[0];
			planeNormal[1] = planeEq[1];
			planeNormal[2] = planeEq[2];

			side2 = planeNormal[0]*dir[0] + planeNormal[1]*dir[1] + planeNormal[2]*dir[2];

			dist = side/side2;
			
			VectorMA(start, -dist, dir, point);

			//Now that we have the intersection point on the plane, see if it's within
			//the tri itself by getting the direction from each vert to the "center" of
			//the triangle and making sure each vert is actually facing our intersection
			//point.
			VectorMA(x, -2.0f, planeNormal, extruded);
			R_CalcPlaneEq(x, y, extruded, planeEq);
			facing = R_PointRelativeToPlane(point, &side, planeEq);

			if (facing >= 0)
			{
				VectorMA(y, -2.0f, planeNormal, extruded);
				R_CalcPlaneEq(y, z, extruded, planeEq);
				facing = R_PointRelativeToPlane(point, &side, planeEq);

				if (facing >= 0)
				{
					VectorMA(z, -2.0f, planeNormal, extruded);
					R_CalcPlaneEq(z, x, extruded, planeEq);
					facing = R_PointRelativeToPlane(point, &side, planeEq);

					if (facing >= 0)
					{ //the point is inside
						float cLen;
						vec3_t v, v2;

						VectorAdd(clip->trace.ent->v.origin, point, v);
						VectorSubtract(v, clip->start, v2);
						cLen = Length(v2);

						//we want to keep going until we get the point
						//closest to the start point, as it should be
						//considered the primary impact point. It's
						//possible that we might otherwise first check
						//a tri on the side opposite the one we should
						//visually be hitting first, and end up drawing
						//damage particles etc. on that one when we
						//should not be
						if (bLen == -1 || cLen < bLen)
						{
							bLen = cLen;
							VectorCopy(v, clip->trace.endpos);
						}
					}
				}
			}
		}
	}

	if (bLen == -1)
	{ //if still < 0, we never hit anything
		return 0;
	}

	return 1;
}
// Q2K4-0050 end

void GL_DrawAliasBlendedShadow (aliashdr_t *paliashdr, int pose1, int pose2, entity_t* e)
{
    trivertx_t* verts1;
    trivertx_t* verts2;
    int*        order;
    vec3_t      point1;
    vec3_t      point2;
    vec3_t      d;
    float       height;
    float       lheight;
    int         count;
    float       blend;
	trace_t		steptrace, downtrace;
	vec3_t		dest,stop,downmove;
	float		s1,c1; //this will store the sin and cos values as they are used so heavily

    blend = (realtime - e->frame_start_time) / e->frame_interval;

    if (blend > 1) blend = 1;

    lheight = e->origin[2] - lightspot[2];
// Q2K4-0024 start
	height = -lheight + 0.1;
	if (have_stencil) 
	{
		glEnable(GL_STENCIL_TEST);
		glStencilFunc(GL_EQUAL,1,2);
		glStencilOp(GL_KEEP,GL_KEEP,GL_INCR);
	}
// Q2K4-0024 end

	VectorCopy (currententity->origin, downmove);
	downmove[2] = downmove[2] - 4096;
	memset (&downtrace, 0, sizeof(downtrace));
	SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, currententity->origin, downmove, &downtrace);

	// calculate the all important angles
	s1 = sin( currententity->angles[1]/180*M_PI);
	c1 = cos( currententity->angles[1]/180*M_PI);

	// end of muff

    verts1 = (trivertx_t *)((byte *)paliashdr + paliashdr->posedata);
    verts2 = verts1;

    verts1 += pose1 * paliashdr->poseverts;
    verts2 += pose2 * paliashdr->poseverts;

    order = (int *)((byte *)paliashdr + paliashdr->commands);

    for (;;)
       {
       // get the vertex count and primitive type
       count = *order++;

       if (!count) break;

       if (count < 0)
          {
          count = -count;
          glBegin (GL_TRIANGLE_FAN);
          }
       else
          {
          glBegin (GL_TRIANGLE_STRIP);
          }

       do
          {
          order += 2;

          point1[0] = verts1->v[0] * paliashdr->scale[0] + paliashdr->scale_origin[0];
          point1[1] = verts1->v[1] * paliashdr->scale[1] + paliashdr->scale_origin[1];
          point1[2] = verts1->v[2] * paliashdr->scale[2] + paliashdr->scale_origin[2];

          point1[0] -= shadevector[0]*(point1[2]+lheight);
          point1[1] -= shadevector[1]*(point1[2]+lheight);

          point2[0] = verts2->v[0] * paliashdr->scale[0] + paliashdr->scale_origin[0];
          point2[1] = verts2->v[1] * paliashdr->scale[1] + paliashdr->scale_origin[1];
          point2[2] = verts2->v[2] * paliashdr->scale[2] + paliashdr->scale_origin[2];

          point2[0] -= shadevector[0]*(point2[2]+lheight); 
          point2[1] -= shadevector[1]*(point2[2]+lheight); 

          VectorSubtract(point2, point1, d);


	// muff@yakko.globalnet.co.uk - 17 Mar 2000
	point1[0] = point1[0] + (blend * d[0]);  //+lheight); //muff
	point1[1] = point1[1] + (blend * d[1]);  //+lheight); //muff
	point1[2] = point1[2] + (blend * d[2]);  //+lheight); //muff

	//drop it down to floor
	point1[2] =  - (currententity->origin[2] - downtrace.endpos[2]) ;

	//now move the z-coordinate as appropriate
	point1[2] += (	(point1[1] * (s1 * downtrace.plane.normal[0])) -
				(point1[0] * (c1 * downtrace.plane.normal[0])) -
			(point1[0] * (s1 * downtrace.plane.normal[1])) - 
			(point1[1] * (c1 * downtrace.plane.normal[1])) 
			) +  ((1.0 - downtrace.plane.normal[2])*20)
			+ 0.2 ;
	// now load the point we have just calculated
		glVertex3fv (point1);
		verts1++;
		verts2++;
	} while (--count);

          glEnd ();
       }   
// Q2K4-0024 start
	if (have_stencil) 
	{
		glDisable(GL_STENCIL_TEST); 
	}
// Q2K4-0024 end    
 }
// Q2K4-0005 end


/*
=================
R_SetupAliasFrame

=================
*/
void R_SetupAliasFrame (int frame, aliashdr_t *paliashdr)
{
	int				pose, numposes;
	float			interval;

	if ((frame >= paliashdr->numframes) || (frame < 0))
	{
		Con_DPrintf ("R_AliasSetupFrame: no such frame %d\n", frame);
		frame = 0;
	}

	pose = paliashdr->frames[frame].firstpose;
	numposes = paliashdr->frames[frame].numposes;

	if (numposes > 1)
	{
		interval = paliashdr->frames[frame].interval;
		pose += (int)(cl.time / interval) % numposes;
	}

	GL_DrawAliasFrame (paliashdr, pose);
}

// Q2K4-0002 start
 /*
 =================
 R_SetupAliasBlendedFrame

 fenix@io.com: model animation interpolation
 =================
 */
 void R_SetupAliasBlendedFrame (int frame, aliashdr_t *paliashdr, entity_t* e)
 {
    int   pose;
    int   numposes;
    float blend;

    if ((frame >= paliashdr->numframes) || (frame < 0))
       {
       Con_DPrintf ("R_AliasSetupFrame: no such frame %d\n", frame);
       frame = 0;
       }

    pose = paliashdr->frames[frame].firstpose;
    numposes = paliashdr->frames[frame].numposes;

    if (numposes > 1)
       {
       e->frame_interval = paliashdr->frames[frame].interval;
       pose += (int)(cl.time / e->frame_interval) % numposes;
       }
    else 
       {
       /* One tenth of a second is a good for most Quake animations.
       If the nextthink is longer then the animation is usually meant to pause
       (e.g. check out the shambler magic animation in shambler.qc).  If its
       shorter then things will still be smoothed partly, and the jumps will be
       less noticable because of the shorter time.  So, this is probably a good
       assumption. */
       e->frame_interval = 0.1;
       }

    if (e->pose2 != pose)
       {
       e->frame_start_time = realtime;
       e->pose1 = e->pose2;
       e->pose2 = pose;
       blend = 0;
       }
    else
       {
       blend = (realtime - e->frame_start_time) / e->frame_interval;
       }

    // wierd things start happening if blend passes 1
    if (cl.paused || blend > 1) blend = 1;
    
    GL_DrawAliasBlendedFrame (paliashdr, e->pose1, e->pose2, blend);
 }
// Q2K4-0002 end


// Q2K4-0017 start

// Q2K4-0018 start
// precalculated dot products for quantized angles
float	r_avertexnormal_dots_md2[16][256] =
#include "anorm_dots.h"
;

float			*shadedots_md2	= r_avertexnormal_dots_md2[0];
float			*shadedots2_md2	= r_avertexnormal_dots_md2[0];
float			lightlerpoffset;

extern vec3_t	lightcolor;
// Q2K4-0018 end

/*
=============
GL_DrawQ2AliasFrame
=============
*/
void GL_DrawQ2AliasFrame (entity_t *e, md2_t *pheader, int lastpose, int pose, float lerp)
{
// Q2K4-0018 start
	float	ilerp;
	float 	l;
	int		*order, count;
	md2trivertx_t	*verts1, *verts2;
	vec3_t	scale1, translate1, scale2, translate2;
	md2frame_t *frame1, *frame2;

	ilerp = 1.0 - lerp;

	frame1 = (md2frame_t *)((int) pheader + pheader->ofs_frames + (pheader->framesize * lastpose)); 
	frame2 = (md2frame_t *)((int) pheader + pheader->ofs_frames + (pheader->framesize * pose)); 

	VectorCopy(frame1->scale, scale1);
	VectorCopy(frame1->translate, translate1);
	VectorCopy(frame2->scale, scale2);
	VectorCopy(frame2->translate, translate2);
	verts1 = &frame1->verts[0];
	verts2 = &frame2->verts[0];
	order = (int *)((int)pheader + pheader->ofs_glcmds);

	while (1)
	{
		// get the vertex count and primitive type
		count = *order++;
		if (!count)
			break;		// done
		if (count < 0)
		{
			count = -count;
			glBegin (GL_TRIANGLE_FAN);
		}
		else
			glBegin (GL_TRIANGLE_STRIP);

		do
		{
			float d1, d2, l1, l2, diff;
			d1 = shadedots_md2[verts2->lightnormalindex] - shadedots_md2[verts1->lightnormalindex];
			d2 = shadedots2_md2[verts2->lightnormalindex] - shadedots2_md2[verts1->lightnormalindex];
			l1 = shadedots_md2[verts1->lightnormalindex] + (lerp * d1);
			l2 = shadedots2_md2[verts1->lightnormalindex] + (lerp * d2);
			if (l1 != l2)
			{
				if (l1 > l2) {
					diff = l1 - l2;
					diff *= lightlerpoffset;
					l = l1 - diff;
				} else {
					diff = l2 - l1;
					diff *= lightlerpoffset;
					l = l1 + diff;
				}
			}
			else
			{
				l = l1;
			}

			glColor4f (l * lightcolor[0], l * lightcolor[1], l * lightcolor[2], 1.0);
			glTexCoord2f(((float *)order)[0], ((float *)order)[1]);
			glVertex3f((verts1[order[2]].v[0]*scale1[0]+translate1[0])*ilerp+(verts2[order[2]].v[0]*scale2[0]+translate2[0])*lerp,
					   (verts1[order[2]].v[1]*scale1[1]+translate1[1])*ilerp+(verts2[order[2]].v[1]*scale2[1]+translate2[1])*lerp,
					   (verts1[order[2]].v[2]*scale1[2]+translate1[2])*ilerp+(verts2[order[2]].v[2]*scale2[2]+translate2[2])*lerp);
			
			order+=3;
		} while (--count);

		glEnd ();
	}
	glColor4f (1,1,1,1);


// Q2K4-0018 end
}


/*
=============
GL_DrawQ2AliasShadow
=============
*/
void GL_DrawQ2AliasShadow (entity_t *e, md2_t *pheader, int lastpose, int pose, float lerp)
{
// Q2K4-0018 start
	float	ilerp, height, lheight;
	float 	l;
	int		*order, count;
	md2trivertx_t	*verts1, *verts2;
	vec3_t	scale1, translate1, scale2, translate2, point;
	md2frame_t *frame1, *frame2;
	// Tomaz - New Shadow Begin
	trace_t		downtrace;
	vec3_t		downmove;
	float		s1,c1;
	// Tomaz - New Shadow End

	lheight = e->origin[2] - lightspot[2];

	height = 0;

	ilerp = 1.0 - lerp;

	// Tomaz - New Shadow Begin
	VectorCopy (e->origin, downmove);
	downmove[2] = downmove[2] - 4096;
	memset (&downtrace, 0, sizeof(downtrace));
	SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, e->origin, downmove, &downtrace);

	s1 = sin( e->angles[1]/180*M_PI);
	c1 = cos( e->angles[1]/180*M_PI);
	// Tomaz - New Shadow End

	frame1 = (md2frame_t *)((int) pheader + pheader->ofs_frames + (pheader->framesize * lastpose)); 
	frame2 = (md2frame_t *)((int) pheader + pheader->ofs_frames + (pheader->framesize * pose)); 

	VectorCopy(frame1->scale, scale1);
	VectorCopy(frame1->translate, translate1);
	VectorCopy(frame2->scale, scale2);
	VectorCopy(frame2->translate, translate2);
	verts1 = &frame1->verts[0];
	verts2 = &frame2->verts[0];
	order = (int *)((int) pheader + pheader->ofs_glcmds);

	height = -lheight + 1.0;

	while (1)
	{
		// get the vertex count and primitive type
		count = *order++;
		if (!count)
			break;		// done
		if (count < 0)
		{
			count = -count;
			glBegin (GL_TRIANGLE_FAN);
		}
		else
			glBegin (GL_TRIANGLE_STRIP);

		do
		{
			point[0] = (verts1[order[2]].v[0]*scale1[0]+translate1[0])*ilerp+(verts2[order[2]].v[0]*scale2[0]+translate2[0])*lerp;
			point[1] = (verts1[order[2]].v[1]*scale1[1]+translate1[1])*ilerp+(verts2[order[2]].v[1]*scale2[1]+translate2[1])*lerp;
			point[2] = (verts1[order[2]].v[2]*scale1[2]+translate1[2])*ilerp+(verts2[order[2]].v[2]*scale2[2]+translate2[2])*lerp;

			// Tomaz - New shadow Begin
			point[2] =  - (e->origin[2] - downtrace.endpos[2]) ;

			point[2] += ((point[1] * (s1 * downtrace.plane.normal[0])) -
						  (point[0] * (c1 * downtrace.plane.normal[0])) -
						  (point[0] * (s1 * downtrace.plane.normal[1])) - 
						  (point[1] * (c1 * downtrace.plane.normal[1]))) +  
						  ((1.0 - downtrace.plane.normal[2])*20) + 0.2 ;

			glVertex3fv (point);
			// Tomaz - New shadow Begin
			order+=3;
		} while (--count);

		glEnd ();

	}


// Q2K4-0018 end
}



/*
=================
R_SetupQ2AliasFrame

=================
*/
void R_SetupQ2AliasFrame (entity_t *e, md2_t *pheader)
{
	int				frame;
	float			lerp, lerpscale;

	frame = e->frame;

      glPushMatrix ();
	if (r_interpolate_model_transform.value)
	{
		R_BlendedRotateForEntity (e, 0);
	}
	else
	{
		R_RotateForEntity (e);
	}

	if ((frame >= pheader->num_frames) || (frame < 0))
	{
		Con_DPrintf ("R_SetupQ2AliasFrame: no such frame %d\n", frame);
		frame = 0;
	}

	if (e->draw_lastmodel == e->model)
	{
		if (frame != e->draw_pose)
		{
			e->draw_lastpose = e->draw_pose;
			e->draw_pose = frame;
			e->draw_lerpstart = cl.time;
			lerp = 0;
		}
		else
			lerp = (cl.time - e->draw_lerpstart) * 10.0;
	}
	else // uninitialized
	{
		e->draw_lastmodel = e->model;
		e->draw_lastpose = e->draw_pose = frame;
		e->draw_lerpstart = cl.time;
		lerp = 0;
	}
	if (lerp > 1) lerp = 1;
	GL_DrawQ2AliasFrame (e, pheader, e->draw_lastpose, frame, lerp);
	if (r_shadows.value)
	{
// Q2K4-0018 start
		trace_t		downtrace;
		vec3_t		downmove;

		glPushMatrix ();

		VectorCopy (e->origin, downmove);
		
		downmove[2] = downmove[2] - 4096;
		memset (&downtrace, 0, sizeof(downtrace));
		SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, e->origin, downmove, &downtrace);

		glDisable (GL_TEXTURE_2D);
		glDepthMask(false); // disable zbuffer updates
		glColor4f (0,0,0,(1.0 - ((e->origin[2] + e->model->mins[2]-downtrace.endpos[2])/60)));

		GL_DrawQ2AliasShadow (e, pheader, e->draw_lastpose, frame, lerp);
		glDepthMask(true); // enable zbuffer updates
		glEnable (GL_TEXTURE_2D);
		glColor4f (1,1,1,1);
		glPopMatrix ();

// Q2K4-0018 end
	}
	glPopMatrix ();
}

// Q2K4-0017 end


/*
=================
R_DrawAliasModel

=================
*/
void R_DrawAliasModel (entity_t *e)
{
	int			i, j;
	int			lnum;
	vec3_t		dist;
	float		add;
	model_t		*clmodel;
	vec3_t		mins, maxs;
	aliashdr_t	*paliashdr;
	trivertx_t	*verts, *v;
	int			index;
	float		s, t, an;
	int			anim;

// Q2K4-0005 start
	//muff@yakko.globalnet.co.uk - 05 Mar 00 - added
	trace_t		steptrace, downtrace;
	vec3_t		dest,stop,downmove;
	//end of muff
// Q2K4-0005 end

// Q2K4-0017 start
	md2_t		*pheader; // LH / muff
// Q2K4-0017 end


// Q2K4-0016 start

	glDisable(GL_ALPHA_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

// Q2K4-0016 end

	clmodel = currententity->model;

	VectorAdd (currententity->origin, clmodel->mins, mins);
	VectorAdd (currententity->origin, clmodel->maxs, maxs);

	if (R_CullBox (mins, maxs))
		return;


	VectorCopy (currententity->origin, r_entorigin);
	VectorSubtract (r_origin, r_entorigin, modelorg);

	//
	// get lighting information
	//

	// LordHavoc: .lit support begin
	R_LightPoint(currententity->origin); // LordHavoc: lightcolor is all that matters from this
	// LordHavoc: .lit support end

	// allways give the gun some light
	// LordHavoc: .lit support begin
	if (e == &cl.viewent)
	{
		if (lightcolor[0] < 8)
			lightcolor[0] = 8;
		if (lightcolor[1] < 8)
			lightcolor[1] = 8;
		if (lightcolor[2] < 8)
			lightcolor[2] = 8;
	}
	// LordHavoc: .lit support end

	for (lnum=0 ; lnum<MAX_DLIGHTS ; lnum++)
	{
		if (cl_dlights[lnum].die >= cl.time)
		{
			VectorSubtract (currententity->origin,
							cl_dlights[lnum].origin,
							dist);
			add = cl_dlights[lnum].radius - Length(dist);

			// LordHavoc: .lit support begin
			if (add > 0)
			{
				lightcolor[0] += add * cl_dlights[lnum].color[0];
				lightcolor[1] += add * cl_dlights[lnum].color[1];
				lightcolor[2] += add * cl_dlights[lnum].color[2];
			}
			// LordHavoc: .lit support end
 		}
	}

	// ZOID: never allow players to go totally black
	i = currententity - cl_entities;
	if (i >= 1 && i<=cl.maxclients)
	// LordHavoc: .lit support begin
	{
		if (lightcolor[0] < 8)
			lightcolor[0] = 8;
		if (lightcolor[1] < 8)
			lightcolor[1] = 8;
		if (lightcolor[2] < 8)
			lightcolor[2] = 8;
	}
	// LordHavoc: .lit support end
	// Q2K4-0088 start
	/*
	// HACK HACK HACK -- no fullbright colors, so make torches full light
	if 
	(
		!strcmp (clmodel->name, "progs/flame2.mdl") ||
		!strcmp (clmodel->name, "progs/flame.mdl") 
	)
	// LordHavoc: .lit support begin
		lightcolor[0] = lightcolor[1] = lightcolor[2] = 256;
	// LordHavoc: .lit support end
	*/
	if (hasValue(script, "models","fullbright", clmodel->name) != -1)
	{
		lightcolor[0] = lightcolor[1] = lightcolor[2] = 256;
	}
	// Q2K4-0088 end
	shadedots = r_avertexnormal_dots[((int)(e->angles[1] * (SHADEDOT_QUANT / 360.0))) & (SHADEDOT_QUANT - 1)];
	// LordHavoc: .lit support begin
	VectorScale(lightcolor, 1.0f / 200.0f, lightcolor);
	// LordHavoc: .lit support end
	
	an = e->angles[1]/180*M_PI;
	shadevector[0] = cos(-an);
	shadevector[1] = sin(-an);
	shadevector[2] = 1;
	VectorNormalize (shadevector);

	//
	// locate the proper data
	//
// Q2K4-0017 start
	if (clmodel->aliastype == ALIASTYPE_MD2)
	{
		pheader = (md2_t *)Mod_Extradata (currententity->model);
		c_alias_polys += pheader->num_tris;
	}
	else
	{
		paliashdr = (aliashdr_t *)Mod_Extradata (currententity->model);
		c_alias_polys += paliashdr->numtris;
	}
// Q2K4-0017 end
	//
	// draw all the triangles
	//

	GL_DisableMultitexture();
// Q2K4-0017 start
	if (clmodel->aliastype != ALIASTYPE_MD2)
	{
// Q2K4-0017 end

		glPushMatrix ();
	// Q2K4-0002 start
		 if (r_interpolate_model_transform.value)
			{
	// Q2K4-0005 start
			 R_BlendedRotateForEntity (e, 0);
	// Q2K4-0005 end
			}
		 else
			{
			R_RotateForEntity (e);
			}
	// Q2K4-0002 end

	// Q2K4-0088 start
		// if (!strcmp (clmodel->name, "progs/eyes.mdl") && gl_doubleeyes.value) {
		if (hasValue(script, "models","doublesize", clmodel->name) != -1)
		{
			glTranslatef (paliashdr->scale_origin[0], paliashdr->scale_origin[1], paliashdr->scale_origin[2] - (22 + 8));
	// double size of eyes, since they are really hard to see in gl
			glScalef (paliashdr->scale[0]*2, paliashdr->scale[1]*2, paliashdr->scale[2]*2);
		} 
		else 
		{
			glTranslatef (paliashdr->scale_origin[0], paliashdr->scale_origin[1], paliashdr->scale_origin[2]);
			glScalef (paliashdr->scale[0], paliashdr->scale[1], paliashdr->scale[2]);
		}
	// Q2K4-0088 end
// Q2K4-0017 start
	}
// Q2K4-0017 end

// Q2K4-0017 start
	if (clmodel->aliastype == ALIASTYPE_MD2)
	    GL_Bind(pheader->gl_texturenum[currententity->skinnum]);
	else
	{
// Q2K4-0017 end
		anim = (int)(cl.time*10) & 3;
	    GL_Bind(paliashdr->gl_texturenum[currententity->skinnum][anim]);
// Q2K4-0017 start
	}
// Q2K4-0017 end
	// we can't dynamically colormap textures, so they are cached
	// seperately for the players.  Heads are just uncolored.
	if (currententity->colormap != vid.colormap && !gl_nocolors.value)
	{
		i = currententity - cl_entities;
		if (i >= 1 && i<=cl.maxclients)
		    GL_Bind(playertextures - 1 + i);
	}

	if (gl_smoothmodels.value)
		glShadeModel (GL_SMOOTH);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	if (gl_affinemodels.value)
		glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

// Q2K4-0017 start
	if (clmodel->aliastype == ALIASTYPE_MD2)
	{
		R_SetupQ2AliasFrame (currententity, pheader);
	}
	else
	{
// Q2K4-0017 end
// Q2K4-0002 start
		if (r_interpolate_model_animation.value)
			{
				R_SetupAliasBlendedFrame (currententity->frame, paliashdr, currententity);
	        }
		else
	        {
		        R_SetupAliasFrame (currententity->frame, paliashdr);
	        }	
// Q2K4-0002 end
// Q2K4-0017 start
	}
// Q2K4-0017 end

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glShadeModel (GL_FLAT);
	if (gl_affinemodels.value)
		glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
// Q2K4-0017 start
	if (clmodel->aliastype != ALIASTYPE_MD2)
	{
// Q2K4-0017 end
		glPopMatrix ();

	// Q2K4-0005 start
		if (r_shadows.value)
		{
// Q2K4-0088 start
/*
			if ( (!strncmp (clmodel->name, "progs/bolt",10)) ||
				 (!strcmp  (clmodel->name, "progs/missile.mdl")) ||
				 (!strcmp  (clmodel->name, "progs/laser.mdl")) ||
				 (!strcmp  (clmodel->name, "progs/lavaball.mdl")) 
			   )
			   return;

			if (!strncmp (clmodel->name, "progs/v_",8))
				return;
*/
			if (hasValue(script, "models","noshadows", clmodel->name) != -1)
			{
				return;
			}
// Q2K4-0088 end
			glPushMatrix ();
			shadevector[0] = 0;
			shadevector[1] = 0;
			shadevector[2] = 1;
			VectorNormalize (shadevector);
			if (r_interpolate_model_animation.value)
			 R_BlendedRotateForEntity (e, 1); // we've re-written this to work properly		 
			else
			{
			 glTranslatef (e->origin[0],  e->origin[1],  e->origin[2]);
	 		 glRotatef (e->angles[1],  0, 0, 1);
			}

			VectorCopy (e->origin, downmove);
			downmove[2] = downmove[2] - 4096;
			memset (&downtrace, 0, sizeof(downtrace));
			SV_RecursiveHullCheck (cl.worldmodel->hulls, 0, 0, 1, e->origin, downmove, &downtrace);
			glDisable (GL_TEXTURE_2D);
			glEnable (GL_BLEND);
			glColor4f (0,0,0,1.0 - ((mins[2]-downtrace.endpos[2])/60)); 
			if (r_interpolate_model_animation.value)
				GL_DrawAliasBlendedShadow (paliashdr, lastposenum0, lastposenum, currententity);
			else
				GL_DrawAliasShadow (paliashdr, lastposenum);

			glEnable (GL_TEXTURE_2D);
			glDisable (GL_BLEND);
			glColor4f (1,1,1,1);
			glPopMatrix ();
		}
// Q2K4-0005 end
// Q2K4-0017 end
	}
// Q2K4-0017 end
// Q2K4-0016 start

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDisable(GL_BLEND);
	glDisable(GL_ALPHA_TEST);

// Q2K4-0016 end
}

//==================================================================================

/*
=============
R_DrawEntitiesOnList
=============
*/
void R_DrawEntitiesOnList (void)
{
	int		i;

	if (!r_drawentities.value)
		return;

	// draw sprites seperately, because of alpha blending
	for (i=0 ; i<cl_numvisedicts ; i++)
	{
		currententity = cl_visedicts[i];
// Q2K4-0006 start
		if (currententity == &cl_entities[cl.viewentity]) 
			currententity->angles[0] *= 0.3;
// Q2K4-0006 end

		switch (currententity->model->type)
		{
		case mod_alias:
			R_DrawAliasModel (currententity);
			break;

// Q2K4-0089 start
//md3 model tutorial by reckless and shadowalker
		case mod_md3:
			R_DrawQ3Model (currententity);
			break;
//end
// Q2K4-0089 end

		case mod_brush:
			R_DrawBrushModel (currententity);
			break;

		default:
			break;
		}
	}

	for (i=0 ; i<cl_numvisedicts ; i++)
	{
		currententity = cl_visedicts[i];
// Q2K4-0006 start
		if (currententity == &cl_entities[cl.viewentity]) 
			currententity->angles[0] *= 0.3;
// Q2K4-0006 end
		switch (currententity->model->type)
		{
		case mod_sprite:
			R_DrawSpriteModel (currententity);
			break;
		}
	}
}

/*
=============
R_DrawViewModel
=============
*/
void R_DrawViewModel (void)
{
// Q2K4-0002 start
	// fenix@io.com: model transform interpolation
	float old_interpolate_model_transform;
// Q2K4-0002 end
	if (!r_drawviewmodel.value)
		return;

	if (chase_active.value)
		return;

	if (envmap)
		return;

	if (!r_drawentities.value)
		return;

	if (cl.items & IT_INVISIBILITY)
		return;

	if (cl.stats[STAT_HEALTH] <= 0)
		return;

	currententity = &cl.viewent;
	if (!currententity->model)
		return;

	// hack the depth range to prevent view model from poking into walls
	glDepthRange (gldepthmin, gldepthmin + 0.3*(gldepthmax-gldepthmin));
// Q2K4-0002 start
	old_interpolate_model_transform = r_interpolate_model_transform.value;
	r_interpolate_model_transform.value = false;
// Q2K4-0089 start
	R_DrawAliasModel (currententity);

	switch (currententity->model->type)
	{
	   case mod_alias:
		   R_DrawAliasModel (currententity);
		  break;

	   case mod_md3:
		  R_DrawQ3Model (currententity);
		  break;
	}       
// Q2K4-0089 end
	r_interpolate_model_transform.value = old_interpolate_model_transform;
// Q2K4-0002 end
	glDepthRange (gldepthmin, gldepthmax);
}


/*
============
R_PolyBlend
============
*/
void R_PolyBlend (void)
{
	if (!gl_polyblend.value)
		return;
	if (!v_blend[3])
		return;

	GL_DisableMultitexture();

	glDisable (GL_ALPHA_TEST);
	glEnable (GL_BLEND);
	glDisable (GL_DEPTH_TEST);
	glDisable (GL_TEXTURE_2D);

    glLoadIdentity ();

    glRotatef (-90,  1, 0, 0);	    // put Z going up
    glRotatef (90,  0, 0, 1);	    // put Z going up

	glColor4fv (v_blend);

	glBegin (GL_QUADS);

	glVertex3f (10, 100, 100);
	glVertex3f (10, -100, 100);
	glVertex3f (10, -100, -100);
	glVertex3f (10, 100, -100);
	glEnd ();

	glDisable (GL_BLEND);
	glEnable (GL_TEXTURE_2D);
	glEnable (GL_ALPHA_TEST);
}


int SignbitsForPlane (mplane_t *out)
{
	int	bits, j;

	// for fast box on planeside test

	bits = 0;
	for (j=0 ; j<3 ; j++)
	{
		if (out->normal[j] < 0)
			bits |= 1<<j;
	}
	return bits;
}


void R_SetFrustum (void)
{
	int		i;

	if (r_refdef.fov_x == 90) 
	{
		// front side is visible

		VectorAdd (vpn, vright, frustum[0].normal);
		VectorSubtract (vpn, vright, frustum[1].normal);

		VectorAdd (vpn, vup, frustum[2].normal);
		VectorSubtract (vpn, vup, frustum[3].normal);
	}
	else
	{
		// rotate VPN right by FOV_X/2 degrees
		RotatePointAroundVector( frustum[0].normal, vup, vpn, -(90-r_refdef.fov_x / 2 ) );
		// rotate VPN left by FOV_X/2 degrees
		RotatePointAroundVector( frustum[1].normal, vup, vpn, 90-r_refdef.fov_x / 2 );
		// rotate VPN up by FOV_X/2 degrees
		RotatePointAroundVector( frustum[2].normal, vright, vpn, 90-r_refdef.fov_y / 2 );
		// rotate VPN down by FOV_X/2 degrees
		RotatePointAroundVector( frustum[3].normal, vright, vpn, -( 90 - r_refdef.fov_y / 2 ) );
	}

	for (i=0 ; i<4 ; i++)
	{
		frustum[i].type = PLANE_ANYZ;
		frustum[i].dist = DotProduct (r_origin, frustum[i].normal);
		frustum[i].signbits = SignbitsForPlane (&frustum[i]);
	}
}

/*
===============
R_SetupFrame
===============
*/
void R_SetupFrame (void)
{
	int				edgecount;
	vrect_t			vrect;
	float			w, h;

// don't allow cheats in multiplayer
	if (cl.maxclients > 1)
		Cvar_Set ("r_fullbright", "0");

	R_AnimateLight ();

	r_framecount++;

// build the transformation matrix for the given view angles
	VectorCopy (r_refdef.vieworg, r_origin);

	AngleVectors (r_refdef.viewangles, vpn, vright, vup);

// current viewleaf
	r_oldviewleaf = r_viewleaf;
	r_viewleaf = Mod_PointInLeaf (r_origin, cl.worldmodel);

	V_SetContentsColor (r_viewleaf->contents);
	V_CalcBlend ();

	r_cache_thrash = false;

	c_brush_polys = 0;
	c_alias_polys = 0;

}


void MYgluPerspective( GLdouble fovy, GLdouble aspect,
		     GLdouble zNear, GLdouble zFar )
{
   GLdouble xmin, xmax, ymin, ymax;

   ymax = zNear * tan( fovy * M_PI / 360.0 );
   ymin = -ymax;

   xmin = ymin * aspect;
   xmax = ymax * aspect;

   glFrustum( xmin, xmax, ymin, ymax, zNear, zFar );
}

/*
=============
R_SetupGL
=============
*/
void R_SetupGL (void)
{
	float	screenaspect;
	float	yfov;
	int		i;
	extern	int glwidth, glheight;
	int		x, x2, y2, y, w, h;

	//
	// set up viewpoint
	//
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity ();
	x = r_refdef.vrect.x * glwidth/vid.width;
	x2 = (r_refdef.vrect.x + r_refdef.vrect.width) * glwidth/vid.width;
	y = (vid.height-r_refdef.vrect.y) * glheight/vid.height;
	y2 = (vid.height - (r_refdef.vrect.y + r_refdef.vrect.height)) * glheight/vid.height;

	// fudge around because of frac screen scale
	if (x > 0)
		x--;
	if (x2 < glwidth)
		x2++;
	if (y2 < 0)
		y2--;
	if (y < glheight)
		y++;

	w = x2 - x;
	h = y - y2;

	if (envmap)
	{
		x = y2 = 0;
		w = h = 256;
	}

	// Q2K4-0058 start
	if (dyntex)
	{
		x = y2 = 0;
// Q2K4-0083 start
//		w = h = 128;
		// check if cvar has a valid value!
		if ((r_dyntexsize.value > 0) && (r_dyntexsize.value <= 256))
		{
			w = h = (int)r_dyntexsize.value;
		}
		else
		{
		// assume a safe default
			w = h = 128;
			Cvar_SetValue ("r_dyntexsize", 128);
		}
// Q2K4-0083 end
	}
	// Q2K4-0058 end

	glViewport (glx + x, gly + y2, w, h);
    screenaspect = (float)r_refdef.vrect.width/r_refdef.vrect.height;
//	yfov = 2*atan((float)r_refdef.vrect.height/r_refdef.vrect.width)*180/M_PI;

// Q2K4-0015 start
    MYgluPerspective (r_refdef.fov_y,  screenaspect,  4,  NEWGLRENDERLIMIT);
// Q2K4-0015 end

// Q2K4-0025 start
	if (mirror)
	{
		if (mirror_plane->normal[2])
			glScalef (1, -1, 1);
		else
		    glScalef (-1, 1, 1);
		glCullFace(GL_BACK);
	}
	else
// Q2K4-0025 end
		glCullFace(GL_FRONT);

	glMatrixMode(GL_MODELVIEW);
    glLoadIdentity ();

    glRotatef (-90,  1, 0, 0);	    // put Z going up
    glRotatef (90,  0, 0, 1);	    // put Z going up
    glRotatef (-r_refdef.viewangles[2],  1, 0, 0);
    glRotatef (-r_refdef.viewangles[0],  0, 1, 0);
    glRotatef (-r_refdef.viewangles[1],  0, 0, 1);
    glTranslatef (-r_refdef.vieworg[0],  -r_refdef.vieworg[1],  -r_refdef.vieworg[2]);

	glGetFloatv (GL_MODELVIEW_MATRIX, r_world_matrix);

	//
	// set drawing parms
	//
	if (gl_cull.value)
		glEnable(GL_CULL_FACE);
	else
		glDisable(GL_CULL_FACE);

	glDisable(GL_BLEND);
	glDisable(GL_ALPHA_TEST);
	glEnable(GL_DEPTH_TEST);
}

/*
================
R_RenderScene

r_refdef must be set before the first call
================
*/
void R_RenderScene (void)
{
	R_SetupFrame ();
	R_SetFrustum ();
	R_SetupGL ();
	R_MarkLeaves ();	// done here so we know if we're in water
	R_DrawWorld ();		// adds static entities to the list
	S_ExtraUpdate ();	// don't let sound get messed up if going slow
	R_DrawEntitiesOnList ();
	GL_DisableMultitexture();
	R_RenderDlights ();
	R_DrawParticles ();
}

/*
=============
R_Clear
=============
*/
void R_Clear (void)
{
// Q2K4-0025 start
	if (r_mirroralpha.value != 1.0)
	{
		if (gl_clear.value)
			glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		else
		    glClear (GL_DEPTH_BUFFER_BIT);
		gldepthmin = 0;
		gldepthmax = 0.5;
		glDepthFunc (GL_LEQUAL);
	}
	else
// Q2K4-0025 end
// Q2K4-0058 start
// Q2K4-0065 start
	if ((gl_ztrick.value) && (!dyntex) && (!clearZBuffer))
	{
		static int trickframe;

		if (gl_clear.value)
			glClear (GL_COLOR_BUFFER_BIT);

		trickframe++;
		if (trickframe & 1)
		{
			gldepthmin = 0;
			gldepthmax = 0.49999;
			glDepthFunc (GL_LEQUAL);
		}
		else
		{
			gldepthmin = 1;
			gldepthmax = 0.5;
			glDepthFunc (GL_GEQUAL);
		}
	}
	else
	{
		if (gl_clear.value)
			glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		else
			glClear (GL_DEPTH_BUFFER_BIT);
		gldepthmin = 0;
		gldepthmax = 1;
		glDepthFunc (GL_LEQUAL);
		clearZBuffer = false;
	}
// Q2K4-0065 end
// Q2K4-0058 end

// Q2K4-0024 start
// Stencil shadows - MrG
	if ((r_shadows.value) && (have_stencil))
	{
		glClearStencil(1);
		glClear(GL_STENCIL_BUFFER_BIT);
	}
// Q2K4-0024 end

	glDepthRange (gldepthmin, gldepthmax);
}

// Q2K4-0012 start
extern GLfloat fogshift[4];
// Q2K4-0012 end

// Q2K4-0025 start
/*
=============
R_Mirror
=============
*/
void R_Mirror (void)
{
	float		d;
	msurface_t	*s;
	entity_t	*ent;

	if (!mirror)
		return;

	memcpy (r_base_world_matrix, r_world_matrix, sizeof(r_base_world_matrix));

	d = DotProduct (r_refdef.vieworg, mirror_plane->normal) - mirror_plane->dist;
	VectorMA (r_refdef.vieworg, -2*d, mirror_plane->normal, r_refdef.vieworg);

	d = DotProduct (vpn, mirror_plane->normal);
	VectorMA (vpn, -2*d, mirror_plane->normal, vpn);

	r_refdef.viewangles[0] = -asin (vpn[2])/M_PI*180;
	r_refdef.viewangles[1] = atan2 (vpn[1], vpn[0])/M_PI*180;
	r_refdef.viewangles[2] = -r_refdef.viewangles[2];

	ent = &cl_entities[cl.viewentity];
	if (cl_numvisedicts < MAX_VISEDICTS)
	{
		cl_visedicts[cl_numvisedicts] = ent;
		cl_numvisedicts++;
	}

	gldepthmin = 0.5;
	gldepthmax = 1;
	glDepthRange (gldepthmin, gldepthmax);
	glDepthFunc (GL_LEQUAL);

	R_RenderScene ();
	R_DrawWaterSurfaces ();


	gldepthmin = 0;
	gldepthmax = 0.5;
	glDepthRange (gldepthmin, gldepthmax);
	glDepthFunc (GL_LEQUAL);

	// blend on top
	glEnable (GL_BLEND);
	glMatrixMode(GL_PROJECTION);
	if (mirror_plane->normal[2])
		glScalef (1,-1,1);
	else
		glScalef (-1,1,1);
	glCullFace(GL_FRONT);
	glMatrixMode(GL_MODELVIEW);

	glLoadMatrixf (r_base_world_matrix);

	glColor4f (1,1,1,r_mirroralpha.value);
	s = cl.worldmodel->textures[mirrortexturenum]->texturechain;
	for ( ; s ; s=s->texturechain)
		R_RenderBrushPoly (s);
	cl.worldmodel->textures[mirrortexturenum]->texturechain = NULL;
	glDisable (GL_BLEND);
	glColor4f (1,1,1,1);
}
// Q2K4-0025 end
/*
================
R_RenderView

r_refdef must be set before the first call
================
*/

int	debugCount = 0;
void R_RenderView (void)
{
	double	time1, time2;
// Q2K4-0028 start
	double	glTexSortTemp;
// Q2K4-0028 end
	GLfloat colors[4] = {(GLfloat) 0.0, (GLfloat) 0.0, (GLfloat) 1, (GLfloat) 0.20};

	if (r_norefresh.value)
		return;

	if (!r_worldentity.model || !cl.worldmodel)
		Sys_Error ("R_RenderView: NULL worldmodel");

	if (r_speeds.value)
	{
		glFinish ();
		time1 = Sys_FloatTime ();
		c_brush_polys = 0;
		c_alias_polys = 0;
	}

// Q2K4-0025 start
	mirror = false;
// Q2K4-0025 end

// Q2K4-0028 start
	if (r_mirroralpha.value < 1)
	{
		glTexSortTemp = gl_texsort.value;
		Cvar_SetValue("gl_texsort", 1.0);
	}
// Q2K4-0028 end
	if (gl_finish.value)
		glFinish ();

	R_Clear ();

	// render normal view
// Q2K4-0011 start
	if( gl_fogenable.value )
	{
		glFogi(GL_FOG_MODE, GL_LINEAR);
// Q2K4-0012 start
		colors[0] = gl_fogred.value * fogshift[0];
		colors[1] = gl_foggreen.value * fogshift[1];
		colors[2] = gl_fogblue.value * fogshift[2]; 
// Q2K4-0012 end
		glFogfv(GL_FOG_COLOR, colors); 
		glFogf(GL_FOG_START, gl_fogstart.value); 
		glFogf(GL_FOG_END, gl_fogend.value);
		glFogf(GL_FOG_DENSITY, gl_fogdensity.value); 
		glEnable(GL_FOG);
	}
	else
	{
		glDisable(GL_FOG);
	}
// Q2K4-0011 end
	R_RenderScene ();
	R_DrawViewModel ();
	R_DrawWaterSurfaces ();

// Q2K4-0011 start
	glDisable(GL_FOG);
// Q2K4-0011 end

// Q2K4-0025 start
	R_Mirror ();
// Q2K4-0028 start
	if (r_mirroralpha.value < 1)
	{
		Cvar_SetValue("gl_texsort", glTexSortTemp);
	}
// Q2K4-0028 end
// Q2K4-0025 end
	R_PolyBlend ();
	if (r_speeds.value)
	{
		time2 = Sys_FloatTime ();
		Con_Printf ("%3i ms  %4i wpoly %4i epoly\n", (int)((time2-time1)*1000), c_brush_polys, c_alias_polys); 
	}
}
