/*
Copyright (C) 2005 by Carlos H. P. da Silva.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// Q2K4 customizable HUD

#include "quakedef.h"
#include "q2k4gui.h"
//=========================================================================
qpic_t	*hudpics[MAXHUDPICS];
cvar_t	cl_sbarmode = {"cl_sbarmode", "0", true};
hud_t	*hudscrn = NULL;
int		hudwidth, hudheight;
int		menuSelection = 0;
//=========================================================================
void	HUD_Reset()
{
	int r;

	for (r = 0; r < hudwidth * hudheight; r++)
	{
		hudscrn[r].type		= hud_none;
		hudscrn[r].value	= 0x0;
		memset(&hudscrn[r].attrs[0], 0x0, 8);
	}
}

void	HUD_Init()
{
	hudwidth = vid.width / 8;
	hudheight = vid.height / 8;
	Cvar_RegisterVariable(&cl_sbarmode);

	if (hudscrn != NULL)
	{
		free(hudscrn);
	}

// Q2K4-0091 start
//	if ((hudscrn = malloc(sizeof(hud_t) * hudwidth * hudheight)) == NULL)
	if ((hudscrn = Hunk_AllocName(sizeof(hud_t) * hudwidth * hudheight, "hudscrn")) == NULL)
// Q2K4-0091 end
	{
		Sys_Error("HUD_Init(): Failed to alloc HUD structure.");
	}

	HUD_Reset();
}

void	HUD_PrecachePic(char *picname, int pos)
{
	if (hudpics[pos] != NULL)
	{
		return;
	}

	hudpics[pos] = Draw_PicFromWad(picname);
}

void	HUD_Pic(int x, int y, int img)
{
	if ((img < 0) || (img > MAXHUDPICS - 1) || (hudpics[img] == NULL))
	{
		return;
	}

	Draw_Pic (x , y, hudpics[img]);
}

void	HUD_TransPic(int x, int y, int img)
{
	if ((img < 0) || (img > MAXHUDPICS - 1) || (hudpics[img] == NULL))
	{
		return;
	}

	Draw_TransPic (x , y, hudpics[img]);
}

void	HUD_SbarPic(int x, int y, int img)
{
	if ((img < 0) || (img > MAXHUDPICS - 1) || (hudpics[img] == NULL))
	{
		return;
	}

	if (cl.gametype == GAME_DEATHMATCH)
		Draw_Pic (x , y + (vid.height-SBAR_HEIGHT), hudpics[img]);
	else
		Draw_Pic (x + ((vid.width - 320)>>1), y + (vid.height-SBAR_HEIGHT), hudpics[img]);
}

void	HUD_SbarTransPic(int x, int y, int img)
{
	if ((img < 0) || (img > MAXHUDPICS - 1) || (hudpics[img] == NULL))
	{
		return;
	}

	if (cl.gametype == GAME_DEATHMATCH)
		Draw_TransPic (x , y + (vid.height-SBAR_HEIGHT), hudpics[img]);
	else
		Draw_TransPic (x + ((vid.width - 320)>>1), y + (vid.height-SBAR_HEIGHT), hudpics[img]);
}

/**
 * The code running on the server don't
 * know which are the screen dimensions
 * in every client, so the function checks
 * if the cell is visible at the current
 * resolution before blindly setting it
 **/
void	HUD_SetCell(int row, int col, char celltype, char value, char *parms)
{
	int i;

	if (hudscrn == NULL)
	{
		return;
	}

	if ((row < 0) || (row > hudheight) || (col < 0) || (col > hudwidth))
	{
		return;
	}

	if (celltype == hud_pic)
	{
	// check to see if the image goes beyond screen limits
		if ((col * 8 + hudpics[value]->width) > vid.width)
		{
			return;
		}

		if ((row * 8 + hudpics[value]->height) > vid.height)
		{
			return;
		}
	}

	i = row * hudwidth + col;
	hudscrn[i].type		= celltype;
	hudscrn[i].value	= value;
	if (parms != NULL)
	{
		memcpy(hudscrn[i].attrs, parms, 8);
	}
}

void	HUD_Fill(int row, int col, int width, int height, char celltype, char value, char *parms)
{
	int x, y;

	for (y = row; y < row + height; y++)
	{
		for (x = col; x < col + width; x++)
		{
			HUD_SetCell(y, x, celltype, value, parms);
		}
	}
}

// ==========================================================

/**
 * Menu replacement functions
 **/

void	MENU_Draw(int activeItem)
{
	int w = vid.width / 16;
	int h = vid.height / 16;
	int x = 0, y = 0, l;
	char buf[64], buf2[64];

	if (!hasConchar2)
	{
		return;
	}

	// caption bar
	sprintf (buf, "%s %01d.%02d", ENGINE_NAME, ENGINE_VERSION, ENGINE_RELEASE);
	l = w / 2 - (strlen(buf) / 2);
	memset (buf2, 0x0, 64);
	memset (buf2, ' ', l);
	x = 0;
	Draw_Str16 (x, y, buf2, BG_IRONBAR, false, false);
	x += l * 16;
	Draw_Str16 (x, y, buf, BG_STONEHI, false, false);
	l += strlen(buf);
	x += strlen(buf) * 16;
	l = w - l;
	memset (buf2, 0x0, 64);
	memset (buf2, ' ', l);
	Draw_Str16 (x, y, buf2, BG_IRONBAR, false, false);

	// DEBUG
	sprintf(buf2, "activeItem == %d", activeItem);
	Draw_Str8 (0, 0, buf2, false, false);

	// main menu items
	y += 16;
	x = 0;
	memset (buf2, 0x0, 64);
	memset (buf2, ' ', w);
	Draw_Str16 (x, y, buf2, BG_RUSTSHAD, false, false);
	
	if ((activeItem >= 0) && (activeItem <= 4))
	{
		// single player
		Draw_Str16 (x, y, "S", BG_NONE, (activeItem == 0), false);
		x += 16;
		Draw_Str8 (x, y, "ingle", (activeItem == 0), false);
		Draw_Str8 (x, y + 8, " player", (activeItem == 0), false);
		x += 64;

		// multi player
		Draw_Str16 (x, y, "M", BG_NONE, (activeItem == 1), false);
		x += 16;
		Draw_Str8 (x, y, "ulti", (activeItem == 1), false);
		Draw_Str8 (x, y + 8, " player", (activeItem == 1), false);
		x += 64;

		// setup
		Draw_Str16 (x, y, "S", BG_NONE, (activeItem == 2), false);
		x += 16;
		Draw_Str8 (x, y, "etup", (activeItem == 2), false);
		x += 40;

		// help
		Draw_Str16 (x, y, "H", BG_NONE, (activeItem == 3), false);
		x += 16;
		Draw_Str8 (x, y, "elp", (activeItem == 3), false);
		x += 32;

		// quit
		Draw_Str16 (x, y, "Q", BG_NONE, (activeItem == 4), false);
		x += 16;
		Draw_Str8 (x, y, "uit", (activeItem == 4), false);
		x += 32;
	}
	else if ((activeItem >= 5) && (activeItem <= 7))
	{
		// new game
		Draw_Str16 (x, y, "N", BG_NONE, (activeItem == 5), false);
		x += 16;
		Draw_Str8 (x, y, "ew", (activeItem == 5), false);
		Draw_Str8 (x, y + 8, " game", (activeItem == 5), false);
		x += 48;

		// new game
		Draw_Str16 (x, y, "L", BG_NONE, (activeItem == 6), false);
		x += 16;
		Draw_Str8 (x, y, "oad", (activeItem == 6), false);
		Draw_Str8 (x, y + 8, " game", (activeItem == 6), false);
		x += 48;

		// new game
		Draw_Str16 (x, y, "S", BG_NONE, (activeItem == 7), false);
		x += 16;
		Draw_Str8 (x, y, "ave", (activeItem == 7), false);
		Draw_Str8 (x, y + 8, " game", (activeItem == 7), false);
		x += 48;
	}
/*
	int	w = vid.width / 16;
	int h = vid.height / 16;
	int x = 0, y = 0, l;
	char buf[64];

	if (!hasConchar2)
	{
		return;
	}

	Draw_Char16 (x * 16, y * 16, 3);
	y++;
	sprintf (buf, "%s %01d.%02d", ENGINE_NAME, ENGINE_VERSION, ENGINE_RELEASE);
	Draw_Str16 (x *16, y * 16, buf, BG_RUSTSHAD, false, true);
	y += strlen(buf);
	l = h - y - 1;
	if (l < 0)
	{
		l = 0;
	}

	memset (buf, 0x0, 64);
	memset (buf, ' ', l);
	Draw_Str16 (x * 16, y * 16, buf, BG_IRONBAR, false, true);
	y += l;
	Draw_Char16 (x * 16, y * 16, 3);
	x = 1;
	y = 0;
	l = 15;
	memset (buf, 0x0, 64);
	memset (buf, ' ', l);
	Draw_Str16 (x * 16, y * 16, buf, BG_IRONBAR, false, false);
	x += l;
	Draw_Char16 (x * 16, y * 16, 3);
	x++;
	l = w - x - 1;
	if (l < 0)
	{
		l = 0;
	}

	memset (buf, 0x0, 64);
	memset (buf, ' ', l);
	Draw_Str16 (x * 16, y * 16, buf, BG_IRONBAR, false, false);
	x += l;
	Draw_Char16 (x * 16, y * 16, 3);
	Draw_Char16 (x * 16, (h - 1) * 16, 3);
	x = 1;
	y = 1;
	Draw_Str16 (x * 16, y * 16, "    Menu       ", BG_RUSTSHAD, false, false);
	y++;
	Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
	y++;

	// DEBUG start
	// sprintf (buf, " activeItem == %d", activeItem);
	// Draw_Str8 (16, 32, buf, false, false);
	// DEBUG end

	Draw_Str16 (x * 16, y * 16, " Single player ", BG_RUSTED, (activeItem == 0), false);
	y++;
	if ((activeItem >= 1) && (activeItem <= 3))
	{
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                    New game  ", (activeItem == 1), false);
		Draw_Str8 (x * 16, y * 16 + 8, "                   Load game  ", (activeItem == 2), false);
		y++;
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                   Save game  ", (activeItem == 3), false);
		y++;
	}

	Draw_Str16 (x * 16, y * 16, "   Multiplayer ", BG_RUSTED, (activeItem == 4), false);
	y++;
	if ((activeItem >= 5) && (activeItem <= 8))
	{
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                Player setup  ", (activeItem == 5), false);
		Draw_Str8 (x * 16, y * 16 + 8, "                Server setup  ", (activeItem == 6), false);
		y++;
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                 Join a game  ", (activeItem == 7), false);
		Draw_Str8 (x * 16, y * 16 + 8, "               Create a game  ", (activeItem == 8), false);
		y++;
	}

	Draw_Str16 (x * 16, y * 16, "         Setup ", BG_RUSTED, (activeItem == 9), false);
	y++;
	if ((activeItem >= 10) && (activeItem <= 14))
	{
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "               Go to console  ", (activeItem == 10), false);
		Draw_Str8 (x * 16, y * 16 + 8, "               Load defaults  ", (activeItem == 11), false);
		y++;
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                       Video  ", (activeItem == 12), false);
		Draw_Str8 (x * 16, y * 16 + 8, "                       Sound  ", (activeItem == 13), false);
		y++;
		Draw_Str16 (x * 16, y * 16, "               ", BG_RUSTED, false, false);
		Draw_Str8 (x * 16, y * 16, "                    Controls  ", (activeItem == 14), false);
		y++;
	}
	Draw_Str16 (x * 16, y * 16, "          Help ", BG_RUSTED, (activeItem == 15), false);
	y++;
	Draw_Str16 (x * 16, y * 16, "          Quit ", BG_RUSTED, (activeItem == 16), false);
*/
}

