/*
Copyright (C) 2005 by Carlos H. P. da Silva.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// Q2K4 customizable GUI

#ifndef	_Q2K4HUD_H
#define	_Q2K4HUD_H	1

#define	MAXHUDPICS		256

// constants for original status bar elements
#define	QPIC_NUM0		0
#define	QPIC_NUM1		1
#define	QPIC_NUM2		2
#define	QPIC_NUM3		3
#define	QPIC_NUM4		4
#define	QPIC_NUM5		5
#define	QPIC_NUM6		6
#define	QPIC_NUM7		7
#define	QPIC_NUM8		8
#define	QPIC_NUM9		9
#define	QPIC_MINUS		10

#define	QPIC_COLON		151
#define	QPIC_SLASH		152
#define	QPIC_IBAR		153
#define	QPIC_SBAR		154

#define QPIC_AMMO0		155
#define	QPIC_AMMO1		156
#define	QPIC_AMMO2		157
#define	QPIC_AMMO3		158

#define	QPIC_ARMOR0		159
#define	QPIC_ARMOR1		160
#define	QPIC_ARMOR2		161

#define	QPIC_SIGIL0		162
#define	QPIC_SIGIL1		163
#define	QPIC_SIGIL2		164
#define	QPIC_SIGIL3		165

#define	QPIC_ITEM0		166
#define	QPIC_ITEM1		167
#define	QPIC_ITEM2		168
#define	QPIC_ITEM3		169
#define	QPIC_ITEM4		170
#define	QPIC_ITEM5		171

#define	QPIC_SCOREBAR	172

#define	SHIFT_ANUM		11

#define	QPIC_WEAPON0	22
#define	QPIC_WEAPON1	23
#define	QPIC_WEAPON2	24
#define	QPIC_WEAPON3	25
#define	QPIC_WEAPON4	26
#define	QPIC_WEAPON5	27
#define	QPIC_WEAPON6	28
#define	QPIC_WEAPON7	29

#define	SHIFT_ACTIVE	0
#define	SHIFT_OWNED		8
#define	SHIFT_FLASH0	16
#define	SHIFT_FLASH1	24
#define	SHIFT_FLASH2	32
#define	SHIFT_FLASH3	40
#define	SHIFT_FLASH4	48

#define	QPIC_FACE0		80
#define	QPIC_FACE1		81
#define	QPIC_FACE2		82
#define	QPIC_FACE3		83
#define	QPIC_FACE4		84
#define	QPIC_FACE5		85
#define	QPIC_FACE6		86

#define	SHIFT_FPAIN		7

#define	QPIC_FINVIS		94
#define	QPIC_FQUAD		95
#define	QPIC_FINVULN	96
#define	QPIC_FINVINV	97

// Rogue status bar elements
#define	QPIC_RINVBAR0	98
#define	QPIC_RINVBAR1	99

#define	QPIC_RWEAPON0	100
#define	QPIC_RWEAPON1	101
#define	QPIC_RWEAPON2	102
#define	QPIC_RWEAPON3	103
#define	QPIC_RWEAPON4	104

#define	QPIC_RITEM0		105
#define	QPIC_RITEM1		106
#define	QPIC_RAMMO0		107
#define	QPIC_RAMMO1		108
#define	QPIC_RAMMO2		109

#define	QPIC_RTEAMBORD	110

// Hypnotic status bar elements
#define	QPIC_HYPWPN0	111
#define	QPIC_HYPWPN1	112
#define	QPIC_HYPWPN2	113
#define	QPIC_HYPWPN3	114
#define	QPIC_HYPWPN4	115

#define	SHIFT_HYPACTIVE	5
#define	SHIFT_HYPOWNED	10
#define	SHIFT_HYPFLSH0	15
#define	SHIFT_HYPFLSH1	20
#define	SHIFT_HYPFLSH2	25
#define	SHIFT_HYPFLSH3	30
#define	SHIFT_HYPFLSH4	35

#define	QPIC_HYPITEM0	173
#define	QPIC_HYPITEM1	174
// ========================================================
typedef enum {hud_none,hud_char,hud_pic,hud_mdl} hudcell_t;

typedef struct
{
	char	type;
	char	value;		// letter, pic or mdl
	char	attrs[8];	// additional info for mdls (frames, skins, etc)
}hud_t;
// ========================================================
extern	cvar_t	cl_sbarmode;
extern	hud_t	*hudscrn;
extern	int		menuSelection;
// ========================================================
void	HUD_Init();
void	HUD_PrecachePic(char *picname, int pos);
void	HUD_Pic(int x, int y, int img);
void	HUD_TransPic(int x, int y, int img);
void	HUD_SbarPic(int x, int y, int img);
void	HUD_SbarTransPic(int x, int y, int img);
void	HUD_SetCell(int row, int col, char celltype, char value, char *parms);
void	HUD_Fill(int row, int col, int width, int height, char celltype, char value, char *parms);

void	MENU_Draw(int activeItem);
#endif