/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// common structures for all supported BSP formats
#ifndef	_UBSP_H
#define	_UBSP_H	1


#define	SURF_PLANEBACK		2
#define	SURF_DRAWSKY		4
#define SURF_DRAWSPRITE		8
#define SURF_DRAWTURB		0x10
#define SURF_DRAWTILED		0x20
#define SURF_DRAWBACKGROUND	0x40
#define SURF_UNDERWATER		0x80
#define	SURF_SCROLLING		0x100

#define	VERTEXSIZE	7		// x, y, z, s, t, u, v
// ===============================================================================
// Quake I / Half-Life I structures (some modified to be common to all BSP formats)
typedef struct
{
	vec3_t		position;
} mvertex_t;

typedef struct mplane_s
{
	vec3_t	normal;
	float	dist;
	byte	type;			// for texture axis selection and fast side tests
	byte	signbits;		// signx + signy<<1 + signz<<1
	byte	pad[2];
} mplane_t;

typedef struct texture_s
{
	char		name[64];	// changed to receive Q2 or Q3A texture names
	unsigned	width, height;
	int			gl_texturenum;
	struct msurface_s	*texturechain;	// for gl_texsort drawing
	int			anim_total;				// total tenths in sequence ( 0 = no)
	int			anim_min, anim_max;		// time for this frame min <=time< max
	struct		texture_s *anim_next;		// in the animation sequence
	struct		texture_s *alternate_anims;	// bmodels in frmae 1 use these
	unsigned	offsets[MIPLEVELS];		// four mip maps stored
	int			fullbright;
// Q2 specific fields
	char		next_name[32];			// for animated textures
// Q2/Q3A specific fields
	int			flags;
	int			contents;
} texture_t;


typedef struct
{
	unsigned short	v[2];
	unsigned int	cachededgeoffset;
} medge_t;

typedef struct
{
	float		vecs[2][4];
	float		mipadjust;
	texture_t	*texture;
	int			flags;
} mtexinfo_t;

typedef struct glpoly_s
{
	struct	glpoly_s	*next;
	struct	glpoly_s	*chain;
	int		numverts;
	int		flags;			// for SURF_UNDERWATER
	float	verts[4][VERTEXSIZE];	// variable sized (xyz s1t1 s2t2)
	// CHECK: create a separated structure for these and more (shader_t) ?
	float	alpha;
	float	speed;
	int		direction;
} glpoly_t;

typedef struct msurface_s
{
	int			visframe;		// should be drawn when node is crossed
	mplane_t	*plane;
	int			flags;
	int			firstedge;	// look up in model->surfedges[], negative numbers
	int			numedges;	// are backwards edges
	short		texturemins[2];
	short		extents[2];
	int			light_s, light_t;	// gl lightmap coordinates
	glpoly_t	*polys;				// multiple if warped
	struct	msurface_s	*texturechain;
	mtexinfo_t	*texinfo;
// lighting info
	int			dlightframe;
	int			dlightbits;
	int			lightmaptexturenum;
	byte		styles[MAXLIGHTMAPS];
	int			cached_light[MAXLIGHTMAPS];	// values currently used in lightmap
	qboolean	cached_dlight;				// true if dynamic light in cache
	byte		*samples;		// [numstyles*surfsize]
	int			draw_this_frame;
	// CHECK: really needed ?
	float		alpha;
} msurface_t;
// ===============================================================================
// Quake II specific structures




// ===============================================================================
// Quake III: Arena specific ones



#endif