/*
	emit.c

	statement emittion

	Copyright (C) 2001 Bill Currie <bill@taniwha.org>

	Author: Bill Currie <bill@taniwha.org>
	Date: 2001/07/26

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to:

		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA

*/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

static __attribute__ ((used)) const char rcsid[] = "$Id$";

#ifdef HAVE_STRING_H
# include <string.h>
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#include <stdlib.h>

#include <QF/mathlib.h>
#include <QF/va.h>

#include "codespace.h"
#include "def.h"
#include "defspace.h"
#include "debug.h"
#include "diagnostic.h"
#include "emit.h"
#include "function.h"
#include "opcodes.h"
#include "options.h"
#include "qfcc.h"
#include "reloc.h"
#include "statements.h"
#include "symtab.h"
#include "type.h"
#include "value.h"

static def_t zero_def;

static def_t *
get_value_def (ex_value_t *value, etype_t type)
{
	def_t      *def;

	if (type == ev_short) {
		def = new_def (0, &type_short, 0, st_extern);
		def->offset = value->v.short_val;
		return def;
	}
	def = emit_value (value, 0);
	if (type != def->type->type)
		return alias_def (def, ev_types[type]);
	return def;
}

static def_t *
get_operand_def (expr_t *expr, operand_t *op)
{
	def_t      *def;

	if (!op)
		return 0;
	switch (op->op_type) {
		case op_symbol:
			switch (op->o.symbol->sy_type) {
				case sy_var:
					if (op->type != op->o.symbol->type->type)
						return alias_def (op->o.symbol->s.def,
										  ev_types[op->type]);
					return op->o.symbol->s.def;
				case sy_func:
					return op->o.symbol->s.func->def;
				case sy_const:
					return get_value_def (&op->o.symbol->s.value, op->type);
				case sy_type:
				case sy_expr:
				case sy_class:
					internal_error (expr, "invalid operand type");
			}
			break;
		case op_value:
			return get_value_def (op->o.value, op->type);
		case op_label:
			zero_def.type = &type_short;
			return &zero_def;	//FIXME
		case op_temp:
			if (!op->o.def)
				op->o.def = temp_def (op->type, op->size);
			return op->o.def;
		case op_pointer:
			def = op->o.pointer->def;
			if (op->o.pointer->val || op->type != def->type->type) {
				def = alias_def (def, ev_types[op->type]);
				def->offset = op->o.pointer->val;
				def->offset_reloc = 1;
			}
			return def;
		case op_alias:
			def = alias_def (get_operand_def (expr, op->o.alias),
							 ev_types[op->type]);
			return def;
	}
	return 0;
}

static void
add_statement_def_ref (def_t *def, dstatement_t *st, int field)
{
	if (def) {
		int         st_ofs = st - pr.code->code;
		int         offset_reloc = 0;

		while (def->alias) {
			//FIXME it seems there is a bug somewhere creating chains
			//of aliases
			def_t      *a = def;
			offset_reloc |= def->offset_reloc;
			def = def->alias;
			free_def (a);
		}
		if (offset_reloc)
			reloc_op_def_ofs (def, st_ofs, field);
		else
			reloc_op_def (def, st_ofs, field);
	}
}

static void
add_statement_op_ref (operand_t *op, dstatement_t *st, int field)
{
	if (op && op->op_type == op_label) {
		int         st_ofs = st - pr.code->code;
		reloc_t    *reloc = new_reloc (0, st_ofs, rel_op_a_op + field);

		reloc->next = op->o.label->dest->relocs;
		op->o.label->dest->relocs = reloc;
	}
}

static void
emit_statement (statement_t *statement)
{
	const char *opcode = statement->opcode;
	def_t      *def_a = get_operand_def (statement->expr, statement->opa);
	def_t      *def_b = get_operand_def (statement->expr, statement->opb);
	def_t      *def_c = get_operand_def (statement->expr, statement->opc);
	opcode_t   *op = opcode_find (opcode, def_a, def_b, def_c);
	dstatement_t *s;

	if (!op) {
		print_expr (statement->expr);
		print_statement (statement);
		internal_error (statement->expr, "ice ice baby");
	}
	if (options.code.debug) {
		expr_t     *e = statement->expr;
		pr_uint_t   line = (e ? e->line : pr.source_line) - lineno_base;

		if (line != pr.linenos[pr.num_linenos - 1].line) {
			pr_lineno_t *lineno = new_lineno ();

			lineno->line = line;
			lineno->fa.addr = pr.code->size;
		}
	}
	s = codespace_newstatement (pr.code);
	s->op = op->opcode;
	s->a = def_a ? def_a->offset : 0;
	s->b = def_b ? def_b->offset : 0;
	s->c = def_c ? def_c->offset : 0;

	add_statement_def_ref (def_a, s, 0);
	add_statement_def_ref (def_b, s, 1);
	add_statement_def_ref (def_c, s, 2);

	add_statement_op_ref (statement->opa, s, 0);
	add_statement_op_ref (statement->opb, s, 1);
	add_statement_op_ref (statement->opc, s, 2);
}

void
emit_statements (sblock_t *first_sblock)
{
	sblock_t   *sblock;
	statement_t *s;

	for (sblock = first_sblock; sblock; sblock = sblock->next) {
		sblock->offset = pr.code->size;
		for (s = sblock->statements; s; s = s->next)
			emit_statement (s);
	}

	for (sblock = first_sblock; sblock; sblock = sblock->next)
		relocate_refs (sblock->relocs, sblock->offset);
}
