int keymap [KEYMAP_COUNT_512][5] = {
// HOLD: 'V' - If NOT extended, translate to the next value.  Only keypad 5 has this issue.  It could be this is an always translation.
// 'E' - If extended, tranlate to the next value.
// 'N' - Do not emit a key press.  This is specific for the numpad keys and our choice for how we decided to translate the keys.
//                                 The short version is we use scancodes 128-255 for things like "HOME"/"END" since it is invalid unicode.
// TODO: Convert Microsoft UTF-16 to UTF-32 or UTF8.  TODO: Unicode!
    { 0,    0,                               0,                    0, 0,               /* vk hex = 0x0 */  },
    { 1,    VK_LBUTTON,                      K_MOUSE1,             0, 0,               /* vk hex = 0x1 */  },
    { 2,    VK_RBUTTON,                      K_MOUSE2,             0, 0,               /* vk hex = 0x2 */  },
    { 3,    VK_CANCEL,                       0,                    0, 0,               /* vk hex = 0x3 */  },
    { 4,    VK_MBUTTON,                      K_MOUSE3,             0, 0,               /* vk hex = 0x4 */  },
    { 5,    VK_XBUTTON1,                     K_MOUSE4,             0, 0,               /* vk hex = 0x5 */  },
    { 6,    VK_XBUTTON2,                     K_MOUSE5,             0, 0,               /* vk hex = 0x6 */  },
    { 7,    0,                               0,                    0, 0,               /* vk hex = 0x7 */  },
    { 8,    VK_BACK,                         K_BACKSPACE,          0, 0,               /* vk hex = 0x8 */  },
    { 9,    VK_TAB,                          K_TAB,                0, 0,               /* vk hex = 0x9 */  },
    { 10,   0,                               0,                    0, 0,               /* vk hex = 0xA */  },
    { 11,   0,                               0,                    0, 0,               /* vk hex = 0xB */  },
    { 12,   VK_CLEAR,                        K_NUMPAD_5, /* 'V' */ 0, K_NUMPAD_5,      /* vk hex = 0xC */  },
    { 13,   VK_RETURN,                       K_ENTER,            'E', K_NUMPAD_ENTER,  /* vk hex = 0xD */  },   // ENTER is not a unique keyboard key (numpad)
    { 14,   0,                               0,                    0, 0,               /* vk hex = 0xE */  },
    { 15,   0,                               0,                    0, 0,               /* vk hex = 0xF */  },
    { 16,   VK_SHIFT,                        0 /*K_SHIFT*/,      'R', 0,               /* vk hex = 0x10 */ },     // SHIFT is not a unique keyboard key.
    { 17,   VK_CONTROL,                      0 /*K_CTRL*/,       'R', 0,               /* vk hex = 0x11 */ },   // CTRL is not a unique keyboard key.
    { 18,   VK_MENU,                         0 /*K_ALT*/,        'R', 0,               /* vk hex = 0x12 */ },   // ALT is not a unique keyboard key.
    { 19,   VK_PAUSE,                        K_PAUSE,              0, 0,               /* vk hex = 0x13 */ },
    { 20,   VK_CAPITAL,                      K_CAPSLOCK,           0, 0,               /* vk hex = 0x14 */ },
    { 21,   VK_KANA,                         0,                    0, 0,               /* vk hex = 0x15 */ },
    { 22,   0,                               0,                    0, 0,               /* vk hex = 0x16 */ },
    { 23,   VK_JUNJA,                        0,                    0, 0,               /* vk hex = 0x17 */ },
    { 24,   VK_FINAL,                        0,                    0, 0,               /* vk hex = 0x18 */ },
    { 25,   VK_HANJA,                        0,                    0, 0,               /* vk hex = 0x19 */ },
    { 26,   0,                               0,                    0, 0,               /* vk hex = 0x1A */ },
    { 27,   VK_ESCAPE,                       K_ESCAPE,             0, 0,               /* vk hex = 0x1B */ },
    { 28,   VK_CONVERT,                      0,                    0, 0,               /* vk hex = 0x1C */ },
    { 29,   VK_NONCONVERT,                   0,                    0, 0,               /* vk hex = 0x1D */ },
    { 30,   VK_ACCEPT,                       0,                    0, 0,               /* vk hex = 0x1E */ },
    { 31,   VK_MODECHANGE,                   0,                    0, 0,               /* vk hex = 0x1F */ },
    { 32,   VK_SPACE,                        K_SPACE,              0, 0,               /* vk hex = 0x20 */ },
    { 33,   VK_PRIOR,                        K_PAGEUP,           'L', K_NUMPAD_9,      /* vk hex = 0x21 */ },
    { 34,   VK_NEXT,                         K_PAGEDOWN,         'L', K_NUMPAD_3,      /* vk hex = 0x22 */ },
    { 35,   VK_END,                          K_END,              'L', K_NUMPAD_1,      /* vk hex = 0x23 */ },
    { 36,   VK_HOME,                         K_HOME,             'L', K_NUMPAD_7,      /* vk hex = 0x24 */ },
    { 37,   VK_LEFT,                         K_LEFTARROW,        'L', K_NUMPAD_4,      /* vk hex = 0x25 */ },
    { 38,   VK_UP,                           K_UPARROW,          'L', K_NUMPAD_8,      /* vk hex = 0x26 */ },
    { 39,   VK_RIGHT,                        K_RIGHTARROW,       'L', K_NUMPAD_6,      /* vk hex = 0x27 */ },
    { 40,   VK_DOWN,                         K_DOWNARROW,        'L', K_NUMPAD_2,      /* vk hex = 0x28 */ },
    { 41,   VK_SELECT,                       0,                    0, 0,               /* vk hex = 0x29 */ },
    { 42,   VK_PRINT,                        0,                    0, 0,               /* vk hex = 0x2A */ },
    { 43,   VK_EXECUTE,                      0,                    0, 0,               /* vk hex = 0x2B */ },
    { 44,   VK_SNAPSHOT,                     K_PRINTSCREEN,        0, 0,               /* vk hex = 0x2C */ },
    { 45,   VK_INSERT,                       K_INSERT,           'L', K_NUMPAD_0,      /* vk hex = 0x2D */ },
    { 46,   VK_DELETE,                       K_DELETE,           'L', K_NUMPAD_PERIOD, /* vk hex = 0x2E */ },
    { 47,   VK_HELP,                         0,                    0, 0,               /* vk hex = 0x2F */ },
    { 48,   0/*VK_0*/,                       '0',                  0, 0,               /* vk hex = 0x30 */ },
    { 49,   0/*VK_1*/,                       '1',                  0, 0,               /* vk hex = 0x31 */ },
    { 50,   0/*VK_2*/,                       '2',                  0, 0,               /* vk hex = 0x32 */ },
    { 51,   0/*VK_3*/,                       '3',                  0, 0,               /* vk hex = 0x33 */ },
    { 52,   0/*VK_4*/,                       '4',                  0, 0,               /* vk hex = 0x34 */ },
    { 53,   0/*VK_5*/,                       '5',                  0, 0,               /* vk hex = 0x35 */ },
    { 54,   0/*VK_6*/,                       '6',                  0, 0,               /* vk hex = 0x36 */ },
    { 55,   0/*VK_7*/,                       '7',                  0, 0,               /* vk hex = 0x37 */ },
    { 56,   0/*VK_8*/,                       '8',                  0, 0,               /* vk hex = 0x38 */ },
    { 57,   0/*VK_9*/,                       '9',                  0, 0,               /* vk hex = 0x39 */ },
    { 58,   0,                               0,                    0, 0,               /* vk hex = 0x3A */ },
    { 59,   0,                               0,                    0, 0,               /* vk hex = 0x3B */ },
    { 60,   0,                               0,                    0, 0,               /* vk hex = 0x3C */ },
    { 61,   0,                               0,                    0, 0,               /* vk hex = 0x3D */ },
    { 62,   0,                               0,                    0, 0,               /* vk hex = 0x3E */ },
    { 63,   0,                               0,                    0, 0,               /* vk hex = 0x3F */ },
    { 64,   0,                               0,                    0, 0,               /* vk hex = 0x40 */ },
    { 65,   0/*VK_A*/,                       'A',                  0, 0,               /* vk hex = 0x41 */ },
    { 66,   0/*VK_B*/,                       'B',                  0, 0,               /* vk hex = 0x42 */ },
    { 67,   0/*VK_C*/,                       'C',                  0, 0,               /* vk hex = 0x43 */ },
    { 68,   0/*VK_D*/,                       'D',                  0, 0,               /* vk hex = 0x44 */ },
    { 69,   0/*VK_E*/,                       'E',                  0, 0,               /* vk hex = 0x45 */ },
    { 70,   0/*VK_F*/,                       'F',                  0, 0,               /* vk hex = 0x46 */ },
    { 71,   0/*VK_G*/,                       'G',                  0, 0,               /* vk hex = 0x47 */ },
    { 72,   0/*VK_H*/,                       'H',                  0, 0,               /* vk hex = 0x48 */ },
    { 73,   0/*VK_I*/,                       'I',                  0, 0,               /* vk hex = 0x49 */ },
    { 74,   0/*VK_J*/,                       'J',                  0, 0,               /* vk hex = 0x4A */ },
    { 75,   0/*VK_K*/,                       'K',                  0, 0,               /* vk hex = 0x4B */ },
    { 76,   0/*VK_L*/,                       'L',                  0, 0,               /* vk hex = 0x4C */ },
    { 77,   0/*VK_M*/,                       'M',                  0, 0,               /* vk hex = 0x4D */ },
    { 78,   0/*VK_N*/,                       'N',                  0, 0,               /* vk hex = 0x4E */ },
    { 79,   0/*VK_O*/,                       'O',                  0, 0,               /* vk hex = 0x4F */ },
    { 80,   0/*VK_P*/,                       'P',                  0, 0,               /* vk hex = 0x50 */ },
    { 81,   0/*VK_Q*/,                       'Q',                  0, 0,               /* vk hex = 0x51 */ },
    { 82,   0/*VK_R*/,                       'R',                  0, 0,               /* vk hex = 0x52 */ },
    { 83,   0/*VK_S*/,                       'S',                  0, 0,               /* vk hex = 0x53 */ },
    { 84,   0/*VK_T*/,                       'T',                  0, 0,               /* vk hex = 0x54 */ },
    { 85,   0/*VK_U*/,                       'U',                  0, 0,               /* vk hex = 0x55 */ },
    { 86,   0/*VK_V*/,                       'V',                  0, 0,               /* vk hex = 0x56 */ },
    { 87,   0/*VK_W*/,                       'W',                  0, 0,               /* vk hex = 0x57 */ },
    { 88,   0/*VK_X*/,                       'X',                  0, 0,               /* vk hex = 0x58 */ },
    { 89,   0/*VK_Y*/,                       'Y',                  0, 0,               /* vk hex = 0x59 */ },
    { 90,   0/*VK_Z*/,                       'Z',                  0, 0,               /* vk hex = 0x5A */ },
    { 91,   VK_LWIN,                         K_LWIN,               0, 0,               /* vk hex = 0x5B */ },
    { 92,   VK_RWIN,                         K_RWIN,               0, 0,               /* vk hex = 0x5C */ },
    { 93,   VK_APPS,                         K_MENU,               0, 0,               /* vk hex = 0x5D */ },
    { 94,   0,                               0,                    0, 0,               /* vk hex = 0x5E */ },
    { 95,   0,                               0,                    0, 0,               /* vk hex = 0x5F */ },
    { 96,   VK_NUMPAD0,                      K_NUMPAD_0,         'N', 0,               /* vk hex = 0x60 */ },
    { 97,   VK_NUMPAD1,                      K_NUMPAD_1,         'N', 0,               /* vk hex = 0x61 */ },
    { 98,   VK_NUMPAD2,                      K_NUMPAD_2,         'N', 0,               /* vk hex = 0x62 */ },
    { 99,   VK_NUMPAD3,                      K_NUMPAD_3,         'N', 0,               /* vk hex = 0x63 */ },
    { 100,  VK_NUMPAD4,                      K_NUMPAD_4,         'N', 0,               /* vk hex = 0x64 */ },
    { 101,  VK_NUMPAD5,                      K_NUMPAD_5,         'N', 0,               /* vk hex = 0x65 */ },
    { 102,  VK_NUMPAD6,                      K_NUMPAD_6,         'N', 0,               /* vk hex = 0x66 */ },
    { 103,  VK_NUMPAD7,                      K_NUMPAD_7,         'N', 0,               /* vk hex = 0x67 */ },
    { 104,  VK_NUMPAD8,                      K_NUMPAD_8,         'N', 0,               /* vk hex = 0x68 */ },
    { 105,  VK_NUMPAD9,                      K_NUMPAD_9,         'N', 0,               /* vk hex = 0x69 */ },
    { 106,  VK_MULTIPLY,                     K_NUMPAD_MULTIPLY,  'N', 0,               /* vk hex = 0x6A */ },
    { 107,  VK_ADD,                          K_NUMPAD_PLUS,      'N', 0,               /* vk hex = 0x6B */ },
    { 108,  VK_SEPARATOR,                    K_NUMPAD_SEPARATOR, 'N', 0,               /* vk hex = 0x6C */ },
    { 109,  VK_SUBTRACT,                     K_NUMPAD_MINUS,     'N', 0,               /* vk hex = 0x6D */ },
    { 110,  VK_DECIMAL,                      K_NUMPAD_PERIOD,    'N', 0,               /* vk hex = 0x6E */ },
    { 111,  VK_DIVIDE,                       K_NUMPAD_DIVIDE,    'N', 0,               /* vk hex = 0x6F */ },
    { 112,  VK_F1,                           K_F1,                 0, 0,               /* vk hex = 0x70 */ },
    { 113,  VK_F2,                           K_F2,                 0, 0,               /* vk hex = 0x71 */ },
    { 114,  VK_F3,                           K_F3,                 0, 0,               /* vk hex = 0x72 */ },
    { 115,  VK_F4,                           K_F4,                 0, 0,               /* vk hex = 0x73 */ },
    { 116,  VK_F5,                           K_F5,                 0, 0,               /* vk hex = 0x74 */ },
    { 117,  VK_F6,                           K_F6,                 0, 0,               /* vk hex = 0x75 */ },
    { 118,  VK_F7,                           K_F7,                 0, 0,               /* vk hex = 0x76 */ },
    { 119,  VK_F8,                           K_F8,                 0, 0,               /* vk hex = 0x77 */ },
    { 120,  VK_F9,                           K_F9,                 0, 0,               /* vk hex = 0x78 */ },
    { 121,  VK_F10,                          K_F10,                0, 0,               /* vk hex = 0x79 */ },
    { 122,  VK_F11,                          K_F11,                0, 0,               /* vk hex = 0x7A */ },
    { 123,  VK_F12,                          K_F12,                0, 0,               /* vk hex = 0x7B */ },
    { 124,  VK_F13,                          0,                    0, 0,               /* vk hex = 0x7C */ },
    { 125,  VK_F14,                          0,                    0, 0,               /* vk hex = 0x7D */ },
    { 126,  VK_F15,                          0,                    0, 0,               /* vk hex = 0x7E */ },
    { 127,  VK_F16,                          0,                    0, 0,               /* vk hex = 0x7F */ },
    { 128,  VK_F17,                          0,                    0, 0,               /* vk hex = 0x80 */ },
    { 129,  VK_F18,                          0,                    0, 0,               /* vk hex = 0x81 */ },
    { 130,  VK_F19,                          0,                    0, 0,               /* vk hex = 0x82 */ },
    { 131,  VK_F20,                          0,                    0, 0,               /* vk hex = 0x83 */ },
    { 132,  VK_F21,                          0,                    0, 0,               /* vk hex = 0x84 */ },
    { 133,  VK_F22,                          0,                    0, 0,               /* vk hex = 0x85 */ },
    { 134,  VK_F23,                          0,                    0, 0,               /* vk hex = 0x86 */ },
    { 135,  VK_F24,                          0,                    0, 0,               /* vk hex = 0x87 */ },
    { 136,  0,                               0,                    0, 0,               /* vk hex = 0x88 */ },
    { 137,  0,                               0,                    0, 0,               /* vk hex = 0x89 */ },
    { 138,  0,                               0,                    0, 0,               /* vk hex = 0x8A */ },
    { 139,  0,                               0,                    0, 0,               /* vk hex = 0x8B */ },
    { 140,  0,                               0,                    0, 0,               /* vk hex = 0x8C */ },
    { 141,  0,                               0,                    0, 0,               /* vk hex = 0x8D */ },
    { 142,  0,                               0,                    0, 0,               /* vk hex = 0x8E */ },
    { 143,  0,                               0,                    0, 0,               /* vk hex = 0x8F */ },
    { 144,  VK_NUMLOCK,                      K_NUMLOCK,            0, 0,               /* vk hex = 0x90 */ },
    { 145,  VK_SCROLL,                       K_SCROLLLOCK,         0, 0,               /* vk hex = 0x91 */ },
    { 146,  0,                               0,                    0, 0,               /* vk hex = 0x92 */ },
    { 147,  0,                               0,                    0, 0,               /* vk hex = 0x93 */ },
    { 148,  0,                               0,                    0, 0,               /* vk hex = 0x94 */ },
    { 149,  0,                               0,                    0, 0,               /* vk hex = 0x95 */ },
    { 150,  0,                               0,                    0, 0,               /* vk hex = 0x96 */ },
    { 151,  0,                               0,                    0, 0,               /* vk hex = 0x97 */ },
    { 152,  0,                               0,                    0, 0,               /* vk hex = 0x98 */ },
    { 153,  0,                               0,                    0, 0,               /* vk hex = 0x99 */ },
    { 154,  0,                               0,                    0, 0,               /* vk hex = 0x9A */ },
    { 155,  0,                               0,                    0, 0,               /* vk hex = 0x9B */ },
    { 156,  0,                               0,                    0, 0,               /* vk hex = 0x9C */ },
    { 157,  0,                               0,                    0, 0,               /* vk hex = 0x9D */ },
    { 158,  0,                               0,                    0, 0,               /* vk hex = 0x9E */ },
    { 159,  0,                               0,                    0, 0,               /* vk hex = 0x9F */ },
    { 160,  VK_LSHIFT,                       K_LSHIFT,             0, 0,               /* vk hex = 0xA0 */ },
    { 161,  VK_RSHIFT,                       K_RSHIFT,             0, 0,               /* vk hex = 0xA1 */ },
    { 162,  VK_LCONTROL,                     K_LCTRL,              0, 0,               /* vk hex = 0xA2 */ },
    { 163,  VK_RCONTROL,                     K_RCTRL,              0, 0,               /* vk hex = 0xA3 */ },
    { 164,  VK_LMENU,                        K_LALT,               0, 0,               /* vk hex = 0xA4 */ },
    { 165,  VK_RMENU,                        K_RALT,               0, 0,               /* vk hex = 0xA5 */ },
    { 166,  VK_BROWSER_BACK,                 0,                    0, 0,               /* vk hex = 0xA6 */ },
    { 167,  VK_BROWSER_FORWARD,              0,                    0, 0,               /* vk hex = 0xA7 */ },
    { 168,  VK_BROWSER_REFRESH,              0,                    0, 0,               /* vk hex = 0xA8 */ },
    { 169,  VK_BROWSER_STOP,                 0,                    0, 0,               /* vk hex = 0xA9 */ },
    { 170,  VK_BROWSER_SEARCH,               0,                    0, 0,               /* vk hex = 0xAA */ },
    { 171,  VK_BROWSER_FAVORITES,            0,                    0, 0,               /* vk hex = 0xAB */ },
    { 172,  VK_BROWSER_HOME,                 0,                    0, 0,               /* vk hex = 0xAC */ },
    { 173,  VK_VOLUME_MUTE,                  0,                    0, 0,               /* vk hex = 0xAD */ },
    { 174,  VK_VOLUME_DOWN,                  0,                    0, 0,               /* vk hex = 0xAE */ },
    { 175,  VK_VOLUME_UP,                    0,                    0, 0,               /* vk hex = 0xAF */ },
    { 176,  VK_MEDIA_NEXT_TRACK,             0,                    0, 0,               /* vk hex = 0xB0 */ },
    { 177,  VK_MEDIA_PREV_TRACK,             0,                    0, 0,               /* vk hex = 0xB1 */ },
    { 178,  VK_MEDIA_STOP,                   0,                    0, 0,               /* vk hex = 0xB2 */ },
    { 179,  VK_MEDIA_PLAY_PAUSE,             0,                    0, 0,               /* vk hex = 0xB3 */ },
    { 180,  VK_LAUNCH_MAIL,                  0,                    0, 0,               /* vk hex = 0xB4 */ },
    { 181,  VK_LAUNCH_MEDIA_SELECT,          0,                    0, 0,               /* vk hex = 0xB5 */ },
    { 182,  VK_LAUNCH_APP1,                  0,                    0, 0,               /* vk hex = 0xB6 */ },
    { 183,  VK_LAUNCH_APP2,                  0,                    0, 0,               /* vk hex = 0xB7 */ },
    { 184,  0,                               0,                    0, 0,               /* vk hex = 0xB8 */ },
    { 185,  0,                               0,                    0, 0,               /* vk hex = 0xB9 */ },
    { 186,  VK_OEM_1,                        K_SEMICOLON,          0, 0,               /* vk hex = 0xBA */ },
    { 187,  VK_OEM_PLUS,                     K_EQUALS,             0, 0,               /* vk hex = 0xBB */ },
    { 188,  VK_OEM_COMMA,                    K_COMMA,              0, 0,               /* vk hex = 0xBC */ },
    { 189,  VK_OEM_MINUS,                    K_MINUS,              0, 0,               /* vk hex = 0xBD */ },
    { 190,  VK_OEM_PERIOD,                   K_PERIOD,             0, 0,               /* vk hex = 0xBE */ },
    { 191,  VK_OEM_2,                        K_SLASH,              0, 0,               /* vk hex = 0xBF */ },
    { 192,  VK_OEM_3,                        K_GRAVE,              0, 0,               /* vk hex = 0xC0 */ },
    { 193,  0,                               0,                    0, 0,               /* vk hex = 0xC1 */ },
    { 194,  0,                               0,                    0, 0,               /* vk hex = 0xC2 */ },
    { 195,  0,                               0,                    0, 0,               /* vk hex = 0xC3 */ },
    { 196,  0,                               0,                    0, 0,               /* vk hex = 0xC4 */ },
    { 197,  0,                               0,                    0, 0,               /* vk hex = 0xC5 */ },
    { 198,  0,                               0,                    0, 0,               /* vk hex = 0xC6 */ },
    { 199,  0,                               0,                    0, 0,               /* vk hex = 0xC7 */ },
    { 200,  0,                               0,                    0, 0,               /* vk hex = 0xC8 */ },
    { 201,  0,                               0,                    0, 0,               /* vk hex = 0xC9 */ },
    { 202,  0,                               0,                    0, 0,               /* vk hex = 0xCA */ },
    { 203,  0,                               0,                    0, 0,               /* vk hex = 0xCB */ },
    { 204,  0,                               0,                    0, 0,               /* vk hex = 0xCC */ },
    { 205,  0,                               0,                    0, 0,               /* vk hex = 0xCD */ },
    { 206,  0,                               0,                    0, 0,               /* vk hex = 0xCE */ },
    { 207,  0,                               0,                    0, 0,               /* vk hex = 0xCF */ },
    { 208,  0,                               0,                    0, 0,               /* vk hex = 0xD0 */ },
    { 209,  0,                               0,                    0, 0,               /* vk hex = 0xD1 */ },
    { 210,  0,                               0,                    0, 0,               /* vk hex = 0xD2 */ },
    { 211,  0,                               0,                    0, 0,               /* vk hex = 0xD3 */ },
    { 212,  0,                               0,                    0, 0,               /* vk hex = 0xD4 */ },
    { 213,  0,                               0,                    0, 0,               /* vk hex = 0xD5 */ },
    { 214,  0,                               0,                    0, 0,               /* vk hex = 0xD6 */ },
    { 215,  0,                               0,                    0, 0,               /* vk hex = 0xD7 */ },
    { 216,  0,                               0,                    0, 0,               /* vk hex = 0xD8 */ },
    { 217,  0,                               0,                    0, 0,               /* vk hex = 0xD9 */ },
    { 218,  0,                               0,                    0, 0,               /* vk hex = 0xDA */ },
    { 219,  VK_OEM_4,                        K_LEFTBRACKET,        0, 0,               /* vk hex = 0xDB */ },
    { 220,  VK_OEM_5,                        K_BACKSLASH,          0, 0,               /* vk hex = 0xDC */ },
    { 221,  VK_OEM_6,                        K_RIGHTBRACKET,       0, 0,               /* vk hex = 0xDD */ },
    { 222,  VK_OEM_7,                        K_APOSTROPHE,         0, 0,               /* vk hex = 0xDE */ },
    { 223,  VK_OEM_8,                        0,                    0, 0,               /* vk hex = 0xDF */ },
    { 224,  0,                               0,                    0, 0,               /* vk hex = 0xE0 */ },
    { 225,  0,                               0,                    0, 0,               /* vk hex = 0xE1 */ },
    { 226,  VK_OEM_102,                      0,                    0, 0,               /* vk hex = 0xE2 */ },
    { 227,  0,                               0,                    0, 0,               /* vk hex = 0xE3 */ },
    { 228,  0,                               0,                    0, 0,               /* vk hex = 0xE4 */ },
    { 229,  VK_PROCESSKEY,                   0,                    0, 0,               /* vk hex = 0xE5 */ },
    { 230,  0,                               0,                    0, 0,               /* vk hex = 0xE6 */ },
    { 231,  VK_PACKET,                       0,                    0, 0,               /* vk hex = 0xE7 */ },
    { 232,  0,                               0,                    0, 0,               /* vk hex = 0xE8 */ },
    { 233,  0,                               0,                    0, 0,               /* vk hex = 0xE9 */ },
    { 234,  0,                               0,                    0, 0,               /* vk hex = 0xEA */ },
    { 235,  0,                               0,                    0, 0,               /* vk hex = 0xEB */ },
    { 236,  0,                               0,                    0, 0,               /* vk hex = 0xEC */ },
    { 237,  0,                               0,                    0, 0,               /* vk hex = 0xED */ },
    { 238,  0,                               0,                    0, 0,               /* vk hex = 0xEE */ },
    { 239,  0,                               0,                    0, 0,               /* vk hex = 0xEF */ },
    { 240,  0,                               0,                    0, 0,               /* vk hex = 0xF0 */ },
    { 241,  0,                               0,                    0, 0,               /* vk hex = 0xF1 */ },
    { 242,  0,                               0,                    0, 0,               /* vk hex = 0xF2 */ },
    { 243,  0,                               0,                    0, 0,               /* vk hex = 0xF3 */ },
    { 244,  0,                               0,                    0, 0,               /* vk hex = 0xF4 */ },
    { 245,  0,                               0,                    0, 0,               /* vk hex = 0xF5 */ },
    { 246,  VK_ATTN,                         0,                    0, 0,               /* vk hex = 0xF6 */ },
    { 247,  VK_CRSEL,                        0,                    0, 0,               /* vk hex = 0xF7 */ },
    { 248,  VK_EXSEL,                        0,                    0, 0,               /* vk hex = 0xF8 */ },
    { 249,  VK_EREOF,                        0,                    0, 0,               /* vk hex = 0xF9 */ },
    { 250,  VK_PLAY,                         0,                    0, 0,               /* vk hex = 0xFA */ },
    { 251,  VK_ZOOM,                         0,                    0, 0,               /* vk hex = 0xFB */ },
    { 252,  VK_NONAME,                       0,                    0, 0,               /* vk hex = 0xFC */ },
    { 253,  VK_PA1,                          0,                    0, 0,               /* vk hex = 0xFD */ },
    { 254,  VK_OEM_CLEAR,                    0,                    0, 0,               /* vk hex = 0xFE */ },
};

