
#ifndef __DX8_MH_WRAPPER_H
#define __DX8_MH_WRAPPER_H


void APIENTRY d3dmh_glAccum (GLenum op, GLfloat value);
void APIENTRY d3dmh_glAlphaFunc (GLenum func, GLclampf ref);
GLboolean APIENTRY d3dmh_glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences);
void APIENTRY d3dmh_glArrayElement (GLint i);
void APIENTRY d3dmh_glBegin (GLenum mode);
void APIENTRY d3dmh_glBindTexture (GLenum target, GLuint texture);
void APIENTRY d3dmh_glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
void APIENTRY d3dmh_glBlendFunc (GLenum sfactor, GLenum dfactor);
void APIENTRY d3dmh_glCallList (GLuint list);
void APIENTRY d3dmh_glCallLists (GLsizei n, GLenum type, const GLvoid *lists);
void APIENTRY d3dmh_glClear (GLbitfield mask);
void APIENTRY d3dmh_glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void APIENTRY d3dmh_glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void APIENTRY d3dmh_glClearDepth (GLclampd depth);
void APIENTRY d3dmh_glClearIndex (GLfloat c);
void APIENTRY d3dmh_glClearStencil (GLint s);
void APIENTRY d3dmh_glClipPlane (GLenum plane, const GLdouble *equation);
void APIENTRY d3dmh_glColor3b (GLbyte red, GLbyte green, GLbyte blue);
void APIENTRY d3dmh_glColor3bv (const GLbyte *v);
void APIENTRY d3dmh_glColor3d (GLdouble red, GLdouble green, GLdouble blue);
void APIENTRY d3dmh_glColor3dv (const GLdouble *v);
void APIENTRY d3dmh_glColor3f (GLfloat red, GLfloat green, GLfloat blue);
void APIENTRY d3dmh_glColor3fv (const GLfloat *v);
void APIENTRY d3dmh_glColor3i (GLint red, GLint green, GLint blue);
void APIENTRY d3dmh_glColor3iv (const GLint *v);
void APIENTRY d3dmh_glColor3s (GLshort red, GLshort green, GLshort blue);
void APIENTRY d3dmh_glColor3sv (const GLshort *v);
void APIENTRY d3dmh_glColor3ub (GLubyte red, GLubyte green, GLubyte blue);
void APIENTRY d3dmh_glColor3ubv (const GLubyte *v);
void APIENTRY d3dmh_glColor3ui (GLuint red, GLuint green, GLuint blue);
void APIENTRY d3dmh_glColor3uiv (const GLuint *v);
void APIENTRY d3dmh_glColor3us (GLushort red, GLushort green, GLushort blue);
void APIENTRY d3dmh_glColor3usv (const GLushort *v);
void APIENTRY d3dmh_glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
void APIENTRY d3dmh_glColor4bv (const GLbyte *v);
void APIENTRY d3dmh_glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
void APIENTRY d3dmh_glColor4dv (const GLdouble *v);
void APIENTRY d3dmh_glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void APIENTRY d3dmh_glColor4fv (const GLfloat *v);
void APIENTRY d3dmh_glColor4i (GLint red, GLint green, GLint blue, GLint alpha);
void APIENTRY d3dmh_glColor4iv (const GLint *v);
void APIENTRY d3dmh_glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha);
void APIENTRY d3dmh_glColor4sv (const GLshort *v);
void APIENTRY d3dmh_glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void APIENTRY d3dmh_glColor4ubv (const GLubyte *v);
void APIENTRY d3dmh_glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha);
void APIENTRY d3dmh_glColor4uiv (const GLuint *v);
void APIENTRY d3dmh_glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha);
void APIENTRY d3dmh_glColor4usv (const GLushort *v);
void APIENTRY d3dmh_glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void APIENTRY d3dmh_glColorMaterial (GLenum face, GLenum mode);
void APIENTRY d3dmh_glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
void APIENTRY d3dmh_glCopyTexImage1D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
void APIENTRY d3dmh_glCopyTexImage2D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void APIENTRY d3dmh_glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void APIENTRY d3dmh_glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void APIENTRY d3dmh_glCullFace (GLenum mode);
void APIENTRY d3dmh_glDeleteLists (GLuint list, GLsizei range);
void APIENTRY d3dmh_glDeleteTextures (GLsizei n, const GLuint *textures);
void APIENTRY d3dmh_glDepthFunc (GLenum func);
void APIENTRY d3dmh_glDepthMask (GLboolean flag);
void APIENTRY d3dmh_glDepthRange (GLclampd zNear, GLclampd zFar);
void APIENTRY d3dmh_glDisable (GLenum cap);
void APIENTRY d3dmh_glDisableClientState (GLenum array);
void APIENTRY d3dmh_glDrawArrays (GLenum mode, GLint first, GLsizei count);
void APIENTRY d3dmh_glDrawBuffer (GLenum mode);
void APIENTRY d3dmh_glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
void APIENTRY d3dmh_glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void APIENTRY d3dmh_glEdgeFlag (GLboolean flag);
void APIENTRY d3dmh_glEdgeFlagPointer (GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glEdgeFlagv (const GLboolean *flag);
void APIENTRY d3dmh_glEnable (GLenum cap);
void APIENTRY d3dmh_glEnableClientState (GLenum array);
void APIENTRY d3dmh_glEnd (void);
void APIENTRY d3dmh_glEndList (void);
void APIENTRY d3dmh_glEvalCoord1d (GLdouble u);
void APIENTRY d3dmh_glEvalCoord1dv (const GLdouble *u);
void APIENTRY d3dmh_glEvalCoord1f (GLfloat u);
void APIENTRY d3dmh_glEvalCoord1fv (const GLfloat *u);
void APIENTRY d3dmh_glEvalCoord2d (GLdouble u, GLdouble v);
void APIENTRY d3dmh_glEvalCoord2dv (const GLdouble *u);
void APIENTRY d3dmh_glEvalCoord2f (GLfloat u, GLfloat v);
void APIENTRY d3dmh_glEvalCoord2fv (const GLfloat *u);
void APIENTRY d3dmh_glEvalMesh1 (GLenum mode, GLint i1, GLint i2);
void APIENTRY d3dmh_glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void APIENTRY d3dmh_glEvalPoint1 (GLint i);
void APIENTRY d3dmh_glEvalPoint2 (GLint i, GLint j);
void APIENTRY d3dmh_glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer);
void APIENTRY d3dmh_glFinish (void);
void APIENTRY d3dmh_glFlush (void);
void APIENTRY d3dmh_glFogf (GLenum pname, GLfloat param);
void APIENTRY d3dmh_glFogfv (GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glFogi (GLenum pname, GLint param);
void APIENTRY d3dmh_glFogiv (GLenum pname, const GLint *params);
void APIENTRY d3dmh_glFrontFace (GLenum mode);
void APIENTRY d3dmh_glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLuint APIENTRY d3dmh_glGenLists (GLsizei range);
void APIENTRY d3dmh_glGenTextures (GLsizei n, GLuint *textures);
void APIENTRY d3dmh_glGetBooleanv (GLenum pname, GLboolean *params);
void APIENTRY d3dmh_glGetClipPlane (GLenum plane, GLdouble *equation);
void APIENTRY d3dmh_glGetDoublev (GLenum pname, GLdouble *params);
GLenum APIENTRY d3dmh_glGetError (void);
void APIENTRY d3dmh_glGetFloatv (GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetIntegerv (GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetLightfv (GLenum light, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetLightiv (GLenum light, GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetMapdv (GLenum target, GLenum query, GLdouble *v);
void APIENTRY d3dmh_glGetMapfv (GLenum target, GLenum query, GLfloat *v);
void APIENTRY d3dmh_glGetMapiv (GLenum target, GLenum query, GLint *v);
void APIENTRY d3dmh_glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetMaterialiv (GLenum face, GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetPixelMapfv (GLenum map, GLfloat *values);
void APIENTRY d3dmh_glGetPixelMapuiv (GLenum map, GLuint *values);
void APIENTRY d3dmh_glGetPixelMapusv (GLenum map, GLushort *values);
void APIENTRY d3dmh_glGetPointerv (GLenum pname, GLvoid **params);
void APIENTRY d3dmh_glGetPolygonStipple (GLubyte *mask);
//const GLubyte *d3dmh_glGetString (GLenum name);
const GLubyte *APIENTRY d3dmh_glGetString (GLenum name);
// DarkPlaces: const GLubyte *(GLAPIENTRY *qglGetString)(GLenum name);
void APIENTRY d3dmh_glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetTexEnviv (GLenum target, GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
void APIENTRY d3dmh_glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetTexGeniv (GLenum coord, GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void APIENTRY d3dmh_glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
void APIENTRY d3dmh_glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
void APIENTRY d3dmh_glGetTexParameteriv (GLenum target, GLenum pname, GLint *params);
void APIENTRY d3dmh_glHint (GLenum target, GLenum mode);
void APIENTRY d3dmh_glIndexMask (GLuint mask);
void APIENTRY d3dmh_glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glIndexd (GLdouble c);
void APIENTRY d3dmh_glIndexdv (const GLdouble *c);
void APIENTRY d3dmh_glIndexf (GLfloat c);
void APIENTRY d3dmh_glIndexfv (const GLfloat *c);
void APIENTRY d3dmh_glIndexi (GLint c);
void APIENTRY d3dmh_glIndexiv (const GLint *c);
void APIENTRY d3dmh_glIndexs (GLshort c);
void APIENTRY d3dmh_glIndexsv (const GLshort *c);
void APIENTRY d3dmh_glIndexub (GLubyte c);
void APIENTRY d3dmh_glIndexubv (const GLubyte *c);
void APIENTRY d3dmh_glInitNames (void);
void APIENTRY d3dmh_glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
GLboolean APIENTRY d3dmh_glIsEnabled (GLenum cap);
GLboolean APIENTRY d3dmh_glIsList (GLuint list);
GLboolean APIENTRY d3dmh_glIsTexture (GLuint texture);
void APIENTRY d3dmh_glLightModelf (GLenum pname, GLfloat param);
void APIENTRY d3dmh_glLightModelfv (GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glLightModeli (GLenum pname, GLint param);
void APIENTRY d3dmh_glLightModeliv (GLenum pname, const GLint *params);
void APIENTRY d3dmh_glLightf (GLenum light, GLenum pname, GLfloat param);
void APIENTRY d3dmh_glLightfv (GLenum light, GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glLighti (GLenum light, GLenum pname, GLint param);
void APIENTRY d3dmh_glLightiv (GLenum light, GLenum pname, const GLint *params);
void APIENTRY d3dmh_glLineStipple (GLint factor, GLushort pattern);
void APIENTRY d3dmh_glLineWidth (GLfloat width);
void APIENTRY d3dmh_glListBase (GLuint base);
void APIENTRY d3dmh_glLoadIdentity (void);
void APIENTRY d3dmh_glLoadMatrixd (const GLdouble *m);
void APIENTRY d3dmh_glLoadMatrixf (const GLfloat *m);
void APIENTRY d3dmh_glLoadName (GLuint name);
void APIENTRY d3dmh_glLogicOp (GLenum opcode);
void APIENTRY d3dmh_glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
void APIENTRY d3dmh_glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
void APIENTRY d3dmh_glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
void APIENTRY d3dmh_glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
void APIENTRY d3dmh_glMapGrid1d (GLint un, GLdouble u1, GLdouble u2);
void APIENTRY d3dmh_glMapGrid1f (GLint un, GLfloat u1, GLfloat u2);
void APIENTRY d3dmh_glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
void APIENTRY d3dmh_glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
void APIENTRY d3dmh_glMaterialf (GLenum face, GLenum pname, GLfloat param);
void APIENTRY d3dmh_glMaterialfv (GLenum face, GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glMateriali (GLenum face, GLenum pname, GLint param);
void APIENTRY d3dmh_glMaterialiv (GLenum face, GLenum pname, const GLint *params);
void APIENTRY d3dmh_glMatrixMode (GLenum mode);
void APIENTRY d3dmh_glMultMatrixd (const GLdouble *m);
void APIENTRY d3dmh_glMultMatrixf (const GLfloat *m);
void APIENTRY d3dmh_glNewList (GLuint list, GLenum mode);
void APIENTRY d3dmh_glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz);
void APIENTRY d3dmh_glNormal3bv (const GLbyte *v);
void APIENTRY d3dmh_glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz);
void APIENTRY d3dmh_glNormal3dv (const GLdouble *v);
void APIENTRY d3dmh_glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz);
void APIENTRY d3dmh_glNormal3fv (const GLfloat *v);
void APIENTRY d3dmh_glNormal3i (GLint nx, GLint ny, GLint nz);
void APIENTRY d3dmh_glNormal3iv (const GLint *v);
void APIENTRY d3dmh_glNormal3s (GLshort nx, GLshort ny, GLshort nz);
void APIENTRY d3dmh_glNormal3sv (const GLshort *v);
void APIENTRY d3dmh_glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void APIENTRY d3dmh_glPassThrough (GLfloat token);
void APIENTRY d3dmh_glPixelMapfv (GLenum map, GLsizei mapsize, const GLfloat *values);
void APIENTRY d3dmh_glPixelMapuiv (GLenum map, GLsizei mapsize, const GLuint *values);
void APIENTRY d3dmh_glPixelMapusv (GLenum map, GLsizei mapsize, const GLushort *values);
void APIENTRY d3dmh_glPixelStoref (GLenum pname, GLfloat param);
void APIENTRY d3dmh_glPixelStorei (GLenum pname, GLint param);
void APIENTRY d3dmh_glPixelTransferf (GLenum pname, GLfloat param);
void APIENTRY d3dmh_glPixelTransferi (GLenum pname, GLint param);
void APIENTRY d3dmh_glPixelZoom (GLfloat xfactor, GLfloat yfactor);
void APIENTRY d3dmh_glPointSize (GLfloat size);
void APIENTRY d3dmh_glPolygonMode (GLenum face, GLenum mode);
void APIENTRY d3dmh_glPolygonOffset (GLfloat factor, GLfloat units);
void APIENTRY d3dmh_glPolygonStipple (const GLubyte *mask);
void APIENTRY d3dmh_glPopAttrib (void);
void APIENTRY d3dmh_glPopClientAttrib (void);
void APIENTRY d3dmh_glPopMatrix (void);
void APIENTRY d3dmh_glPopName (void);
void APIENTRY d3dmh_glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities);
void APIENTRY d3dmh_glPushAttrib (GLbitfield mask);
void APIENTRY d3dmh_glPushClientAttrib (GLbitfield mask);
void APIENTRY d3dmh_glPushMatrix (void);
void APIENTRY d3dmh_glPushName (GLuint name);
void APIENTRY d3dmh_glRasterPos2d (GLdouble x, GLdouble y);
void APIENTRY d3dmh_glRasterPos2dv (const GLdouble *v);
void APIENTRY d3dmh_glRasterPos2f (GLfloat x, GLfloat y);
void APIENTRY d3dmh_glRasterPos2fv (const GLfloat *v);
void APIENTRY d3dmh_glRasterPos2i (GLint x, GLint y);
void APIENTRY d3dmh_glRasterPos2iv (const GLint *v);
void APIENTRY d3dmh_glRasterPos2s (GLshort x, GLshort y);
void APIENTRY d3dmh_glRasterPos2sv (const GLshort *v);
void APIENTRY d3dmh_glRasterPos3d (GLdouble x, GLdouble y, GLdouble z);
void APIENTRY d3dmh_glRasterPos3dv (const GLdouble *v);
void APIENTRY d3dmh_glRasterPos3f (GLfloat x, GLfloat y, GLfloat z);
void APIENTRY d3dmh_glRasterPos3fv (const GLfloat *v);
void APIENTRY d3dmh_glRasterPos3i (GLint x, GLint y, GLint z);
void APIENTRY d3dmh_glRasterPos3iv (const GLint *v);
void APIENTRY d3dmh_glRasterPos3s (GLshort x, GLshort y, GLshort z);
void APIENTRY d3dmh_glRasterPos3sv (const GLshort *v);
void APIENTRY d3dmh_glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void APIENTRY d3dmh_glRasterPos4dv (const GLdouble *v);
void APIENTRY d3dmh_glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void APIENTRY d3dmh_glRasterPos4fv (const GLfloat *v);
void APIENTRY d3dmh_glRasterPos4i (GLint x, GLint y, GLint z, GLint w);
void APIENTRY d3dmh_glRasterPos4iv (const GLint *v);
void APIENTRY d3dmh_glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
void APIENTRY d3dmh_glRasterPos4sv (const GLshort *v);
void APIENTRY d3dmh_glReadBuffer (GLenum mode);
void APIENTRY d3dmh_glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void APIENTRY d3dmh_glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void APIENTRY d3dmh_glRectdv (const GLdouble *v1, const GLdouble *v2);
void APIENTRY d3dmh_glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void APIENTRY d3dmh_glRectfv (const GLfloat *v1, const GLfloat *v2);
void APIENTRY d3dmh_glRecti (GLint x1, GLint y1, GLint x2, GLint y2);
void APIENTRY d3dmh_glRectiv (const GLint *v1, const GLint *v2);
void APIENTRY d3dmh_glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void APIENTRY d3dmh_glRectsv (const GLshort *v1, const GLshort *v2);
GLint APIENTRY d3dmh_glRenderMode (GLenum mode);
void APIENTRY d3dmh_glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void APIENTRY d3dmh_glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void APIENTRY d3dmh_glScaled (GLdouble x, GLdouble y, GLdouble z);
void APIENTRY d3dmh_glScalef (GLfloat x, GLfloat y, GLfloat z);
void APIENTRY d3dmh_glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
void APIENTRY d3dmh_glSelectBuffer (GLsizei size, GLuint *buffer);
void APIENTRY d3dmh_glShadeModel (GLenum mode);
void APIENTRY d3dmh_glStencilFunc (GLenum func, GLint ref, GLuint mask);
void APIENTRY d3dmh_glStencilMask (GLuint mask);
void APIENTRY d3dmh_glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
void APIENTRY d3dmh_glTexCoord1d (GLdouble s);
void APIENTRY d3dmh_glTexCoord1dv (const GLdouble *v);
void APIENTRY d3dmh_glTexCoord1f (GLfloat s);
void APIENTRY d3dmh_glTexCoord1fv (const GLfloat *v);
void APIENTRY d3dmh_glTexCoord1i (GLint s);
void APIENTRY d3dmh_glTexCoord1iv (const GLint *v);
void APIENTRY d3dmh_glTexCoord1s (GLshort s);
void APIENTRY d3dmh_glTexCoord1sv (const GLshort *v);
void APIENTRY d3dmh_glTexCoord2d (GLdouble s, GLdouble t);
void APIENTRY d3dmh_glTexCoord2dv (const GLdouble *v);
void APIENTRY d3dmh_glTexCoord2f (GLfloat s, GLfloat t);
void APIENTRY d3dmh_glTexCoord2fv (const GLfloat *v);
void APIENTRY d3dmh_glTexCoord2i (GLint s, GLint t);
void APIENTRY d3dmh_glTexCoord2iv (const GLint *v);
void APIENTRY d3dmh_glTexCoord2s (GLshort s, GLshort t);
void APIENTRY d3dmh_glTexCoord2sv (const GLshort *v);
void APIENTRY d3dmh_glTexCoord3d (GLdouble s, GLdouble t, GLdouble r);
void APIENTRY d3dmh_glTexCoord3dv (const GLdouble *v);
void APIENTRY d3dmh_glTexCoord3f (GLfloat s, GLfloat t, GLfloat r);
void APIENTRY d3dmh_glTexCoord3fv (const GLfloat *v);
void APIENTRY d3dmh_glTexCoord3i (GLint s, GLint t, GLint r);
void APIENTRY d3dmh_glTexCoord3iv (const GLint *v);
void APIENTRY d3dmh_glTexCoord3s (GLshort s, GLshort t, GLshort r);
void APIENTRY d3dmh_glTexCoord3sv (const GLshort *v);
void APIENTRY d3dmh_glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void APIENTRY d3dmh_glTexCoord4dv (const GLdouble *v);
void APIENTRY d3dmh_glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void APIENTRY d3dmh_glTexCoord4fv (const GLfloat *v);
void APIENTRY d3dmh_glTexCoord4i (GLint s, GLint t, GLint r, GLint q);
void APIENTRY d3dmh_glTexCoord4iv (const GLint *v);
void APIENTRY d3dmh_glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q);
void APIENTRY d3dmh_glTexCoord4sv (const GLshort *v);
void APIENTRY d3dmh_glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glTexEnvf (GLenum target, GLenum pname, GLfloat param);
void APIENTRY d3dmh_glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glTexEnvi (GLenum target, GLenum pname, GLint param);
void APIENTRY d3dmh_glTexEnviv (GLenum target, GLenum pname, const GLint *params);
void APIENTRY d3dmh_glTexGend (GLenum coord, GLenum pname, GLdouble param);
void APIENTRY d3dmh_glTexGendv (GLenum coord, GLenum pname, const GLdouble *params);
void APIENTRY d3dmh_glTexGenf (GLenum coord, GLenum pname, GLfloat param);
void APIENTRY d3dmh_glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glTexGeni (GLenum coord, GLenum pname, GLint param);
void APIENTRY d3dmh_glTexGeniv (GLenum coord, GLenum pname, const GLint *params);
void APIENTRY d3dmh_glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void APIENTRY d3dmh_glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void APIENTRY d3dmh_glTexParameterf (GLenum target, GLenum pname, GLfloat param);
void APIENTRY d3dmh_glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
void APIENTRY d3dmh_glTexParameteri (GLenum target, GLenum pname, GLint param);
void APIENTRY d3dmh_glTexParameteriv (GLenum target, GLenum pname, const GLint *params);
void APIENTRY d3dmh_glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void APIENTRY d3dmh_glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void APIENTRY d3dmh_glTranslated (GLdouble x, GLdouble y, GLdouble z);
void APIENTRY d3dmh_glTranslatef (GLfloat x, GLfloat y, GLfloat z);
void APIENTRY d3dmh_glVertex2d (GLdouble x, GLdouble y);
void APIENTRY d3dmh_glVertex2dv (const GLdouble *v);
void APIENTRY d3dmh_glVertex2f (GLfloat x, GLfloat y);
void APIENTRY d3dmh_glVertex2fv (const GLfloat *v);
void APIENTRY d3dmh_glVertex2i (GLint x, GLint y);
void APIENTRY d3dmh_glVertex2iv (const GLint *v);
void APIENTRY d3dmh_glVertex2s (GLshort x, GLshort y);
void APIENTRY d3dmh_glVertex2sv (const GLshort *v);
void APIENTRY d3dmh_glVertex3d (GLdouble x, GLdouble y, GLdouble z);
void APIENTRY d3dmh_glVertex3dv (const GLdouble *v);
void APIENTRY d3dmh_glVertex3f (GLfloat x, GLfloat y, GLfloat z);
void APIENTRY d3dmh_glVertex3fv (const GLfloat *v);
void APIENTRY d3dmh_glVertex3i (GLint x, GLint y, GLint z);
void APIENTRY d3dmh_glVertex3iv (const GLint *v);
void APIENTRY d3dmh_glVertex3s (GLshort x, GLshort y, GLshort z);
void APIENTRY d3dmh_glVertex3sv (const GLshort *v);
void APIENTRY d3dmh_glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void APIENTRY d3dmh_glVertex4dv (const GLdouble *v);
void APIENTRY d3dmh_glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void APIENTRY d3dmh_glVertex4fv (const GLfloat *v);
void APIENTRY d3dmh_glVertex4i (GLint x, GLint y, GLint z, GLint w);
void APIENTRY d3dmh_glVertex4iv (const GLint *v);
void APIENTRY d3dmh_glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w);
void APIENTRY d3dmh_glVertex4sv (const GLshort *v);
void APIENTRY d3dmh_glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void APIENTRY d3dmh_glViewport (GLint x, GLint y, GLsizei width, GLsizei height);

// wgl interface
HGLRC WINAPI d3dmh_wglCreateContext (HDC hdc);
BOOL WINAPI d3dmh_wglDeleteContext (HGLRC hglrc);
HGLRC WINAPI d3dmh_wglGetCurrentContext (VOID);
HDC WINAPI d3dmh_wglGetCurrentDC (VOID);
BOOL WINAPI d3dmh_wglMakeCurrent (HDC hdc, HGLRC hglrc);
PROC WINAPI d3dmh_wglGetProcAddress (LPCSTR s);

// override SPF
BOOL WINAPI d3dmh_SetPixelFormat (HDC hdc, int format, CONST PIXELFORMATDESCRIPTOR * ppfd);

// our fake CDS replacement
LONG WINAPI ChangeDisplaySettings_FakeGL (LPDEVMODE lpDevMode, DWORD dwflags);

void Direct3D_SetVsync (int wants_vsync); // Baker
void Direct3D_SetFullscreen (int wants_fullscreen); // Baker
void Direct3D_SetBPP (int wants_bpp);
void Direct3D_SwapBuffers (void); // Baker

#endif // ! __DX8_MH_WRAPPER_H
