#include "quakedef.h"

#ifdef GLQUAKE
extern cvar_t s_ambientfade;
extern cvar_t s_ambientlevel;
extern cvar_t v_ofsy;
extern cvar_t v_gunkick;
extern cvar_t v_cshiftquad;

qboolean      OnChange_ambience (cvar_t * var, char *string);
cvar_t        ambience = { "ambience", "default", CVAR_ARCHIVE | CVAR_AGGREGATE, OnChange_ambience };
cvar_t        ambienceauto = { "ambienceauto", "0", CVAR_ARCHIVE };
cvar_t        ambiencehd = { "ambiencehd", "0", CVAR_ARCHIVE };

void ambience_default_f (void) {
    Cvar_ResetVar (&gl_bloomalpha);
    Cvar_ResetVar (&gl_bloomcolor);
    Cvar_ResetVar (&gl_bloomdarken);
    Cvar_ResetVar (&gl_bloomdiamond);
    Cvar_ResetVar (&gl_bloomintensity);
    Cvar_ResetVar (&gl_bluralpha);
    Cvar_ResetVar (&gl_blurdarkness);
    Cvar_ResetVar (&gl_blurscale);
    Cvar_ResetVar (&gl_dcontrastcolor);
    Cvar_ResetVar (&gl_dcontrastscale);
    Cvar_ResetVar (&gl_dlightintensity);
    Cvar_ResetVar (&gl_fogcolor);
    Cvar_ResetVar (&gl_fogdarkness);
    Cvar_ResetVar (&gl_fogdensity);
    Cvar_ResetVar (&gl_fogdistance);
    Cvar_ResetVar (&gl_smokealpha);
    Cvar_ResetVar (&gl_smokedensity);
    Cvar_ResetVar (&gl_smokeradius);
    Cvar_ResetVar (&r_alphalava);
    Cvar_ResetVar (&r_alphaslime);
    Cvar_ResetVar (&r_alphateleport);
    Cvar_ResetVar (&r_alphawater);
    Cvar_ResetVar (&r_levelsmodels);
    Cvar_ResetVar (&r_levelsweapon);
    Cvar_ResetVar (&r_levelsgray);
    Cvar_ResetVar (&r_levelsmax);
    Cvar_ResetVar (&r_levelsthresholdhigh);
    Cvar_ResetVar (&r_levelsthresholdlow);
    Cvar_ResetVar (&s_ambientlevel);
    Cvar_ResetVar (&v_ofsy);
    Cvar_ResetVar (&v_contrast);
    if (r_quality.value > 0.65)
        Cvar_SetValue (&v_gamma, 1.5);
    else
        Cvar_ResetVar (&v_gamma);
    Cvar_ResetVar (&v_gunkick);
    Cvar_ResetVar (&v_idlescale);
    Cvar_ResetVar (&v_cshiftquad);
}
void ambience_quake_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.5);
    Cvar_SetValue (&gl_bloomcolor, 0.5);
    Cvar_SetValue (&gl_bloomdarken, 2);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 1);
    Cvar_SetValue (&gl_bluralpha, 0.2);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 0.2);
    Cvar_SetValue (&gl_dcontrastcolor, 0.5);
    Cvar_SetValue (&gl_dcontrastscale, 0.2);
    Cvar_SetValue (&gl_dlightintensity, 0.1);
    Cvar_SetValue (&gl_fogcolor, 0.5);
    Cvar_SetValue (&gl_fogdarkness, 0.2);
    Cvar_SetValue (&gl_fogdensity, 0.2);
    Cvar_SetValue (&gl_fogdistance, 0.5);
    Cvar_SetValue (&gl_smokealpha, 0.2);
    Cvar_SetValue (&gl_smokedensity, 2);
    Cvar_SetValue (&gl_smokeradius, 0);
    Cvar_SetValue (&r_alphalava, 0.4);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.5);
    if (ambiencehd.value) {
        Cvar_SetValue (&r_levelsmodels, 0.7);
        Cvar_SetValue (&r_levelsweapon, 0.9);
    } else {
        Cvar_SetValue (&r_levelsmodels, 0.9);
        Cvar_SetValue (&r_levelsweapon, 1);
    }
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0.7);
    Cvar_SetValue (&r_levelsthresholdlow, 0.1);
    Cvar_SetValue (&s_ambientlevel, 0.25);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 1);
    Cvar_SetValue (&v_gunkick, 0);
    if (ambiencehd.value)
        Cvar_SetValue (&v_idlescale, 0.5);
    else
        Cvar_SetValue (&v_idlescale, 0);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}
void ambience_despair_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.2);
    Cvar_SetValue (&gl_bloomcolor, 0.5);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 10);
    Cvar_SetValue (&gl_bluralpha, 1);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 1);
    Cvar_SetValue (&gl_dcontrastcolor, 0.5);
    Cvar_SetValue (&gl_dcontrastscale, 0.5);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.1);
    Cvar_SetValue (&gl_fogdarkness, 0);
    Cvar_SetValue (&gl_fogdensity, 0.4);
    Cvar_SetValue (&gl_fogdistance, 0.5);
    Cvar_SetValue (&gl_smokealpha, 0.8);
    Cvar_SetValue (&gl_smokedensity, 5);
    Cvar_SetValue (&gl_smokeradius, 0);
    Cvar_SetValue (&r_alphalava, 0.2);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.5);
    Cvar_SetValue (&r_alphawater, 0.4);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 1);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0);
    Cvar_SetValue (&r_levelsthresholdlow, 0.2);
    Cvar_SetValue (&s_ambientlevel, 0.25);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 1.75);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.5);
}
void ambience_epic_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.5);
    Cvar_SetValue (&gl_bloomcolor, 0.5);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 2);
    Cvar_SetValue (&gl_bluralpha, 0.5);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 0.2);
    Cvar_SetValue (&gl_dcontrastcolor, 0.8);
    Cvar_SetValue (&gl_dcontrastscale, 0.2);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.8);
    Cvar_SetValue (&gl_fogdarkness, 0.1);
    Cvar_SetValue (&gl_fogdensity, 0.2);
    Cvar_SetValue (&gl_fogdistance, 0.1);
    Cvar_SetValue (&gl_smokealpha, 0.8);
    Cvar_SetValue (&gl_smokedensity, 5);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.4);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.5);
    Cvar_SetValue (&r_alphawater, 0.5);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0.4);
    Cvar_SetValue (&r_levelsthresholdlow, 0.2);
    Cvar_SetValue (&s_ambientlevel, 0.25);
    Cvar_SetValue (&v_ofsy, 2);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 1);
    Cvar_SetValue (&v_gunkick, 2);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}
void ambience_exorcist_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.5);
    Cvar_SetValue (&gl_bloomcolor, 0.5);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 2);
    Cvar_SetValue (&gl_bluralpha, 0.5);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 0.2);
    Cvar_SetValue (&gl_dcontrastcolor, 0.5);
    Cvar_SetValue (&gl_dcontrastscale, 0.5);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.8);
    Cvar_SetValue (&gl_fogdarkness, 0.1);
    Cvar_SetValue (&gl_fogdensity, 0.2);
    Cvar_SetValue (&gl_fogdistance, 0.5);
    Cvar_SetValue (&gl_smokealpha, 0.5);
    Cvar_SetValue (&gl_smokedensity, 2);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.4);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.5);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 1);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0.4);
    Cvar_SetValue (&r_levelsthresholdlow, 0.2);
    Cvar_SetValue (&s_ambientlevel, 0.25);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 1.25);
    Cvar_SetValue (&v_gamma, 1.25);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.5);
}
void ambience_graveyard_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.4);
    Cvar_SetValue (&gl_bloomcolor, 1);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 0);
    Cvar_SetValue (&gl_bloomintensity, 2);
    Cvar_SetValue (&gl_bluralpha, 0.8);
    Cvar_SetValue (&gl_blurdarkness, 1);
    Cvar_SetValue (&gl_blurscale, 0.8);
    Cvar_SetValue (&gl_dcontrastcolor, 0.9);
    Cvar_SetValue (&gl_dcontrastscale, 1);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.7);
    Cvar_SetValue (&gl_fogdarkness, 0.5);
    Cvar_SetValue (&gl_fogdensity, 0.2);
    Cvar_SetValue (&gl_fogdistance, 0);
    Cvar_SetValue (&gl_smokealpha, 1);
    Cvar_SetValue (&gl_smokedensity, 1);
    Cvar_SetValue (&gl_smokeradius, 1);
    Cvar_SetValue (&r_alphalava, 0.4);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.2);
    Cvar_SetValue (&r_levelsmodels, 0.5);
    Cvar_SetValue (&r_levelsweapon, 0.8);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 0.5);
    Cvar_SetValue (&r_levelsthresholdhigh, 1);
    Cvar_SetValue (&r_levelsthresholdlow, 0.1);
    Cvar_SetValue (&s_ambientlevel, 0.8);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 2.5);
    Cvar_SetValue (&v_gamma, 2);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.25);
}
void ambience_inferno_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 1);
    Cvar_SetValue (&gl_bloomcolor, 0);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 1);
    Cvar_SetValue (&gl_bluralpha, 1);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 1);
    Cvar_SetValue (&gl_dcontrastcolor, 0.9);
    Cvar_SetValue (&gl_dcontrastscale, 0.5);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.2);
    Cvar_SetValue (&gl_fogdarkness, 0.8);
    Cvar_SetValue (&gl_fogdensity, 0.4);
    Cvar_SetValue (&gl_fogdistance, 0);
    Cvar_SetValue (&gl_smokealpha, 0.8);
    Cvar_SetValue (&gl_smokedensity, 4);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.5);
    Cvar_SetValue (&r_alphaslime, 0.7);
    Cvar_SetValue (&r_alphateleport, 0.5);
    Cvar_SetValue (&r_alphawater, 0.5);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 0.8);
    Cvar_SetValue (&r_levelsthresholdhigh, 0);
    Cvar_SetValue (&r_levelsthresholdlow, 0.4);
    Cvar_SetValue (&s_ambientlevel, 0.8);
    Cvar_SetValue (&v_ofsy, 2);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 2);
    Cvar_SetValue (&v_gunkick, 2);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.5);
}
void ambience_macabre_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.5);
    Cvar_SetValue (&gl_bloomcolor, 0.2);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 0);
    Cvar_SetValue (&gl_bloomintensity, 2);
    Cvar_SetValue (&gl_bluralpha, 0.5);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 0.5);
    Cvar_SetValue (&gl_dcontrastcolor, 0.9);
    Cvar_SetValue (&gl_dcontrastscale, 0.2);
    Cvar_SetValue (&gl_dlightintensity, 0.1);
    Cvar_SetValue (&gl_fogcolor, 0.1);
    Cvar_SetValue (&gl_fogdarkness, 0.1);
    Cvar_SetValue (&gl_fogdensity, 0.666);
    Cvar_SetValue (&gl_fogdistance, 0.1);
    Cvar_SetValue (&gl_smokealpha, 0.8);
    Cvar_SetValue (&gl_smokedensity, 2);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.2);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.4);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0.2);
    Cvar_SetValue (&r_levelsthresholdlow, 0.2);
    Cvar_SetValue (&s_ambientlevel, 1);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 1.25);
    Cvar_SetValue (&v_gunkick, 2);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.5);
}
void ambience_night_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.4);
    Cvar_SetValue (&gl_bloomcolor, 0.1);
    Cvar_SetValue (&gl_bloomdarken, 2);
    Cvar_SetValue (&gl_bloomdiamond, 0);
    Cvar_SetValue (&gl_bloomintensity, 2);
    Cvar_SetValue (&gl_bluralpha, 0.8);
    Cvar_SetValue (&gl_blurdarkness, 1);
    Cvar_SetValue (&gl_blurscale, 0.8);
    Cvar_SetValue (&gl_dcontrastcolor, 0.9);
    Cvar_SetValue (&gl_dcontrastscale, 1);
    Cvar_SetValue (&gl_dlightintensity, 0.25);
    Cvar_SetValue (&gl_fogcolor, 0.8);
    Cvar_SetValue (&gl_fogdarkness, 0.8);
    Cvar_SetValue (&gl_fogdensity, 0.1);
    Cvar_SetValue (&gl_fogdistance, 0.1);
    Cvar_SetValue (&gl_smokealpha, 0.5);
    Cvar_SetValue (&gl_smokedensity, 5);
    Cvar_SetValue (&gl_smokeradius, 5);
    Cvar_SetValue (&r_alphalava, 0.5);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.5);
    Cvar_SetValue (&r_alphawater, 0.4);
    Cvar_SetValue (&r_levelsmodels, 0.7);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 0.5);
    Cvar_SetValue (&r_levelsthresholdhigh, 0);
    Cvar_SetValue (&r_levelsthresholdlow, 1);
    Cvar_SetValue (&s_ambientlevel, 0.8);
    Cvar_SetValue (&v_ofsy, 2);
    Cvar_SetValue (&v_contrast, 2.5);
    Cvar_SetValue (&v_gamma, 2);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}
void ambience_nightmare_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.1);
    Cvar_SetValue (&gl_bloomcolor, 0.4);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 10);
    Cvar_SetValue (&gl_bluralpha, 1);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 1);
    Cvar_SetValue (&gl_dcontrastcolor, 0.2);
    Cvar_SetValue (&gl_dcontrastscale, 0.5);
    Cvar_SetValue (&gl_dlightintensity, 0.1);
    Cvar_SetValue (&gl_fogcolor, 0.5);
    Cvar_SetValue (&gl_fogdarkness, 0.1);
    Cvar_SetValue (&gl_fogdensity, 0.4);
    Cvar_SetValue (&gl_fogdistance, 0);
    Cvar_SetValue (&gl_smokealpha, 1);
    Cvar_SetValue (&gl_smokedensity, 2);
    Cvar_SetValue (&gl_smokeradius, 0);
    Cvar_SetValue (&r_alphalava, 0.5);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.5);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 1);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 1);
    Cvar_SetValue (&r_levelsthresholdhigh, 0.2);
    Cvar_SetValue (&r_levelsthresholdlow, 1);
    Cvar_SetValue (&s_ambientlevel, 0.5);
    Cvar_SetValue (&v_ofsy, 2);
    Cvar_SetValue (&v_contrast, 3);
    Cvar_SetValue (&v_gamma, 1.75);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}
void ambience_underworld_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 1);
    Cvar_SetValue (&gl_bloomcolor, 0.5);
    Cvar_SetValue (&gl_bloomdarken, 2);
    Cvar_SetValue (&gl_bloomdiamond, 1);
    Cvar_SetValue (&gl_bloomintensity, 1);
    Cvar_SetValue (&gl_bluralpha, 1);
    Cvar_SetValue (&gl_blurdarkness, 1);
    Cvar_SetValue (&gl_blurscale, 1);
    Cvar_SetValue (&gl_dcontrastcolor, 0.5);
    Cvar_SetValue (&gl_dcontrastscale, 1);
    Cvar_SetValue (&gl_dlightintensity, 0.1);
    Cvar_SetValue (&gl_fogcolor, 0.5);
    Cvar_SetValue (&gl_fogdarkness, 0.4);
    Cvar_SetValue (&gl_fogdensity, 0.4);
    Cvar_SetValue (&gl_fogdistance, 0.1);
    Cvar_SetValue (&gl_smokealpha, 0.7);
    Cvar_SetValue (&gl_smokedensity, 2);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.7);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.4);
    Cvar_SetValue (&r_levelsmodels, 0.8);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 0.8);
    Cvar_SetValue (&r_levelsthresholdhigh, 0);
    Cvar_SetValue (&r_levelsthresholdlow, 0.5);
    Cvar_SetValue (&s_ambientlevel, 0.8);
    Cvar_SetValue (&v_ofsy, 1);
    Cvar_SetValue (&v_contrast, 1);
    Cvar_SetValue (&v_gamma, 1.25);
    Cvar_SetValue (&v_gunkick, 2);
    Cvar_SetValue (&v_idlescale, 1);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}
void ambience_violence_f (void) {
    Cvar_SetValue (&gl_bloomalpha, 0.5);
    Cvar_SetValue (&gl_bloomcolor, 0.2);
    Cvar_SetValue (&gl_bloomdarken, 1);
    Cvar_SetValue (&gl_bloomdiamond, 0);
    Cvar_SetValue (&gl_bloomintensity, 1);
    Cvar_SetValue (&gl_bluralpha, 1);
    Cvar_SetValue (&gl_blurdarkness, 0.5);
    Cvar_SetValue (&gl_blurscale, 1);
    Cvar_SetValue (&gl_dcontrastcolor, 0.8);
    Cvar_SetValue (&gl_dcontrastscale, 1);
    Cvar_SetValue (&gl_dlightintensity, 0.1);
    Cvar_SetValue (&gl_fogcolor, 0.2);
    Cvar_SetValue (&gl_fogdarkness, 0.2);
    Cvar_SetValue (&gl_fogdensity, 0.5);
    Cvar_SetValue (&gl_fogdistance, 0);
    Cvar_SetValue (&gl_smokealpha, 0.8);
    Cvar_SetValue (&gl_smokedensity, 5);
    Cvar_SetValue (&gl_smokeradius, 2);
    Cvar_SetValue (&r_alphalava, 0.4);
    Cvar_SetValue (&r_alphaslime, 0.5);
    Cvar_SetValue (&r_alphateleport, 0.7);
    Cvar_SetValue (&r_alphawater, 0.4);
    Cvar_SetValue (&r_levelsmodels, 0.7);
    Cvar_SetValue (&r_levelsweapon, 0.9);
    Cvar_SetValue (&r_levelsgray, 0);
    Cvar_SetValue (&r_levelsmax, 0.5);
    Cvar_SetValue (&r_levelsthresholdhigh, 0);
    Cvar_SetValue (&r_levelsthresholdlow, 1);
    Cvar_SetValue (&s_ambientlevel, 1);
    Cvar_SetValue (&v_ofsy, 2);
    Cvar_SetValue (&v_contrast, 2.5);
    Cvar_SetValue (&v_gamma, 2);
    Cvar_SetValue (&v_gunkick, 1);
    Cvar_SetValue (&v_idlescale, 2);
    Cvar_SetValue (&v_cshiftquad, 0.2);
}

ambience_t    ambiencelist[] = {
    {"Default", ambience_default_f, 0},
    {"Quake", ambience_quake_f, 2},
    {"Despair", ambience_despair_f, 0},
    {"Epic", ambience_epic_f, 0},
    {"Exorcist", ambience_exorcist_f, 0},
    {"Graveyard", ambience_graveyard_f, 1},
    {"Inferno", ambience_inferno_f, 1},
    {"Macabre", ambience_macabre_f, 0},
    {"Night", ambience_night_f, 1},
    {"Nightmare", ambience_nightmare_f, 0},
    {"Underworld", ambience_underworld_f, 1},
    {"Violence", ambience_violence_f, 1}
};

#  define NUM_AMBIENCES 12
/*
 * OnChange_ambience
 */
qboolean OnChange_ambience (cvar_t * var, char *string) {
    int           i;

    for (i = 0; i < NUM_AMBIENCES; i++) {
        if (!Q_strcasecmp (ambiencelist[i].name, string))
            break;
    }

    if (i == NUM_AMBIENCES) {
        Con_Printf ("Unknown ambience name: %s\n", string);
        return true;
    }

    ambiencelist[i].apply ();

    return false;
}

void Ambience_List_f (void) {
    int           i;

    for (i = 0; i < NUM_AMBIENCES; i++)
        Con_Printf ("%s\n", ambiencelist[i].name);

    Con_Printf ("------------\n%d ambiences\n", NUM_AMBIENCES);
}

void Ambience_Next_f (void) {
    int           i;

    for (i = 0; i < NUM_AMBIENCES; i++)
        if (!Q_strcasecmp (ambiencelist[i].name, ambience.string))
            break;
    if (i == NUM_AMBIENCES)
        i = 0;
    else
        i++;
    while (ambiencelist[i].select != 2 && ambiencelist[i].select != ambiencehd.value && i < NUM_AMBIENCES)
        i++;
    if (i == NUM_AMBIENCES) {
        i = 0;
        while (ambiencelist[i].select != 2 && ambiencelist[i].select != ambiencehd.value && i < NUM_AMBIENCES)
            i++;
    }
    Cvar_Set (&ambience, ambiencelist[i].name);
    SCR_CenterPrint (ambiencelist[i].name);
}

void Ambience_Prev_f (void) {
    int           i;

    for (i = 0; i < NUM_AMBIENCES; i++)
        if (!Q_strcasecmp (ambiencelist[i].name, ambience.string))
            break;
    if (i == 0)
        i = NUM_AMBIENCES - 1;
    else
        i--;
    while (ambiencelist[i].select != 2 && ambiencelist[i].select != ambiencehd.value && i > -1)
        i--;
    if (i == -1) {
        i = NUM_AMBIENCES - 1;
        while (ambiencelist[i].select != 2 && ambiencelist[i].select != ambiencehd.value && i > -1)
            i--;
    }
    Cvar_Set (&ambience, ambiencelist[i].name);
    SCR_CenterPrint (ambiencelist[i].name);
}

void Ambience_Init (void) {
    Cvar_Register (&ambience);
    Cvar_Register (&ambienceauto);
    Cvar_Register (&ambiencehd);

    Cmd_AddCommand ("ambiencelist", Ambience_List_f);
    Cmd_AddCommand ("ambiencenext", Ambience_Next_f);
    Cmd_AddCommand ("ambienceprev", Ambience_Prev_f);
}
#endif
