#include "quakedef.h"

static int    xss_timeout, xss_interval, xss_blanking, xss_exposures;

#ifdef HAVE_MISC
#  include <X11/extensions/xf86misc.h>
#endif

#ifdef HAVE_XEXT_DEBUG
#  include <X11/extensions/dpms.h>
static BOOL   dpms_on;
#endif

#ifdef HAVE_DBUS
#  include <dbus/dbus.h>

#  define DBUS_SERVICE   "org.gnome.ScreenSaver"
#  define DBUS_PATH      "/org/gnome/ScreenSaver"
#  define DBUS_INTERFACE "org.gnome.ScreenSaver"

DBusConnection *connection;
uint          cookie;

void DBUS_DisableScreenSaver (void) {
    DBusError     error;
    DBusMessage  *reply_message;
    DBusMessage  *message;
    DBusBusType   type = DBUS_BUS_SESSION;
    const char   *app;
    const char   *reason;

    dbus_error_init (&error);
    connection = dbus_bus_get_private (type, &error);
    if (connection == NULL) {
        Sys_Printf ("Failed to open connection to %s message bus: %s\n",
                    (type == DBUS_BUS_SYSTEM) ? "system" : "session", error.message);
        dbus_error_free (&error);
        return;
    }

    if (connection != NULL) {
        message = dbus_message_new_method_call (DBUS_SERVICE, DBUS_PATH, DBUS_INTERFACE, "Inhibit");
        app = Q_strdup (ENGINE_NAME);
        reason = Q_strdup ("playing");
        dbus_message_append_args (message, DBUS_TYPE_STRING, &app, DBUS_TYPE_STRING, &reason, DBUS_TYPE_INVALID);
        reply_message = dbus_connection_send_with_reply_and_block (connection, message, 200, &error);
        if (reply_message) {
            dbus_message_get_args (reply_message, &error, DBUS_TYPE_INT32, &cookie, NULL);
            dbus_message_unref (reply_message);
        }

        dbus_message_unref (message);
        dbus_error_free (&error);
    }
}

void DBUS_RestoreScreenSaver (void) {
    DBusMessage  *message;

    if (connection != NULL) {
        message = dbus_message_new_method_call (DBUS_SERVICE, DBUS_PATH, DBUS_INTERFACE, "UnInhibit");
        dbus_message_append_args (message, DBUS_TYPE_INT32, &cookie, DBUS_TYPE_INVALID);
        dbus_connection_send (connection, message, NULL);
        dbus_message_unref (message);
    }
}
#endif

void VID_DisableScreenSaver (Display * dpy) {
#ifdef HAVE_XEXT_DEBUG
    CARD16        dpms_state;
    int           dpms_dummy;
#endif

    XLockDisplay (dpy);
    XGetScreenSaver (dpy, &xss_timeout, &xss_interval, &xss_blanking, &xss_exposures);
    XSetScreenSaver (dpy, 0, 0, xss_blanking, xss_exposures);
    XUnlockDisplay (dpy);
#ifdef HAVE_DBUS
    DBUS_DisableScreenSaver ();
#endif
#ifdef HAVE_XEXT_DEBUG
    if ((DPMSQueryExtension (dpy, &dpms_dummy, &dpms_dummy)) && (DPMSCapable (dpy))) {
        DPMSInfo (dpy, &dpms_state, &dpms_on);
        DPMSDisable (dpy);
    }
#endif
}

void VID_RestoreScreenSaver (Display * dpy) {
#ifdef HAVE_XEXT_DEBUG
    int           dpms_dummy;

    if ((DPMSQueryExtension (dpy, &dpms_dummy, &dpms_dummy)) && (DPMSCapable (dpy)) && dpms_on) {
        DPMSEnable (dpy);
    }
#endif
#ifdef HAVE_DBUS
    DBUS_RestoreScreenSaver ();
#endif
    XLockDisplay (dpy);
    XSetScreenSaver (dpy, xss_timeout, xss_interval, xss_blanking, xss_exposures);
    XUnlockDisplay (dpy);
}

#ifdef HAVE_MISC
// lxndr: from xpilot-ng project
void VID_Manage3rdButton (Display * dpy, qboolean disable) {
    static qboolean first_run = true;
    static qboolean working = true;
    static qboolean already_warned = false;
    static int orig_timeout;
    int MajorVersion, MinorVersion;
    XF86MiscMouseSettings m;
    Status status;

    if (!working) return;

    MajorVersion = MinorVersion = 0;
    if (!XF86MiscQueryVersion(dpy, &MajorVersion, &MinorVersion)) {
        Con_Warnf ("Failed to query X server.");
        working = false;
        return;
    }

    Con_Printf ("Using XFree86-MiscExtension Version %d.%d\n", MajorVersion, MinorVersion);
    if (!(MajorVersion > 0) || !(MajorVersion == 0 && MinorVersion > 0)) {
        Con_Warnf ("Invalid major or minor opcode.\n");
        working = false;
        return;
    }

    status = XF86MiscGetMouseSettings(dpy, &m);
    if (status != 1) {
        Con_Warnf ("Failed to retrieve mouse settings from X server.");
        working = false;
        return;
    }

    if (first_run) {
        if (m.emulate3buttons) {
            Con_Warnf ("Emulate3Buttons is enabled.");
            orig_timeout = m.emulate3timeout;
        } else {
            working = false; // Emulate3Buttons disabled from the start, so function is turned inactive
            return;
        }
    }

    m.emulate3buttons = !disable;
    m.emulate3timeout = disable ? 0 : orig_timeout;

    status = XF86MiscSetMouseSettings(dpy, &m);
    if (status != 1) {
        Con_Warnf ("Failed to set X server mouse settings.");
        working = false;
        return;
    }

    XF86MiscGetMouseSettings(dpy, &m);

    if (m.emulate3buttons != (!disable) && !already_warned) {
        Con_Warnf ("Failed to disable Emulate3Buttons. Just setting timeout to 0.");
        already_warned = true;
        if (m.emulate3timeout != (disable ? 0 : orig_timeout)) {
            Con_Warnf ("Can't set timeout. Giving up...");
            working = false;
        }
    }

    first_run = false;
}
#endif

int XLateKey (XKeyEvent * ev) {
    int           key, kp;
    //      char          buf[64];
    KeySym        keysym;
    extern cvar_t cl_keypad;

    key = 0;
    kp = (int) cl_keypad.value;

    //      XLookupString (ev, buf, sizeof buf, &keysym, 0);
    keysym = XLookupKeysym (ev, 0);

    switch (keysym) {
        case XK_Scroll_Lock:
            key = K_SCRLCK;
            break;

        case XK_Caps_Lock:
            key = K_CAPSLOCK;
            break;

        case XK_Num_Lock:
            key = kp ? KP_NUMLOCK : K_PAUSE;
            break;

        case XK_KP_Page_Up:
            key = kp ? KP_PGUP : K_PGUP;
            break;
        case XK_Page_Up:
            key = K_PGUP;
            break;

        case XK_KP_Page_Down:
            key = kp ? KP_PGDN : K_PGDN;
            break;
        case XK_Page_Down:
            key = K_PGDN;
            break;

        case XK_KP_Home:
            key = kp ? KP_HOME : K_HOME;
            break;
        case XK_Home:
            key = K_HOME;
            break;

        case XK_KP_End:
            key = kp ? KP_END : K_END;
            break;
        case XK_End:
            key = K_END;
            break;

        case XK_KP_Left:
            key = kp ? KP_LEFTARROW : K_LEFTARROW;
            break;
        case XK_Left:
            key = K_LEFTARROW;
            break;

        case XK_KP_Right:
            key = kp ? KP_RIGHTARROW : K_RIGHTARROW;
            break;
        case XK_Right:
            key = K_RIGHTARROW;
            break;

        case XK_KP_Down:
            key = kp ? KP_DOWNARROW : K_DOWNARROW;
            break;

        case XK_Down:
            key = K_DOWNARROW;
            break;

        case XK_KP_Up:
            key = kp ? KP_UPARROW : K_UPARROW;
            break;

        case XK_Up:
            key = K_UPARROW;
            break;

        case XK_Escape:
            key = K_ESCAPE;
            break;

        case XK_KP_Enter:
            key = kp ? KP_ENTER : K_ENTER;
            break;

        case XK_Return:
            key = K_ENTER;
            break;

        case XK_Tab:
            key = K_TAB;
            break;

        case XK_F1:
            key = K_F1;
            break;

        case XK_F2:
            key = K_F2;
            break;

        case XK_F3:
            key = K_F3;
            break;

        case XK_F4:
            key = K_F4;
            break;

        case XK_F5:
            key = K_F5;
            break;

        case XK_F6:
            key = K_F6;
            break;

        case XK_F7:
            key = K_F7;
            break;

        case XK_F8:
            key = K_F8;
            break;

        case XK_F9:
            key = K_F9;
            break;

        case XK_F10:
            key = K_F10;
            break;

        case XK_F11:
            key = K_F11;
            break;

        case XK_F12:
            key = K_F12;
            break;

        case XK_BackSpace:
            key = K_BACKSPACE;
            break;

        case XK_KP_Delete:
            key = kp ? KP_DEL : K_DEL;
            break;
        case XK_Delete:
            key = K_DEL;
            break;

        case XK_Pause:
            key = K_PAUSE;
            break;

        case XK_Shift_L:
            key = K_LSHIFT;
            break;
        case XK_Shift_R:
            key = K_RSHIFT;
            break;

        case XK_Execute:
        case XK_Control_L:
            key = K_LCTRL;
            break;
        case XK_Control_R:
            key = K_RCTRL;
            break;

        case XK_Alt_L:
        case XK_Meta_L:
            key = K_LALT;
            break;
        case XK_Alt_R:
        case XK_Meta_R:
            key = K_RALT;
            break;

        case XK_Super_L:
            key = K_LWIN;
            break;
        case XK_Super_R:
            key = K_RWIN;
            break;
        case XK_Menu:
            key = K_MENU;
            break;

        case XK_KP_Begin:
            key = kp ? KP_5 : '5';
            break;

        case XK_KP_Insert:
            key = kp ? KP_INS : K_INS;
            break;
        case XK_Insert:
            key = K_INS;
            break;

        case XK_KP_Multiply:
            key = kp ? KP_STAR : '*';
            break;

        case XK_KP_Add:
            key = kp ? KP_PLUS : '+';
            break;

        case XK_KP_Subtract:
            key = kp ? KP_MINUS : '-';
            break;

        case XK_KP_Divide:
            key = kp ? KP_SLASH : '/';
            break;

        case XK_Print:
            key = K_PRINTSCR;
            break;

            //case XF86XK_AudioLowerVolume: key = K_VOLUMEDOWN; break; // lxndr: FIXME:
            //case XF86XK_AudioRaiseVolume: key = K_VOLUMEUP; break;
        default:
            switch (ev->keycode) {
                case 0xae:
                    key = K_VOLUMEDOWN;
                    break;             // lxndr: those values
                case 0xb0:
                    key = K_VOLUMEUP;
                    break;             // come from gnome
                default:
                    if (keysym >= 32 && keysym <= 126)
                        key = tolower (keysym);
                    break;
            }
            break;
    }

    return key;
}

