/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// mp3.c -- mp3 playing code (By Tomas 'Tomaz' Jakobsson) for the fmod based 
// sound system (By Robert 'Heffo' Heffernan)


#include "quakedef.h"

char mp3[MAX_QPATH];

void MP3_Play(char *track)
{
	sprintf(mp3, "music/%s.mp3", track);

	S_StopMusic();

	if (SND_MusicVolume.value != 0)
		S_StartMusic(mp3, true);
}

void MP3_Restart(void)
{
	S_StopMusic();

	if (SND_MusicVolume.value != 0)
		S_StartMusic(mp3, true);
}

static void MP3_f (void)
{
	char	*command;

	if (Cmd_Argc() < 2)
		return;

	command = Cmd_Argv (1);

	if (Q_strcasecmp(command, "play") == 0)
	{
		MP3_Play(Cmd_Argv (2));
		return;
	}

	if (Q_strcasecmp(command, "stop") == 0)
	{
		S_StopMusic();
		return;
	}

	if (Q_strcasecmp(command, "pause") == 0)
	{
		S_PauseMusic();
		return;
	}

	if (Q_strcasecmp(command, "resume") == 0)
	{
		S_ResumeMusic();
		return;
	}

	if (Q_strcasecmp(command, "restart") == 0)
	{
		MP3_Restart();
		return;
	}
}

void MP3_Init (void)
{
	Cmd_AddCommand ("mp3", MP3_f);
}
