/*
	$RCSfile: progs.h,v $

	Copyright (C) 1996-1997  Id Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to:
	
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA

	$Id: progs.h,v 1.16 2003/06/14 23:53:07 warp Exp $
*/

#ifndef __PROGS_H
#define __PROGS_H

#include "common.h"
#include "pr_comp.h"					// defs shared with qcc
#include "progdefs.h"					// generated by program cdefs
#include "protocol.h"

typedef union eval_s
{
	string_t    string;
	float       _float;
	float       vector[3];
	func_t      function;
	int         ivector[3];
	int         _int;
	int         edict;
}
eval_t;

#define MAX_ENT_LEAFS 256
typedef struct edict_s
{
	qboolean	free;
	link_t		area;					// linked to a division node or leaf

	Uint32		num_leafs;
	short		leafnums[MAX_ENT_LEAFS];

	entity_state_t baseline;

	float		freetime;				// sv.time when the object was freed
	entvars_t	v;						// C exported fields from progs
										// other fields from progs come immediately after
}
edict_t;

extern int eval_gravity;
extern int eval_button3;
extern int eval_button4;
extern int eval_button5;
extern int eval_button6;
extern int eval_button7;
extern int eval_button8;
extern int eval_items2;
extern int eval_ammo_shells1;
extern int eval_ammo_nails1;
extern int eval_ammo_lava_nails;
extern int eval_ammo_rockets1;
extern int eval_ammo_multi_rockets;
extern int eval_ammo_cells1;
extern int eval_ammo_plasma;
extern int eval_idealpitch;
extern int eval_pitch_speed;
extern int eval_ping;
extern int eval_movement;
extern int eval_punchvector;

// eval_t *GetEdictFieldValue (edict_t *ed, char *field);
// LordHavoc -- faster macro version
#define GETEDICTFIELDVALUE(ed, fieldoffset) (fieldoffset ? (eval_t*)((char*)&ed->v + fieldoffset) : NULL)

#define	EDICT_FROM_AREA(l) ((edict_t *)((Uint8 *)l - (int)&(((edict_t *)0)->area)))

//============================================================================

extern dprograms_t	*progs;
extern dfunction_t	*pr_functions;
extern char			*pr_strings;
extern ddef_t		*pr_globaldefs;
extern ddef_t		*pr_fielddefs;
extern dstatement_t	*pr_statements;
extern globalvars_t	*pr_global_struct;
extern float		*pr_globals;		// same as pr_global_struct
extern cvar_t		*pr_boundscheck;

extern int	pr_edict_size;				// in bytes
extern int	pr_edictareasize;			// in bytes

//============================================================================

void PR_Init_Cvars (void);
void PR_Init (void);

void PR_ExecuteProgram (func_t fnum, const char *errormessage);
void PR_LoadProgs (void);

void PR_Profile_f (void);

edict_t *ED_Alloc (void);
void ED_Free (edict_t *ed);

// returns a copy of the string allocated from the server's string heap

void ED_Print (edict_t *ed);
void ED_Write (SDL_RWops *rw, edict_t *ed);
const char *ED_ParseEdict (const char *data, edict_t *ent);

void ED_WriteGlobals (SDL_RWops *rw);
void ED_ParseGlobals (const char *data);

void ED_LoadFromFile (const char *data);

edict_t *EDICT_NUM_ERROR (Uint n);
#define EDICT_NUM(n) (n < sv.max_edicts ? (edict_t *)((Uint8 *)sv.edicts + (n) * pr_edict_size) : EDICT_NUM_ERROR(n))

Uint NUM_FOR_EDICT (edict_t *e, char *filename, int fileline);

#define	NEXT_EDICT(e) ((edict_t *)( (Uint8 *)e + pr_edict_size))

#define	EDICT_TO_PROG(e) ((Uint8 *)e - (Uint8 *)sv.edicts)
#define PROG_TO_EDICT(e) ((edict_t *)((Uint8 *)sv.edicts + e))

//============================================================================

#define	G_FLOAT(o) (pr_globals[o])
#define	G_INT(o) (*(int *)&pr_globals[o])
#define	G_EDICT(o) ((edict_t *)((Uint8 *)sv.edicts+ *(int *)&pr_globals[o]))
#define G_EDICTNUM(o) NUM_FOR_EDICT(G_EDICT(o), __FILE__, __LINE__)
#define	G_VECTOR(o) (&pr_globals[o])
#define	G_STRING(o) (pr_strings + *(string_t *)&pr_globals[o])
#define	G_FUNCTION(o) (*(func_t *)&pr_globals[o])

#define	E_FLOAT(e,o) (((float*)&e->v)[o])
#define	E_INT(e,o) (*(int *)&((float*)&e->v)[o])
#define	E_VECTOR(e,o) (&((float*)&e->v)[o])
#define	E_STRING(e,o) (pr_strings + *(string_t *)&((float*)&e->v)[o])

typedef void (*builtin_t) (void);
extern builtin_t *pr_builtins;
extern Uint pr_numbuiltins;

extern Uint pr_argc;

extern qboolean pr_trace;
extern dfunction_t *pr_xfunction;
extern int pr_xstatement;

extern unsigned short pr_crc;

void PR_RunError (char *error, ...);

void ED_PrintEdicts (void);
void ED_PrintNum (Uint ent);

#endif // __PROGS_H

