/*
	$RCSfile: progs.h,v $

	Copyright (C) 1996-1997  Id Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to:
	
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA

	$Id: progs.h,v 1.7 2003/06/14 23:53:08 warp Exp $
*/

#ifndef __PROGS_H
#define __PROGS_H

#include "pr_comp.h"					// defs shared with qcc
#include "progdefs.h"					// generated by program cdefs
#include "protocol.h"

typedef union eval_s
{
	string_t    string;
	float       _float;
	float       vector[3];
	func_t      function;
	int         ivector[3];
	int         _int;
	int         edict;
}
eval_t;

#define MAX_ENT_LEAFS 256
typedef struct edict_s
{
	qboolean	free;
	link_t		area;					// linked to a division node or leaf

	Uint		num_leafs;
	short		leafnums[MAX_ENT_LEAFS];

	entity_state_t baseline;

	float		freetime;				// sv.time when the object was freed
	double		lastruntime;			// sv.time when SV_RunEntity was last
										// called for this edict

	entvars_t	v;						// C exported fields from progs

	// other fields from progs come immediately after
}
edict_t;

#define	EDICT_FROM_AREA(l) ((edict_t *)((Uint8 *)l - (int)&(((edict_t *)0)->area)))

//============================================================================

extern dprograms_t *progs;
extern dfunction_t *pr_functions;
extern char *pr_strings;
extern ddef_t *pr_globaldefs;
extern ddef_t *pr_fielddefs;
extern dstatement_t *pr_statements;
extern globalvars_t *pr_global_struct;
extern float *pr_globals;				// same as pr_global_struct

extern Uint pr_edict_size;				// in bytes


//============================================================================

void PR_Init (void);

char *PR_GlobalString (int ofs);
char *PR_GlobalStringNoContents (int ofs);

void PR_ExecuteProgram (func_t fnum);
void PR_LoadProgs (void);

void PR_Profile_f (void);

edict_t *ED_Alloc (void);
void ED_Free (edict_t *ed);

// returns a copy of the string allocated from the server's string heap

void ED_Print (edict_t *ed);

void ED_ParseGlobals (const char *data);

void ED_LoadFromFile (const char *data);

edict_t *EDICT_NUM_ERROR (Uint n);
#define EDICT_NUM(n) (n < MAX_EDICTS ? (edict_t *)((Uint8 *)sv.edicts + (n) * pr_edict_size) : EDICT_NUM_ERROR(n))

Uint NUM_FOR_EDICT (edict_t *e);

#define	NEXT_EDICT(e) ((edict_t *)( (Uint8 *)e + pr_edict_size))

#define	EDICT_TO_PROG(e) ((Uint8 *)e - (Uint8 *)sv.edicts)
#define PROG_TO_EDICT(e) ((edict_t *)((Uint8 *)sv.edicts + e))

//============================================================================

#define	G_FLOAT(o) (pr_globals[o])
#define	G_INT(o) (*(int *)&pr_globals[o])
#define	G_EDICT(o) ((edict_t *)((Uint8 *)sv.edicts+ *(int *)&pr_globals[o]))
#define G_EDICTNUM(o) NUM_FOR_EDICT(G_EDICT(o))
#define	G_VECTOR(o) (&pr_globals[o])
#define	G_STRING(o) (PR_GetString(*(string_t *)&pr_globals[o]))
#define	G_FUNCTION(o) (*(func_t *)&pr_globals[o])

#define	E_FLOAT(e,o) (((float*)&e->v)[o])
#define	E_INT(e,o) (*(int *)&((float*)&e->v)[o])
#define	E_VECTOR(e,o) (&((float*)&e->v)[o])
#define	E_STRING(e,o) (PR_GetString(*(string_t *)&((float*)&e->v)[o]))

extern Uint type_size[8];

typedef void (*builtin_t) (void);
extern builtin_t *pr_builtins;
extern Uint pr_numbuiltins;

extern Uint pr_argc;

extern qboolean pr_trace;
extern dfunction_t *pr_xfunction;
extern int pr_xstatement;

extern func_t SpectatorConnect;
extern func_t SpectatorThink;
extern func_t SpectatorDisconnect;

void PR_RunError (char *error, ...);

void ED_PrintEdicts (void);
void ED_PrintNum (int ent);

eval_t *GetEdictFieldValue (edict_t *ed, char *field);

//
// PR Strings stuff
//

#define PR_GetString(num)	(pr_strings + (num))
#define PR_SetString(s)		((int) ((s) - (pr_strings)))

#endif // __PROGS_H

