/*
	$RCSfile: vis.h,v $

	Copyright (C) 1996-1997  Id Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to:
	
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA

	$Id: vis.h,v 1.3 2003/05/26 07:10:21 warp Exp $
*/

#ifndef __VIS_H
#define __VIS_H

#include "qtypes.h"
#include "model.h"

extern Uint		 vis_framecount;
extern mleaf_t	*vis_viewleaf, *vis_oldviewleaf;
extern model_t	*vis_model;

void Vis_Init_Cvars(void);
void Vis_Init(void);
void Vis_NewVisParams(model_t *mod, vec3_t org, vec3_t up, vec3_t right, vec3_t point, float fov_x, float fov_y);
qboolean Vis_CullBox(vec3_t emins, vec3_t emaxs);
void Vis_RecursiveWorldNode(mnode_t *node, model_t *mod, vec3_t org);
void Vis_MarkLeaves(model_t *mod);

#endif // __VIS_H

