
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef WIN32
#define snprintf _snprintf
#endif

static char *nibbletohex = "0123456789ABCDEF";

int main(int argc, char **argv)
{
	int i, j, c, w, skipstart, filenum, filesize, strings = 0, hex = 0;
	FILE *infile;
	unsigned char readbuf[128];
	char writebuf[sizeof(readbuf) * 6 + 32];
	char	*base = NULL, file_name[1024];
	if (argc >= 2)
	{
		printf("/*this file generated by %s*/\n\ntypedef struct embeddedfile_s\n{\n\tchar *name;\n\tunsigned char *data;\n\tint datasize;\n}\nembeddedfile_t;\n\n", argv[0]);
		filenum = 0;
		for (i = 1;i < argc;i++)
		{
			if (!strcmp(argv[i], "-strings"))
				strings = 1;
			else if (!strcmp(argv[i], "-array"))
			{
				strings = 0;
				hex = 0;
			}
			else if (!strcmp(argv[i], "-hexarray"))
			{
				strings = 0;
				hex = 1;
			}
			else if (!strncmp(argv[i], "-base=", 6))
				base = strchr (argv[i], '=') + 1;
			else
			{
				if (base)
					snprintf(file_name, sizeof (file_name), "%s/%s", base, argv[i]);
				else
					snprintf(file_name, sizeof (file_name), "%s", argv[i]);

				if (!(infile = fopen(file_name, "rb"))) {
					printf("/*file \"%s\" not found*/\n", file_name);
					fprintf(stderr, "file \"%s\" not found\n", file_name);
					continue;
				}
				fseek(infile, 0, SEEK_END);
				filesize = ftell(infile);
				fseek(infile, 0, SEEK_SET);
				printf("/*file \"%s\"*/\n", argv[i]);
				if (strings/* && filesize < 8192*/)
				{
					printf("char embeddedfile_data%i[%i] =", filenum, filesize);
					filenum++;
					for(;;)
					{
						c = fread(readbuf, 1, sizeof(readbuf), infile);
						if (c < 1)
							break;
						w = 0;
						writebuf[w++] = '\n';
						writebuf[w++] = '"';
						for (j = 0;j < c;j++)
						{
							if (readbuf[j] == '?')
							{
								writebuf[w++] = '\\';
								writebuf[w++] = '?';
							}
							else if (readbuf[j] == '\\')
							{
								writebuf[w++] = '\\';
								writebuf[w++] = '\\';
							}
							else if (readbuf[j] >= ' ' && readbuf[j] <= 0x7e && readbuf[j] != '"' && readbuf[j] != '\\')
								writebuf[w++] = readbuf[j];
							else
							{
								writebuf[w++] = '\\';
								     if (readbuf[j] == '\n')
									writebuf[w++] = 'n';
								else if (readbuf[j] == '\r')
									writebuf[w++] = 'r';
								else if (readbuf[j] == '\t')
									writebuf[w++] = 't';
								else
								{
									if (readbuf[j] >= 0100 || (j < c - 1 && readbuf[j + 1] >= '0' && readbuf[j + 1] <= '9'))
									{
										writebuf[w++] = ((readbuf[j] >> 6) & 3) + '0';
										writebuf[w++] = ((readbuf[j] >> 3) & 7) + '0';
										writebuf[w++] = ((readbuf[j] >> 0) & 7) + '0';
									}
									else if (readbuf[j] >= 010)
									{
										writebuf[w++] = ((readbuf[j] >> 3) & 7) + '0';
										writebuf[w++] = ((readbuf[j] >> 0) & 7) + '0';
									}
									else
										writebuf[w++] = ((readbuf[j] >> 0) & 7) + '0';
								}
							}
						}
						writebuf[w++] = '"';
						fwrite(writebuf, 1, w, stdout);
					}
					printf(";\n\n");
				}
				else
				{
					skipstart = 1;
					printf("unsigned char embeddedfile_data%i[%i] =\n{", filenum, filesize);
					filenum++;
					for(;;)
					{
						c = fread(readbuf, 1, sizeof(readbuf), infile);
						if (c < 1)
							break;
						w = 0;
						if (skipstart)
							skipstart = 0;
						else
							writebuf[w++] = ',';
						writebuf[w++] = '\n';
						//writebuf[w++] = '\t';
						for (j = 0;j < c;j++)
						{
							if (j > 0)
							{
								writebuf[w++] = ',';
								//writebuf[w++] = ' ';
							}
							if (hex)
							{
								writebuf[w++] = '0';
								writebuf[w++] = 'x';
								writebuf[w++] = nibbletohex[(readbuf[j] >> 4) & 15];
								writebuf[w++] = nibbletohex[readbuf[j] & 15];
							}
							else
							{
								if (readbuf[j] >= 100)
								{
									writebuf[w++] = '0' + ((readbuf[j] / 100));
									writebuf[w++] = '0' + ((readbuf[j] / 10) % 10);
									writebuf[w++] = '0' + ((readbuf[j]) % 10);
								}
								else if (readbuf[j] >= 10)
								{
									writebuf[w++] = '0' + (readbuf[j] / 10);
									writebuf[w++] = '0' + ((readbuf[j]) % 10);
								}
								else
									writebuf[w++] = '0' + readbuf[j];
							}
						}
						fwrite(writebuf, 1, w, stdout);
					}
					printf("\n};\n\n");
				}
				fclose(infile);
			}
		}
		printf("embeddedfile_t embeddedfile[%i] =\n{\n", filenum + 1);
		filenum = 0;
		base = NULL;
		for (i = 1;i < argc;i++)
		{
			if (!strncmp(argv[i], "-base=", 6))
				base = strchr (argv[i], '=') + 1;
			else if (strcmp(argv[i], "-strings") && strcmp(argv[i], "-array") && strcmp(argv[i], "-hexarray") && strncmp(argv[i], "-base=", 6))
			{
				if (base)
					snprintf(file_name, sizeof (file_name), "%s/%s", base, argv[i]);
				else
					snprintf(file_name, sizeof (file_name), "%s", argv[i]);
				if ((infile = fopen(file_name, "rb")))
				{
					fseek(infile, 0, SEEK_END);
					filesize = ftell(infile);
					printf("\t{\"%s\", embeddedfile_data%i, %i},\n", argv[i], filenum, filesize);
					filenum++;
					fclose(infile);
				}
				else
					printf("/*file \"%s\" not found*/\n", file_name);
			}
		}
		printf("\t{0, 0, 0}\n};\n");
		return 0;
	}

	fprintf(stderr, "usage: %s [options] inputfiles\nOptions:\n-strings   output strings with escape codes\n-array    output an array of bytes as decimal\n-hexarray    output an array of bytes as hexidecimal\n", argv[0]);
	return 1;
}

