/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	COMMON.H - Common main definitions.
*/

#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "dmunix.h"
#include "ctemplate.h"


/*
	the global definitions
*/
#define INFO_VERSION "4.0"
#define LISTSIZE 300
#define ENTRYSIZE (LISTSIZE/6)

typedef int16_t  BCINT;
typedef uint16_t UBCINT;
typedef uint8_t  UBYTE;
typedef int32_t  BCLNG;


/*
	syntactic sugar
*/
typedef UBYTE Bool; /* Boolean data: true or false */

/* boolean constants */
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif


/*
	Description of the command line arguments and config file keywords
*/
typedef struct
{
	char *short_name;   /* abbreviated command line argument */
	char *long_name;    /* command line arg. or keyword */
	enum {              /* type of this option: */
		OPT_BOOLEAN,      /* boolean (toggle) */
		OPT_INTEGER,      /* integer number */
		OPT_STRING,       /* character string */
		OPT_STRINGACC,    /* character string, but store in a list */
		OPT_STRINGLIST,   /* list of character strings */
		OPT_END           /* end of the options description */
	}     opt_type;
	char *msg_if_true;  /* message printed if option is true */
	char *msg_if_false; /* message printed if option is false */
	void *data_ptr;     /* pointer to the data */
} OptDesc;


/*
	the global variables
*/
extern BCINT GameVersion; /* which game and version? */
extern Bool Verb;         /* verbose logging? */
extern Bool XWik;         /* wiki template? */
extern char **Wads;       /* list of IWAD files */

extern int Weap;   /* weapon number */
extern int Clss;   /* class number */
extern int Thng;   /* thing type number */
extern int Objt;   /* object number */
extern char *Enum; /* enum string */
extern char *Stat; /* state string */
extern Bool Pain;  /* pain chance table */
extern Bool Mnst;  /* monsters pc/hp */
extern Bool AllT;  /* all thing types by number */
extern Bool AllC;  /* all thing types by class */
extern Bool AllO;  /* all mobjs */

extern TMPL_varlist *tpldata; /* template data */

extern char fieldlist[], field2list[], fieldentry[];

/*
	the global function prototypes
*/
void Common( int argc, char *argv[], char *, char *);
void ProgError( char *, ...);

#endif /* COMMON_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
