/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	MAPS.H - Common definitions for mappings.
*/

#ifndef MAPS_H_COMMON
#define MAPS_H_COMMON

#include "common.h"
#ifdef DMINFO
#include "doomdef.h"
#elif D64INFO
#include "doomdef.h"
#elif HTINFO
#include "doomdef.h"
#elif HXINFO
#include "h2def.h"
#elif SFINFO
#include "p_mobj.h"
#endif


/*
	the type definitions
*/
typedef struct mflagstr_s
{
#ifdef DMINFO
	mobjflag_t flag;
#else
	int32_t    flag;
#endif
	char       *desc;
} mflagstr_t;

typedef struct monststr_s
{
	mobjtype_t type;
	char       *desc;
} monststr_t;

extern int weaponthing[]
#ifdef HXINFO
	[NUMCLASSES]
#endif
;


/*
	the global function prototypes
*/
int Thg2Obj( int);
char *Obj2Str( mobjtype_t);
char *Wpn2Str( weapontype_t
#ifdef HXINFO
	, pclass_t
#endif
);
Bool IsWeapon( char *);
int Enum2Obj( char *);
statenum_t State2Num( char *);
void PrintFlags( int);
#if defined(HTINFO) || defined(HXINFO) || (defined(SFINFO) && defined(MOBJTRANSLATION))
void PrintFlags2( int);
#endif
char *Monst2Str( mobjtype_t);

#endif /* MAPS_H_COMMON */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
