/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	PRINT.H - Common print definitions.
*/

#ifndef PRINT_H_COMMON
#define PRINT_H_COMMON

#include "common.h"
#include "ctemplate.h"
#ifdef DMINFO
#include "p_mobj.h"
#elif D64INFO
#include "doomdef.h"
#elif HTINFO
#include "doomdef.h"
#elif HXINFO
#include "h2def.h"
#elif SFINFO
#include "p_mobj.h"
#endif


/*
	the global definitions
*/
typedef enum {
	ST_NONE,
	ST_PICKUP,
	ST_WIELD,
	ST_FIRE,
	ST_REFIRE,
	ST_FLASH,
	ST_WIELD_P,
	ST_FIRE_P,
	ST_REFIRE_P,
	ST_SPAWN,
	ST_SEE,
	ST_PAIN,
	ST_MELEE,
	ST_MISSL,
	ST_DEATH,
	ST_XDEATH,
	ST_CRASH,
	ST_RAISE
} statestr_t;


/*
	the global function prototypes
*/
void PainChances( void);
void MonstersPcHp( void);
void InitTypes( void);
void ThingTypes( void);
void ClassTypes( void);
void AppearsIn( int);

void PrintState( void);
void PrintSpawns( void);
void PrintTypeHealth( mobjinfo_t *);
void PrintDimsTimesFlags( mobjinfo_t *);
void PrintSpeed( mobjinfo_t *);
void PrintItemSprites( mobjinfo_t *);
void PrintMonsterSprites( mobjinfo_t *);
void PrintSprite( statenum_t, statestr_t, Bool);
void TallyFrames( statenum_t, Bool);
float PainPerc( int);
int PainTics( statenum_t);
TMPL_varlist *tmpl_add_int( TMPL_varlist *, char *, char *, BCLNG);
TMPL_varlist *tmpl_add_float( TMPL_varlist *, char *, char *, float);

/* implemented in game-specific print.c */
void PrintWeapon( void);
void PrintData( void);
int FrameTics( statenum_t);

#endif /* PRINT_H_COMMON */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
