/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.H - Common thing type and data definitions.
*/

#ifndef THINGS_H_COMMON
#define THINGS_H_COMMON

#include "common.h"

/*
	the global definitions
*/
enum {
	ThClassMnst, // 0
	ThClassChar, // 1
	ThClassWeap, // 2
	ThClassAmmo, // 3
	ThClassItem, // 4
	ThClassHlAr, // 5
	ThClassKeys, // 6
	ThClassObst, // 7
	ThClassDeco, // 8
	ThClassSnds, // 9
	ThClassMisc, // 10
	ThClass_End  // 11
};

/*
	the global data types and variables
*/
typedef struct
{
	UBCINT class;
	char  *wikiname;
	char  *wikilink;
	char  *wikistr;
} ThClass;

extern UBCINT NumThClasses;
extern ThClass **ThClasses;

typedef struct
{
	UBCINT class;
	UBCINT type;
	char  *wikiname;
	char  *wikilink;
	char  *wikistr;
} ThItem;

extern UBCINT NumThItems;
extern ThItem  **ThItems;


/*
	DOOM, Heretic, Hexen & Strife common Things
*/
#define THING_PLAYER1         1
#define THING_PLAYER2         2
#define THING_PLAYER3         3
#define THING_PLAYER4         4
#define THING_DEATHMATCH      11
#define THING_TELEPORT        14

/*
	Doom- and Hexen format flags
*/
#define TF_NOTSP  0x10    /* not single-player thing */
#define TF_HXNSP  0x100   /* single-player thing */
#define TF_HXNCP  0x200   /* cooperative thing */

/*
	the global function prototypes
*/
void ForgetThings( void);
void AppendClass( UBCINT, char *, char *, char *);
void AppendItem( UBCINT, UBCINT, char *, char *);
char *LookupClassName( int);
int LookupThingClass( int);
char *LookupThing( int, Bool);

#endif /* THINGS_H_COMMON */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
