/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	MAPS.C - Common code for mappings.
*/

#include <ctype.h>
#include "maps.h"
#include "info.h"


/*
	the global variables
*/
extern char *mobjstr[];
extern char *statestr[];
extern char *weaponstr[]
#ifdef HXINFO
	[NUMCLASSES]
#endif
;

extern mflagstr_t mflagstr[];
#if defined(HTINFO) || defined(HXINFO) || (defined(SFINFO) && defined(MOBJTRANSLATION))
extern mflagstr_t mflag2str[];
#endif
extern monststr_t monststr[];

extern int iNUMWEAPS;
#ifdef HXINFO
extern int iNUMCLASS;
#endif
extern int iNUMFLAGS;
#if defined(HTINFO) || defined(HXINFO) || (defined(SFINFO) && defined(MOBJTRANSLATION))
extern int iNUMFLAGS2;
#endif
extern int iNUMMONST;


/*
	search Object table for Thing number
*/
int Thg2Obj( int thng)
{
	int i;

	for (i = 0; i < NUMMOBJTYPES; i++)
		if (mobjinfo[i].doomednum == thng)
			return i;

	ProgError( "no such Thing type: %d", thng);
}

/*
	search Enum table for Enum string
*/
int Enum2Obj( char *str)
{
	int i;

	for (i = 0; i < NUMMOBJTYPES; i++)
		if (strcmp(mobjstr[i], str) == 0)
			return i;

	ProgError( "no such Enum string: %s", str);
}

/*
	search State table for State string
*/
statenum_t State2Num( char *str)
{
	int i;

	for (i = 0; i < NUMSTATES; i++)
		if (strcmp(statestr[i], str) == 0)
			return (statenum_t) i;

	ProgError( "no such State string: %s", str);
}

char *Obj2Str( mobjtype_t mobj)
{
	return mobjstr[mobj];
}

char *Wpn2Str( weapontype_t weap
#ifdef HXINFO
	, pclass_t clss
#endif
)
{
	return weaponstr[weap]
#ifdef HXINFO
	[clss]
#endif
;
}

/*
	check if Thing name is a weapon
*/
Bool IsWeapon( char *thing)
{
	int i
#ifdef HXINFO
	, j
#endif
;

	for (i = 0; i < iNUMWEAPS; i++)
#ifdef HXINFO
		for (j = 0; j < iNUMCLASS; j++)
		/* compare name but not Hexen's component postfix */
		if (strncmp( weaponstr[i][j], thing, strlen( weaponstr[i][j])) == 0)

#elif SFINFO
		/* compare name but not Strife's component postfix */
		if ((strstr(weaponstr[i], " (") || strstr(thing, " (")) &&
		    (strlen( weaponstr[i]) < strlen( thing) && strncmp( weaponstr[i], thing, strlen( weaponstr[i])) == 0 ||
		     strlen( weaponstr[i]) >= strlen( thing) && strncmp( weaponstr[i], thing, strlen( thing)) == 0) ||
		    strcmp( weaponstr[i], "The Sigil") == 0 && strncmp( thing, "Sigil ", 6) == 0 && isdigit(thing[6]) ||
		    strcmp( weaponstr[i], thing) == 0)

#else
		/* otherwise simply compare whole name */
		if (strcmp( weaponstr[i], thing) == 0)
#endif
			return TRUE;

	return FALSE;
}


/*
	print Mobj flag(s) with their description(s)
*/
void PrintFlags( int flags)
{
	int i;
	Bool first = TRUE;

	memset( fieldlist, 0, LISTSIZE);
	for (i = 0; i < iNUMFLAGS; i++)
		if (flags & mflagstr[i].flag)
			if (XWik)
			{
				if (first)
					first = FALSE;
				else
					strcat( fieldlist, "<br>");
				sprintf( fieldentry, "%2d: %s", i, mflagstr[i].desc);
				strcat( fieldlist, fieldentry);
			}
			else
			{
				printf( "  %2d: %s\n", i, mflagstr[i].desc);
			}

	if (XWik)
		tpldata = TMPL_add_var( tpldata, "FLAGLIST", fieldlist, NULL);
}

#if defined(HTINFO) || defined(HXINFO) || (defined(SFINFO) && defined(MOBJTRANSLATION))

void PrintFlags2( int flags2)
{
	int i;
	Bool first = TRUE;

	memset( fieldlist, 0, LISTSIZE);
	for (i = 0; i < iNUMFLAGS2; i++)
		if (flags2 & mflag2str[i].flag)
			if (XWik)
			{
				if (first)
					first = FALSE;
				else
					strcat( fieldlist, "<br>");
				sprintf( fieldentry, "%2d: %s", i, mflag2str[i].desc);
				strcat( fieldlist, fieldentry);
			}
			else
			{
				printf( "  %2d: %s\n", i, mflag2str[i].desc);
			}

	if (XWik)
		tpldata = TMPL_add_var( tpldata, "FLAGLIST2", fieldlist, NULL);
}

#endif

/*
	search Monsters table for type
*/
char *Monst2Str( mobjtype_t monst)
{
	int i;

	for (i = 0; i < iNUMMONST; i++)
		if (monststr[i].type == monst)
			return monststr[i].desc;

	return "";
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
