/*
	DooM 64 INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	MAPS.C - Mappings of enums to strings.
*/

#include "../common/maps.h"

char *mobjstr[] = {
	"MT_PLAYER",
	"MT_PLAYERBOT1",
	"MT_PLAYERBOT2",
	"MT_PLAYERBOT3",
	"MT_DEMON1",
	"MT_DEMON2",
	"MT_MANCUBUS",
	"MT_POSSESSED1",
	"MT_POSSESSED2",
	"MT_IMP1",
	"MT_IMP2",
	"MT_CACODEMON",
	"MT_BRUISER1",
	"MT_BRUISER2",
	"MT_SKULL",
	"MT_BABY",
	"MT_CYBORG",
	"MT_CYBORG_TITLE",
	"MT_PAIN",
	"MT_RESURRECTOR",
	"MT_CAMERA",
	"MT_DEST_TELEPORT",
	"MT_DEST_PROJECTILE",
	"MT_FAKEITEM",
	"MT_LASERMARKER",
	"MT_PROJ_ROCKET",
	"MT_PROJ_PLASMA",
	"MT_PROJ_BFG",
	"MT_PROJ_LASER",
	"MT_PROJ_IMP1",
	"MT_PROJ_IMP2",
	"MT_PROJ_HEAD",
	"MT_PROJ_BRUISER1",
	"MT_PROJ_BRUISER2",
	"MT_PROJ_BABY",
	"MT_PROJ_FATSO",
	"MT_PROJ_TRACER",
	"MT_PROJ_DART",
	"MT_PROJ_RECTFIRE",
	"MT_PROJ_RECT",
	"MT_SMOKE_GRAY",
	"MT_SMOKE_RED",
	"MT_SMOKE_SMALL",
	"MT_BLOOD",
	"MT_GIB_CRUSHED",
	"MT_TELEPORTFOG",
	"MT_BFGSPREAD",
	"MT_ITEM_ARMOR1",
	"MT_ITEM_ARMOR2",
	"MT_ITEM_BONUSHEALTH",
	"MT_ITEM_BONUSARMOR",
	"MT_ITEM_BLUECARDKEY",
	"MT_ITEM_REDCARDKEY",
	"MT_ITEM_YELLOWCARDKEY",
	"MT_ITEM_YELLOWSKULLKEY",
	"MT_ITEM_REDSKULLKEY",
	"MT_ITEM_BLUESKULLKEY",
	"MT_ITEM_ARTIFACT1",
	"MT_ITEM_ARTIFACT2",
	"MT_ITEM_ARTIFACT3",
	"MT_ITEM_STIMPACK",
	"MT_ITEM_MEDKIT",
	"MT_ITEM_SOULSPHERE",
	"MT_ITEM_INVULSPHERE",
	"MT_ITEM_BERSERK",
	"MT_ITEM_INVISSPHERE",
	"MT_ITEM_RADSPHERE",
	"MT_ITEM_AUTOMAP",
	"MT_ITEM_PVIS",
	"MT_ITEM_MEGASPHERE",
	"MT_AMMO_CLIP",
	"MT_AMMO_CLIPBOX",
	"MT_AMMO_ROCKET",
	"MT_AMMO_ROCKETBOX",
	"MT_AMMO_CELL",
	"MT_AMMO_CELLPACK",
	"MT_AMMO_SHELL",
	"MT_AMMO_SHELLBOX",
	"MT_AMMO_BACKPACK",
	"MT_WEAP_BFG",
	"MT_WEAP_CHAINSAW",
	"MT_WEAP_CHAINGUN",
	"MT_WEAP_LAUNCHER",
	"MT_WEAP_PLASMA",
	"MT_WEAP_SHOTGUN",
	"MT_WEAP_SSHOTGUN",
	"MT_WEAP_LCARBINE",
	"MT_PROP_FIRE",
	"MT_PROP_CANDLE",
	"MT_PROP_BARREL",
	"MT_EXPLOSION1",
	"MT_EXPLOSION2",
	"MT_PROP_TECHLAMP1",
	"MT_PROP_TECHLAMP2",
	"MT_PROP_TORCHBLUE",
	"MT_PROP_TORCHYELLOW",
	"MT_PROP_TORCHRED",
	"MT_PROP_POLEBASELONG",
	"MT_PROP_POLEBASESHORT",
	"MT_PROP_FIREBLUE",
	"MT_PROP_FIRERED",
	"MT_PROP_FIREYELLOW",
	"MT_GIB_MEATSTICK",
	"MT_GIB_MEATHANG",
	"MT_GIB_TORSOHANG",
	"MT_GIB_RIBFLOOR",
	"MT_GIB_TWITCHFLOOR",
	"MT_GIB_BLOODPOOL",
	"MT_GIB_BONEFLOOR",
	"MT_GIB_MEATRIBFLOOR",
	"MT_GIB_MEATRIBCAGE",
	"MT_GIB_CHAINHOOK",
	"MT_GIB_HANGCAGE",
	"MT_GIB_CHAINPINSER",
	"MT_GIB_CHAINARM",
	"MT_GIB_HANGMACE1",
	"MT_GIB_HEADSTICK1",
	"MT_GIB_HEADSTICK2",
	"MT_GIB_DOUBLEMEATSTICK",
	"MT_PROP_STATUE1",
	"MT_PROP_STATUE2",
	"MT_PROP_TECHPOLELONG",
	"MT_PROP_TECHPOLESHORT",
	"MT_PROP_TREESTUMPSMALL",
	"MT_PROP_TREESTUMPLARGE",
	"MT_PROP_TREE",
	"MT_PROP_BLOODYPOLE",
	"MT_GIB_HANGMACE2",
	"MT_GIB_HANGWHITEMEAT",
	"MT_GIB_HANGHEAD",
	"MT_GIB_HANGRIB"
};

char *statestr[] = {
	"S_000",
	"S_001",
	"S_002",
	"S_003",
	"S_004",
	"S_005",
	"S_006",
	"S_007",
	"S_008",
	"S_009",
	"S_010",
	"S_011",
	"S_012",
	"S_013",
	"S_014",
	"S_015",
	"S_016",
	"S_017",
	"S_018",
	"S_019",
	"S_020",
	"S_021",
	"S_022",
	"S_023",
	"S_024",
	"S_025",
	"S_026",
	"S_027",
	"S_028",
	"S_029",
	"S_030",
	"S_031",
	"S_032",
	"S_033",
	"S_034",
	"S_035",
	"S_036",
	"S_037",
	"S_038",
	"S_039",
	"S_040",
	"S_041",
	"S_042",
	"S_043",
	"S_044",
	"S_045",
	"S_046",
	"S_047",
	"S_048",
	"S_049",
	"S_050",
	"S_051",
	"S_052",
	"S_053",
	"S_054",
	"S_055",
	"S_056",
	"S_057",
	"S_058",
	"S_059",
	"S_060",
	"S_061",
	"S_062",
	"S_063",
	"S_064",
	"S_065",
	"S_066",
	"S_067",
	"S_068",
	"S_069",
	"S_070",
	"S_071",
	"S_072",
	"S_073",
	"S_074",
	"S_075",
	"S_076",
	"S_077",
	"S_078",
	"S_079",
	"S_080",
	"S_081",
	"S_082",
	"S_083",
	"S_084",
	"S_085",
	"S_086",
	"S_087",
	"S_088",
	"S_089",
	"S_090",
	"S_091",
	"S_092",
	"S_093",
	"S_094",
	"S_095",
	"S_096",
	"S_097",
	"S_098",
	"S_099",
	"S_100",
	"S_101",
	"S_102",
	"S_103",
	"S_104",
	"S_105",
	"S_106",
	"S_107",
	"S_108",
	"S_109",
	"S_110",
	"S_111",
	"S_112",
	"S_113",
	"S_114",
	"S_115",
	"S_116",
	"S_117",
	"S_118",
	"S_119",
	"S_120",
	"S_121",
	"S_122",
	"S_123",
	"S_124",
	"S_125",
	"S_126",
	"S_127",
	"S_128",
	"S_129",
	"S_130",
	"S_131",
	"S_132",
	"S_133",
	"S_134",
	"S_135",
	"S_136",
	"S_137",
	"S_138",
	"S_139",
	"S_140",
	"S_141",
	"S_142",
	"S_143",
	"S_144",
	"S_145",
	"S_146",
	"S_147",
	"S_148",
	"S_149",
	"S_150",
	"S_151",
	"S_152",
	"S_153",
	"S_154",
	"S_155",
	"S_156",
	"S_157",
	"S_158",
	"S_159",
	"S_160",
	"S_161",
	"S_162",
	"S_163",
	"S_164",
	"S_165",
	"S_166",
	"S_167",
	"S_168",
	"S_169",
	"S_170",
	"S_171",
	"S_172",
	"S_173",
	"S_174",
	"S_175",
	"S_176",
	"S_177",
	"S_178",
	"S_179",
	"S_180",
	"S_181",
	"S_182",
	"S_183",
	"S_184",
	"S_185",
	"S_186",
	"S_187",
	"S_188",
	"S_189",
	"S_190",
	"S_191",
	"S_192",
	"S_193",
	"S_194",
	"S_195",
	"S_196",
	"S_197",
	"S_198",
	"S_199",
	"S_200",
	"S_201",
	"S_202",
	"S_203",
	"S_204",
	"S_205",
	"S_206",
	"S_207",
	"S_208",
	"S_209",
	"S_210",
	"S_211",
	"S_212",
	"S_213",
	"S_214",
	"S_215",
	"S_216",
	"S_217",
	"S_218",
	"S_219",
	"S_220",
	"S_221",
	"S_222",
	"S_223",
	"S_224",
	"S_225",
	"S_226",
	"S_227",
	"S_228",
	"S_229",
	"S_230",
	"S_231",
	"S_232",
	"S_233",
	"S_234",
	"S_235",
	"S_236",
	"S_237",
	"S_238",
	"S_239",
	"S_240",
	"S_241",
	"S_242",
	"S_243",
	"S_244",
	"S_245",
	"S_246",
	"S_247",
	"S_248",
	"S_249",
	"S_250",
	"S_251",
	"S_252",
	"S_253",
	"S_254",
	"S_255",
	"S_256",
	"S_257",
	"S_258",
	"S_259",
	"S_260",
	"S_261",
	"S_262",
	"S_263",
	"S_264",
	"S_265",
	"S_266",
	"S_267",
	"S_268",
	"S_269",
	"S_270",
	"S_271",
	"S_272",
	"S_273",
	"S_274",
	"S_275",
	"S_276",
	"S_277",
	"S_278",
	"S_279",
	"S_280",
	"S_281",
	"S_282",
	"S_283",
	"S_284",
	"S_285",
	"S_286",
	"S_287",
	"S_288",
	"S_289",
	"S_290",
	"S_291",
	"S_292",
	"S_293",
	"S_294",
	"S_295",
	"S_296",
	"S_297",
	"S_298",
	"S_299",
	"S_300",
	"S_301",
	"S_302",
	"S_303",
	"S_304",
	"S_305",
	"S_306",
	"S_307",
	"S_308",
	"S_309",
	"S_310",
	"S_311",
	"S_312",
	"S_313",
	"S_314",
	"S_315",
	"S_316",
	"S_317",
	"S_318",
	"S_319",
	"S_320",
	"S_321",
	"S_322",
	"S_323",
	"S_324",
	"S_325",
	"S_326",
	"S_327",
	"S_328",
	"S_329",
	"S_330",
	"S_331",
	"S_332",
	"S_333",
	"S_334",
	"S_335",
	"S_336",
	"S_337",
	"S_338",
	"S_339",
	"S_340",
	"S_341",
	"S_342",
	"S_343",
	"S_344",
	"S_345",
	"S_346",
	"S_347",
	"S_348",
	"S_349",
	"S_350",
	"S_351",
	"S_352",
	"S_353",
	"S_354",
	"S_355",
	"S_356",
	"S_357",
	"S_358",
	"S_359",
	"S_360",
	"S_361",
	"S_362",
	"S_363",
	"S_364",
	"S_365",
	"S_366",
	"S_367",
	"S_368",
	"S_369",
	"S_370",
	"S_371",
	"S_372",
	"S_373",
	"S_374",
	"S_375",
	"S_376",
	"S_377",
	"S_378",
	"S_379",
	"S_380",
	"S_381",
	"S_382",
	"S_383",
	"S_384",
	"S_385",
	"S_386",
	"S_387",
	"S_388",
	"S_389",
	"S_390",
	"S_391",
	"S_392",
	"S_393",
	"S_394",
	"S_395",
	"S_396",
	"S_397",
	"S_398",
	"S_399",
	"S_400",
	"S_401",
	"S_402",
	"S_403",
	"S_404",
	"S_405",
	"S_406",
	"S_407",
	"S_408",
	"S_409",
	"S_410",
	"S_411",
	"S_412",
	"S_413",
	"S_414",
	"S_415",
	"S_416",
	"S_417",
	"S_418",
	"S_419",
	"S_420",
	"S_421",
	"S_422",
	"S_423",
	"S_424",
	"S_425",
	"S_426",
	"S_427",
	"S_428",
	"S_429",
	"S_430",
	"S_431",
	"S_432",
	"S_433",
	"S_434",
	"S_435",
	"S_436",
	"S_437",
	"S_438",
	"S_439",
	"S_440",
	"S_441",
	"S_442",
	"S_443",
	"S_444",
	"S_445",
	"S_446",
	"S_447",
	"S_448",
	"S_449",
	"S_450",
	"S_451",
	"S_452",
	"S_453",
	"S_454",
	"S_455",
	"S_456",
	"S_457",
	"S_458",
	"S_459",
	"S_460",
	"S_461",
	"S_462",
	"S_463",
	"S_464",
	"S_465",
	"S_466",
	"S_467",
	"S_468",
	"S_469",
	"S_470",
	"S_471",
	"S_472",
	"S_473",
	"S_474",
	"S_475",
	"S_476",
	"S_477",
	"S_478",
	"S_479",
	"S_480",
	"S_481",
	"S_482",
	"S_483",
	"S_484",
	"S_485",
	"S_486",
	"S_487",
	"S_488",
	"S_489",
	"S_490",
	"S_491",
	"S_492",
	"S_493",
	"S_494",
	"S_495",
	"S_496",
	"S_497",
	"S_498",
	"S_499",
	"S_500",
	"S_501",
	"S_502",
	"S_503",
	"S_504",
	"S_505",
	"S_506",
	"S_507",
	"S_508",
	"S_509",
	"S_510",
	"S_511",
	"S_512",
	"S_513",
	"S_514",
	"S_515",
	"S_516",
	"S_517",
	"S_518",
	"S_519",
	"S_520",
	"S_521",
	"S_522",
	"S_523",
	"S_524",
	"S_525",
	"S_526",
	"S_527",
	"S_528",
	"S_529",
	"S_530",
	"S_531",
	"S_532",
	"S_533",
	"S_534",
	"S_535",
	"S_536",
	"S_537",
	"S_538",
	"S_539",
	"S_540",
	"S_541",
	"S_542",
	"S_543",
	"S_544",
	"S_545",
	"S_546",
	"S_547",
	"S_548",
	"S_549",
	"S_550",
	"S_551",
	"S_552",
	"S_553",
	"S_554",
	"S_555",
	"S_556",
	"S_557",
	"S_558",
	"S_559",
	"S_560",
	"S_561",
	"S_562",
	"S_563",
	"S_564",
	"S_565",
	"S_566",
	"S_567",
	"S_568",
	"S_569",
	"S_570",
	"S_571",
	"S_572",
	"S_573",
	"S_574",
	"S_575",
	"S_576",
	"S_577",
	"S_578",
	"S_579",
	"S_580",
	"S_581",
	"S_582",
	"S_583",
	"S_584",
	"S_585",
	"S_586",
	"S_587",
	"S_588",
	"S_589",
	"S_590",
	"S_591",
	"S_592",
	"S_593",
	"S_594",
	"S_595",
	"S_596",
	"S_597",
	"S_598",
	"S_599",
	"S_600",
	"S_601",
	"S_602",
	"S_603",
	"S_604",
	"S_605",
	"S_606",
	"S_607",
	"S_608",
	"S_609",
	"S_610",
	"S_611",
	"S_612",
	"S_613",
	"S_614",
	"S_615",
	"S_616",
	"S_617",
	"S_618",
	"S_619",
	"S_620",
	"S_621",
	"S_622",
	"S_623",
	"S_624",
	"S_625",
	"S_626",
	"S_627",
	"S_628",
	"S_629",
	"S_630",
	"S_631",
	"S_632",
	"S_633",
	"S_634",
	"S_635",
	"S_636",
	"S_637",
	"S_638",
	"S_639",
	"S_640",
	"S_641",
	"S_642",
	"S_643",
	"S_644",
	"S_645",
	"S_646",
	"S_647",
	"S_648",
	"S_649",
	"S_650",
	"S_651",
	"S_652",
	"S_653",
	"S_654",
	"S_655",
	"S_656",
	"S_657",
	"S_658",
	"S_659",
	"S_660",
	"S_661",
	"S_662",
	"S_663",
	"S_664",
	"S_665",
	"S_666",
	"S_667",
	"S_668",
	"S_669",
	"S_670",
	"S_671",
	"S_672",
	"S_673",
	"S_674",
	"S_675",
	"S_676",
	"S_677",
	"S_678",
	"S_679",
	"S_680",
	"S_681",
	"S_682",
	"S_683",
	"S_684",
	"S_685",
	"S_686",
	"S_687",
	"S_688",
	"S_689",
	"S_690",
	"S_691",
	"S_692",
	"S_693",
	"S_694",
	"S_695",
	"S_696",
	"S_697",
	"S_698",
	"S_699",
	"S_700",
	"S_701",
	"S_702",
	"S_703",
	"S_704",
	"S_705",
	"S_706",
	"S_707",
	"S_708",
	"S_709",
	"S_710",
	"S_711",
	"S_712",
	"S_713",
	"S_714",
	"S_715",
	"S_716",
	"S_717",
	"S_718",
	"S_719",
	"S_720",
	"S_721",
	"S_722",
	"S_723",
	"S_724",
	"S_725",
	"S_726",
	"S_727",
	"S_728",
	"S_729",
	"S_730",
	"S_731",
	"S_732",
	"S_733",
	"S_734",
	"S_735",
	"S_736",
	"S_737",
	"S_738",
	"S_739",
	"S_740",
	"S_741",
	"S_742",
	"S_743",
	"S_744",
	"S_745",
	"S_746",
	"S_747",
	"S_748",
	"S_749",
	"S_750",
	"S_751",
	"S_752",
	"S_753",
	"S_754",
	"S_755",
	"S_756",
	"S_757",
	"S_758",
	"S_759",
	"S_760",
	"S_761",
	"S_762",
	"S_763",
	"S_764",
	"S_765",
	"S_766",
	"S_767",
	"S_768",
	"S_769",
	"S_770",
	"S_771",
	"S_772",
	"S_773",
	"S_774",
	"S_775",
	"S_776",
	"S_777",
	"S_778",
	"S_779",
	"S_780",
	"S_781",
	"S_782",
	"S_783",
	"S_784",
	"S_785",
	"S_786",
	"S_787",
	"S_788",
	"S_789",
	"S_790",
	"S_791",
	"S_792",
	"S_793",
	"S_794",
	"S_795",
	"S_796"
};


#define NUMWEAPS 10
int iNUMWEAPS = NUMWEAPS;

char *weaponstr[NUMWEAPS] = {
	"Chainsaw",
	"Fist",
	"Pistol",
	"Shotgun",
	"Super shotgun",
	"Chaingun",
	"Rocket launcher",
	"Plasma gun",
	"BFG9000",
	"Unmaker",
};

int weaponthing[NUMWEAPS] = {
	2005, // chainsaw
	-1,   // fist
	-1,   // pistol
	2001, // shotgun
	82,   // super shotgun
	2002, // chaingun
	2003, // rocket launcher
	2004, // plasma gun
	2006, // BFG9000
	84,   // Unmaker
};


#define NUMFLAGS 32
int iNUMFLAGS = NUMFLAGS;

mflagstr_t mflagstr[NUMFLAGS] = {
/*  0 */ { MF_SPECIAL     , "Can be picked up" },
/*  1 */ { MF_SOLID       , "Obstacle" },
/*  2 */ { MF_SHOOTABLE   , "Shootable" },
/*  3 */ { MF_NOSECTOR    , "No sector links (Invisible)" },
/*  4 */ { MF_NOBLOCKMAP  , "No blocklinks (Inert)" },
/*  5 */ { MF_AMBUSH      , "Ambush (Semi-deaf)" },
/*  6 */ { MF_JUSTHIT     , "Just hit (In pain)" },
/*  7 */ { MF_JUSTATTACKED, "Just attacked (Step first)" },
/*  8 */ { MF_SPAWNCEILING, "Hangs from ceiling" },
/*  9 */ { MF_GRAVITY     , "Apply gravity" },
/* 10 */ { MF_DROPOFF     , "Drops off ledges" },
/* 11 */ { MF_PICKUP      , "Picks up [[item]]s" },
/* 12 */ { MF_NOCLIP      , "No clipping" },
/* 13 */ { MF_TRIGDEATH   , "Trigger line on death" },
/* 14 */ { MF_FLOAT       , "Floating" },
/* 15 */ { MF_TELEPORT    , "No line crossing" },
/* 16 */ { MF_MISSILE     , "Projectile" },
/* 17 */ { MF_DROPPED     , "Dropped by enemy" },
/* 18 */ { MF_TRIGTOUCH   , "Trigger line on touch/pickup" },
/* 19 */ { MF_NOBLOOD     , "Puffs vs. blood" },
/* 20 */ { MF_CORPSE      , "Sliding corpse" },
/* 21 */ { MF_INFLOAT     , "No auto-leveling" },
/* 22 */ { MF_COUNTKILL   , "Affects kill %" },
/* 23 */ { MF_COUNTITEM   , "Affects item %" },
/* 24 */ { MF_SKULLFLY    , "Flying skull" },
/* 25 */ { MF_NOTDMATCH   , "Not in [[deathmatch]]" },
/* 26 */ { MF_SEETARGET   , "Target visible?" },
/* 27 */ { MF_COUNTSECRET , "Count secret upon pickup" },
/* 28 */ { MF_RENDERLASER , "Render laser (Unmaker)" },
/* 29 */ { MF_NIGHTMARE   , "Nightmare mode" },
/* 30 */ { MF_SHADOW      , "Partial [[translucency]]" },
/* 31 */ { MF_NOINFIGHTING, "No infighting" },
};


#define NUMMONST 16
int iNUMMONST = NUMMONST;

monststr_t monststr[NUMMONST] = {
	{ MT_POSSESSED1 , "Zombieman" },
	{ MT_POSSESSED2 , "Shotgun guy" },
	{ MT_MANCUBUS   , "Mancubus" },
	{ MT_IMP1       , "Imp" },
	{ MT_IMP2       , "Nightmare imp" },
	{ MT_DEMON1     , "Demon" },
	{ MT_DEMON2     , "Spectre" },
	{ MT_CACODEMON  , "Cacodemon" },
	{ MT_BRUISER1   , "Baron of Hell" },
	{ MT_BRUISER2   , "Hell knight" },
	{ MT_SKULL      , "Lost soul" },
	{ MT_BABY       , "Arachnotron" },
	{ MT_CYBORG     , "Cyberdemon" },
	{ MT_PAIN       , "Pain elemental" },
	{ MT_RESURRECTOR, "Mother demon" },
	{ MT_PROP_BARREL, "Barrel" },
};

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
