/*
	DooM 64 INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "things.h"
#include "../common/things.h"


/*
	initialize Doom 64 thing classes and items
*/
void InitDoom64Things( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo", NULL);
	AppendClass( ThClassItem, "Artifact items", "Item#Doom games", NULL);
	AppendClass( ThClassHlAr, "Powerups", "Item#Doom games", NULL);
	AppendClass( ThClassKeys, "Keys", "Key", NULL);
	AppendClass( ThClassObst, "Obstacles", NULL, NULL);
	AppendClass( ThClassDeco, "Decorations", NULL, NULL);
	AppendClass( ThClassMisc, "Other", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_HUMAN, "Zombieman", ""); // 20
	AppendItem( ThClassMnst, THING_SERGEANT, "Shotgun guy", ""); // 30
	AppendItem( ThClassMnst, THING_IMP, "Imp", ""); // 60
	AppendItem( ThClassMnst, THING_NIGHTMAREIMP, "Nightmare imp", ""); // 60, Doom 64
	AppendItem( ThClassMnst, THING_LOSTSOUL, "Lost soul", ""); // 100
	AppendItem( ThClassMnst, THING_DEMON, "Demon", ""); // 150
	AppendItem( ThClassMnst, THING_SPECTRE, "Spectre", ""); // 150
	AppendItem( ThClassMnst, THING_CACODEMON, "Cacodemon", ""); // 400
	AppendItem( ThClassMnst, THING_PAINELEM, "Pain elemental", ""); // 400
	AppendItem( ThClassMnst, THING_KNIGHT, "Hell knight", ""); // 500
	AppendItem( ThClassMnst, THING_BARON, "Baron of Hell", ""); // 1000
	AppendItem( ThClassMnst, THING_ARACHNO, "Arachnotron", ""); // 500
	AppendItem( ThClassMnst, THING_MANCUBUS, "Mancubus", ""); // 600
	AppendItem( ThClassMnst, THING_CYBERDEMON, "Cyberdemon", ""); // 4000
	AppendItem( ThClassMnst, THING_RESURRECTOR, "Mother demon", ""); // 5000, Doom 64

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CHAINSAW, "Chainsaw", "");
	AppendItem( ThClassWeap, THING_SHOTGUN, "Shotgun", "");
	AppendItem( ThClassWeap, THING_COMBATGUN, "Super shotgun", "");
	AppendItem( ThClassWeap, THING_CHAINGUN, "Chaingun", "");
	AppendItem( ThClassWeap, THING_LAUNCHER, "Rocket launcher", "");
	AppendItem( ThClassWeap, THING_PLASMAGUN, "Plasma gun", "");
	AppendItem( ThClassWeap, THING_BFG9000, "BFG9000", "");
	AppendItem( ThClassWeap, THING_64_LASER, "Unmaker", ""); // Doom 64

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_AMMOCLIP, "Clip", "");
	AppendItem( ThClassAmmo, THING_AMMOBOX, "Box of bullets", "");
	AppendItem( ThClassAmmo, THING_SHELLS, "4 shotgun shells", "");
	AppendItem( ThClassAmmo, THING_SHELLBOX, "Box of shotgun shells", "");
	AppendItem( ThClassAmmo, THING_ROCKET, "Rocket", "");
	AppendItem( ThClassAmmo, THING_ROCKETBOX, "Box of rockets", "");
	AppendItem( ThClassAmmo, THING_ENERGYCELL, "Energy cell", "Energy cell (Doom)");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy cell pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_STIMPACK, "Stimpack", "");
	AppendItem( ThClassHlAr, THING_MEDIKIT, "Medikit", "");
	AppendItem( ThClassHlAr, THING_GREENARMOR, "Armor", "");
	AppendItem( ThClassHlAr, THING_BLUEARMOR, "Megaarmor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_ARMBONUS1, "Armor bonus", "");
	AppendItem( ThClassItem, THING_HLTBONUS1, "Health bonus", "");
	AppendItem( ThClassItem, THING_SOULSPHERE, "Supercharge", "");
	AppendItem( ThClassItem, THING_MEGASPHERE, "Megasphere", "");
	AppendItem( ThClassHlAr, THING_BACKPACK, "Backpack", "");
	AppendItem( ThClassItem, THING_BERSERK, "Berserk", "");
	AppendItem( ThClassItem, THING_COMPMAP, "Computer area map", "");
	AppendItem( ThClassItem, THING_INVULN, "Invulnerability", "");
	AppendItem( ThClassItem, THING_LITEAMP, "Light amplification visor", "");
	AppendItem( ThClassItem, THING_BLURSPHERE, "Partial invisibility", "");
	AppendItem( ThClassHlAr, THING_RADSUIT, "Radiation shielding suit", "");
	AppendItem( ThClassItem, THING_ARTIFACT1, "Orange demon key", "Demon Key"); // Doom 64
	AppendItem( ThClassItem, THING_ARTIFACT2, "Cyan demon key", "Demon Key"); // Doom 64
	AppendItem( ThClassItem, THING_ARTIFACT3, "Purple demon key", "Demon Key"); // Doom 64

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUECARD, "Blue keycard", "");
	AppendItem( ThClassKeys, THING_BLUESKULLKEY, "Blue skull key", "");
	AppendItem( ThClassKeys, THING_REDCARD, "Red keycard", "");
	AppendItem( ThClassKeys, THING_REDSKULLKEY, "Red skull key", "");
	AppendItem( ThClassKeys, THING_YELLOWCARD, "Yellow keycard", "");
	AppendItem( ThClassKeys, THING_YELLOWSKULLKEY, "Yellow skull key", "");

	/* initialize Doom 64 specials */
	AppendItem( ThClassMisc, THING_64_BARREL, "Exploding barrel", "Barrel");
	AppendItem( ThClassMisc, THING_64_CAMERA, "Camera", "");
	AppendItem( ThClassMisc, THING_64_PROJSPOT, "Projectile spot", NULL);
	AppendItem( ThClassMisc, THING_64_TRIGGER, "Trigger", NULL);
	AppendItem( ThClassMisc, THING_64_LASERMARKER, "Laser marker", NULL);
	AppendItem( ThClassMisc, THING_64_TITLECYBER, "Cyberdemon dummy", NULL);
	AppendItem( ThClassMisc, THING_64_MARINE_RED, "Red marine bot", "Marine (Doom 64)");
	AppendItem( ThClassMisc, THING_64_MARINE_AQUA, "Aqua marine bot", "Marine (Doom 64)");
	AppendItem( ThClassMisc, THING_64_MARINE_GREEN, "Green marine bot", "Marine (Doom 64)");

	/* initialize Doom 64 obstacles/decorations */
	AppendItem( ThClassObst, THING_64_TORCHBASELONG, "Long torch base", NULL);
	AppendItem( ThClassObst, THING_64_TORCHBASESHORT, "Short torch base", NULL);
	AppendItem( ThClassObst, THING_64_GIBMEATSTICK, "Gib meat stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBSKULLSTICK, "Gib skull stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBHEADSTICK, "Gib head stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBDOUBLEMEATSTICK, "Gib double meat stick", NULL);
	AppendItem( ThClassObst, THING_64_STATUEDRAGON, "Dragon statue", NULL);
	AppendItem( ThClassObst, THING_64_STATUEDEMON, "Demon statue", NULL);
	AppendItem( ThClassObst, THING_64_TECHPOLELONG, "Tech pole, long", NULL);
	AppendItem( ThClassObst, THING_64_TECHPOLESHORT, "Tech pole, short", NULL);
	AppendItem( ThClassObst, THING_64_TREESTUMPSMALL, "Tree stump, small", NULL);
	AppendItem( ThClassObst, THING_64_TREESTUMPLARGE, "Tree stump, large", NULL);
	AppendItem( ThClassObst, THING_64_TREE, "Tree", NULL);
	AppendItem( ThClassObst, THING_64_BLOODYMETALPOLE, "Bloody metal pole", NULL);

	AppendItem( ThClassDeco, THING_CANDLE, "Candle", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD, "Pool of blood and flesh", NULL);
	AppendItem( ThClassDeco, THING_64_BIGFIRE, "Big fire", NULL);
	AppendItem( ThClassDeco, THING_64_LAMPTECHLONGHANG, "Long hanging tech lamp", NULL);
	AppendItem( ThClassDeco, THING_64_LAMPTECHSHORTHANG, "Short hanging tech lamp", NULL);
	AppendItem( ThClassDeco, THING_64_BLUETORCH, "Blue torch", NULL);
	AppendItem( ThClassDeco, THING_64_REDTORCH, "Red torch", NULL);
	AppendItem( ThClassDeco, THING_64_YELLOWTORCH, "Yellow torch", NULL);
	AppendItem( ThClassDeco, THING_64_BLUEFIRE, "Blue fire", NULL);
	AppendItem( ThClassDeco, THING_64_REDFIRE, "Red fire", NULL);
	AppendItem( ThClassDeco, THING_64_YELLOWFIRE, "Yellow fire", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATHANG, "Gib meat hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBTORSOHANG, "Gib torso hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBRIBFLOOR, "Gib rib floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBTWITCHFLOOR, "Gib twitch floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBBLOODPOOL, "Gib blood pool", NULL);
	AppendItem( ThClassDeco, THING_64_GIBBONEFLOOR, "Gib bone floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATRIBFLOOR, "Gib meat rib floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATRIBCAGE, "Gib meat rib cage", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINHOOK, "Gib chain hook", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGCAGE, "Gib hang cage", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINPINCER, "Gib chain pincer", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINARM, "Gib chain arm", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMACEBLOODY, "Gib hang mace bloody", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMACECLEAN, "Gib mace clean", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGWHITEMEAT, "Gib hang white meat", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHEADHANG, "Gib head hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGRIBROTTING, "Gib hang rib rotting", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
