/*
	DooM 64 INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.H - Thing flag definitions.
*/

#ifndef THINGS_H
#define THINGS_H

/*
	the global function prototypes
*/
void InitDoom64Things( void);


/* DOOM Things */

/* Enemies */
#define THING_HUMAN           3004
#define THING_SERGEANT        9
#define THING_IMP             3001
#define THING_NIGHTMAREIMP    3007  /* 64 */
#define THING_LOSTSOUL        3006
#define THING_DEMON           3002
#define THING_SPECTRE         58
#define THING_CACODEMON       3005
#define THING_PAINELEM        71    /* ][ */
#define THING_KNIGHT          69    /* ][ */
#define THING_BARON           3003
#define THING_ARACHNO         68    /* ][ */
#define THING_MANCUBUS        67    /* ][ */
#define THING_CYBERDEMON      16
#define THING_RESURRECTOR     3013  /* 64 */

/* Weapons & ammo */
#define THING_CHAINSAW        2005
#define THING_SHOTGUN         2001
#define THING_COMBATGUN       82    /* ][ */
#define THING_CHAINGUN        2002
#define THING_LAUNCHER        2003
#define THING_PLASMAGUN       2004
#define THING_BFG9000         2006
#define THING_64_LASER        84    /* 64 */
#define THING_AMMOCLIP        2007
#define THING_AMMOBOX         2048
#define THING_SHELLS          2008
#define THING_SHELLBOX        2049
#define THING_ROCKET          2010
#define THING_ROCKETBOX       2046
#define THING_ENERGYCELL      2047
#define THING_ENERGYPACK      17

/* Enhancements & bonuses */
#define THING_STIMPACK        2011
#define THING_MEDIKIT         2012
#define THING_GREENARMOR      2018
#define THING_BLUEARMOR       2019

#define THING_ARMBONUS1       2015
#define THING_HLTBONUS1       2014
#define THING_SOULSPHERE      2013
#define THING_MEGASPHERE      83    /* ][ */
#define THING_BACKPACK        8
#define THING_BERSERK         2023
#define THING_COMPMAP         2026
#define THING_INVULN          2022
#define THING_LITEAMP         2045
#define THING_BLURSPHERE      2024
#define THING_RADSUIT         2025
#define THING_ARTIFACT1       1042  /* 64 */
#define THING_ARTIFACT2       1043  /* 64 */
#define THING_ARTIFACT3       1044  /* 64 */

/* Keys */
#define THING_BLUECARD        5
#define THING_BLUESKULLKEY    40
#define THING_YELLOWCARD      6
#define THING_YELLOWSKULLKEY  39
#define THING_REDCARD         13
#define THING_REDSKULLKEY     38

/* Doom64 Specials */
#define THING_64_BARREL       1001
#define THING_64_CAMERA       0
#define THING_64_PROJSPOT     2050
#define THING_64_TRIGGER      89
#define THING_64_LASERMARKER  90
#define THING_64_TITLECYBER   3014
#define THING_64_MARINE_RED   3008
#define THING_64_MARINE_AQUA  3009
#define THING_64_MARINE_GREEN 3010

/* Doom64 Obstacles/Decorations */
#define THING_CANDLE                34
#define THING_POOLOFBLOOD           24
#define THING_64_BIGFIRE            2051
#define THING_64_LAMPTECHLONGHANG   1015
#define THING_64_LAMPTECHSHORTHANG  1016
#define THING_64_BLUETORCH          1003
#define THING_64_REDTORCH           1025
#define THING_64_YELLOWTORCH        1039
#define THING_64_BLUEFIRE           1033
#define THING_64_REDFIRE            1034
#define THING_64_YELLOWFIRE         1035
#define THING_64_TORCHBASELONG      1050
#define THING_64_TORCHBASESHORT     1051
#define THING_64_GIBMEATSTICK       1005
#define THING_64_GIBMEATHANG        1006
#define THING_64_GIBTORSOHANG       1007
#define THING_64_GIBRIBFLOOR        1008
#define THING_64_GIBTWITCHFLOOR     1009
#define THING_64_GIBBLOODPOOL       1010
#define THING_64_GIBBONEFLOOR       1011
#define THING_64_GIBMEATRIBFLOOR    1012
#define THING_64_GIBMEATRIBCAGE     1013
#define THING_64_GIBCHAINHOOK       1014
#define THING_64_GIBHANGCAGE        1017
#define THING_64_GIBCHAINPINCER     1018
#define THING_64_GIBCHAINARM        1019
#define THING_64_GIBMACEBLOODY      1020
#define THING_64_GIBMACECLEAN       1046
#define THING_64_GIBHANGWHITEMEAT   1047
#define THING_64_GIBHEADHANG        1048
#define THING_64_GIBHANGRIBROTTING  1049
#define THING_64_GIBSKULLSTICK      1022
#define THING_64_GIBHEADSTICK       1023
#define THING_64_GIBDOUBLEMEATSTICK 1024
#define THING_64_STATUEDRAGON       1028
#define THING_64_STATUEDEMON        1029
#define THING_64_TECHPOLELONG       1031
#define THING_64_TECHPOLESHORT      1032
#define THING_64_TREESTUMPSMALL     1036
#define THING_64_TREESTUMPLARGE     1037
#define THING_64_TREE               1038
#define THING_64_BLOODYMETALPOLE    1045

#endif /* THINGS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
