/*
	HeXen INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "things.h"
#include "../common/things.h"


/*
	initialize Hexen thing classes and items
*/
void InitHexenThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Hexen", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Hexen", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Hexen", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Hexen", NULL);
	AppendClass( ThClassItem, "Items", "Item#Hexen", NULL);
	AppendClass( ThClassKeys, "Keys & Puzzle items", "Hexen keys",
	                          "[[Hexen keys|Keys]] & [[Item#Puzzle items|Puzzle items]]");
	AppendClass( ThClassObst, "Obstacles", NULL, NULL);
	AppendClass( ThClassDeco, "Decorations", NULL, NULL);
	AppendClass( ThClassSnds, "Ambient sounds", "Hexen scripted ambient sounds", NULL);
	AppendClass( ThClassMisc, "Other", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_AFRIT, "Afrit", ""); // 80
	AppendItem( ThClassMnst, THING_STALKER, "Stalker", ""); // 90
	AppendItem( ThClassMnst, THING_STALKERBOSS, "Stalker boss", "Stalker"); // 90
	AppendItem( ThClassMnst, THING_WENDIGO, "Wendigo", ""); // 120
	AppendItem( ThClassMnst, THING_DARKBISHOP, "Dark bishop", ""); // 130
	AppendItem( ThClassMnst, THING_REIVER, "Reiver", ""); // 150
	AppendItem( ThClassMnst, THING_REIVERBURIED, "Reiver (buried)", "Reiver"); // 150
	AppendItem( ThClassMnst, THING_ETTIN, "Ettin", ""); // 175
	AppendItem( ThClassMnst, THING_CENTAUR, "Centaur", ""); // 200
	AppendItem( ThClassMnst, THING_BROWNCSERP, "Brown chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_GREENCSERP, "Green chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_SLAUGHTAUR, "Slaughtaur", ""); // 250
	AppendItem( ThClassMnst, THING_DEATHWYVERN, "Death wyvern", ""); // 640
	AppendItem( ThClassMnst, THING_MENELKIR, "Menelkir", ""); // 800
	AppendItem( ThClassMnst, THING_TRADUCTUS, "Traductus", ""); // 800
	AppendItem( ThClassMnst, THING_ZEDEK, "Zedek", ""); // 800
	AppendItem( ThClassMnst, THING_HERESIARCH, "Heresiarch", ""); // 5000
	AppendItem( ThClassMnst, THING_KORAX, "Korax", ""); // 5000

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_TIMONSAXE, "Timon's Axe", "");
	AppendItem( ThClassWeap, THING_HAMMERRETR, "Hammer of Retribution", "");
	AppendItem( ThClassWeap, THING_QUIETUSHILT, "Quietus (hilt)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSCROSS, "Quietus (cross)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSBLADE, "Quietus (blade)", "Quietus");
	AppendItem( ThClassWeap, THING_SERPENTSTAFF, "Serpent staff", "");
	AppendItem( ThClassWeap, THING_FIRESTORM, "Firestorm", "");
	AppendItem( ThClassWeap, THING_WVERGESHAFT, "Wraithverge (shaft)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGECROSS, "Wraithverge (cross)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGEARC, "Wraithverge (arc)", "Wraithverge");
	AppendItem( ThClassWeap, THING_FROSTSHARDS, "Frost shards", "");
	AppendItem( ThClassWeap, THING_ARCDEATH, "Arc of Death", "");
	AppendItem( ThClassWeap, THING_BSCOURGESTICK, "Bloodscourge (stick)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESTUB, "Bloodscourge (stub)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESKULL, "Bloodscourge (skull)", "Bloodscourge");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_BLUEMANA, "Blue mana", "");
	AppendItem( ThClassAmmo, THING_GREENMANA, "Green mana", "");
	AppendItem( ThClassAmmo, THING_COMBMANA, "Combined mana", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal vial", "");
	AppendItem( ThClassHlAr, THING_AMULETWARD, "Amulet of Warding", "");
	AppendItem( ThClassHlAr, THING_FALCONSHIELD, "Falcon shield", "");
	AppendItem( ThClassHlAr, THING_MESHARMOR, "Mesh armor", "");
	AppendItem( ThClassHlAr, THING_PLATINUMHELM, "Platinum helm", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BANISHDEV, "Banishment Device", "");
	AppendItem( ThClassItem, THING_BOOTSSPEED, "Boots of Speed", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_DARKSERVANT, "Dark Servant", "");
	AppendItem( ThClassItem, THING_DISCREPULS, "Disc of Repulsion", "");
	AppendItem( ThClassItem, THING_DSKINBRACERS, "Dragonskin bracers", "");
	AppendItem( ThClassItem, THING_FLECHETTE, "Fléchette", "");
	AppendItem( ThClassItem, THING_ICONDEFEND, "Icon of the Defender", "");
	AppendItem( ThClassItem, THING_KRATERMIGHT, "Krater of Might", "");
	AppendItem( ThClassItem, THING_MYSTAMBINC, "Mystic Ambit Incant", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic urn", "");
	AppendItem( ThClassItem, THING_PORKALATOR, "Porkalator", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz flask", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_AXEKEY, "Axe key", NULL);
	AppendItem( ThClassKeys, THING_CASTLEKEY, "Castle key", NULL);
	AppendItem( ThClassKeys, THING_CAVEKEY, "Cave key", NULL);
	AppendItem( ThClassKeys, THING_DUNGEONKEY, "Dungeon key", NULL);
	AppendItem( ThClassKeys, THING_EMERALDKEY, "Emerald key", NULL);
	AppendItem( ThClassKeys, THING_FIREKEY, "Fire key", NULL);
	AppendItem( ThClassKeys, THING_HORNKEY, "Horn key", NULL);
	AppendItem( ThClassKeys, THING_RUSTYKEY, "Rusty key", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY, "Silver key", NULL);
	AppendItem( ThClassKeys, THING_STEELKEY, "Steel key", NULL);
	AppendItem( ThClassKeys, THING_SWAMPKEY, "Swamp key", NULL);

	/* initialize puzzle items */
	AppendItem( ThClassKeys, THING_FLAMEMASK, "Flame Mask", "Puzzle item#Flame Mask");
	AppendItem( ThClassKeys, THING_HEARTDSPARIL, "Heart of D'Sparil", "Puzzle item#Heart of D'Sparil");
	AppendItem( ThClassKeys, THING_EMERALDPLANET1, "Emerald planet 1", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_EMERALDPLANET2, "Emerald planet 2", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_RUBYPLANET, "Ruby planet", NULL);
	AppendItem( ThClassKeys, THING_SAPPHPLANET1, "Sapphire planet 1", NULL);
	AppendItem( ThClassKeys, THING_SAPPHPLANET2, "Sapphire planet 2", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGBRNZSTL, "Clock gear (bronze in steel)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_CLOCKGBRONZE, "Clock gear (bronze)", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGSTLBRNZ, "Clock gear (steel in bronze)", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGSTEEL, "Clock gear (steel)", NULL);
	AppendItem( ThClassKeys, THING_DAEMONCODEX, "Daemon Codex", "Puzzle item#The Books");
	AppendItem( ThClassKeys, THING_LIBEROSCURA, "Liber Oscura", NULL);
	AppendItem( ThClassKeys, THING_YORICKSSKULL, "Yorick's Skull", "Puzzle item#Yorick's Statue");
	AppendItem( ThClassKeys, THING_GLAIVESEAL, "Glaive Seal", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_HOLYRELIC, "Holy Relic", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_SIGILMAGUS, "Sigil of the Magus", "Puzzle item#Hub 5: Necropolis");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_WINGEDSTATUE, "Winged statue", NULL);
	AppendItem( ThClassObst, THING_YORICKSTATUE, "Yorick's statue", NULL);
	AppendItem( ThClassObst, THING_PEDDSPARIL, "Pedestal of D'Sparil", NULL);
	AppendItem( ThClassObst, THING_TOMBRIP, "Tombstone (RIP)", NULL);
	AppendItem( ThClassObst, THING_TOMBSHANE, "Tombstone (Shane)", NULL);
	AppendItem( ThClassObst, THING_TOMBSLIMY, "Tombstone (slimy)", NULL);
	AppendItem( ThClassObst, THING_TOMBBRIANR, "Tombstone (Brian R)", NULL);
	AppendItem( ThClassObst, THING_TOMBCRSCIRC, "Tombstone (cross circle)", NULL);
	AppendItem( ThClassObst, THING_TOMBSMCROSS, "Tombstone (small cross)", NULL);
	AppendItem( ThClassObst, THING_TOMBBRIANP, "Tombstone (Brian P)", NULL);
	AppendItem( ThClassObst, THING_IMPALEDCORPSE, "Impaled corpse", NULL);
	AppendItem( ThClassObst, THING_HANGINGCORPSE, "Hanging corpse", NULL);
	AppendItem( ThClassObst, THING_LYNCHDCORPSE, "Lynched corpse", NULL);
	AppendItem( ThClassObst, THING_LYNCHDCORPSEHL, "Lynched corpse (heartless)", NULL);
	AppendItem( ThClassObst, THING_SITTINGCORPSE, "Sitting corpse", NULL);
	AppendItem( ThClassObst, THING_TWINEDTORCHLIT, "Twined torch (lit)", NULL);
	AppendItem( ThClassObst, THING_TWINEDTORCHULT, "Twined torch (unlit)", NULL);
	AppendItem( ThClassObst, THING_MINOTSTATLIT, "Minotaur statue (lit)", NULL);
	AppendItem( ThClassObst, THING_MINOTSTATULT, "Minotaur statue (unlit)", NULL);
	AppendItem( ThClassObst, THING_SKULLWFLAME, "Skull with flame", NULL);
	AppendItem( ThClassObst, THING_BRAZIERWFLAME, "Brazier with flame", NULL);
	AppendItem( ThClassObst, THING_CAULDRONLIT, "Cauldron (lit)", NULL);
	AppendItem( ThClassObst, THING_CAULDRONULT, "Cauldron (unlit)", NULL);
	AppendItem( ThClassObst, THING_BARREL, "Barrel", NULL);
	AppendItem( ThClassObst, THING_PILLARWVASE, "Pillar with vase", NULL);
	AppendItem( ThClassObst, THING_BATTLERAGBNNR, "Battle rag banner", NULL);
	AppendItem( ThClassObst, THING_IRONMAIDEN, "Iron maiden", NULL);
	AppendItem( ThClassObst, THING_HANGINGBUCKET, "Hanging bucket", NULL);
	AppendItem( ThClassObst, THING_ICEGARGTLL, "Ice gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_ICEGARGSHT, "Ice gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_STONEGARGTLL, "Stone gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_STONEGARGSHT, "Stone gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_RUSTYGARGTLL, "Rusty gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_DLAVAGARGTLL, "Dark lava gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_DLAVAGARGSHT, "Dark lava gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_LLAVAGARGTLL, "Light lava gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_LLAVAGARGSHT, "Light lava gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_BRONZEGARGTLL, "Bronze gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_BRONZEGARGSHT, "Bronze gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_STEELGARGTLL, "Steel gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_STEELGARGSHT, "Steel gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_DEADTREE, "Dead tree", NULL);
	AppendItem( ThClassObst, THING_LEAFLESSTREE, "Leafless tree", NULL);
	AppendItem( ThClassObst, THING_MOSSYTREE1, "Mossy tree 1", NULL);
	AppendItem( ThClassObst, THING_MOSSYTREE2, "Mossy tree 2", NULL);
	AppendItem( ThClassObst, THING_MOSSYDEADTREE, "Mossy dead tree", NULL);
	AppendItem( ThClassObst, THING_TREESTUMPBRND, "Tree stump (burned)", NULL);
	AppendItem( ThClassObst, THING_TREESTUMPBARE, "Tree stump (bare)", NULL);
	AppendItem( ThClassObst, THING_TREELOG, "Tree log", NULL);
	AppendItem( ThClassObst, THING_TALLTREE1, "Tall tree 1", NULL);
	AppendItem( ThClassObst, THING_TALLTREE2, "Tall tree 2", NULL);
	AppendItem( ThClassObst, THING_GNARLEDTREE1, "Gnarled tree 1", NULL);
	AppendItem( ThClassObst, THING_GNARLEDTREE2, "Gnarled tree 2", NULL);
	AppendItem( ThClassObst, THING_SHRUBSML, "Shrub (small)", NULL);
	AppendItem( ThClassObst, THING_SHRUBLRG, "Shrub (large)", NULL);
	AppendItem( ThClassObst, THING_DESTRUCTREE, "Destructible tree", NULL);
	AppendItem( ThClassObst, THING_EVERGRNTREE, "Evergreen tree", NULL);
	AppendItem( ThClassObst, THING_STALAGMPILLAR, "Stalagmite pillar", NULL);
	AppendItem( ThClassObst, THING_STALAGMLRG, "Stalagmite (large)", NULL);
	AppendItem( ThClassObst, THING_STALAGMMED, "Stalagmite (medium)", NULL);
	AppendItem( ThClassObst, THING_STALAGMSML, "Stalagmite (small)", NULL);
	AppendItem( ThClassObst, THING_STALACTLRG, "Stalactite (large)", NULL);
	AppendItem( ThClassObst, THING_STALACTMED, "Stalactite (medium)", NULL);
	AppendItem( ThClassObst, THING_STALACTSML, "Stalactite (small)", NULL);
	AppendItem( ThClassObst, THING_ICICLELRG, "Icicle (large)", NULL);
	AppendItem( ThClassObst, THING_ICICLEMED, "Icicle (medium)", NULL);
	AppendItem( ThClassObst, THING_ICICLESML, "Icicle (small)", NULL);
	AppendItem( ThClassObst, THING_ICICLETNY, "Icicle (tiny)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKELRG, "Ice spike (large)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKEMED, "Ice spike (medium)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKESML, "Ice spike (small)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKETNY, "Ice spike (tiny)", NULL);
	AppendItem( ThClassObst, THING_BROWNROCKLRG, "Brown rock (large)", NULL);
	AppendItem( ThClassObst, THING_BROWNROCKSML, "Brown rock (small)", NULL);
	AppendItem( ThClassObst, THING_BLACKROCK, "Black rock", NULL);
	AppendItem( ThClassObst, THING_MOSSYROCKLRG, "Mossy rock (large)", NULL);
	AppendItem( ThClassObst, THING_BELL, "Bell", NULL);
	AppendItem( ThClassObst, THING_POTTLL, "Pot (tall)", NULL);
	AppendItem( ThClassObst, THING_POTMED, "Pot (medium)", NULL);
	AppendItem( ThClassObst, THING_POTSHT, "Pot (short)", NULL);
	AppendItem( ThClassObst, THING_SUITARMOR, "Suit of armor", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_CHANDELIERLIT, "Chandelier (lit)", NULL);
	AppendItem( ThClassDeco, THING_CHANDELIERULT, "Chandelier (unlit)", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCHLIT, "Wall torch (lit)", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCHULT, "Wall torch (unlit)", NULL);
	AppendItem( ThClassDeco, THING_3CANDLESLIT, "3 Candles (lit)", NULL);
	AppendItem( ThClassDeco, THING_BLUECANDLELIT, "Blue candle (lit)", NULL);
	AppendItem( ThClassDeco, THING_CANDLEWWEBULT, "Candle with web (unlit)", NULL);
	AppendItem( ThClassDeco, THING_GRAYCANDLEULT, "Gray candle (unlit)", NULL);
	AppendItem( ThClassDeco, THING_CANDLEWOWEBULT, "Candle w/o web (unlit)", NULL);
	AppendItem( ThClassDeco, THING_SMLFLAMETMD, "Small flame (timed)", NULL);
	AppendItem( ThClassDeco, THING_SMLFLAME, "Small flame", NULL);
	AppendItem( ThClassDeco, THING_LRGFLAMETMD, "Large flame (timed)", NULL);
	AppendItem( ThClassDeco, THING_LRGFLAME, "Large flame", NULL);
	AppendItem( ThClassDeco, THING_CHAINSHT, "Chain (short)", NULL);
	AppendItem( ThClassDeco, THING_CHAINLONG, "Chain (long)", NULL);
	AppendItem( ThClassDeco, THING_CHAINWLRGHOOK, "Chain with large hook", NULL);
	AppendItem( ThClassDeco, THING_CHAINWSMLHOOK, "Chain with small hook", NULL);
	AppendItem( ThClassDeco, THING_CHAINWSPKBALL, "Chain with spike ball", NULL);
	AppendItem( ThClassDeco, THING_HOOKWHEART, "Hook with heart", NULL);
	AppendItem( ThClassDeco, THING_HOOKWSKULL, "Hook with skull", NULL);
	AppendItem( ThClassDeco, THING_POOLBLOOD, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_SLEEPINGCORPSE, "Sleeping corpse", NULL);
	AppendItem( ThClassDeco, THING_WOODENSTEIN, "Wooden beer stein", NULL);
	AppendItem( ThClassDeco, THING_METALSTEIN, "Metal beer stein", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSPILLED, "Goblet (spilled)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETTLL, "Goblet (tall)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSHT, "Goblet (short)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSILVER, "Goblet (silver)", NULL);
	AppendItem( ThClassDeco, THING_MEATCLEAVER, "Meat cleaver", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKTNY, "Mossy rock (tiny)", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKSML, "Mossy rock (small)", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKMED, "Mossy rock (medium)", NULL);
	AppendItem( ThClassDeco, THING_TREESTUMP1, "Tree stump 1", NULL);
	AppendItem( ThClassDeco, THING_TREESTUMP2, "Tree stump 2", NULL);
	AppendItem( ThClassDeco, THING_LARGEMUSHROOM1, "Large mushroom 1", NULL);
	AppendItem( ThClassDeco, THING_LARGEMUSHROOM2, "Large mushroom 2", NULL);
	AppendItem( ThClassDeco, THING_MEDIUMMUSHROOM, "Medium mushroom", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM1, "Small mushroom 1", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM2, "Small mushroom 2", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM3, "Small mushroom 3", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM4, "Small mushroom 4", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM5, "Small mushroom 5", NULL);
	AppendItem( ThClassDeco, THING_HANGINGMOSS1, "Hanging moss 1", NULL);
	AppendItem( ThClassDeco, THING_HANGINGMOSS2, "Hanging moss 2", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLELRG, "Brick rubble (large)", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLESML, "Brick rubble (small)", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLEMED, "Brick rubble (medium)", NULL);

	/* initialize sounds */
	AppendItem( ThClassSnds, THING_SNDCREAK, "Creak", NULL);
	AppendItem( ThClassSnds, THING_SNDEARTH, "Earth", NULL);
	AppendItem( ThClassSnds, THING_SNDHEAVY, "Heavy", NULL);
	AppendItem( ThClassSnds, THING_SNDICE, "Ice", NULL);
	AppendItem( ThClassSnds, THING_SNDLAVA, "Lava", NULL);
	AppendItem( ThClassSnds, THING_SNDMETAL, "Metal", NULL);
	AppendItem( ThClassSnds, THING_SNDMETAL2, "Metal2", NULL);
	AppendItem( ThClassSnds, THING_SNDSILENCE, "Silence", NULL);
	AppendItem( ThClassSnds, THING_SNDSTONE, "Stone", NULL);
	AppendItem( ThClassSnds, THING_SNDWATER, "Water", NULL);
	AppendItem( ThClassSnds, THING_SNDWIND, "Wind", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5X, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6X, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7X, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8X, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_MUSHROOM, "Poisonous mushroom", "Mushroom");
	AppendItem( ThClassMisc, THING_SPIKE_DN, "Spike down", "Spike");
	AppendItem( ThClassMisc, THING_SPIKE_UP, "Spike up", "Spike");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_TELEPSMOKE, "Teleport smoke", NULL);
	AppendItem( ThClassMisc, THING_MAPSPOT, "Map spot", NULL);
	AppendItem( ThClassMisc, THING_MAPSPOTGRAV, "Map spot (gravity)", NULL);
	AppendItem( ThClassMisc, THING_POLYANCHOR, "Polyobject anchor", "Polyobject");
	AppendItem( ThClassMisc, THING_POLYSPAWN, "Polyobject start spot", NULL);
	AppendItem( ThClassMisc, THING_POLYSPAWNCR, "Polyobject start spot (crush)", NULL);
	AppendItem( ThClassMisc, THING_GLITTBRIDGE, "Glitter bridge", NULL);
	AppendItem( ThClassMisc, THING_BATSPAWNER, "Bat spawner", NULL);
	AppendItem( ThClassMisc, THING_LEAFSPAWNER, "Leaf spawner", NULL);
	AppendItem( ThClassMisc, THING_FOGSPAWNER, "Fog spawner", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHLRG, "Fog patch (large)", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHMED, "Fog patch (medium)", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHSML, "Fog patch (small)", NULL);
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
