/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	COMMON.H - Common main definitions.
*/

#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "dmunix.h"


/*
	the global definitions
*/
#define INFO_VERSION "2.0"

typedef int16_t  BCINT;
typedef uint16_t UBCINT;
typedef uint8_t  UBYTE;
typedef int32_t  BCLNG;


/*
	syntactic sugar
*/
typedef BCINT Bool; /* Boolean data: true or false */

/* boolean constants */
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif


/*
	Description of the command line arguments and config file keywords
*/
typedef struct
{
	char *short_name;   /* abbreviated command line argument */
	char *long_name;    /* command line arg. or keyword */
	enum {              /* type of this option: */
		OPT_BOOLEAN,      /* boolean (toggle) */
		OPT_INTEGER,      /* integer number */
		OPT_STRING,       /* character string */
		OPT_STRINGACC,    /* character string, but store in a list */
		OPT_STRINGLIST,   /* list of character strings */
		OPT_END           /* end of the options description */
	}     opt_type;
	char *msg_if_true;  /* message printed if option is true */
	char *msg_if_false; /* message printed if option is false */
	void *data_ptr;     /* pointer to the data */
} OptDesc;


/*
	the global variables
*/
BCINT GameVersion; /* which game and version? */
Bool Verb;         /* verbose logging? */
char **Wads;       /* list of IWAD files */

int Weap;   /* weapon number */
int Clss;   /* class number */
int Thng;   /* thing type number */
int Objt;   /* object number */
char *Enum; /* enum string */
Bool Pain;  /* pain chance table */
Bool Mnst;  /* monsters pc/hp */
Bool AllT;  /* all thing types by number */
Bool AllC;  /* all thing types by class */
Bool AllO;  /* all mobjs */


/*
	the global function prototypes
*/
void Common( int argc, char *argv[], char *, char *);
void ProgError( char *, ...);

#endif /* COMMON_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
