/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	DMUNIX.H - Some UNIX specific things.
*/

#ifndef DM_UNIX_H
#define DM_UNIX_H

/* from common.c */
extern char *strupr( char *);

/* from wads.c */
#ifdef DM_BIG_ENDIAN
/* big endian machines (eg. Sun, SGI) need to swap bytes within int's/long's */
  extern void swapint( BCINT *i);
  extern void swaplong( int32_t *l);
#else
/* little endian machines (eg. IBM PC) need to do nothing */
# define swapint(i)
# define swaplong(l)
#endif


/* global (re)definitions */
#define GetMemory(x)         malloc(x)
#define FreeMemory(x)        free(x)
#define ResizeMemory(x,y)    realloc(x,y)
#define GetFarMemory(x)      malloc(x)
#define FreeFarMemory(x)     free(x)
#define ResizeFarMemory(x,y) realloc(x,y)

#endif /* DM_UNIX_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
