/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	LEVELS.H - Level data definitions.
*/

#ifndef LEVELS_H
#define LEVELS_H

#include "common.h"
#include "wstructs.h"
#include "wads.h"


/*
	the global variables
*/
UBCINT NumThings;   /* number of things */
TPtr      Things;   /* things data */
UBCINT NumLineDefs; /* number of line defs */
LDPtr     LineDefs; /* line defs data */
UBCINT NumSideDefs; /* number of side defs */
SDPtr     SideDefs; /* side defs data */
BCLNG  TotVertexes; /* total number of vertexes */
BCLNG  NumVertexes; /* number of used vertexes */
VPtr      Vertexes; /* vertex data */
UBCINT NumSegs;     /* number of segments */
SEPtr     Segs;     /* list of segments */
UBCINT NumSSectors; /* number of subsectors */
SSPtr     SSectors; /* list of subsectors */
UBCINT NumSectors;  /* number of sectors */
SPtr      Sectors;  /* sectors data */

/*
	the global function prototypes
*/
void ReadLevelData( WadPtr, char *);
void ForgetLevelData( void);
Bool SearchLevels( WadPtr, char *, UBCINT);
Bool FindThingInLevel( WadPtr, UBCINT);

#endif /* LEVELS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
