/*
	DooM/HereTic/HeXen/StriFe INFO.c processors, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	WADS.H - WAD data defines.
*/

#ifndef WADS_H
#define WADS_H

#include "common.h"


/*
	The directory structure is the structure used by the DOOM-engine
	to order the data in its Wad files.
*/
typedef struct Directory *DirPtr;
struct Directory
{
	BCLNG start;    /* offset to start of data */
	BCLNG size;     /* byte size of data */
	char  name[8];  /* name of data block */
};

/*
	The master directory structure is used to build a complete directory
	of all the data blocks from a Wad file.
*/
typedef struct MasterDirectory *MDirPtr;
struct MasterDirectory
{
	MDirPtr next;         /* next in list */
	struct Directory dir; /* directory data */
};

/*
	The Wad file structure is used for holding the information on the
	Wad files in a linked list.
*/
typedef struct WadFileInfo *WadPtr;
struct WadFileInfo
{
	WadPtr  next;      /* next file in linked list */
	char   *filename;  /* name of the WAD file */
	FILE   *fileinfo;  /* C file stream information */
	char    type[4];   /* type of WAD file (IWAD or PWAD) */
	BCLNG   dirsize;   /* directory size of WAD */
	BCLNG   dirstart;  /* offset to start of directory */
	BCINT   gamevers;  /* which game and version? */
	DirPtr  directory; /* array of directory information */
	MDirPtr masterdir; /* linked master directory list */
};


/*
	the global variables
*/
WadPtr WadFileList; /* linked list of Wad files */

/*
	the global function prototypes
*/
void OpenIWad( char *);
void CloseIWads( void);
MDirPtr FindMasterDir( MDirPtr, char *);
MDirPtr FindNextLump( MDirPtr, char *, Bool);
MDirPtr FindLevelDir( MDirPtr, char *);
int CountSpriteLumps( MDirPtr, char *);

#endif /* WADS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
