/*
	DooM INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	PRINT.C - Print routines
*/

#include "print.h"
#include "../common/print.h"
#include "../common/stub.h"


/*
	the global variables
*/
extern int maxammo[];
extern int clipammo[];

/*
	the local function prototypes
*/
void PrintSound(char *, int);
void PrintWpnAmmo( weapontype_t);
void PrintShotsPM( mobjinfo_t *);
void PrintWpnShotsPM( weapontype_t);
int FrameTics( statenum_t);
void PrintWpnSprites( weapontype_t);


/*
	the weapon print data function
*/
void PrintWeapon()
{
	if (Weap < 0 || Weap >= NUMWEAPONS)
		ProgError( "no such Weapon %d", Weap);

	printf( "\n");
	printf( "Weapon\t\t%s\n", Wpn2Str( Weap));
	PrintWpnAmmo( Weap);
	PrintWpnShotsPM( Weap);
	printf( "\n");
	PrintWpnSprites( Weap);
	PrintSpawns();
}

/*
	the main print data function
*/
void PrintData()
{
	mobjinfo_t *MOBJ;

	if (Enum != NULL)
		Objt = Enum2Obj( Enum);
	else if (Thng != -1)
		Objt = Thg2Obj( Thng);
	else
		if (Objt < 0 || Objt >= NUMMOBJTYPES)
			ProgError( "no such Object %d", Objt);

	MOBJ = &mobjinfo[Objt];
	printf( "\n");
	printf( "Enum\t\t%s (%d)\n", Obj2Str( Objt), Objt);
	if (MOBJ->doomednum != -1)
		printf( "Type\t\t%d\t%X\n", MOBJ->doomednum, MOBJ->doomednum);
	else
		printf( "Type\t\t%d\n", MOBJ->doomednum);

	printf( "Health\t\t%d\n", MOBJ->spawnhealth);
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintShotsPM( MOBJ);
	else
		PrintSpeed( MOBJ);

	//printf( "Width\t\t%d\n", MOBJ->radius * 2 / FRACUNIT);
	printf( "Radius\t\t%d\n", MOBJ->radius / FRACUNIT);
	printf( "Height\t\t%d\n", MOBJ->height / FRACUNIT);
	printf( "Mass\t\t%d\n", MOBJ->mass);
	if (MOBJ->flags & MF_MISSILE) // missile formula
		printf( "Damage\t\t%d-%d\n", MOBJ->damage, MOBJ->damage * 8);
	else
		printf( "Damage\t\t%d\n", MOBJ->damage);

	if (!(MOBJ->flags & MF_SPECIAL)) // no pick-up item
	{
		printf( "Reaction time\t%d tics\n", MOBJ->reactiontime);
		printf( "Pain chance\t%d ; %.2f%%\n", MOBJ->painchance, PainPerc( MOBJ->painchance));
		printf( "Pain time\t%d tics\n", PainTics( MOBJ->painstate));
	}
	printf( "Flags\t\t%08x  %d\n", MOBJ->flags, MOBJ->flags);
	PrintFlags( MOBJ->flags);

	TallyFrames( MOBJ->spawnstate);
	TallyFrames( MOBJ->seestate);
	TallyFrames( MOBJ->painstate);
	TallyFrames( MOBJ->meleestate);
	TallyFrames( MOBJ->missilestate);
	TallyFrames( MOBJ->deathstate);
	TallyFrames( MOBJ->xdeathstate);
	TallyFrames( MOBJ->raisestate);

	printf( "\n");
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintSprites( MOBJ);
	else
	{
		PrintSprite( MOBJ->spawnstate, NULL);
		PrintSound( "Alert", MOBJ->seesound);
		PrintSound( "Active", MOBJ->activesound);
		PrintSound( "Attack", MOBJ->attacksound);
		PrintSound( "Pain", MOBJ->painsound);
		PrintSound( "Death", MOBJ->deathsound);
	}
	PrintSpawns();
}


void PrintSound(char *type, int sound)
{
	char name[9];

	printf( "%s sound\t", type);
	if (sound != 0)
	{
		strcpy( name, S_sfx[sound].name);
		strupr( name);
		printf( "DS%s\n", name);
	}
	else
		printf( "-\n");
}

void PrintWpnAmmo( weapontype_t weapon)
{
	int ammo;

	ammo = clipammo[weaponinfo[weapon].ammo];
	printf("Incl ammo\t%d (%d on [[Skill level|skills]] 1 & 5)\n", ammo * 2, ammo * 2 * 2); // 2 clips
	ammo = maxammo[weaponinfo[weapon].ammo];
	printf("Max ammo\t%d (%d with [[backpack]])\n", ammo, ammo * 2);
}


void PrintShotsPM( mobjinfo_t *MOBJ)
{
	int weapon;

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_CSAW: weapon = wp_chainsaw; break;
		case SPR_SHOT: weapon = wp_shotgun; break;
		case SPR_SGN2: weapon = wp_supershotgun; break;
		case SPR_MGUN: weapon = wp_chaingun; break;
		case SPR_LAUN: weapon = wp_missile; break;
		case SPR_PLAS: weapon = wp_plasma; break;
		case SPR_BFUG: weapon = wp_bfg; break;
		default: return;
	}
	PrintWpnShotsPM( weapon);
}

void PrintWpnShotsPM( weapontype_t weapon)
{
	int percycle = 0, tics = 0;
	statenum_t state, st;

	state = st = weaponinfo[weapon].atkstate;
	if (state != S_NULL)
		for (;;)
		{
			if (states[st].action.acp1)
				states[st].action.acp1(NULL);
			else
				funcname[0] = '\0';
			if (strncmp( funcname, "A_Fire", strlen("A_Fire")) == 0 ||
			    strcmp( funcname, "A_Punch") == 0 ||
			    strcmp( funcname, "A_Saw") == 0)
				percycle++;
			else if (strcmp( funcname, "A_ReFire") == 0)
				break;
			tics += states[st].tics;
			st = states[st].nextstate;
			if (tics > 100)
				ProgError( "unable to count tics for atkstate %d", state);
		}

	if (tics != 0)
		printf( "Shots / min\t%.1f\n",
		        (float)percycle * (TICRATE * 60) / tics);
}

int FrameTics( statenum_t state)
{
	statenum_t st = state;

	/* skip Arachnotron sight state */
	if (!states[st].action.acp1)
		st = states[st].nextstate;

	/* skip to A_Chase state */
	if (states[st].action.acp1)
		states[st].action.acp1(NULL);
	else
		funcname[0] = '\0';
	if (strcmp( funcname, "A_Hoof") == 0 ||     // Cyberdemon
	    strcmp( funcname, "A_Metal") == 0 ||    // Spiderdemon
	    strcmp( funcname, "A_BabyMetal") == 0)  // Arachnotron
		st = states[st].nextstate;

	if (states[st].action.acp1)
	{
		states[st].action.acp1(NULL);
		if (strcmp( funcname, "A_Chase") == 0 ||    // generic
		    strcmp( funcname, "A_VileChase") == 0)  // Arch-Vile
			return states[st].tics;
	}

	return -1;
}


void PrintSprites( mobjinfo_t *MOBJ)
{
	int weapon;

	PrintSprite( MOBJ->spawnstate, "pickup");

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_CSAW: weapon = wp_chainsaw; break;
		case SPR_SHOT: weapon = wp_shotgun; break;
		case SPR_SGN2: weapon = wp_supershotgun; break;
		case SPR_MGUN: weapon = wp_chaingun; break;
		case SPR_LAUN: weapon = wp_missile; break;
		case SPR_PLAS: weapon = wp_plasma; break;
		case SPR_BFUG: weapon = wp_bfg; break;
		default: return;
	}
	PrintWpnSprites( weapon);
}

void PrintWpnSprites( weapontype_t weapon)
{
	PrintSprite( weaponinfo[weapon].readystate, "wield");
	PrintSprite( weaponinfo[weapon].atkstate, "fire");
	PrintSprite( weaponinfo[weapon].flashstate, "flash");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
