/*
	DooM INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.H - Thing flag definitions.
*/

#ifndef THINGS_H
#define THINGS_H

/*
	the global function prototypes
*/
void InitDoomThings( void);


/* DOOM Things */

/* Enemies */
#define THING_HUMAN           3004
#define THING_SERGEANT        9
#define THING_COMMANDO        65    /* ][ */
#define THING_IMP             3001
#define THING_LOSTSOUL        3006
#define THING_DEMON           3002
#define THING_SPECTRE         58
#define THING_REVENANT        66    /* ][ */
#define THING_CACODEMON       3005
#define THING_PAINELEM        71    /* ][ */
#define THING_KNIGHT          69    /* ][ */
#define THING_BARON           3003
#define THING_ARACHNO         68    /* ][ */
#define THING_MANCUBUS        67    /* ][ */
#define THING_ARCHVILE        64    /* ][ */
#define THING_SPIDERBOSS      7
#define THING_CYBERDEMON      16
#define THING_WOLF3DSS        84    /* ][ */

/* Weapons & ammo */
#define THING_CHAINSAW        2005
#define THING_SHOTGUN         2001
#define THING_COMBATGUN       82    /* ][ */
#define THING_CHAINGUN        2002
#define THING_LAUNCHER        2003
#define THING_PLASMAGUN       2004
#define THING_BFG9000         2006
#define THING_AMMOCLIP        2007
#define THING_AMMOBOX         2048
#define THING_SHELLS          2008
#define THING_SHELLBOX        2049
#define THING_ROCKET          2010
#define THING_ROCKETBOX       2046
#define THING_ENERGYCELL      2047
#define THING_ENERGYPACK      17

/* Enhancements & bonuses */
#define THING_STIMPACK        2011
#define THING_MEDIKIT         2012
#define THING_GREENARMOR      2018
#define THING_BLUEARMOR       2019

#define THING_ARMBONUS1       2015
#define THING_HLTBONUS1       2014
#define THING_SOULSPHERE      2013
#define THING_MEGASPHERE      83    /* ][ */
#define THING_BACKPACK        8
#define THING_BERSERK         2023
#define THING_COMPMAP         2026
#define THING_INVULN          2022
#define THING_LITEAMP         2045
#define THING_BLURSPHERE      2024
#define THING_RADSUIT         2025

/* Keys */
#define THING_BLUECARD        5
#define THING_BLUESKULLKEY    40
#define THING_YELLOWCARD      6
#define THING_YELLOWSKULLKEY  39
#define THING_REDCARD         13
#define THING_REDSKULLKEY     38

/* Specials */
#define THING_BARREL          2035
#define THING_BOSSBRAIN       88    /* ][ */
#define THING_BOSSSHOOT       89    /* ][ */
#define THING_SPAWNSPOT       87    /* ][ */
#define THING_KEEN            72    /* ][ */

/* Decorations */
#define THING_TECHCOLUMN      48
#define THING_TGREENPILLAR    30
#define THING_TREDPILLAR      32
#define THING_SGREENPILLAR    31
#define THING_SREDPILLAR      33
#define THING_PILLARHEART     36
#define THING_PILLARSKULL     37
#define THING_EYEINSYMBOL     41
#define THING_GREYTREE        43
#define THING_BROWNSTUB       47
#define THING_BROWNTREE       54

#define THING_LAMP            2028
#define THING_TALLLAMP        85    /* ][ */
#define THING_SHORTLAMP       86    /* ][ */
#define THING_CANDLE          34
#define THING_CANDELABRA      35
#define THING_TBLUETORCH      44
#define THING_TGREENTORCH     45
#define THING_TREDTORCH       46
#define THING_SBLUETORCH      55
#define THING_SGREENTORCH     56
#define THING_SREDTORCH       57
#define THING_FLAMECAN        70    /* ][ */

#define THING_DEADPLAYER      15
#define THING_DEADHUMAN       18
#define THING_DEADSERGEANT    19
#define THING_DEADIMP         20
#define THING_DEADDEMON       21
#define THING_DEADCACODEMON   22
#define THING_DEADLOSTSOUL    23
#define THING_BONES           10
#define THING_BONES2          12
#define THING_POOLOFBLOOD     24
#define THING_POOLOFBLOOD2    79    /* ][ */
#define THING_POOLOFBLOOD3    80    /* ][ */
#define THING_POOLOFBRAINS    81    /* ][ */
#define THING_SKULLTOPPOLE    27
#define THING_HEADSKEWER      28
#define THING_PILEOFSKULLS    29
#define THING_IMPALEDBODY     25
#define THING_IMPALEDBODY2    26
#define THING_SKULLSINFLAMES  42

#define THING_HANGINGSWAYING  49
#define THING_HANGINGSWAYING2 63
#define THING_HANGINGARMSOUT  50
#define THING_HANGINGARMSOUT2 59
#define THING_HANGINGONELEG   51
#define THING_HANGINGONELEG2  61
#define THING_HANGINGTORSO    52
#define THING_HANGINGTORSO2   60
#define THING_HANGINGLEG      53
#define THING_HANGINGLEG2     62
#define THING_HANGINGNOGUTS   73    /* ][ */
#define THING_HANGINGNOGUTS2  74    /* ][ */
#define THING_HANGINGLOOKDN   75    /* ][ */
#define THING_HANGINGLOOKUP   77    /* ][ */
#define THING_HANGINGTORSO3   76    /* ][ */
#define THING_HANGINGTORSO4   78    /* ][ */

#endif /* THINGS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
