/*
	HereTic INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	MAPS.C - Mappings of enums to strings
*/

#include "../common/maps.h"
#include "doomdef.h"

char *mobjstr[] = {
	"MT_MISC0",
	"MT_ITEMSHIELD1",
	"MT_ITEMSHIELD2",
	"MT_MISC1",
	"MT_MISC2",
	"MT_ARTIINVISIBILITY",
	"MT_MISC3",
	"MT_ARTIFLY",
	"MT_ARTIINVULNERABILITY",
	"MT_ARTITOMEOFPOWER",
	"MT_ARTIEGG",
	"MT_EGGFX",
	"MT_ARTISUPERHEAL",
	"MT_MISC4",
	"MT_MISC5",
	"MT_FIREBOMB",
	"MT_ARTITELEPORT",
	"MT_POD",
	"MT_PODGOO",
	"MT_PODGENERATOR",
	"MT_SPLASH",
	"MT_SPLASHBASE",
	"MT_LAVASPLASH",
	"MT_LAVASMOKE",
	"MT_SLUDGECHUNK",
	"MT_SLUDGESPLASH",
	"MT_SKULLHANG70",
	"MT_SKULLHANG60",
	"MT_SKULLHANG45",
	"MT_SKULLHANG35",
	"MT_CHANDELIER",
	"MT_SERPTORCH",
	"MT_SMALLPILLAR",
	"MT_STALAGMITESMALL",
	"MT_STALAGMITELARGE",
	"MT_STALACTITESMALL",
	"MT_STALACTITELARGE",
	"MT_MISC6",
	"MT_BARREL",
	"MT_MISC7",
	"MT_MISC8",
	"MT_MISC9",
	"MT_MISC10",
	"MT_MISC11",
	"MT_KEYGIZMOBLUE",
	"MT_KEYGIZMOGREEN",
	"MT_KEYGIZMOYELLOW",
	"MT_KEYGIZMOFLOAT",
	"MT_MISC12",
	"MT_VOLCANOBLAST",
	"MT_VOLCANOTBLAST",
	"MT_TELEGLITGEN",
	"MT_TELEGLITGEN2",
	"MT_TELEGLITTER",
	"MT_TELEGLITTER2",
	"MT_TFOG",
	"MT_TELEPORTMAN",
	"MT_STAFFPUFF",
	"MT_STAFFPUFF2",
	"MT_BEAKPUFF",
	"MT_MISC13",
	"MT_GAUNTLETPUFF1",
	"MT_GAUNTLETPUFF2",
	"MT_MISC14",
	"MT_BLASTERFX1",
	"MT_BLASTERSMOKE",
	"MT_RIPPER",
	"MT_BLASTERPUFF1",
	"MT_BLASTERPUFF2",
	"MT_WMACE",
	"MT_MACEFX1",
	"MT_MACEFX2",
	"MT_MACEFX3",
	"MT_MACEFX4",
	"MT_WSKULLROD",
	"MT_HORNRODFX1",
	"MT_HORNRODFX2",
	"MT_RAINPLR1",
	"MT_RAINPLR2",
	"MT_RAINPLR3",
	"MT_RAINPLR4",
	"MT_GOLDWANDFX1",
	"MT_GOLDWANDFX2",
	"MT_GOLDWANDPUFF1",
	"MT_GOLDWANDPUFF2",
	"MT_WPHOENIXROD",
	"MT_PHOENIXFX1",
	"MT_PHOENIXPUFF",
	"MT_PHOENIXFX2",
	"MT_MISC15",
	"MT_CRBOWFX1",
	"MT_CRBOWFX2",
	"MT_CRBOWFX3",
	"MT_CRBOWFX4",
	"MT_BLOOD",
	"MT_BLOODSPLATTER",
	"MT_PLAYER",
	"MT_BLOODYSKULL",
	"MT_CHICPLAYER",
	"MT_CHICKEN",
	"MT_FEATHER",
	"MT_MUMMY",
	"MT_MUMMYLEADER",
	"MT_MUMMYGHOST",
	"MT_MUMMYLEADERGHOST",
	"MT_MUMMYSOUL",
	"MT_MUMMYFX1",
	"MT_BEAST",
	"MT_BEASTBALL",
	"MT_BURNBALL",
	"MT_BURNBALLFB",
	"MT_PUFFY",
	"MT_SNAKE",
	"MT_SNAKEPRO_A",
	"MT_SNAKEPRO_B",
	"MT_HEAD",
	"MT_HEADFX1",
	"MT_HEADFX2",
	"MT_HEADFX3",
	"MT_WHIRLWIND",
	"MT_CLINK",
	"MT_WIZARD",
	"MT_WIZFX1",
	"MT_IMP",
	"MT_IMPLEADER",
	"MT_IMPCHUNK1",
	"MT_IMPCHUNK2",
	"MT_IMPBALL",
	"MT_KNIGHT",
	"MT_KNIGHTGHOST",
	"MT_KNIGHTAXE",
	"MT_REDAXE",
	"MT_SORCERER1",
	"MT_SRCRFX1",
	"MT_SORCERER2",
	"MT_SOR2FX1",
	"MT_SOR2FXSPARK",
	"MT_SOR2FX2",
	"MT_SOR2TELEFADE",
	"MT_MINOTAUR",
	"MT_MNTRFX1",
	"MT_MNTRFX2",
	"MT_MNTRFX3",
	"MT_AKYY",
	"MT_BKYY",
	"MT_CKEY",
	"MT_AMGWNDWIMPY",
	"MT_AMGWNDHEFTY",
	"MT_AMMACEWIMPY",
	"MT_AMMACEHEFTY",
	"MT_AMCBOWWIMPY",
	"MT_AMCBOWHEFTY",
	"MT_AMSKRDWIMPY",
	"MT_AMSKRDHEFTY",
	"MT_AMPHRDWIMPY",
	"MT_AMPHRDHEFTY",
	"MT_AMBLSRWIMPY",
	"MT_AMBLSRHEFTY",
	"MT_SOUNDWIND",
	"MT_SOUNDWATERFALL",
};

#define NUMWEAPS 9
int iNUMWEAPS = NUMWEAPS;

char *weaponstr[NUMWEAPS] = {
	"Staff",
	"Elven Wand",
	"Ethereal Crossbow",
	"Dragon Claw",
	"Hellstaff",
	"Phoenix Rod",
	"Firemace",
	"Gauntlets of the Necromancer",
	"Chicken Beak",
};


#define NUMFLAGS 26
int iNUMFLAGS = NUMFLAGS;

mflagstr_t mflagstr[NUMFLAGS] = {
/*  0 */ { MF_SPECIAL     , "Can be picked up" },
/*  1 */ { MF_SOLID       , "Obstacle" },
/*  2 */ { MF_SHOOTABLE   , "Shootable" },
/*  3 */ { MF_NOSECTOR    , "No sector links (Invisible)" },
/*  4 */ { MF_NOBLOCKMAP  , "No blocklinks (Inert)" },
/*  5 */ { MF_AMBUSH      , "Ambush (Semi-deaf)" },
/*  6 */ { MF_JUSTHIT     , "Just hit (In pain)" },
/*  7 */ { MF_JUSTATTACKED, "Just attacked (Step first)" },
/*  8 */ { MF_SPAWNCEILING, "Hangs from ceiling" },
/*  9 */ { MF_NOGRAVITY   , "No gravity" },
/* 10 */ { MF_DROPOFF     , "Drops off ledges" },
/* 11 */ { MF_PICKUP      , "Picks up items" },
/* 12 */ { MF_NOCLIP      , "No clipping" },
/* 13 */ { MF_SLIDE       , "Sliding along walls" },
/* 14 */ { MF_FLOAT       , "Floating" },
/* 15 */ { MF_TELEPORT    , "No line crossing" },
/* 16 */ { MF_MISSILE     , "Projectile" },
/* 17 */ { MF_DROPPED     , "Dropped by enemy" },
/* 18 */ { MF_SHADOW      , "Partial invisibility" },
/* 19 */ { MF_NOBLOOD     , "Puffs vs. blood" },
/* 20 */ { MF_CORPSE      , "Sliding corpse" },
/* 21 */ { MF_INFLOAT     , "No auto-leveling" },
/* 22 */ { MF_COUNTKILL   , "Affects kill %" },
/* 23 */ { MF_COUNTITEM   , "Affects item %" },
/* 24 */ { MF_SKULLFLY    , "Flying skull" },
/* 25 */ { MF_NOTDMATCH   , "Not in deathmatch" },
};

#define NUMFLAGS2 21
int iNUMFLAGS2 = NUMFLAGS2;

mflagstr_t mflag2str[NUMFLAGS2] = {
/*  0 */ { MF2_LOGRAV        , "Alternate gravity" },
/*  1 */ { MF2_WINDTHRUST    , "Wind can thrust" },
/*  2 */ { MF2_FLOORBOUNCE   , "Bounces off floor" },
/*  3 */ { MF2_THRUGHOST     , "Missile passes thru ghosts" },
/*  4 */ { MF2_FLY           , "Flying" },
/*  5 */ { MF2_FOOTCLIP      , "Feet can be clipped" },
/*  6 */ { MF2_SPAWNFLOAT    , "Spawn random float height" },
/*  7 */ { MF2_NOTELEPORT    , "No teleport" },
/*  8 */ { MF2_RIP           , "Missile rips thru solid" },
/*  9 */ { MF2_PUSHABLE      , "Pushable" },
/* 10 */ { MF2_SLIDE         , "Slide against walls" },
/* 11 */ { MF2_ONMOBJ        , "On top of [[mobj]]" },
/* 12 */ { MF2_PASSMOBJ      , "Pass over/under [[mobj]]" },
/* 13 */ { MF2_CANNOTPUSH    , "Cannot push other pushables" },
/* 14 */ { MF2_FEETARECLIPPED, "Feet are being clipped" },
/* 15 */ { MF2_BOSS          , "Major boss" },
/* 16 */ { MF2_FIREDAMAGE    , "Fire damage" },
/* 17 */ { MF2_NODMGTHRUST   , "No damage Thrust" },
/* 18 */ { MF2_TELESTOMP     , "Can stomp (Telefrag)" },
/* 19 */ { MF2_FLOATBOB      , "Float bobbing movement" },
/* 20 */ { MF2_DONTDRAW      , "No vissprite" },
};


#define NUMMONST 18
int iNUMMONST = NUMMONST;

monststr_t monststr[NUMMONST] = {
	{ MT_CHICKEN         , "Chicken monster" },
	{ MT_MUMMY           , "Golem" },
	{ MT_MUMMYLEADER     , "Nitrogolem" },
	{ MT_MUMMYGHOST      , "Golem ghost" },
	{ MT_MUMMYLEADERGHOST, "Nitrogolem ghost" },
	{ MT_BEAST           , "Weredragon" },
	{ MT_SNAKE           , "Ophidian" },
	{ MT_HEAD            , "Iron lich" },
	{ MT_CLINK           , "Sabreclaw" },
	{ MT_WIZARD          , "Disciple of D'Sparil" },
	{ MT_IMP             , "Gargoyle" },
	{ MT_IMPLEADER       , "Fire gargoyle" },
	{ MT_KNIGHT          , "Undead warrior" },
	{ MT_KNIGHTGHOST     , "Undead warrior ghost" },
	{ MT_SORCERER1       , "D'Sparil on Serpent" },
	{ MT_SORCERER2       , "D'Sparil sans Serpent" },
	{ MT_MINOTAUR        , "Maulotaur" },
	{ MT_POD             , "Pod" },
};

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
