/*
	HereTic INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	PRINT.C - Print routines
*/

#include "print.h"
#include "../common/print.h"
#include "../common/stub.h"


/*
	the global variables
*/
extern sfxinfo_t S_sfx[];
extern int GetWeaponAmmo[];

/*
	the local function prototypes
*/
void PrintSound(char *, int);
void PrintWpnAmmo( weapontype_t);
void PrintShotsPM( mobjinfo_t *, Bool);
void PrintWpnShotsPM( weapontype_t, Bool);
int FrameTics( statenum_t);
void PrintWpnSprites( weapontype_t);


/*
	the weapon print data function
*/
void PrintWeapon()
{
	if (Weap < 0 || Weap >= NUMWEAPONS)
		ProgError( "no such Weapon %d", Weap);

	printf( "\n");
	printf( "Weapon\t\t%s\n", Wpn2Str( Weap));
	PrintWpnAmmo( Weap);
	PrintWpnShotsPM( Weap, FALSE);
	PrintWpnShotsPM( Weap, TRUE);
	printf( "\n");
	PrintWpnSprites( Weap);
	PrintSpawns();
}

/*
	the main print data function
*/
void PrintData()
{
	mobjinfo_t *MOBJ;

	if (Enum != NULL)
		Objt = Enum2Obj( Enum);
	else if (Thng != -1)
		Objt = Thg2Obj( Thng);
	else
		if (Objt < 0 || Objt >= NUMMOBJTYPES)
			ProgError( "no such Object %d", Objt);

	MOBJ = &mobjinfo[Objt];
	printf( "\n");
	printf( "Enum\t\t%s (%d)\n", Obj2Str( Objt), Objt);
	if (MOBJ->doomednum != -1)
		printf( "Type\t\t%d\t%X\n", MOBJ->doomednum, MOBJ->doomednum);
	else
		printf( "Type\t\t%d\n", MOBJ->doomednum);

	printf( "Health\t\t%d\n", MOBJ->spawnhealth);
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
	{
		PrintShotsPM( MOBJ, FALSE);
		PrintShotsPM( MOBJ, TRUE);
	}
	else
		PrintSpeed( MOBJ);

	//printf( "Width\t\t%d\n", MOBJ->radius * 2 / FRACUNIT);
	printf( "Radius\t\t%d\n", MOBJ->radius / FRACUNIT);
	printf( "Height\t\t%d\n", MOBJ->height / FRACUNIT);
	printf( "Mass\t\t%d\n", MOBJ->mass);
	if (MOBJ->flags & MF_MISSILE) // missile formula
		printf( "Damage\t\t%d-%d\n", MOBJ->damage, MOBJ->damage * 8);
	else
		printf( "Damage\t\t%d\n", MOBJ->damage);

	if (!(MOBJ->flags & MF_SPECIAL)) // no pick-up item
	{
		printf( "Reaction time\t%d tics\n", MOBJ->reactiontime);
		printf( "Pain chance\t%d ; %.2f%%\n", MOBJ->painchance, PainPerc( MOBJ->painchance));
		printf( "Pain time\t%d tics\n", PainTics( MOBJ->painstate));
	}
	printf( "Flags\t\t%08x  %d\n", MOBJ->flags, MOBJ->flags);
	PrintFlags( MOBJ->flags);
	printf( "Flags2\t\t%08x  %d\n", MOBJ->flags2, MOBJ->flags2);
	PrintFlags2( MOBJ->flags2);

	TallyFrames( MOBJ->spawnstate);
	TallyFrames( MOBJ->seestate);
	TallyFrames( MOBJ->painstate);
	TallyFrames( MOBJ->meleestate);
	TallyFrames( MOBJ->missilestate);
	TallyFrames( MOBJ->crashstate);
	TallyFrames( MOBJ->deathstate);
	TallyFrames( MOBJ->xdeathstate);

	printf( "\n");
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintSprites( MOBJ);
	else
	{
		PrintSprite( MOBJ->spawnstate, NULL);
		PrintSound( "Alert", MOBJ->seesound);
		PrintSound( "Active", MOBJ->activesound);
		PrintSound( "Attack", MOBJ->attacksound);
		PrintSound( "Pain", MOBJ->painsound);
		PrintSound( "Death", MOBJ->deathsound);
	}
	PrintSpawns();
}


void PrintSound(char *type, int sound)
{
	char name[9];

	printf( "%s sound\t", type);
	if (sound != 0)
	{
		if (S_sfx[sound].link != NULL)
			strcpy( name, S_sfx[sound].link->name);
		else
			strcpy( name, S_sfx[sound].name);
		strupr( name);
		printf( "%s\n", name);
	}
	else
		printf( "-\n");
}

void PrintWpnAmmo( weapontype_t weapon)
{
	int ammo;

	ammo = GetWeaponAmmo[weapon];
	printf("Incl ammo\t%d (%d on [[Skill level|skills]] 1 & 5)\n", ammo, (int)(ammo * 1.5));
	ammo = maxammo[wpnlev1info[weapon].ammo];
	printf("Max ammo\t%d (%d with [[bag of holding]])\n", ammo, ammo * 2);
}


void PrintShotsPM( mobjinfo_t *MOBJ, Bool powered)
{
	int weapon;

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_WGNT: weapon = wp_gauntlets; break;
		case SPR_WBOW: weapon = wp_crossbow; break;
		case SPR_WBLS: weapon = wp_blaster; break;
		case SPR_WSKL: weapon = wp_skullrod; break;
		case SPR_WPHX: weapon = wp_phoenixrod; break;
		case SPR_WMCE: weapon = wp_mace; break;
		default: return;
	}
	PrintWpnShotsPM( weapon, powered);
}

void PrintWpnShotsPM( weapontype_t weapon, Bool powered)
{
	int percycle = 0, tics = 0;
	statenum_t state, st;

	state = st = (powered ? wpnlev2info[weapon].holdatkstate
	                      : wpnlev1info[weapon].holdatkstate);
	if (state != S_NULL)
		for (;;)
		{
			if (states[st].action)
				states[st].action(NULL);
			else
				funcname[0] = '\0';
			if (strncmp( funcname, "A_Fire", strlen("A_Fire")) == 0 ||
			    strncmp( funcname, "A_StaffAttack", strlen("A_StaffAttack")) == 0 ||
			    strncmp( funcname, "A_BeakAttack", strlen("A_BeakAttack")) == 0 ||
			    strcmp( funcname, "A_GauntletAttack") == 0)
				percycle++;
			else if (strcmp( funcname, "A_ReFire") == 0 ||
			         strcmp( funcname, "A_BeakReady") == 0)
				break;
			tics += states[st].tics;
			st = states[st].nextstate;
			if (tics > 100)
				ProgError( "unable to count tics for holdatkstate %d", state);
		}

	if (tics != 0)
		printf( "Shots / min%s\t%.1f\n", (powered ? " (p)" : ""),
		        (float)percycle * (TICRATE * 60) / tics);
}

int FrameTics( statenum_t state)
{
	if (states[state].action)
	{
		states[state].action(NULL);
		if (strcmp( funcname, "A_Chase") == 0 ||
		    strcmp( funcname, "A_ChicChase") == 0 ||  // Chicken
		    strcmp( funcname, "A_Sor1Chase") == 0)    // D'Sparil
			return states[state].tics;
	}

	return -1;
}


void PrintSprites( mobjinfo_t *MOBJ)
{
	int weapon;

	PrintSprite( MOBJ->spawnstate, "pickup");

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_WGNT: weapon = wp_gauntlets; break;
		case SPR_WBOW: weapon = wp_crossbow; break;
		case SPR_WBLS: weapon = wp_blaster; break;
		case SPR_WSKL: weapon = wp_skullrod; break;
		case SPR_WPHX: weapon = wp_phoenixrod; break;
		case SPR_WMCE: weapon = wp_mace; break;
		default: return;
	}
	PrintWpnSprites( weapon);
}

void PrintWpnSprites( weapontype_t weapon)
{
	PrintSprite( wpnlev1info[weapon].readystate, "wield");
	PrintSprite( wpnlev1info[weapon].atkstate, "fire");
	PrintSprite( wpnlev1info[weapon].holdatkstate, "refire");
	PrintSprite( wpnlev2info[weapon].readystate, "p wld");
	PrintSprite( wpnlev2info[weapon].atkstate, "p fire");
	PrintSprite( wpnlev2info[weapon].holdatkstate, "p ref");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
