
//**************************************************************************
//**
//** p_pspr.c : Heretic 2 : Raven Software, Corp.
//**
//** $RCSfile: p_pspr.c,v $
//** $Revision: 1.105 $
//** $Date: 96/01/06 03:23:35 $
//** $Author: bgokey $
//**
//**************************************************************************

// HEADER FILES ------------------------------------------------------------

#include "h2def.h"
//#include "p_local.h"
#include "soundst.h"

// MACROS ------------------------------------------------------------------

#define LOWERSPEED FRACUNIT*6
#define RAISESPEED FRACUNIT*6
#define WEAPONBOTTOM 128*FRACUNIT
#define WEAPONTOP 32*FRACUNIT

// TYPES -------------------------------------------------------------------

// EXTERNAL FUNCTION PROTOTYPES --------------------------------------------

extern void P_ExplodeMissile(mobj_t *mo);
extern void A_UnHideThing(mobj_t *actor);

// PUBLIC FUNCTION PROTOTYPES ----------------------------------------------

// PRIVATE FUNCTION PROTOTYPES ---------------------------------------------

// EXTERNAL DATA DECLARATIONS ----------------------------------------------

extern fixed_t FloatBobOffsets[64];

// PUBLIC DATA DEFINITIONS -------------------------------------------------

fixed_t bulletslope;

weaponinfo_t WeaponInfo[NUMWEAPONS][NUMCLASSES] =
{
	{ // First Weapons
		{ // Fighter First Weapon - Punch
			MANA_NONE,			// mana
			S_PUNCHUP,			// upstate
			S_PUNCHDOWN,		// downstate
			S_PUNCHREADY,		// readystate
			S_PUNCHATK1_1,		// atkstate
			S_PUNCHATK1_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Cleric First Weapon - Mace
			MANA_NONE,			// mana
			S_CMACEUP,			// upstate
			S_CMACEDOWN,		// downstate
			S_CMACEREADY,		// readystate
			S_CMACEATK_1,		// atkstate
			S_CMACEATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Mage First Weapon - Wand
			MANA_NONE,
			S_MWANDUP,
			S_MWANDDOWN,
			S_MWANDREADY,
			S_MWANDATK_1,
			S_MWANDATK_1,
			S_NULL
		},
		{ // Pig - Snout
			MANA_NONE,			// mana
			S_SNOUTUP,			// upstate
			S_SNOUTDOWN,		// downstate
			S_SNOUTREADY,		// readystate
			S_SNOUTATK1,		// atkstate
			S_SNOUTATK1,		// holdatkstate
			S_NULL				// flashstate
		}
	},
	{ // Second Weapons
		{ // Fighter - Axe
			MANA_NONE,			// mana
			S_FAXEUP,			// upstate
			S_FAXEDOWN,			// downstate
			S_FAXEREADY,		// readystate
			S_FAXEATK_1,		// atkstate
			S_FAXEATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Cleric - Serpent Staff
			MANA_1,			// mana
			S_CSTAFFUP,		// upstate
			S_CSTAFFDOWN,	// downstate
			S_CSTAFFREADY,	// readystate
			S_CSTAFFATK_1,	// atkstate
			S_CSTAFFATK_1,	// holdatkstate
			S_NULL			// flashstate
		},
		{ // Mage - Cone of shards
			MANA_1,			// mana
			S_CONEUP,		// upstate
			S_CONEDOWN,		// downstate
			S_CONEREADY,	// readystate
			S_CONEATK1_1,	// atkstate
			S_CONEATK1_3,	// holdatkstate
			S_NULL			// flashstate
		},
		{ // Pig - Snout
			MANA_NONE,			// mana
			S_SNOUTUP,			// upstate
			S_SNOUTDOWN,		// downstate
			S_SNOUTREADY,		// readystate
			S_SNOUTATK1,		// atkstate
			S_SNOUTATK1,		// holdatkstate
			S_NULL				// flashstate
		}
	},
	{ // Third Weapons
		{ // Fighter - Hammer
			MANA_NONE,			// mana
			S_FHAMMERUP,		// upstate
			S_FHAMMERDOWN,		// downstate
			S_FHAMMERREADY,		// readystate
			S_FHAMMERATK_1,		// atkstate
			S_FHAMMERATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Cleric - Flame Strike
			MANA_2,				// mana
			S_CFLAMEUP,			// upstate
			S_CFLAMEDOWN,		// downstate
			S_CFLAMEREADY1,		// readystate
			S_CFLAMEATK_1,		// atkstate
			S_CFLAMEATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Mage - Lightning
			MANA_2,		// mana
			S_MLIGHTNINGUP,		// upstate
			S_MLIGHTNINGDOWN,	// downstate
			S_MLIGHTNINGREADY,	// readystate
			S_MLIGHTNINGATK_1,	// atkstate
			S_MLIGHTNINGATK_1,	// holdatkstate
			S_NULL				// flashstate
		},
		{ // Pig - Snout
			MANA_NONE,			// mana
			S_SNOUTUP,			// upstate
			S_SNOUTDOWN,		// downstate
			S_SNOUTREADY,		// readystate
			S_SNOUTATK1,		// atkstate
			S_SNOUTATK1,		// holdatkstate
			S_NULL				// flashstate
		}
	},
	{ // Fourth Weapons
		{ // Fighter - Rune Sword
			MANA_BOTH,			// mana
			S_FSWORDUP,			// upstate
			S_FSWORDDOWN,		// downstate
			S_FSWORDREADY,		// readystate
			S_FSWORDATK_1,		// atkstate
			S_FSWORDATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Cleric - Holy Symbol
			MANA_BOTH,			// mana
			S_CHOLYUP,		// upstate
			S_CHOLYDOWN,		// downstate
			S_CHOLYREADY,		// readystate
			S_CHOLYATK_1,		// atkstate
			S_CHOLYATK_1,		// holdatkstate
			S_NULL				// flashstate
		},
		{ // Mage - Staff
			MANA_BOTH,		// mana
			S_MSTAFFUP,		// upstate
			S_MSTAFFDOWN,		// downstate
			S_MSTAFFREADY,		// readystate
			S_MSTAFFATK_1,	// atkstate
			S_MSTAFFATK_1,	// holdatkstate
			S_NULL				// flashstate
		},
		{ // Pig - Snout
			MANA_NONE,			// mana
			S_SNOUTUP,			// upstate
			S_SNOUTDOWN,		// downstate
			S_SNOUTREADY,		// readystate
			S_SNOUTATK1,		// atkstate
			S_SNOUTATK1,		// holdatkstate
			S_NULL				// flashstate
		}
	}
};

// PRIVATE DATA DEFINITIONS ------------------------------------------------

int WeaponManaUse[NUMCLASSES][NUMWEAPONS] = 
{
	{ 0, 2, 3, 14 },
	{ 0, 1, 4, 18 },
	{ 0, 3, 5, 15 },
	{ 0, 0, 0, 0 }
};

