/*
	HeXen INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	PRINT.C - Print routines
*/

#include "print.h"
#include "../common/print.h"
#include "../common/stub.h"
//#include "h2def.h"


/*
	the global variables
*/
extern sfxinfo_t S_sfx[];
extern int WeaponManaUse[][NUMWEAPONS];

/*
	the local function prototypes
*/
void PrintSound(char *, int);
char *LookupSoundTag( char *);
void PrintWpnMana( weapontype_t, pclass_t);
void PrintShotsPM( mobjinfo_t *);
void PrintWpnShotsPM( weapontype_t, pclass_t);
int FrameTics( statenum_t);
void PrintWpnSprites( weapontype_t, pclass_t);


/*
	the weapon print data function
*/
void PrintWeapon()
{
	if (Weap < 0 || Weap >= NUMWEAPONS)
		ProgError( "no such Weapon %d", Weap);
	if (Clss < 0 || Clss >= NUMCLASSES)
		ProgError( "no such Class %d", Clss);

	printf( "\n");
	printf( "Weapon\t\t%s\n", Wpn2Str( Weap, Clss));
	PrintWpnMana( Weap, Clss);
	printf( "\n");
	PrintWpnShotsPM( Weap, Clss);
	PrintWpnSprites( Weap, Clss);
	PrintSpawns();
}

/*
	the main print data function
*/
void PrintData()
{
	mobjinfo_t *MOBJ;

	if (Enum != NULL)
		Objt = Enum2Obj( Enum);
	else if (Thng != -1)
		Objt = Thg2Obj( Thng);
	else
		if (Objt < 0 || Objt >= NUMMOBJTYPES)
			ProgError( "no such Object %d", Objt);

	MOBJ = &mobjinfo[Objt];
	printf( "\n");
	printf( "Enum\t\t%s (%d)\n", Obj2Str( Objt), Objt);
	if (MOBJ->doomednum != -1)
		printf( "Type\t\t%d\t%X\n", MOBJ->doomednum, MOBJ->doomednum);
	else
		printf( "Type\t\t%d\n", MOBJ->doomednum);

	printf( "Health\t\t%d\n", MOBJ->spawnhealth);
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintShotsPM( MOBJ);
	else
		PrintSpeed( MOBJ);

	//printf( "Width\t\t%d\n", MOBJ->radius * 2 / FRACUNIT);
	printf( "Radius\t\t%d\n", MOBJ->radius / FRACUNIT);
	printf( "Height\t\t%d\n", MOBJ->height / FRACUNIT);
	printf( "Mass\t\t%d\n", MOBJ->mass);
	if (MOBJ->flags & MF_MISSILE) // missile formula
		printf( "Damage\t\t%d-%d\n", MOBJ->damage, MOBJ->damage * 8);
	else
		printf( "Damage\t\t%d\n", MOBJ->damage);

	if (!(MOBJ->flags & MF_SPECIAL)) // no pick-up item
	{
		printf( "Reaction time\t%d tics\n", MOBJ->reactiontime);
		printf( "Pain chance\t%d ; %.2f%%\n", MOBJ->painchance, PainPerc( MOBJ->painchance));
		printf( "Pain time\t%d tics\n", PainTics( MOBJ->painstate));
	}
	printf( "Flags\t\t%08x  %d\n", MOBJ->flags, MOBJ->flags);
	PrintFlags( MOBJ->flags);
	printf( "Flags2\t\t%08x  %d\n", MOBJ->flags2, MOBJ->flags2);
	PrintFlags2( MOBJ->flags2);

	TallyFrames( MOBJ->spawnstate);
	TallyFrames( MOBJ->seestate);
	TallyFrames( MOBJ->painstate);
	TallyFrames( MOBJ->meleestate);
	TallyFrames( MOBJ->missilestate);
	TallyFrames( MOBJ->crashstate);
	TallyFrames( MOBJ->deathstate);
	TallyFrames( MOBJ->xdeathstate);

	printf( "\n");
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintSprites( MOBJ);
	else
	{
		PrintSprite( MOBJ->spawnstate, NULL);
		PrintSound( "Alert", MOBJ->seesound);
		PrintSound( "Active", MOBJ->activesound);
		PrintSound( "Attack", MOBJ->attacksound);
		PrintSound( "Pain", MOBJ->painsound);
		PrintSound( "Death", MOBJ->deathsound);
	}
	PrintSpawns();
}


void PrintSound(char *type, int sound)
{
	char *name;

	printf( "%s sound\t", type);
	if (sound != 0)
	{
		name = LookupSoundTag( S_sfx[sound].tagName);
		strupr( name);
		printf( "%s\n", name);
		FreeMemory( name);
	}
	else
		printf( "-\n");
}

#define BUFSIZE 120

char *LookupSoundTag( char *tag)
{
	FILE *sndinfo;
	char buf[BUFSIZE], *ptr = NULL;

	if ((sndinfo = fopen( "sndinfo.txt", "r")) == NULL)
		ProgError( "error opening sndinfo.txt");

	while (fgets( buf, BUFSIZE, sndinfo) != NULL)
	{
		/* skip comment lines */
		if (buf[0] == ';')
			continue;

		if (strncmp(buf, tag, strlen(tag)) == 0)
		{
			ptr = strrchr( buf, ' ') + 1;
			/* erase newline */
			buf[strlen(buf)-1] = '\0';
			break;
		}
	}

	fclose( sndinfo);
	if (ptr != NULL)
		return strdup( ptr);
	else
		return strdup( "");
}

char *ManaColor( weapontype_t weapon, pclass_t class)
{
	if (WeaponInfo[weapon][class].mana == MANA_1)
		return "Blue";
	else if (WeaponInfo[weapon][class].mana == MANA_2)
		return "Green";
	else if (WeaponInfo[weapon][class].mana == MANA_BOTH)
		return "Both";
	else
		return "None";
}

void PrintWpnMana( weapontype_t weapon, pclass_t class)
{
	int mana;

	if (weapon == WP_FIRST)
	{
		printf("Incl mana\tInfinite\n");
		return;
	}
	mana = (weapon == WP_FOURTH) ? 20 : 25; // hardcoded
	printf("Incl mana\t%d %s (%d on [[Skill level|skills]] 1 & 5)\n",
	       mana, ManaColor( weapon, class), (int)(mana * 1.5));
	mana = WeaponManaUse[class][weapon];
	printf("Mana use\t%d %s\n", mana, ManaColor( weapon, class));
}


void PrintShotsPM( mobjinfo_t *MOBJ)
{
	int weapon, class;

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_WFAX: weapon = WP_SECOND; class = PCLASS_FIGHTER; break;
		case SPR_WCSS: weapon = WP_SECOND; class = PCLASS_CLERIC; break;
		case SPR_WMCS: weapon = WP_SECOND; class = PCLASS_MAGE; break;
		case SPR_WFHM: weapon = WP_THIRD; class = PCLASS_FIGHTER; break;
		case SPR_WCFM: weapon = WP_THIRD; class = PCLASS_CLERIC; break;
		case SPR_WMLG: weapon = WP_THIRD; class = PCLASS_MAGE; break;
		case SPR_WFR1:
		case SPR_WFR2:
		case SPR_WFR3: weapon = WP_FOURTH; class = PCLASS_FIGHTER; break;
		case SPR_WCH1:
		case SPR_WCH2:
		case SPR_WCH3: weapon = WP_FOURTH; class = PCLASS_CLERIC; break;
		case SPR_WMS1:
		case SPR_WMS2:
		case SPR_WMS3: weapon = WP_FOURTH; class = PCLASS_MAGE; break;
		default: return;
	}
	PrintWpnShotsPM( weapon, class);
}

void PrintWpnShotsPM( weapontype_t weapon, pclass_t class)
{
	int percycle = 0, tics = 0;
	statenum_t state, st;

	state = st = WeaponInfo[weapon][class].holdatkstate;
	if (state != S_NULL)
		for (;;)
		{
			if (states[st].action)
				states[st].action(NULL);
			else
				funcname[0] = '\0';
			if (strncmp( funcname, "A_Fire", strlen("A_Fire")) == 0 ||
			    strcmp( funcname, "A_MntrFloorFire") == 0)
				percycle++;
			else if (strcmp( funcname, "A_ReFire") == 0 ||
			         strcmp( funcname, "A_CStaffAttack") == 0 ||      // Serpent Staff
			         strcmp( funcname, "A_FHammerThrow") == 0 ||      // Hammer of Retribution
			         strcmp( funcname, "A_CFlameAttack") == 0 ||      // Firestorm
			         strcmp( funcname, "A_MLightningAttack") == 0 ||  // Arc of Death
			         strcmp( funcname, "A_FSwordAttack") == 0 ||      // Quietus
			         strcmp( funcname, "A_CHolyAttack") == 0 ||       // Wraithverge
			         strcmp( funcname, "A_MStaffAttack") == 0)        // Bloodscourge
				break;
			tics += states[st].tics;
			st = states[st].nextstate;
			if (tics > 100)
				ProgError( "unable to count tics for holdatkstate %d", state);
		}

	if (tics != 0)
		printf( "Shots / min\t%.1f\n",
		        (float)percycle * (TICRATE * 60) / tics);
}

int FrameTics( statenum_t state)
{
	if (states[state].action)
	{
		states[state].action(NULL);
		if (strcmp( funcname, "A_Chase") == 0 ||
		    strcmp( funcname, "A_PigChase") == 0 ||       // Chicken
		    strcmp( funcname, "A_WraithChase") == 0 ||    // Wraith
		    strcmp( funcname, "A_MinotaurChase") == 0 ||  // Maulotaur
		    strcmp( funcname, "A_SerpentChase") == 0 ||   // Serpent
		    strcmp( funcname, "A_BishopChase") == 0 ||    // Dark Bishop
		    strcmp( funcname, "A_FiredChase") == 0 ||     // Firedemon
		    strcmp( funcname, "A_IceGuyChase") == 0 ||    // Chicken
		    strcmp( funcname, "A_FastChase") == 0 ||      // Chicken
		    strcmp( funcname, "A_DragonFlap") == 0 ||     // Death Wyvern
		    strcmp( funcname, "A_KoraxChase") == 0)       // Korax
		{
//printf("%s\n", funcname);
			return states[state].tics;
		}
	}

	return -1;
}


void PrintSprites( mobjinfo_t *MOBJ)
{
	int weapon, class;

	PrintSprite( MOBJ->spawnstate, "pickup");

	switch (states[MOBJ->spawnstate].sprite)
	{
		case SPR_WFAX: weapon = WP_SECOND; class = PCLASS_FIGHTER; break;
		case SPR_WCSS: weapon = WP_SECOND; class = PCLASS_CLERIC; break;
		case SPR_WMCS: weapon = WP_SECOND; class = PCLASS_MAGE; break;
		case SPR_WFHM: weapon = WP_THIRD; class = PCLASS_FIGHTER; break;
		case SPR_WCFM: weapon = WP_THIRD; class = PCLASS_CLERIC; break;
		case SPR_WMLG: weapon = WP_THIRD; class = PCLASS_MAGE; break;
		case SPR_WFR1:
		case SPR_WFR2:
		case SPR_WFR3: weapon = WP_FOURTH; class = PCLASS_FIGHTER; break;
		case SPR_WCH1:
		case SPR_WCH2:
		case SPR_WCH3: weapon = WP_FOURTH; class = PCLASS_CLERIC; break;
		case SPR_WMS1:
		case SPR_WMS2:
		case SPR_WMS3: weapon = WP_FOURTH; class = PCLASS_MAGE; break;
		default: return;
	}
	PrintWpnSprites( weapon, class);
}

void PrintWpnSprites( weapontype_t weapon, pclass_t class)
{
	PrintSprite( WeaponInfo[weapon][class].readystate, "wield");
	PrintSprite( WeaponInfo[weapon][class].atkstate, "fire");
	PrintSprite( WeaponInfo[weapon][class].holdatkstate, "refire");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
