/*
	StriFe INFO.c processor, by Frans P. de Vries.

Derived from:

	DooM MaP StaTistics, by Frans P. de Vries.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	PRINT.C - Print routines
*/

#include "print.h"
#include "../common/print.h"
#include "../common/stub.h"
#include "d_items.h"
#include "sounds.h"


/*
	the global variables
*/
extern int maxammo[];
extern int clipammo[];

/*
	the local function prototypes
*/
void PrintSound(char *, int);
void PrintWpnAmmo( weapontype_t);
void PrintShotsPM( mobjinfo_t *);
void PrintWpnShotsPM( weapontype_t);
int FrameTics( statenum_t);
void PrintWpnSprites( weapontype_t);


/*
	the weapon print data function
*/
void PrintWeapon()
{
	if (Weap < 0 || Weap >= NUMWEAPONS)
		ProgError( "no such Weapon %d", Weap);

	printf( "\n");
	printf( "Weapon\t\t%s\n", Wpn2Str( Weap));
	PrintWpnAmmo( Weap);
	printf( "\n");
	PrintWpnShotsPM( Weap);
	PrintWpnSprites( Weap);
	PrintSpawns();
}

/*
	the main print data function
*/
void PrintData()
{
	mobjinfo_t *MOBJ;

	if (Enum != NULL)
		Objt = Enum2Obj( Enum);
	else if (Thng != -1)
		Objt = Thg2Obj( Thng);
	else
		if (Objt < 0 || Objt >= NUMMOBJTYPES)
			ProgError( "no such Object %d", Objt);

	MOBJ = &mobjinfo[Objt];
	printf( "MOBJ\n");
	printf( "Enum\t\t%s (%d)\n", Obj2Str( Objt), Objt);
	if (MOBJ->doomednum != -1)
		printf( "Type\t\t%d\t%X\n", MOBJ->doomednum, MOBJ->doomednum);
	else
		printf( "Type\t\t%d\n", MOBJ->doomednum);

	printf( "Health\t\t%d\n", MOBJ->spawnhealth);
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintShotsPM( MOBJ);
	else
		PrintSpeed( MOBJ);

	//printf( "Width\t\t%d\n", MOBJ->radius * 2 / FRACUNIT);
	printf( "Radius\t\t%d\n", MOBJ->radius / FRACUNIT);
	printf( "Height\t\t%d\n", MOBJ->height / FRACUNIT);
	printf( "Mass\t\t%d\n", MOBJ->mass);
	if (MOBJ->flags & MF_MISSILE) // missile formula
		printf( "Damage\t\t%d-%d\n", MOBJ->damage, MOBJ->damage * 8);
	else
		printf( "Damage\t\t%d\n", MOBJ->damage);

	if (!(MOBJ->flags & MF_SPECIAL)) // no pick-up item
	{
		printf( "Reaction time\t%d tics\n", MOBJ->reactiontime);
		printf( "Pain chance\t%d ; %.2f%%\n", MOBJ->painchance, PainPerc( MOBJ->painchance));
		printf( "Pain time\t%d tics\n", PainTics( MOBJ->painstate));
	}
	printf( "Flags\t\t%08x  %d\n", MOBJ->flags, MOBJ->flags);
	PrintFlags( MOBJ->flags);
#ifdef MOBJTRANSLATION
	printf( "Flags2\t\t%08x  %d\n", MOBJ->flags2, MOBJ->flags2);
	PrintFlags2( MOBJ->flags2);
#endif

	TallyFrames( MOBJ->spawnstate);
	TallyFrames( MOBJ->seestate);
	TallyFrames( MOBJ->painstate);
	TallyFrames( MOBJ->meleestate);
	TallyFrames( MOBJ->missilestate);
	TallyFrames( MOBJ->crashstate);
	TallyFrames( MOBJ->deathstate);
	TallyFrames( MOBJ->xdeathstate);

	printf( "\n");
	if (MOBJ->flags & MF_SPECIAL) // pick-up item
		PrintSprites( MOBJ);
	else
	{
		PrintSprite( MOBJ->spawnstate, NULL);
		PrintSound( "Alert", MOBJ->seesound);
		PrintSound( "Active", MOBJ->activesound);
		PrintSound( "Attack", MOBJ->attacksound);
		PrintSound( "Pain", MOBJ->painsound);
		PrintSound( "Death", MOBJ->deathsound);
	}
	PrintSpawns();
}


void PrintSound(char *type, int sound)
{
	char name[9];

	printf( "%s sound\t", type);
	if (sound != 0)
	{
		if (S_sfx[sound].link != NULL)
			strcpy( name, S_sfx[sound].link->name);
		else
			strcpy( name, S_sfx[sound].name);
		strupr( name);
		printf( "%s\n", name);
	}
	else
		printf( "-\n");
}

void PrintWpnAmmo( weapontype_t weapon)
{
	int ammo;

	ammo = clipammo[weaponinfo[weapon].ammo];
	printf("Incl ammo\t%d (%d on [[Skill level|skills]] 1 & 5)\n", ammo * 2, ammo * 2 * 2); // 2 clips
	ammo = maxammo[weaponinfo[weapon].ammo];
	printf("Max ammo\t%d (%d with [[ammo satchel]])\n", ammo, ammo * 2);
}


void PrintShotsPM( mobjinfo_t *MOBJ)
{
	int weapon;

	switch (states[MOBJ->spawnstate].sprite)
	{
		//case SPR: weapon = wp_fist; break;
		case SPR_CBOW: weapon = wp_elecbow; break;
		//case SPR: weapon = wp_poisonbow; break;
		case SPR_RIFL: weapon = wp_rifle; break;
		case SPR_MMSL: weapon = wp_missile; break;
		case SPR_GRND: weapon = wp_hegrenade; break;
		//case SPR: weapon = wp_wpgrenade; break;
		case SPR_FLAM: weapon = wp_flame; break;
		case SPR_TRPD: weapon = wp_mauler; break;
		//case SPR: weapon = wp_torpedo; break;
		case SPR_SIGL: weapon = wp_sigil; break;
		default: return;
	}
	PrintWpnShotsPM( weapon);
}

void PrintWpnShotsPM( weapontype_t weapon)
{
	int percycle = 0, tics = 0;
	statenum_t state, st;

	state = st = weaponinfo[weapon].atkstate;
	if (state != S_NULL)
		for (;;)
		{
			if (states[st].action.acp1)
				states[st].action.acp1(NULL);
			else
				funcname[0] = '\0';
			if (strncmp( funcname, "A_Fire", strlen("A_Fire")) == 0)
				percycle++;
			else if (strcmp( funcname, "A_ReFire") == 0 ||
			         strcmp( funcname, "A_WeaponReady") == 0)
				break;
			tics += states[st].tics;
			st = states[st].nextstate;
			if (tics > 100)
				ProgError( "unable to count tics for atkstate %d", state);
		}

	if (tics != 0)
		printf( "Shots / min\t%.1f\n",
		        (float)percycle * (TICRATE * 60) / tics);
}

int FrameTics( statenum_t state)
{
	if (states[state].action.acp1)
	{
		states[state].action.acp1(NULL);
		if (strcmp( funcname, "A_Chase") == 0 ||
		    strcmp( funcname, "A_StalkerChase") == 0 ||  // Stalker
		    strcmp( funcname, "A_InqChase") == 0)        // Inquisitor
			return states[state].tics;
	}

	return -1;
}


void PrintSprites( mobjinfo_t *MOBJ)
{
	int weapon;

	PrintSprite( MOBJ->spawnstate, "pickup");

	switch (states[MOBJ->spawnstate].sprite)
	{
		//case SPR: weapon = wp_fist; break;
		case SPR_CBOW: weapon = wp_elecbow; break;
		//case SPR: weapon = wp_poisonbow; break;
		case SPR_RIFL: weapon = wp_rifle; break;
		case SPR_MMSL: weapon = wp_missile; break;
		case SPR_GRND: weapon = wp_hegrenade; break;
		//case SPR: weapon = wp_wpgrenade; break;
		case SPR_FLAM: weapon = wp_flame; break;
		case SPR_TRPD: weapon = wp_mauler; break;
		//case SPR: weapon = wp_torpedo; break;
		case SPR_SIGL: weapon = wp_sigil; break;
		default: return;
	}
	PrintWpnSprites( weapon);
}

void PrintWpnSprites( weapontype_t weapon)
{
	PrintSprite( weaponinfo[weapon].readystate, "wield");
	PrintSprite( weaponinfo[weapon].atkstate, "fire");
	PrintSprite( weaponinfo[weapon].flashstate, "flash");
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
