
/* This is a simple C program to display the thing attributes 
   within the doom.exe file.

	-Sam Lantinga		6/23/94
*/

#include	<sys/types.h>
#include	<fcntl.h>
#include	"things.h"

#define DOOM_EXE	"doom.exe"
#define THING_OFFSET	0x8b3c8
#define NUM_THINGS	103

/* We assume an int is a four byte integer */
typedef struct {
	int type;		/* The thing number (5 for blue key, etc) */
	int fs_frame;		/* The first static frame of the sequence */
	int hp;			/* Toughness (hitpoints) */
	int fm_frame;		/* The first moving frame of the sequence */
	int C_sound;		/* "See player" sound (1-61) */
	int eight;		/* ?? */
	int F_sound;		/* "Attack (fight)" sound (1-61) */
	int I_sound;		/* "Injury" sound (1-61) */
	int m_p_only;		/* ?? */
	int O_sound;		/* "Pain" sound (1-61) */
	int B_sound;		/* "Brawling" sound (close attack) (1-61) */
	int L_sound;		/* "Long Range Attack" sound (1-61) */
	int fd_frame;		/* The first death frame of the sequence */
	int fe_frame;		/* The first explosive death frame */
	int D_sound;		/* "Death/Explode" sound (1-61) */
	int m_speed;		/* Movement speed */
	int width;		/* Horizontal size */
	int height;		/* Height */
	int points;		/* Point value? */
	int M_damage;		/* Missle damage */
	int A_sound;		/* "Action" sound (1-61) */
	int attributes;		/* Thing attributes */
} Thing;

/* Attribute bitmask definitions */
#define GETTABLE_THING	0x00000001	/* A gettable thing */
#define OBSTACLE_THING	0x00000002	/* An obstacle */
#define HURTABLE_THING	0x00000004	/* Can be hurt */
#define TELEPORT_THING	0x00000008	/* Teleport destination */
#define AUTOGEN_THING	0x00000010	/* Automatically created */
/* Bits 5-7 unused? */
#define OCEILING_THING	0x00000100	/* Hung from ceiling */
#define FLOATING_THING	0x00000200	/* Floating thing */
/* Unknown bit 10 */			/* projectiles and player ? */
#define PLAYER_THING	0x00000800	/* player only ? */
/* Bits 12-13 unused? */
#define FLOATING_MONST	0x00004000	/* Floating monster */
/* Bit 15 unused? */
#define THROWN_THING	0x00010000	/* Projectiles */
/* Bit 17 unused? */
#define INVISIBL_MONST	0x00040000
#define BARREL_THING	0x00080000	/* ? barrel only */
/* Bits 20-21 unused? */
#define MONSTER_THING	0x00400000	/* Monster: counts towards KILL % */
#define ARTIFACT_THING	0x00800000	/* Artifact: counts towards ITEM % */
/* Bit 24 unused? */
/* Unknown bit 25 */			/* the 6 keys and the player */
/* Bits 26-31 unused? */

/* Special effects */
#undef FLYING_BARON

void print_thing();
main()
{
	int fd, i;
	Thing thing;

	if ( (fd=open(DOOM_EXE, O_RDWR, 0)) < 0 ) {
		perror(DOOM_EXE);
		exit(2);
	}
	if ( lseek(fd, THING_OFFSET, 0) < 0 ) {
		perror("lseek()");
		exit(2);
	}

	for ( i=0; i < NUM_THINGS; ++i ) {
		if ( read(fd, &thing, sizeof(thing)) != sizeof(thing) ) {
			perror("read()");
			exit(2);
		}
#ifdef FLYING_BARON
		if ( thing.type == THING_BARON ) {
			lseek(fd, sizeof(thing), 1);
			thing.attributes |= FLOATING_THING;
			thing.attributes |= FLOATING_MONST;
			write(fd, &thing, sizeof(thing));
		}
#endif
		printf("(%d) ", i);
		print_thing(&thing);
	}
	exit(0);
}


void print_thing(thing)
Thing *thing;
{
	printf("Thing: %s\n", GetThingName(thing->type));
	printf("\tHP: %d\t\tHeight: %d\tWidth: %d\n", 
		thing->hp, (thing->height/65536), (thing->width/65536));
	printf("\tAttributes:\n\t\t");
	if ( thing->attributes & GETTABLE_THING )
		printf("gettable, ");
	if ( thing->attributes & OBSTACLE_THING )
		printf("obstacle, ");
	if ( thing->attributes & HURTABLE_THING )
		printf("hurtable, ");
	if ( thing->attributes & AUTOGEN_THING )
		printf("autogenerated, ");
	if ( thing->attributes & OCEILING_THING )
		printf("ceiling hung, ");
	if ( thing->attributes & FLOATING_THING )
		printf("floating, ");
	if ( thing->attributes & THROWN_THING )
		printf("projectile, ");
	if ( thing->attributes & INVISIBL_MONST )
		printf("invisible, ");
	if ( thing->attributes & MONSTER_THING )
		printf("monster.\n");
	else if ( thing->attributes & ARTIFACT_THING )
		printf("artifact.\n");
	else
		printf("thing.\n");
	printf("\n");
}
